#include "print.h"



/*
  Merge support procedure for Mergesort
*/

void Merge(OBJ *vet,OBJ *vet1,int first,int last) {
  int mid,i1,i2,i3;
  mid = (first + last)/2;
  i1 = i2 = first;
  i3 = mid + 1;
  while(i2<=mid && i3<=last)
    if(vet[i2].x > vet[i3].x) {
      vet1[i1].x = vet[i2].x;
      vet1[i1].i = vet[i2].i;
      vet1[i1++].j = vet[i2++].j;
    }
    else {
      vet1[i1].x = vet[i3].x;
      vet1[i1].i = vet[i3].i;
      vet1[i1++].j = vet[i3++].j;
    }
  while(i2<=mid) {
    vet1[i1].x = vet[i2].x;
    vet1[i1].i = vet[i2].i;
    vet1[i1++].j = vet[i2++].j;
  }
  while(i3<=last) {
    vet1[i1].x = vet[i3].x;
    vet1[i1].i = vet[i3].i;
    vet1[i1++].j = vet[i3++].j;
  }
  i1=i2=first;
  while(i2<=last) {
    vet[i2].x=vet1[i1].x;
    vet[i2].i=vet1[i1].i;
    vet[i2++].j=vet1[i1++].j;
  }
}



/*
  Mergesort for the correlation values in vet.
  It takes two array of objects OBJ, the first index and the last index and 
  returns the array ordered
*/

void MergeSort(OBJ *vet,OBJ *vet1,int first,int last) {
  int mid;
  if(first < last) {
    mid = (first + last)/2;
    MergeSort(vet,vet1,first,mid);
    MergeSort(vet,vet1,mid+1,last);
    Merge(vet,vet1,first,last);
  }
}



/*
  It takes a path of labels, its length and a position and
  returns the label at that position.
*/

char * Return_str(char *w,int *len_words,int pos) {
  int l=0,tmp1,tmp2=0,i,pos1;
  char *ret=NULL;

  tmp1 = strlen(w);
  pos1=pos+1;
  
  while(tmp1!=tmp2) {
    pos1--;
    if(pos1==0) {
      ret = (char *)malloc(sizeof(char)*(len_words[l]+1));
      for(i=0;i<len_words[l];i++)
	ret[i]=w[i+tmp2];
      ret[i]='\0';
      break;
    }
    tmp2 += len_words[l++];
  }
  return ret;
}



/*
  It takes a word, its length and and it prepares the file.dot for the
  springraph command for the word created with ALLPAIRSHORTESTPATHS
*/

void springraph(char *w,int *len_words,char *grafo) {
  FILE *dot=NULL;
  char *ret1=NULL,*ret2=NULL;
  int node,l;
  char command[MAX_STR];

  dot = fopen("./correlation_files/file.dot","w");
  fprintf(dot, "\"\" { \n");
  fprintf(dot, "size = \"1,1\";\n");
    
  node = 1;
  for(l=0;l<Length_words(w,len_words);l++) {
    if(Length_words(w,len_words)==1)
      fprintf(dot,". -- %s id%d\n",w,node);
    else
      if(l==0) {
	ret1 = Return_str(w,len_words,l);
	ret2 = Return_str(w,len_words,l+1);
	if(directed == 'u')
	  fprintf(dot,"%s id%d -- %s id%d\n",ret1,node,ret2,node+1);
	else
	  fprintf(dot,"%s id%d -> %s id%d\n",ret1,node,ret2,node+1);
	free(ret1);
	free(ret2);
	l++;
      }
      else {
	ret1 = Return_str(w,len_words,l-1);
	ret2 = Return_str(w,len_words,l);
	if(directed == 'u')
	  fprintf(dot,"%s id%d -- %s id%d\n",ret1,node,ret2,node+1);
	else
	  fprintf(dot,"%s id%d -> %s id%d\n",ret1,node,ret2,node+1);
	free(ret1);
	free(ret2);
      }
    node++;
  }

  if(node==2)
    fprintf(dot," -- .\n");
  fprintf(dot,"\n}");
  strcpy(command,"springgraph -s 0.6 < ./correlation_files/file.dot > ");
  strcat(grafo,".png");
  strcat(command,grafo);
  strcat(command," 2> /dev/null");
  fclose(dot);
  system(command);
}



/* 
   It takes a file pointer *p, a word, his length and an integer value and 
   writes in *p the Substructure with the LNE format
*/

void Write(FILE *p,char *w,int *len_words,int i) {
  int j=0,k=0,l=0,tmp1,tmp2=0,offset=0;
  char str[MAX_GRAPHS];
  
  fprintf(p,"#Substructure %d\n",i);
  tmp1 = strlen(w);
  while(tmp1!=tmp2) {
    tmp2 += len_words[l];
    for(j=0+offset;j<len_words[l]+offset;j++) 
      str[k++]=w[j];
    offset = j;
    str[k++]='\n';
    l++;
  }
  
  str[k]='\0';
  fprintf(p,"%d\n",l);
  fprintf(p,"%s",str);
  fprintf(p,"%d\n",l-1);
  k=0;
  l=0;
  for(j=0;j<tmp1;j+=len_words[l-1]) {
    if(j+len_words[l]>=tmp1)
      break;
    fprintf(p,"%d %d\n",k,k+1);
    k++;
    l++;
  }
}



/* 
   It takes a word and its length and returns the real length of the word
   Example: if 'ab' and 'ggt' are two labels, abggt is a path of length 2
*/

int Length_words(char *w,int *len) {
  int i=0,tmp,tmp1=0,real=0;
  tmp = strlen(w);
  while(tmp!=tmp1) {
    tmp1 += len[i++];
    real++;
  }
  return real;
}



/*
  It returns 1 if the *file_name exists.
  Otherwise returns 0.
*/

int file_exists(char *file_name) {
  FILE *ftemp=NULL;

  if ( (ftemp=fopen(file_name, "r")) == NULL ) {
    /* File cannot be opened */
    return 0;
  }
  else {
    fclose(ftemp);
    return 1;
  }
}



/* 
   It takes the correlation matrix, the number of words, the min number of nodes of the substructures,
   the words and their length and write the outputs: S_i subgraphs (ALLPAIRSHORTESTPATHS) and correlation 
   files for the java program
*/

void Write_Correlation(float **cor,int cont_words,int min) {
  int i,j,cont=0;
  OBJ *vet=NULL,*vet1=NULL;
  FILE *f=NULL,*p=NULL;
  char str[MAX_STR],str_grafo[MAX_STR];

  for(i=1;i<cont_words+1;i++)
    for(j=i+1;j<cont_words+1;j++)
      if(Length_words(words[i-1],len_words[i-1])>=min && Length_words(words[j-1],len_words[j-1])>=min) {
	vet = (OBJ *)realloc(vet,sizeof(OBJ)*(cont+1));
	vet1 = (OBJ *)realloc(vet1,sizeof(OBJ)*(cont+1));
	vet[cont].i=i;
	vet[cont].j=j;
	vet[cont++].x=cor[i][j];
      }

  MergeSort(vet,vet1,0,cont-1);

  if(file_exists("./correlation_files")==1) {
    system("rm -f ./correlation_files/*");
    system("rmdir ./correlation_files/");
  }
  system("mkdir ./correlation_files/");
  f = fopen("./correlation_files/info.txt","w");

  for(i=0;i<cont;i++) {
    sprintf(str,"./correlation_files/S%d",vet[i].i);
    sprintf(str_grafo,"./correlation_files/Graph%d",vet[i].i);
    p = fopen(str,"r");
    if(p==NULL) {
      p = fopen(str,"w");
      Write(p,words[vet[i].i-1],len_words[vet[i].i-1],vet[i].i);
      springraph(words[vet[i].i-1],len_words[vet[i].i-1],str_grafo);
    }
    fclose(p);
    sprintf(str,"./correlation_files/S%d",vet[i].j);
    sprintf(str_grafo,"./correlation_files/Graph%d",vet[i].j);
    p = fopen(str,"r");
    if(p==NULL) {
      p = fopen(str,"w");
      Write(p,words[vet[i].j-1],len_words[vet[i].j-1],vet[i].j);
      springraph(words[vet[i].j-1],len_words[vet[i].j-1],str_grafo);
    }
    fclose(p);
    fprintf(f,"S%d S%d %.2f\n",vet[i].i,vet[i].j,vet[i].x);
  }
  fclose(f);
  free(vet);
  free(vet1);
}



/*
  It takes a FILE pointer, a string containing the substructure pathname, the size (number of
  the nodes of the substructure and an int i (the number of the substructure) and
  it calls the springraph command to create the substructures created with SUBDUE
*/

void springraph_Subdue(FILE *p,char *grafo,int size,int i) {
  FILE *dot=NULL,*cor=NULL;
  int l,e1,e2,nod,k=0;
  char **nodes=NULL;
  char command[MAX_STR],str[MAX_SIZE_LABEL];
  char c;
  
  dot = fopen("./correlation_files/file.dot","w");
  sprintf(str,"./correlation_files/S%d",i);
  strcpy(command,str);
  cor = fopen(command,"w");
  fprintf(cor,"#Substructure %d\n",i);
  fprintf(dot, "\"\" { \n");
  fprintf(dot, "size = \"1,1\";\n");
  fseek(p,0,0);
  nod = 0;
  strcpy(command,"");
  strcpy(str,"");
  while(!feof(p)) {
    fscanf(p,"%c",&c);
    if(c=='v') {
      nod++;
      fscanf(p,"%d",&l);
      if(l==1) {
	if(nodes!=NULL) {
	  for(i=0;i<nod;i++)
	    free(nodes[i]);
	  free(nodes);
	  nodes = NULL;
	}
      }
      nodes = (char **)realloc(nodes,sizeof(char *)*(l));
      nodes[l-1] = NULL;
      fscanf(p,"%c%s",&c,str);
      nodes[l-1] = (char *)realloc(nodes[l-1],sizeof(char)*(strlen(str)+1));
      strcpy(nodes[l-1],str);
      strcat(command,nodes[l-1]);
      k+=strlen(nodes[l-1]);
      command[k++]='\n';
      if(size==1) {
	fprintf(dot,". -- %s id%d\n",nodes[l-1],l);
	fprintf(cor,"1\n%s\n",nodes[l-1]);
      }
    }
    else {
      if(size!=1 && (c=='u' || c=='d')) {
	if(nod>0) {
	  command[k]='\0';
	  fprintf(cor,"%d\n",nod);
	  fprintf(cor,"%s",command);
	  strcpy(command,"");
	  k=0;
	  nod=0;
	}
      }
      if(c=='u') {
	fscanf(p,"%d %d %c",&e1,&e2,&c);
	sprintf(str,"%d %d\n",e1-1,e2-1);
	strcat(command,str);
	strcat(command,"\0");
	k++;
	fprintf(dot,"%s id%d -- %s id%d\n",nodes[e1-1],e1,nodes[e2-1],e2);
      }
      else
	if(c=='d') {
	  fscanf(p,"%d %d %c",&e1,&e2,&c);
	  sprintf(str,"%d %d\n",e1-1,e2-1);
	  strcat(command,str);
	  strcat(command,"\0");
	  k++;
	  fprintf(dot,"%s id%d -> %s id%d\n",nodes[e1-1],e1,nodes[e2-1],e2);
	}
    }
  }
  fprintf(cor,"%d\n%s",k,command);
  fclose(cor);
  fprintf(dot,"\n}");
  strcpy(command,"springgraph -s 0.6 < ./correlation_files/file.dot > ");
  strcat(command,grafo);
  strcat(command," 2> /dev/null");
  fclose(dot);
  system(command);
  if(nodes!=NULL) {
    for(i=0;i<nod;i++)
      free(nodes[i]);
    free(nodes);
    nodes = NULL;
  }
}



/* 
   It takes the correlation matrix, the number of words, the min number of nodes of the substructures,
   and the size of each substructure and it
   writes the outputs: S_i subgraphs (SUBDUE) and correlation files for the java program
   files for the java program
*/

void Write_Correlation_Subdue(float **cor,int cont_words,int min,int *size) {
  int i,j,cont=0;
  OBJ *vet=NULL,*vet1=NULL;
  FILE *f=NULL,*p=NULL;
  char str[MAX_STR],str_grafo[MAX_STR];

  for(i=1;i<cont_words+1;i++)
    for(j=i+1;j<cont_words+1;j++) {
      if(size[i-1]>=min && size[j-1]>=min) {
	vet = (OBJ *)realloc(vet,sizeof(OBJ)*(cont+1));
	vet1 = (OBJ *)realloc(vet1,sizeof(OBJ)*(cont+1));
	vet[cont].i=i;
	vet[cont].j=j;
	vet[cont++].x=cor[i][j];
      }
    }
  MergeSort(vet,vet1,0,cont-1);

  if(file_exists("./correlation_files")==1) {
    system("rm -f ./correlation_files/*");
    system("rmdir ./correlation_files/");
  }
  system("mkdir ./correlation_files/");
  f = fopen("./correlation_files/info.txt","w");
  for(i=0;i<cont;i++) {
    sprintf(str,"./subdue_files/%d.sub",vet[i].i-1);
    sprintf(str_grafo,"./correlation_files/Graph%d.png",vet[i].i);
    p = fopen(str_grafo,"r");
    if(p==NULL) {
      p = fopen(str,"r");
      springraph_Subdue(p,str_grafo,size[vet[i].i-1],vet[i].i-1);
    }
    fclose(p);
    sprintf(str,"./subdue_files/%d.sub",vet[i].j-1);
    sprintf(str_grafo,"./correlation_files/Graph%d.png",vet[i].j);
    p = fopen(str_grafo,"r");
    if(p==NULL) {
      p = fopen(str,"r");
      springraph_Subdue(p,str_grafo,size[vet[i].j-1],vet[i].j-1);
    }
    fclose(p);

    fprintf(f,"S%d S%d %.2f\n",vet[i].i,vet[i].j,vet[i].x);
  }
  fclose(f);
  free(vet);
  free(vet1);
}



/*
  It writes on the file MAPPA the MAPPA matrix and creates mat_output as the substructures-graphs matrix
  It is called when AllPairShortestPath is used to find the substructures
*/

void write_MAPPA(float ***mat_output,int num_grafo) {
  int i,j;
  FILE *fp=NULL;
  
  *mat_output = (float **)malloc(sizeof(float *)*(cont_words+1));
  for(i=0;i<cont_words+1;i++)
    (*mat_output)[i] = (float *)malloc(sizeof(float)*(num_grafo+1));
  fp = fopen("MAPPA","w");
  assert(fp);
  for(i=0;i<num_grafo;i++) {
    for(j=0;j<cont_words;j++) {
      if(loc_con[i] <= j) {
	fprintf(fp,"0 ");
  	(*mat_output)[j+1][i+1]=0;
      }
      else {
  	fprintf(fp,"%d ",MAPPA[i][j]);
  	(*mat_output)[j+1][i+1]=MAPPA[i][j];
      }
    }
    fprintf(fp,"\n");
  }
  fclose(fp);
}



/*
  It writes on the file MAPPA the Mat matrix and creates mat_output as the substructures-graphs matrix.
  It is called when Subdue is used to find the substructures
*/

void write_MAPPA_Subdue(float ***mat_output,int num_grafo,int **Mat) {
  int i,j;
  FILE *fp=NULL;

  *mat_output = (float **)malloc(sizeof(float *)*(cont_words+1));
  for(i=0;i<cont_words+1;i++)
    (*mat_output)[i] = (float *)malloc(sizeof(float)*(num_grafo+1));
  fp = fopen("MAPPA","w");
  assert(fp);
  for(i=0;i<num_grafo;i++) {
    for(j=0;j<cont_words;j++) {
      fprintf(fp,"%d ",Mat[i][j]);
      (*mat_output)[j+1][i+1]=Mat[i][j];
    }
    fprintf(fp,"\n");
  }
  fclose(fp);
}



/*
  Display 's'
*/

void Set_s(char *c1,char *c2,int num_grafo,int cont_words) {
  if(num_grafo == 1)
    *c1 = 0;
  else
    *c1 = 's';
  if(cont_words == 1)
    *c2 = 0;
  else
    *c2 = 's';
}



/*
  Call java function to display the correlation values
*/

void Call_Java() {
  system("java correlation correlation_files/info.txt");
}
