#include "loadKmeans.h"



/*
  Allocated memory for S
*/

void Allocating_S() {
  int i;
  S = (Object *) malloc(n * sizeof(Object));
  if(!S)
    exit(-1);
  for(i = 0; i < n; i++) {
    S[i].X = (float *) malloc(sizeof(float)*SpaceDim);
    if(!S[i].X)
      exit(-1);
    S[i].index = (int *) malloc(sizeof(int));
    if(!S[i].index)
      exit(-1);
    S[i].idx_CLU = (int *) malloc(sizeof(int));
    if(!S[i].idx_CLU)
      exit(-1);
    S[i].Dv = NULL;
  }
}



/*
  Load 'size' objects of SpaceDim 'dim' from the file *fp in *S
*/

void Load_Data2(Object *S, int size,int dim,FILE *fp) {
  int i,j;
  
  for(i = 0; i < size; i++){
    for(j = 0; j < dim; j++) {
      fscanf(fp,"%f",&S[i].X[j]);
    }
    *S[i].index = i;
    S[i].dvS = 0;
    S[i].clu = -1;
  }
  return;
}



/*
  Free the n data objects saved in S
*/

void Libera_S(int n) {
  int i;
  for(i=0;i<n;i++) {
    free(S[i].idx_CLU);
    S[i].idx_CLU=NULL;
    free(S[i].index);
    S[i].index=NULL;
    free(S[i].X);
    S[i].X=NULL;
    if(S[i].Dv!=NULL) {
      free(S[i].Dv);
    }
  }
  free(S);
  S=NULL;
}



/*
  It returns the distance between two Objects *O1 and O2
*/

float Dist(Object *O1,Object *O2){
  float d;
  d = ComputeDist(O1->X,O2->X);
  return d;
}



/*
  It computes the inner product distance or the Euclidean distance according to choice
*/

float ComputeDist(float *X, float *Y) {
  int i;
  double d = 0;
  switch(choice) {
  case 'I':
    for(i = 0; i < SpaceDim; i++) {
      d += X[i]*Y[i]; // inner product
    }
    return d;
  case 'E':
    for(i = 0; i < SpaceDim; i++)
      d += pow(X[i]-Y[i],2);
    return sqrt(d); // Euclidean
  }
  return -1;
}



/*
  It takes the Kmeans data structure and the number of clusters (k) and
  frees the memory allocated for it
*/

void Libera(Cluster *G,int num_clusters) {
  int i;
  for(i=0;i<num_clusters;i++) {
    if(G[i].Elements!=NULL) {
      free(G[i].Elements);
      free(G[i].Dc);
    }
  }
  free(G);
}
