/*
  Antipole_Subdue.c
  main file of graphclust using Antipole method to cluster and Subdue to find the 
  graphs substructures
*/

#include "includeAntipole.h"



int main(int argc, char *argv[]) {
  int i,j=0,num_grafo=0,range,min,*size=NULL;
  char **name=NULL,*nnn=NULL,c1,c2;
  int num_clusters,**Mat=NULL,SVD;
  FILE *fp=NULL;
  float *w=NULL,**v=NULL,**reduced=NULL,**mat_output=NULL;

  if(argc != 6 && argc != 7) {
    printf("USAGE:  <Dataset> <d/u> <1..4> <min> <SVD> [ <[I]nner Product / [E]uclidean [I/E]> ]\n");
    exit(-1);
  }
  if(argc == 7)
    sscanf(argv[6],"%c",&choice);
  
  if(choice!='I' && choice!='E') {
    fprintf(stderr,"\nUnrecognized value : %c. Please write 'I' or 'E'.\n",choice);
    exit(-1);
  }

  min = atoi(argv[4]);
  if(!strcmp(argv[5],"NOSVD"))
    SVD = -1;
  else
    SVD = atoi(argv[5]);
  S=NULL;
  
  sscanf(argv[2],"%c",&directed);
  if(directed!='d' && directed!='u') {
    fprintf(stderr,"\nUse 'd' or 'u' instead of %c\n\n",directed);
    exit(-1);
  }
  fp = fopen(argv[1],"r");
  
  fprintf(stderr,"\n\nParsing Dataset.....");  
  ParserSubdue(fp,&num_grafo,&name,&size,&Mat);
  Set_s(&c1,&c2,num_grafo,cont_words);
  fprintf(stderr,"done [read %d input graph%c and made %d substructure%c]\n",num_grafo,c1,cont_words,c2);

  fprintf(stderr,"Writing file 'MAPPA'.....");
  write_MAPPA_Subdue(&mat_output,num_grafo,Mat);
  fprintf(stderr,"done\n");
  
  if(SVD<=0 || SVD>num_grafo)
    SVD = num_grafo;
  
  if(SVD > 0) {
    fprintf(stderr,"SVD matrix computation running....");
    Allocating_vw(&w,&v,num_grafo);    
    svdcmp(mat_output,cont_words,num_grafo,w,v);
    fprintf(stderr,"done\n");
    
    fprintf(stderr,"Dimensionality reduction for the term-term matrix....");
    reduced = Reduction(mat_output,w,v,cont_words,num_grafo,SVD);
    fprintf(stderr,"done [SVD : %d]\n",SVD);
    
    fprintf(stderr,"Writing reduced correlation term-term matrix....");
    Write_Correlation_Subdue(reduced,cont_words,min,size);
    fprintf(stderr,"done [Pairs with #nodes >= %d]\n",min);
  }    
  
  i=j=0;
  n = num_grafo;
  SpaceDim = cont_words;
  
  sscanf(argv[3],"%d",&range);
  
  if(range!=1 && range!=2 && range!=3 && range!=4) {
    fprintf(stderr,"\nThe range must be 1..4!!!\n\n");
    exit(-1);
  }

  if(!(fp = fopen("MAPPA","r+"))) {
    printf("file MAPPA not found. Exit...");
    exit(-1);
  }

  if(cont_words == 0) {
    fprintf(stderr,"\nNo substructures found!!!\n\n");
    exit(1);
  }
  
  assert(fp);
  fprintf(stderr,"Loading Data.....");
  Allocating_S();
  Load_Data2(S, n,SpaceDim,fp);
  fprintf(stderr,"done\n");
  fclose(fp);
  
  fprintf(stderr,"Making Clusters with Antipole.....");
  Compute_Radius(range,S,n,&d);
  Tree = NULL;
  C_List = NULL;
  Tree = Build_Tree(S,n, 0, n-1, d,NULL,0,NULL);
  if(TOTAL > 1)
    fprintf(stderr,"done [%d Clusters]\n",TOTAL);
  else
    fprintf(stderr,"done [%d Cluster]\n",TOTAL);

  fprintf(stderr,"Writing file 'output'.....");
  num_clusters = 1;
  fp = fopen("output","w");
  write_output(Tree,name,&num_clusters,fp);
  fclose(fp);
  fprintf(stderr,"done\n");

  nnn = (char *)malloc(sizeof(char)*MAX_STR);
  for(i=0;i<num_grafo;i++) {
    sprintf(nnn,"./subdue_files/%d",i);
    remove(nnn);
    strcat(nnn,".sub");
    remove(nnn);
  }
  free(nnn);

  system("rmdir subdue_files");
  
  /* Free memory */

  fprintf(stderr,"\n\n");
  free(size);
  free_matrix(num_grafo,(void **)name);
  free_matrix(num_grafo,(void **)Mat);
  Libera_S(n);
  Libera_Tree2(Tree);  
  if(SVD >= 0) {
    free_matrix(num_grafo+1,(void **)v);
    free_matrix(cont_words+1,(void **)mat_output);
    free_matrix(cont_words+1,(void **)reduced);
    free(w);
  }
  
  /* End Free memory */
  
  Call_Java();

  return 1;
}
