/*
  GraphBlast
  common.h
  2006(c) Modified by Diego Reforgiato Recupero
  2007(c) Modified by Dmitry Skripin
*/

#ifndef COMMON_H
#define COMMON_H

// sys
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/resource.h>
#include <sys/time.h>

// c++
#include <iostream>
#include <fstream>
#include <ctime>
#include <cerrno>
#include <cstdlib>
#include <string>
#include <map>
#include <vector>
#include <queue>
#include <cassert>
#include <cctype>
#include <string>
#include <pthread.h>
#include <unistd.h>

// oracle berkeley db
#include <db_cxx.h>

// vento lib
#include "argedit.h"
#include "vf2_sub_state.h"
#include "vf_sub_state.h"
#include "vf_state.h"
#include "vf2_state.h"
#include "vf2_mono_state.h"
#include "vf_mono_state.h"
#include "match.h"


// shell commands
inline void rmdir_recursive(char* dir)
{
	// questo comando non  cross-platform, ma al momento non  un grosso problema
	// il messaggio "sh: rm: command not found" pu essere ignorato
	std::string command = "rm -rf ";
	command += dir;
	system(command.c_str());
}


//MAX Table name length and MAX line length
#define MAX_TABLENAME 128
#define MAX_LINE 1024

//int value of OP-commands
#define INTERSECT 0
#define TESTUNIQUE 1
#define SPIT 2
#define CARTESIANPRODUCT 3
#define SELECT 4

#define HASHP 1000

//used namespaces
using namespace std;

//extern control flags

//extern int MAP_X[100][100];
extern bool OUTPUT_DATA_COUNT;	//flag to control if showing the current matched record with each operation
extern bool QUIET_MODE;				//flag to control if showing the debug information
extern bool DEBUG_OPFILE;			//flag to control if showing the debug information of OPFILE
extern bool FILTERING2;

extern int DEFAULT_LP;					//The LP defination
extern int NUM_INTS;					//The Number of Intergers of a FingerPrint. Default is 256. Used in the Frowns Filtering process.
extern int INT_SIZE;						//The size of an int (in bits). Default is 32. Used in Frowns Filtering process.
extern int NUM_FP;						//The group size of fingerprints. Default is 4000. Used in Frowns Filtering process.

extern const string delims;				//The defination of th delims. Used in tools.cpp and opfile.cpp

typedef u_short NodeType;				//Defination of the NodeType
extern const int NodeTypeBitLen;			//The size of an NodeType (in bits). The information is needed when storing data into BekerlyDB

// Used for time measuing
typedef map<char*,double> clockmap;

extern clockmap v_clock_old;
extern clockmap v_clock_sum;
void setclock(char* name,int end_flag);
void printtime(char*name);
void printtime_cl(char*name);

//used data-structures for storing data into DB
//class PathTable;
//class TableWithDegreePaths;
//typedef map<string,PathTable*> Map_PathTable;							    
//typedef map<string,TableWithDegreePaths*> Map_TableWithDegreePaths;         

//utility functions
vector<string> sep_words(const string& str);
NodeType* LoadTablefromDB(Db* db,const char* tablename);
NodeType* sep_DegreeString(const string& str,int lp);

typedef struct listwildconnection {     /* It contains id-nodes connected with wildcards and the valuation of those wildcards */
  int info[3];  /* id-node1, id-node2, wildvalue */
  char op;             /*{g greater, l less, e equal}*/
  struct listwildconnection *next;
  //struct listpaths *p;
}listwildconnection;

extern listwildconnection *wildhead;

//Exception class
class GraphGrepExcp: public exception
{
public:
	GraphGrepExcp(const char* err_str){};
};

class ReadGraphExcp: public exception
{
	int graphID;
public:
	ReadGraphExcp(int id):graphID(id){};

	int getID(){return graphID;}
};



#endif
