/*
 * Decompiled with CFR 0.152.
 */
package processing.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.Socket;
import processing.core.PApplet;

public class Client
implements Runnable {
    PApplet parent;
    Method clientEventMethod;
    Method disconnectEventMethod;
    Thread thread;
    Socket socket;
    String ip;
    int port;
    String host;
    public InputStream input;
    public OutputStream output;
    byte[] buffer = new byte[32768];
    int bufferIndex;
    int bufferLast;

    public Client(PApplet pApplet, String string, int n) {
        this.parent = pApplet;
        this.host = string;
        this.port = n;
        try {
            this.socket = new Socket(this.host, this.port);
            this.input = this.socket.getInputStream();
            this.output = this.socket.getOutputStream();
            this.thread = new Thread(this);
            this.thread.start();
            pApplet.registerDispose(this);
            try {
                this.clientEventMethod = pApplet.getClass().getMethod("clientEvent", Client.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.disconnectEventMethod = pApplet.getClass().getMethod("disconnectEvent", Client.class);
            }
            catch (Exception exception) {}
        }
        catch (ConnectException connectException) {
            connectException.printStackTrace();
            this.dispose();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.dispose();
        }
    }

    public Client(PApplet pApplet, Socket socket) throws IOException {
        this.socket = socket;
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.dispose();
        if (this.disconnectEventMethod != null) {
            try {
                this.disconnectEventMethod.invoke((Object)this.parent, this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.disconnectEventMethod = null;
            }
        }
    }

    public void dispose() {
        this.thread = null;
        try {
            if (this.input != null) {
                this.input.close();
            }
            if (this.output != null) {
                this.output.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.input = null;
        this.output = null;
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        while (Thread.currentThread() == this.thread) {
            try {
                while (this.input != null && this.input.available() > 0) {
                    byte[] byArray = this.buffer;
                    // MONITORENTER : this.buffer
                    if (this.bufferLast == this.buffer.length) {
                        byte[] byArray2 = new byte[this.bufferLast << 1];
                        System.arraycopy(this.buffer, 0, byArray2, 0, this.bufferLast);
                        this.buffer = byArray2;
                    }
                    this.buffer[this.bufferLast++] = (byte)this.input.read();
                    // MONITOREXIT : byArray
                }
                if (this.clientEventMethod != null) {
                    try {
                        this.clientEventMethod.invoke((Object)this.parent, this);
                    }
                    catch (Exception exception) {
                        System.err.println("error, disabling clientEvent() for " + this.host);
                        exception.printStackTrace();
                        this.clientEventMethod = null;
                    }
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public boolean active() {
        return this.thread != null;
    }

    public String ip() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public int available() {
        return this.bufferLast - this.bufferIndex;
    }

    public void clear() {
        this.bufferLast = 0;
        this.bufferIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        if (this.bufferIndex == this.bufferLast) {
            return -1;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n = this.buffer[this.bufferIndex++] & 0xFF;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public char readChar() {
        if (this.bufferIndex == this.bufferLast) {
            return '\uffff';
        }
        return (char)this.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n = this.bufferLast - this.bufferIndex;
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.buffer, this.bufferIndex, byArray2, 0, n);
            this.bufferIndex = 0;
            this.bufferLast = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] byArray) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte[] byArray2 = this.buffer;
        synchronized (this.buffer) {
            int n = this.bufferLast - this.bufferIndex;
            if (n > byArray.length) {
                n = byArray.length;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n);
            this.bufferIndex += n;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytesUntil(int n) {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte by = (byte)n;
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n2;
            int n3 = -1;
            for (n2 = this.bufferIndex; n2 < this.bufferLast; ++n2) {
                if (this.buffer[n2] != by) continue;
                n3 = n2;
                break;
            }
            if (n3 == -1) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            n2 = n3 - this.bufferIndex + 1;
            byte[] byArray2 = new byte[n2];
            System.arraycopy(this.buffer, this.bufferIndex, byArray2, 0, n2);
            this.bufferIndex += n2;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytesUntil(int n, byte[] byArray) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte by = (byte)n;
        byte[] byArray2 = this.buffer;
        synchronized (this.buffer) {
            int n2;
            int n3 = -1;
            for (n2 = this.bufferIndex; n2 < this.bufferLast; ++n2) {
                if (this.buffer[n2] != by) continue;
                n3 = n2;
                break;
            }
            if (n3 == -1) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return 0;
            }
            n2 = n3 - this.bufferIndex + 1;
            if (n2 > byArray.length) {
                System.err.println("readBytesUntil() byte buffer is too small for the " + n2 + " bytes up to and including char " + n);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return -1;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n2);
            this.bufferIndex += n2;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return n2;
        }
    }

    public String readString() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        return new String(this.readBytes());
    }

    public String readStringUntil(int n) {
        byte[] byArray = this.readBytesUntil(n);
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    public void write(int n) {
        try {
            this.output.write(n & 0xFF);
            this.output.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.stop();
        }
    }

    public void write(byte[] byArray) {
        try {
            this.output.write(byArray);
            this.output.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.stop();
        }
    }

    public void write(String string) {
        this.write(string.getBytes());
    }
}

