/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import java.io.File;
import java.lang.reflect.Method;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.io.QTFile;
import quicktime.qd.Pict;
import quicktime.qd.PixMap;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.StdQTException;
import quicktime.std.movies.media.DataRef;
import quicktime.util.EndianOrder;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.RawEncodedImage;

public class Movie
extends PImage
implements PConstants,
Runnable {
    Method movieEventMethod;
    String filename;
    Thread runner;
    PImage borderImage;
    boolean removeBorders = true;
    boolean play;
    boolean repeat;
    boolean available;
    int fps;
    public quicktime.std.movies.Movie movie;
    QDRect movieRect;
    QDGraphics movieGraphics;
    boolean firstFrame = true;
    RawEncodedImage raw;

    public Movie(PApplet pApplet, String string) {
        this(pApplet, string, 30);
    }

    public Movie(PApplet pApplet, String string, int n) {
        super(1, 1, 1);
        this.init(pApplet, string, n);
    }

    public void init(PApplet pApplet, String string, int n) {
        Object object;
        block20: {
            this.parent = pApplet;
            this.fps = n;
            try {
                QTSession.open();
            }
            catch (QTException qTException) {
                qTException.printStackTrace();
                return;
            }
            try {
                try {
                    object = new File(pApplet.dataPath(string));
                    if (((File)object).exists()) {
                        this.movie = this.fromDataRef(new DataRef(new QTFile((File)object)));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.movie != null) break block20;
                try {
                    object = new File(string);
                    if (((File)object).exists()) {
                        this.movie = this.fromDataRef(new DataRef(new QTFile((File)object)));
                    }
                }
                catch (QTException qTException) {}
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.movie == null) {
            object = pApplet.loadBytes(string);
            try {
                this.movie = this.fromDataRef(new DataRef((QTHandleRef)new QTHandle((byte[])object)));
            }
            catch (QTException qTException) {
                qTException.printStackTrace();
            }
        }
        if (this.movie == null) {
            pApplet.die("Could not find movie file " + string, null);
        }
        try {
            this.movie.preroll(0, 1.0f);
            while (this.movie.maxLoadedTimeInMovie() == 0) {
                this.movie.task(100);
            }
            this.movie.setRate(1.0f);
            pApplet.registerDispose(this);
            try {
                this.movieEventMethod = pApplet.getClass().getMethod("movieEvent", Movie.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.runner = new Thread(this);
            this.runner.start();
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private quicktime.std.movies.Movie fromDataRef(DataRef dataRef) throws QTException {
        return quicktime.std.movies.Movie.fromDataRef((DataRef)dataRef, (int)257);
    }

    public boolean available() {
        return this.available;
    }

    public void read() {
        try {
            int n;
            int n2;
            int n3;
            if (this.firstFrame) {
                this.movieRect = this.movie.getBox();
                this.movieGraphics = EndianOrder.isNativeLittleEndian() ? new QDGraphics(1111970369, this.movieRect) : new QDGraphics(QDGraphics.kDefaultPixelFormat, this.movieRect);
            }
            Pict pict = this.movie.getPict(this.movie.getTime());
            pict.draw(this.movieGraphics, this.movieRect);
            PixMap pixMap = this.movieGraphics.getPixMap();
            this.raw = pixMap.getPixelData();
            if (this.firstFrame) {
                n3 = this.movieRect.getWidth();
                n2 = this.movieRect.getHeight();
                n = this.raw.getRowBytes() - n3 * 4;
                int n4 = n / 4;
                int n5 = n3 + n4;
                if (n5 != n3) {
                    if (this.removeBorders) {
                        this.borderImage = new PImage(n5, n2, 1);
                    } else {
                        n3 = n5;
                    }
                }
                super.init(n3, n2, 1);
                this.firstFrame = false;
            }
            this.loadPixels();
            if (this.borderImage != null) {
                this.raw.copyToArray(0, this.borderImage.pixels, 0, this.borderImage.width * this.borderImage.height);
                n3 = 0;
                n2 = 0;
                for (n = 0; n < this.height; ++n) {
                    System.arraycopy(this.borderImage.pixels, n3, this.pixels, n2, this.width);
                    n3 += this.borderImage.width;
                    n2 += this.width;
                }
            } else {
                this.raw.copyToArray(0, this.pixels, 0, this.width * this.height);
            }
            this.updatePixels();
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public void play() {
        this.play = true;
    }

    public void loop() {
        this.play();
        this.repeat = true;
    }

    public void noLoop() {
        this.repeat = false;
    }

    public void pause() {
        this.play = false;
    }

    public void stop() {
        this.play = false;
        try {
            this.movie.setTimeValue(0);
        }
        catch (StdQTException stdQTException) {
            this.errorMessage("stop", (Exception)((Object)stdQTException));
        }
    }

    public void frameRate(int n) {
        if (n <= 0) {
            System.err.println("Movie: ignoring bad frame rate of " + n + " fps.");
        } else {
            this.fps = n;
        }
    }

    public void speed(float f) {
        try {
            this.movie.setRate(f);
        }
        catch (StdQTException stdQTException) {
            this.errorMessage("speed", (Exception)((Object)stdQTException));
        }
    }

    public float time() {
        try {
            return (float)this.movie.getTime() / (float)this.movie.getTimeScale();
        }
        catch (StdQTException stdQTException) {
            this.errorMessage("time", (Exception)((Object)stdQTException));
            return -1.0f;
        }
    }

    public void jump(float f) {
        try {
            int n = (int)(f * (float)this.movie.getTimeScale());
            this.movie.setTimeValue(n);
        }
        catch (StdQTException stdQTException) {
            this.errorMessage("jump", (Exception)((Object)stdQTException));
        }
    }

    public float duration() {
        try {
            return (float)this.movie.getDuration() / (float)this.movie.getTimeScale();
        }
        catch (StdQTException stdQTException) {
            this.errorMessage("length", (Exception)((Object)stdQTException));
            return -1.0f;
        }
    }

    public void run() {
        while (Thread.currentThread() == this.runner) {
            try {
                Thread.sleep(1000 / this.fps);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.play) continue;
            this.available = true;
            if (this.movieEventMethod == null) {
                this.read();
            } else {
                try {
                    this.movieEventMethod.invoke((Object)this.parent, this);
                }
                catch (Exception exception) {
                    System.err.println("error, disabling movieEvent() for " + this.filename);
                    exception.printStackTrace();
                    this.movieEventMethod = null;
                }
            }
            try {
                if (!this.movie.isDone() || !this.repeat) continue;
                this.movie.goToBeginning();
            }
            catch (StdQTException stdQTException) {
                this.play = false;
                this.errorMessage("rewinding", (Exception)((Object)stdQTException));
            }
        }
    }

    public void dispose() {
        this.stop();
        this.runner = null;
        QTSession.close();
    }

    protected void errorMessage(String string, Exception exception) {
        this.parent.die("Error inside Movie." + string + "()", exception);
    }
}

