/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import com.sun.opengl.util.BufferUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.PathIterator;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PGraphics3D;
import processing.core.PImage;

public class PGraphicsOpenGL
extends PGraphics3D {
    protected GLDrawable drawable;
    protected GLContext context;
    public GL gl;
    public GLU glu;
    protected float[] projectionFloats;
    protected GLUtessellator tobj;
    protected TessCallback tessCallback;
    protected float[] lightArray = new float[]{1.0f, 1.0f, 1.0f};
    static int maxTextureSize;
    int[] textureDeleteQueue = new int[10];
    int textureDeleteQueueCount = 0;
    protected float[] colorBuffer;
    protected FloatBuffer zeroBuffer;
    protected IntBuffer pixelBuffer;
    public static boolean BIG_ENDIAN;
    private float[] ctm;
    IntBuffer getsetBuffer = BufferUtil.newIntBuffer(1);

    public PGraphicsOpenGL() {
        this.glu = new GLU();
        this.tobj = this.glu.gluNewTess();
        this.tessCallback = new TessCallback();
        this.glu.gluTessCallback(this.tobj, 100100, this.tessCallback);
        this.glu.gluTessCallback(this.tobj, 100102, this.tessCallback);
        this.glu.gluTessCallback(this.tobj, 100101, this.tessCallback);
        this.glu.gluTessCallback(this.tobj, 100105, this.tessCallback);
        this.glu.gluTessCallback(this.tobj, 100103, this.tessCallback);
    }

    protected void allocate() {
        if (this.context == null) {
            GLCapabilities gLCapabilities = new GLCapabilities();
            if (!this.hints[1]) {
                gLCapabilities.setSampleBuffers(true);
                gLCapabilities.setNumSamples(2);
            } else if (this.hints[2]) {
                gLCapabilities.setSampleBuffers(true);
                gLCapabilities.setNumSamples(4);
            }
            GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory();
            this.drawable = gLDrawableFactory.getGLDrawable(this.parent, gLCapabilities, null);
            this.context = this.drawable.createContext(null);
            this.gl = this.context.getGL();
            this.settingsInited = false;
        } else {
            this.context.destroy();
            this.context = this.drawable.createContext(null);
            this.gl = this.context.getGL();
            this.reapplySettings();
        }
    }

    public GLContext getContext() {
        return this.context;
    }

    protected void detainContext() {
        try {
            while (this.context.makeCurrent() == 0) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    protected void releaseContext() {
        this.context.release();
    }

    public boolean canDraw() {
        return this.parent.isDisplayable();
    }

    public void beginDraw() {
        if (this.drawable != null) {
            this.drawable.setRealized(this.parent.isDisplayable());
            if (!this.parent.isDisplayable()) {
                return;
            }
            this.drawable.setRealized(true);
            this.detainContext();
        }
        super.beginDraw();
        this.report("top beginDraw()");
        this.gl.glDisable(2896);
        for (int i = 0; i < 8; ++i) {
            this.gl.glDisable(16384 + i);
        }
        this.updateProjection();
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
        this.gl.glScalef(1.0f, -1.0f, 1.0f);
        this.gl.glEnable(3042);
        this.gl.glBlendFunc(770, 771);
        if (this.hints[4]) {
            this.gl.glDisable(2929);
        } else {
            this.gl.glEnable(2929);
        }
        this.gl.glDepthFunc(515);
        this.gl.glFrontFace(2304);
        this.gl.glEnable(2903);
        this.gl.glColorMaterial(1032, 5634);
        this.gl.glColorMaterial(1032, 4610);
        this.report("bot beginDraw()");
    }

    public void endDraw() {
        this.report("top endDraw()");
        if (this.hints[5]) {
            this.flush();
        }
        if (this.drawable != null) {
            this.drawable.swapBuffers();
        }
        this.report("bot endDraw()");
        if (this.drawable != null) {
            this.releaseContext();
        }
    }

    public GL beginGL() {
        this.gl.glPushMatrix();
        if (this.ctm == null) {
            this.ctm = new float[16];
        }
        this.ctm[0] = this.modelview.m00;
        this.ctm[1] = this.modelview.m10;
        this.ctm[2] = this.modelview.m20;
        this.ctm[3] = this.modelview.m30;
        this.ctm[4] = this.modelview.m01;
        this.ctm[5] = this.modelview.m11;
        this.ctm[6] = this.modelview.m21;
        this.ctm[7] = this.modelview.m31;
        this.ctm[8] = this.modelview.m02;
        this.ctm[9] = this.modelview.m12;
        this.ctm[10] = this.modelview.m22;
        this.ctm[11] = this.modelview.m32;
        this.ctm[12] = this.modelview.m03;
        this.ctm[13] = this.modelview.m13;
        this.ctm[14] = this.modelview.m23;
        this.ctm[15] = this.modelview.m33;
        this.gl.glMultMatrixf(this.ctm, 0);
        return this.gl;
    }

    public void endGL() {
        this.gl.glPopMatrix();
    }

    public void hint(int n) {
        boolean bl = !this.hints[1];
        boolean bl2 = this.hints[2];
        super.hint(n);
        if (n == 4) {
            this.gl.glDisable(2929);
            this.gl.glClear(256);
        } else if (n == -4) {
            this.gl.glEnable(2929);
        } else if (n == 1) {
            if (bl) {
                this.releaseContext();
                this.context.destroy();
                this.context = null;
                this.allocate();
                throw new PApplet.RendererChangeException();
            }
        } else if (n != -1 && n == 2 && !bl2) {
            this.releaseContext();
            this.context.destroy();
            this.context = null;
            this.allocate();
            throw new PApplet.RendererChangeException();
        }
    }

    protected void endShapeLighting(boolean bl) {
        super.endShapeLighting(bl);
        if (bl) {
            for (int i = this.shapeFirst; i < this.shapeLast; ++i) {
                float[] fArray = this.vertices[i];
                fArray[3] = this.clamp(fArray[3] + fArray[28]);
                fArray[4] = this.clamp(fArray[4] + fArray[29]);
                fArray[5] = this.clamp(fArray[5] + fArray[30]);
            }
        }
    }

    protected void renderPoints(int n, int n2) {
        float f = this.vertices[this.lines[n][0]][17];
        if (f > 0.0f) {
            this.gl.glPointSize(f);
            this.gl.glBegin(0);
            for (int i = n; i < n2; ++i) {
                float[] fArray = this.vertices[this.points[i][0]];
                this.gl.glColor4f(fArray[13], fArray[14], fArray[15], fArray[16]);
                this.gl.glVertex3f(fArray[21], fArray[22], fArray[23]);
            }
            this.gl.glEnd();
        }
    }

    protected void addLine(int n, int n2) {
        this.addLineWithoutClip(n, n2);
    }

    protected void renderLines(int n, int n2) {
        this.report("render_lines in");
        for (int i = 0; i < this.pathCount; ++i) {
            int n3 = this.pathOffset[i];
            float f = this.vertices[this.lines[n3][0]][17];
            if (!(f > 0.0f)) continue;
            this.gl.glLineWidth(f);
            this.gl.glBegin(3);
            float[] fArray = this.vertices[this.lines[n3][0]];
            this.gl.glColor4f(fArray[13], fArray[14], fArray[15], fArray[16]);
            this.gl.glVertex3f(fArray[21], fArray[22], fArray[23]);
            for (int j = 0; j < this.pathLength[i]; ++j) {
                float[] fArray2 = this.vertices[this.lines[n3][1]];
                this.gl.glColor4f(fArray2[13], fArray2[14], fArray2[15], fArray2[16]);
                this.gl.glVertex3f(fArray2[21], fArray2[22], fArray2[23]);
                ++n3;
            }
            this.gl.glEnd();
        }
        this.report("render_lines out");
    }

    protected void addTriangle(int n, int n2, int n3) {
        this.addTriangleWithoutClip(n, n2, n3);
    }

    protected void renderTriangles(int n, int n2) {
        this.report("render_triangles in");
        for (int i = n; i < n2; ++i) {
            float[] fArray = this.vertices[this.triangles[i][0]];
            float[] fArray2 = this.vertices[this.triangles[i][1]];
            float[] fArray3 = this.vertices[this.triangles[i][2]];
            float f = this.clamp(this.triangleColors[i][0][0] + this.triangleColors[i][0][4]);
            float f2 = this.clamp(this.triangleColors[i][0][1] + this.triangleColors[i][0][5]);
            float f3 = this.clamp(this.triangleColors[i][0][2] + this.triangleColors[i][0][6]);
            float f4 = this.clamp(this.triangleColors[i][1][0] + this.triangleColors[i][1][4]);
            float f5 = this.clamp(this.triangleColors[i][1][1] + this.triangleColors[i][1][5]);
            float f6 = this.clamp(this.triangleColors[i][1][2] + this.triangleColors[i][1][6]);
            float f7 = this.clamp(this.triangleColors[i][2][0] + this.triangleColors[i][2][4]);
            float f8 = this.clamp(this.triangleColors[i][2][1] + this.triangleColors[i][2][5]);
            float f9 = this.clamp(this.triangleColors[i][2][2] + this.triangleColors[i][2][6]);
            int n3 = this.triangles[i][3];
            if (n3 != -1) {
                this.report("before enable");
                this.gl.glEnable(3553);
                this.report("after enable");
                this.report("before bind");
                PImage pImage = this.textures[n3];
                this.bindTexture(pImage);
                this.report("after bind");
                ImageCache imageCache = (ImageCache)pImage.getCache(this);
                float f10 = (float)pImage.width / (float)imageCache.twidth;
                float f11 = (float)pImage.height / (float)imageCache.theight;
                this.gl.glBegin(4);
                this.gl.glColor4f(f, f2, f3, fArray[6]);
                this.gl.glTexCoord2f(fArray[7] * f10, fArray[8] * f11);
                this.gl.glNormal3f(fArray[9], fArray[10], fArray[11]);
                this.gl.glEdgeFlag(fArray[12] == 1.0f);
                this.gl.glVertex3f(fArray[21], fArray[22], fArray[23]);
                this.gl.glColor4f(f4, f5, f6, fArray2[6]);
                this.gl.glTexCoord2f(fArray2[7] * f10, fArray2[8] * f11);
                this.gl.glNormal3f(fArray2[9], fArray2[10], fArray2[11]);
                this.gl.glEdgeFlag(fArray[12] == 1.0f);
                this.gl.glVertex3f(fArray2[21], fArray2[22], fArray2[23]);
                this.gl.glColor4f(f7, f8, f9, fArray3[6]);
                this.gl.glTexCoord2f(fArray3[7] * f10, fArray3[8] * f11);
                this.gl.glNormal3f(fArray3[9], fArray3[10], fArray3[11]);
                this.gl.glEdgeFlag(fArray[12] == 1.0f);
                this.gl.glVertex3f(fArray3[21], fArray3[22], fArray3[23]);
                this.gl.glEnd();
                this.report("non-binding 6");
                this.gl.glDisable(3553);
                continue;
            }
            this.gl.glBegin(4);
            this.gl.glColor4f(f, f2, f3, fArray[6]);
            this.gl.glNormal3f(fArray[9], fArray[10], fArray[11]);
            this.gl.glEdgeFlag(fArray[12] == 1.0f);
            this.gl.glVertex3f(fArray[21], fArray[22], fArray[23]);
            this.gl.glColor4f(f4, f5, f6, fArray2[6]);
            this.gl.glNormal3f(fArray2[9], fArray2[10], fArray2[11]);
            this.gl.glEdgeFlag(fArray[12] == 1.0f);
            this.gl.glVertex3f(fArray2[21], fArray2[22], fArray2[23]);
            this.gl.glColor4f(f7, f8, f9, fArray3[6]);
            this.gl.glNormal3f(fArray3[9], fArray3[10], fArray3[11]);
            this.gl.glEdgeFlag(fArray[12] == 1.0f);
            this.gl.glVertex3f(fArray3[21], fArray3[22], fArray3[23]);
            this.gl.glEnd();
        }
        this.report("render_triangles out");
    }

    protected void bindTexture(PImage pImage) {
        ImageCache imageCache = (ImageCache)pImage.getCache(this);
        if (imageCache == null) {
            imageCache = new ImageCache();
            pImage.setCache(this, imageCache);
            pImage.setModified(true);
        }
        if (pImage.isModified()) {
            imageCache.rebind(pImage);
            pImage.setModified(false);
        } else {
            this.gl.glBindTexture(3553, imageCache.tindex);
        }
    }

    public void smooth() {
        this.smooth = true;
        if (this.hints[1]) {
            this.gl.glEnable(2832);
            this.gl.glEnable(2848);
            this.gl.glEnable(2881);
        }
    }

    public void noSmooth() {
        this.smooth = false;
        if (this.hints[1]) {
            this.gl.glDisable(2832);
            this.gl.glDisable(2848);
            this.gl.glDisable(2881);
        }
    }

    public float textAscent() {
        Font font = this.textFont.getFont();
        if (this.textMode != 5 || font == null) {
            return super.textAscent();
        }
        FontMetrics fontMetrics = this.parent.getFontMetrics(font);
        return fontMetrics.getAscent();
    }

    public float textDescent() {
        Font font = this.textFont.getFont();
        if (this.textMode != 5 || font == null) {
            return super.textDescent();
        }
        FontMetrics fontMetrics = this.parent.getFontMetrics(font);
        return fontMetrics.getDescent();
    }

    public void textFont(PFont pFont) {
        super.textFont(pFont);
        if (this.textMode == 5 && this.textFont.findFont() == null) {
            PGraphicsOpenGL.showWarning("Cannot use " + pFont.getName() + " as with textMode(SHAPE) " + "because its native equivalent cannot be found.");
        }
    }

    protected boolean textModeCheck(int n) {
        return this.textMode == 4 || this.textMode == 256 || this.textMode == 5;
    }

    protected float textWidthImpl(char[] cArray, int n, int n2) {
        Font font = this.textFont.getFont();
        if (this.textMode != 5 || font == null) {
            return super.textWidthImpl(cArray, n, n2);
        }
        Graphics2D graphics2D = (Graphics2D)this.parent.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, cArray);
        float f = 0.0f;
        for (int i = n; i < n2; ++i) {
            GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(i);
            f += glyphMetrics.getAdvance();
        }
        return f;
    }

    protected void textCharImpl(char c, float f, float f2) {
        if (this.textMode == 5) {
            if (this.textFont.getFont() == null) {
                PGraphics.showWarning("textMode(SHAPE) is disabled because the font \"" + this.textFont.getName() + "\" is not available.");
            } else {
                this.textCharShapeImpl(c, f, f2);
            }
        } else {
            super.textCharImpl(c, f, f2);
        }
    }

    protected void textCharShapeImpl(char c, float f, float f2) {
        boolean bl = this.stroke;
        this.stroke = false;
        float[] fArray = new float[6];
        char[] cArray = new char[]{c};
        Graphics2D graphics2D = (Graphics2D)this.parent.getGraphics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = this.textFont.getFont();
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, cArray);
        Shape shape = glyphVector.getOutline();
        PathIterator pathIterator = shape.getPathIterator(null);
        this.glu.gluTessBeginPolygon(this.tobj, null);
        float f3 = 0.0f;
        float f4 = 0.0f;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: 
                case 1: {
                    if (n == 0) {
                        this.glu.gluTessBeginContour(this.tobj);
                    }
                    double[] dArray = new double[]{f + fArray[0], f2 + fArray[1], 0.0};
                    this.glu.gluTessVertex(this.tobj, dArray, 0, dArray);
                    f3 = fArray[0];
                    f4 = fArray[1];
                    break;
                }
                case 2: {
                    float f5;
                    int n2;
                    double[] dArray;
                    for (n2 = 1; n2 < this.bezierDetail; ++n2) {
                        f5 = (float)n2 / (float)this.bezierDetail;
                        dArray = new double[]{f + this.bezierPoint(f3, f3 + (float)((double)((fArray[0] - f3) * 2.0f) / 3.0), fArray[2] + (float)((double)((fArray[0] - fArray[2]) * 2.0f) / 3.0), fArray[2], f5), f2 + this.bezierPoint(f4, f4 + (float)((double)((fArray[1] - f4) * 2.0f) / 3.0), fArray[3] + (float)((double)((fArray[1] - fArray[3]) * 2.0f) / 3.0), fArray[3], f5), 0.0};
                        this.glu.gluTessVertex(this.tobj, dArray, 0, dArray);
                    }
                    f3 = fArray[2];
                    f4 = fArray[3];
                    break;
                }
                case 3: {
                    float f5;
                    int n2;
                    double[] dArray;
                    for (n2 = 1; n2 < this.bezierDetail; ++n2) {
                        f5 = (float)n2 / (float)this.bezierDetail;
                        dArray = new double[]{f + this.bezierPoint(f3, fArray[0], fArray[2], fArray[4], f5), f2 + this.bezierPoint(f4, fArray[1], fArray[3], fArray[5], f5), 0.0};
                        this.glu.gluTessVertex(this.tobj, dArray, 0, dArray);
                    }
                    f3 = fArray[4];
                    f4 = fArray[5];
                    break;
                }
                case 4: {
                    this.glu.gluTessEndContour(this.tobj);
                }
            }
            pathIterator.next();
        }
        this.glu.gluTessEndPolygon(this.tobj);
        this.stroke = bl;
    }

    protected void updateProjection() {
        this.gl.glMatrixMode(5889);
        if (this.projectionFloats == null) {
            this.projectionFloats = new float[]{this.projection.m00, this.projection.m10, this.projection.m20, this.projection.m30, this.projection.m01, this.projection.m11, this.projection.m21, this.projection.m31, this.projection.m02, this.projection.m12, this.projection.m22, this.projection.m32, this.projection.m03, this.projection.m13, this.projection.m23, this.projection.m33};
        } else {
            this.projectionFloats[0] = this.projection.m00;
            this.projectionFloats[1] = this.projection.m10;
            this.projectionFloats[2] = this.projection.m20;
            this.projectionFloats[3] = this.projection.m30;
            this.projectionFloats[4] = this.projection.m01;
            this.projectionFloats[5] = this.projection.m11;
            this.projectionFloats[6] = this.projection.m21;
            this.projectionFloats[7] = this.projection.m31;
            this.projectionFloats[8] = this.projection.m02;
            this.projectionFloats[9] = this.projection.m12;
            this.projectionFloats[10] = this.projection.m22;
            this.projectionFloats[11] = this.projection.m32;
            this.projectionFloats[12] = this.projection.m03;
            this.projectionFloats[13] = this.projection.m13;
            this.projectionFloats[14] = this.projection.m23;
            this.projectionFloats[15] = this.projection.m33;
        }
        this.gl.glLoadMatrixf(this.projectionFloats, 0);
    }

    public void strokeWeight(float f) {
        this.strokeWeight = f;
    }

    public void strokeJoin(int n) {
        if (n != 8) {
            PGraphicsOpenGL.showMethodWarning("strokeJoin");
        }
    }

    public void strokeCap(int n) {
        if (n != 2) {
            PGraphicsOpenGL.showMethodWarning("strokeCap");
        }
    }

    protected void fillFromCalc() {
        super.fillFromCalc();
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 5634, this.colorBuffer, 0);
    }

    protected void ambientFromCalc() {
        super.ambientFromCalc();
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 4608, this.colorBuffer, 0);
    }

    protected void specularFromCalc() {
        super.specularFromCalc();
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 4610, this.colorBuffer, 0);
    }

    public void shininess(float f) {
        super.shininess(f);
        this.gl.glMaterialf(1032, 5633, f);
    }

    protected void emissiveFromCalc() {
        super.emissiveFromCalc();
        this.calcColorBuffer();
        this.gl.glMaterialfv(1032, 5632, this.colorBuffer, 0);
    }

    public void ambientLight(float f, float f2, float f3) {
        super.ambientLight(f, f2, f3);
        this.glLightEnable(this.lightCount - 1);
        this.glLightAmbient(this.lightCount - 1);
        this.glLightPosition(this.lightCount - 1);
        this.glLightFalloff(this.lightCount - 1);
    }

    public void ambientLight(float f, float f2, float f3, float f4, float f5, float f6) {
        super.ambientLight(f, f2, f3, f4, f5, f6);
        this.glLightEnable(this.lightCount - 1);
        this.glLightAmbient(this.lightCount - 1);
        this.glLightPosition(this.lightCount - 1);
        this.glLightFalloff(this.lightCount - 1);
    }

    public void directionalLight(float f, float f2, float f3, float f4, float f5, float f6) {
        super.directionalLight(f, f2, f3, f4, f5, f6);
        this.glLightEnable(this.lightCount - 1);
        this.glLightNoAmbient(this.lightCount - 1);
        this.glLightDirection(this.lightCount - 1);
        this.glLightDiffuse(this.lightCount - 1);
        this.glLightSpecular(this.lightCount - 1);
        this.glLightFalloff(this.lightCount - 1);
    }

    public void pointLight(float f, float f2, float f3, float f4, float f5, float f6) {
        super.pointLight(f, f2, f3, f4, f5, f6);
        this.glLightEnable(this.lightCount - 1);
        this.glLightNoAmbient(this.lightCount - 1);
        this.glLightPosition(this.lightCount - 1);
        this.glLightDiffuse(this.lightCount - 1);
        this.glLightSpecular(this.lightCount - 1);
        this.glLightFalloff(this.lightCount - 1);
    }

    public void spotLight(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        super.spotLight(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11);
        this.glLightNoAmbient(this.lightCount - 1);
        this.glLightPosition(this.lightCount - 1);
        this.glLightDirection(this.lightCount - 1);
        this.glLightDiffuse(this.lightCount - 1);
        this.glLightSpecular(this.lightCount - 1);
        this.glLightFalloff(this.lightCount - 1);
        this.glLightSpotAngle(this.lightCount - 1);
        this.glLightSpotConcentration(this.lightCount - 1);
    }

    public void lightFalloff(float f, float f2, float f3) {
        super.lightFalloff(f, f2, f3);
        this.glLightFalloff(this.lightCount);
    }

    public void lightSpecular(float f, float f2, float f3) {
        super.lightSpecular(f, f2, f3);
        this.glLightSpecular(this.lightCount);
    }

    protected void lightPosition(int n, float f, float f2, float f3) {
        super.lightPosition(n, f, f2, f3);
        this.glLightPosition(n);
    }

    protected void lightDirection(int n, float f, float f2, float f3) {
        super.lightDirection(n, f, f2, f3);
        this.glLightDirection(n);
    }

    private void glLightAmbient(int n) {
        this.gl.glLightfv(16384 + n, 4608, this.lightDiffuse[n], 0);
    }

    private void glLightNoAmbient(int n) {
        if (this.zeroBuffer == null) {
            this.zeroBuffer = BufferUtil.newFloatBuffer(3);
        }
        this.gl.glLightfv(16384 + n, 4608, this.zeroBuffer);
    }

    private void glLightDiffuse(int n) {
        this.gl.glLightfv(16384 + n, 4609, this.lightDiffuse[n], 0);
    }

    private void glLightDirection(int n) {
        if (this.lightType[n] == 1) {
            this.gl.glLightfv(16384 + n, 4611, this.lightNormal[n].array(), 0);
        } else {
            this.gl.glLightfv(16384 + n, 4612, this.lightNormal[n].array(), 0);
        }
    }

    private void glLightEnable(int n) {
        this.gl.glEnable(16384 + n);
    }

    private void glLightFalloff(int n) {
        this.gl.glLightf(16384 + n, 4615, this.lightFalloffConstant[n]);
        this.gl.glLightf(16384 + n, 4616, this.lightFalloffLinear[n]);
        this.gl.glLightf(16384 + n, 4617, this.lightFalloffQuadratic[n]);
    }

    private void glLightPosition(int n) {
        this.gl.glLightfv(16384 + n, 4611, this.lightPosition[n].array(), 0);
    }

    private void glLightSpecular(int n) {
        this.gl.glLightfv(16384 + n, 4610, this.lightSpecular[n], 0);
    }

    private void glLightSpotAngle(int n) {
        this.gl.glLightf(16384 + n, 4614, this.lightSpotAngle[n]);
    }

    private void glLightSpotConcentration(int n) {
        this.gl.glLightf(16384 + n, 4613, this.lightSpotConcentration[n]);
    }

    protected void backgroundImpl(PImage pImage) {
        this.gl.glClearColor(this.backgroundR, this.backgroundG, this.backgroundB, 1.0f);
        this.gl.glClear(16640);
        this.set(0, 0, pImage);
    }

    protected void backgroundImpl() {
        this.gl.glClearColor(this.backgroundR, this.backgroundG, this.backgroundB, 1.0f);
        this.gl.glClear(16640);
    }

    private final void calcColorBuffer() {
        if (this.colorBuffer == null) {
            this.colorBuffer = new float[4];
        }
        this.colorBuffer[0] = this.calcR;
        this.colorBuffer[1] = this.calcG;
        this.colorBuffer[2] = this.calcB;
        this.colorBuffer[3] = this.calcA;
    }

    public void report(String string) {
        int n;
        if (!this.hints[6] && (n = this.gl.glGetError()) != 0) {
            String string2 = this.glu.gluErrorString(n);
            String string3 = "OpenGL error " + n + " at " + string + ": " + string2;
            PGraphics.showWarning(string3);
        }
    }

    public void loadPixels() {
        block10: {
            int n;
            if (this.pixels == null || this.pixels.length != this.width * this.height) {
                this.pixels = new int[this.width * this.height];
                this.pixelBuffer = BufferUtil.newIntBuffer(this.pixels.length);
            }
            this.gl.glReadPixels(0, 0, this.width, this.height, 6408, 5121, this.pixelBuffer);
            this.pixelBuffer.get(this.pixels);
            this.pixelBuffer.rewind();
            int n2 = 0;
            int n3 = (this.height - 1) * this.width;
            for (n = 0; n < this.height / 2; ++n) {
                int n4;
                int n5;
                if (BIG_ENDIAN) {
                    for (n5 = 0; n5 < this.width; ++n5) {
                        n4 = this.pixels[n2];
                        this.pixels[n2] = 0xFF000000 | this.pixels[n3] >> 8 & 0xFFFFFF;
                        this.pixels[n3] = 0xFF000000 | n4 >> 8 & 0xFFFFFF;
                        ++n2;
                        ++n3;
                    }
                } else {
                    for (n5 = 0; n5 < this.width; ++n5) {
                        n4 = this.pixels[n2];
                        this.pixels[n2] = 0xFF000000 | this.pixels[n3] << 16 & 0xFF0000 | this.pixels[n3] & 0xFF00 | this.pixels[n3] >> 16 & 0xFF;
                        this.pixels[n3] = 0xFF000000 | n4 << 16 & 0xFF0000 | n4 & 0xFF00 | n4 >> 16 & 0xFF;
                        ++n2;
                        ++n3;
                    }
                }
                n3 -= this.width * 2;
            }
            if (this.height % 2 != 1) break block10;
            n2 = this.height / 2 * this.width;
            if (BIG_ENDIAN) {
                for (n = 0; n < this.width; ++n) {
                    this.pixels[n2] = 0xFF000000 | this.pixels[n2] >> 8 & 0xFFFFFF;
                }
            } else {
                for (n = 0; n < this.width; ++n) {
                    this.pixels[n2] = 0xFF000000 | this.pixels[n2] << 16 & 0xFF0000 | this.pixels[n2] & 0xFF00 | this.pixels[n2] >> 16 & 0xFF;
                }
            }
        }
    }

    static void nativeToJavaRGB(PImage pImage) {
        int n = 0;
        int n2 = (pImage.height - 1) * pImage.width;
        for (int i = 0; i < pImage.height / 2; ++i) {
            int n3;
            int n4;
            if (BIG_ENDIAN) {
                for (n4 = 0; n4 < pImage.width; ++n4) {
                    n3 = pImage.pixels[n];
                    pImage.pixels[n] = 0xFF000000 | pImage.pixels[n2] >> 8 & 0xFFFFFF;
                    pImage.pixels[n2] = 0xFF000000 | n3 >> 8 & 0xFFFFFF;
                    ++n;
                    ++n2;
                }
            } else {
                for (n4 = 0; n4 < pImage.width; ++n4) {
                    n3 = pImage.pixels[n];
                    pImage.pixels[n] = 0xFF000000 | pImage.pixels[n2] << 16 & 0xFF0000 | pImage.pixels[n2] & 0xFF00 | pImage.pixels[n2] >> 16 & 0xFF;
                    pImage.pixels[n2] = 0xFF000000 | n3 << 16 & 0xFF0000 | n3 & 0xFF00 | n3 >> 16 & 0xFF;
                    ++n;
                    ++n2;
                }
            }
            n2 -= pImage.width * 2;
        }
    }

    static void nativeToJavaARGB(PImage pImage) {
        int n = 0;
        int n2 = (pImage.height - 1) * pImage.width;
        for (int i = 0; i < pImage.height / 2; ++i) {
            int n3;
            int n4;
            if (BIG_ENDIAN) {
                for (n4 = 0; n4 < pImage.width; ++n4) {
                    n3 = pImage.pixels[n];
                    pImage.pixels[n] = pImage.pixels[n2] & 0xFF000000 | pImage.pixels[n2] >> 8 & 0xFFFFFF;
                    pImage.pixels[n2] = n3 & 0xFF000000 | n3 >> 8 & 0xFFFFFF;
                    ++n;
                    ++n2;
                }
            } else {
                for (n4 = 0; n4 < pImage.width; ++n4) {
                    n3 = pImage.pixels[n];
                    pImage.pixels[n] = pImage.pixels[n2] & 0xFF000000 | pImage.pixels[n2] << 16 & 0xFF0000 | pImage.pixels[n2] & 0xFF00 | pImage.pixels[n2] >> 16 & 0xFF;
                    pImage.pixels[n2] = n3 & 0xFF000000 | n3 << 16 & 0xFF0000 | n3 & 0xFF00 | n3 >> 16 & 0xFF;
                    ++n;
                    ++n2;
                }
            }
            n2 -= pImage.width * 2;
        }
    }

    static void javaToNativeRGB(PImage pImage) {
        int n = pImage.width;
        int n2 = pImage.height;
        int[] nArray = pImage.pixels;
        int n3 = 0;
        int n4 = (n2 - 1) * n;
        for (int i = 0; i < n2 / 2; ++i) {
            int n5;
            int n6;
            if (BIG_ENDIAN) {
                for (n6 = 0; n6 < pImage.width; ++n6) {
                    n5 = nArray[n3];
                    nArray[n3] = nArray[n4] << 8 & 0xFFFFFF00 | 0xFF;
                    nArray[n4] = n5 << 8 & 0xFFFFFF00 | 0xFF;
                    ++n3;
                    ++n4;
                }
            } else {
                for (n6 = 0; n6 < n; ++n6) {
                    n5 = nArray[n3];
                    nArray[n3] = 0xFF000000 | nArray[n4] << 16 & 0xFF0000 | nArray[n4] & 0xFF00 | nArray[n4] >> 16 & 0xFF;
                    nArray[n4] = 0xFF000000 | n5 << 16 & 0xFF0000 | n5 & 0xFF00 | n5 >> 16 & 0xFF;
                    ++n3;
                    ++n4;
                }
            }
            n4 -= n * 2;
        }
    }

    static void javaToNativeARGB(PImage pImage) {
        int n = pImage.width;
        int n2 = pImage.height;
        int[] nArray = pImage.pixels;
        int n3 = 0;
        int n4 = (n2 - 1) * n;
        for (int i = 0; i < n2 / 2; ++i) {
            int n5;
            int n6;
            if (BIG_ENDIAN) {
                for (n6 = 0; n6 < pImage.width; ++n6) {
                    n5 = nArray[n3];
                    nArray[n3] = nArray[n4] >> 24 & 0xFF | nArray[n4] << 8 & 0xFFFFFF00;
                    nArray[n4] = n5 >> 24 & 0xFF | n5 << 8 & 0xFFFFFF00;
                    ++n3;
                    ++n4;
                }
            } else {
                for (n6 = 0; n6 < n; ++n6) {
                    n5 = nArray[n3];
                    nArray[n3] = nArray[n4] & 0xFF000000 | nArray[n4] << 16 & 0xFF0000 | nArray[n4] & 0xFF00 | nArray[n4] >> 16 & 0xFF;
                    nArray[n4] = nArray[n4] & 0xFF000000 | n5 << 16 & 0xFF0000 | n5 & 0xFF00 | n5 >> 16 & 0xFF;
                    ++n3;
                    ++n4;
                }
            }
            n4 -= n * 2;
        }
    }

    public void updatePixels() {
        int n = 0;
        int n2 = (this.height - 1) * this.width;
        for (int i = 0; i < this.height / 2; ++i) {
            int n3;
            int n4;
            if (BIG_ENDIAN) {
                for (n4 = 0; n4 < this.width; ++n4) {
                    n3 = this.pixels[n];
                    this.pixels[n] = this.pixels[n2] << 8 & 0xFFFFFF00 | 0xFF;
                    this.pixels[n2] = n3 << 8 & 0xFFFFFF00 | 0xFF;
                    ++n;
                    ++n2;
                }
            } else {
                for (n4 = 0; n4 < this.width; ++n4) {
                    n3 = this.pixels[n];
                    this.pixels[n] = 0xFF000000 | this.pixels[n2] << 16 & 0xFF0000 | this.pixels[n2] & 0xFF00 | this.pixels[n2] >> 16 & 0xFF;
                    this.pixels[n2] = 0xFF000000 | n3 << 16 & 0xFF0000 | n3 & 0xFF00 | n3 >> 16 & 0xFF;
                    ++n;
                    ++n2;
                }
            }
            n2 -= this.width * 2;
        }
        this.setRasterPos(0.0f, 0.0f);
        this.pixelBuffer.put(this.pixels);
        this.pixelBuffer.rewind();
        this.gl.glDrawPixels(this.width, this.height, 6408, 5121, this.pixelBuffer);
    }

    public void resize(int n, int n2) {
        PGraphics.showMethodWarning("resize");
    }

    public int get(int n, int n2) {
        this.gl.glReadPixels(n, n2, 1, 1, 6408, 5121, this.getsetBuffer);
        int n3 = this.getsetBuffer.get(0);
        if (BIG_ENDIAN) {
            return 0xFF000000 | n3 >> 8 & 0xFFFFFF;
        }
        return 0xFF000000 | n3 << 16 & 0xFF0000 | n3 & 0xFF00 | n3 >> 16 & 0xFF;
    }

    protected PImage getImpl(int n, int n2, int n3, int n4) {
        PImage pImage = new PImage(n3, n4);
        pImage.parent = this.parent;
        IntBuffer intBuffer = BufferUtil.newIntBuffer(n3 * n4);
        this.gl.glReadPixels(n, n2, n3, n4, 6408, 5121, intBuffer);
        intBuffer.get(pImage.pixels);
        PGraphicsOpenGL.nativeToJavaARGB(pImage);
        return pImage;
    }

    public PImage get() {
        return this.get(0, 0, this.width, this.height);
    }

    public void set(int n, int n2, int n3) {
        int n4 = 0;
        n4 = BIG_ENDIAN ? n3 << 8 | 0xFF : n3 & 0xFF00FF00 | n3 << 16 & 0xFF0000 | n3 >> 16 & 0xFF;
        this.getsetBuffer.put(0, n4);
        this.getsetBuffer.rewind();
        this.setRasterPos(n, this.height - n2 - 1);
        this.gl.glDrawPixels(1, 1, 6408, 5121, this.getsetBuffer);
    }

    public void set(int n, int n2, PImage pImage) {
        int[] nArray = new int[pImage.pixels.length];
        System.arraycopy(pImage.pixels, 0, nArray, 0, pImage.pixels.length);
        PGraphicsOpenGL.javaToNativeARGB(pImage);
        IntBuffer intBuffer = BufferUtil.newIntBuffer(pImage.pixels.length);
        intBuffer.put(pImage.pixels);
        intBuffer.rewind();
        this.setRasterPos(n, this.height - n2 - pImage.height);
        this.gl.glDrawPixels(pImage.width, pImage.height, 6408, 5121, intBuffer);
        pImage.pixels = nArray;
    }

    protected void setRasterPos(float f, float f2) {
        float f3 = 0.0f;
        float f4 = 1.0f;
        this.gl.glPushAttrib(6144);
        this.gl.glMatrixMode(5889);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glMatrixMode(5888);
        this.gl.glPushMatrix();
        this.gl.glLoadIdentity();
        this.gl.glDepthRange(f3, f3);
        this.gl.glViewport((int)f - 1, (int)f2 - 1, 2, 2);
        float f5 = f - (float)((int)f);
        float f6 = f2 - (float)((int)f2);
        this.gl.glRasterPos4f(f5, f6, 0.0f, f4);
        this.gl.glPopMatrix();
        this.gl.glMatrixMode(5889);
        this.gl.glPopMatrix();
        this.gl.glPopAttrib();
    }

    public void mask(int[] nArray) {
        PGraphics.showMethodWarning("mask");
    }

    public void mask(PImage pImage) {
        PGraphics.showMethodWarning("mask");
    }

    public void filter(int n) {
        PImage pImage = this.get();
        pImage.filter(n);
        this.set(0, 0, pImage);
    }

    public void filter(int n, float f) {
        PImage pImage = this.get();
        pImage.filter(n, f);
        this.set(0, 0, pImage);
    }

    protected final float clamp(float f) {
        return f < 1.0f ? f : 1.0f;
    }

    static {
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    }

    public class TessCallback
    extends GLUtessellatorCallbackAdapter {
        public void begin(int n) {
            switch (n) {
                case 6: {
                    PGraphicsOpenGL.this.beginShape(11);
                    break;
                }
                case 5: {
                    PGraphicsOpenGL.this.beginShape(10);
                    break;
                }
                case 4: {
                    PGraphicsOpenGL.this.beginShape(9);
                }
            }
        }

        public void end() {
            PGraphicsOpenGL.this.endShape();
        }

        public void edge(boolean bl) {
            PGraphicsOpenGL.this.edge(bl);
        }

        public void vertex(Object object) {
            double[] dArray;
            if (object instanceof double[]) {
                dArray = (double[])object;
                if (dArray.length != 3) {
                    throw new RuntimeException("TessCallback vertex() data isn't length 3");
                }
            } else {
                throw new RuntimeException("TessCallback vertex() data not understood");
            }
            PGraphicsOpenGL.this.vertex((float)dArray[0], (float)dArray[1], (float)dArray[2]);
        }

        public void error(int n) {
            String string = PGraphicsOpenGL.this.glu.gluErrorString(n);
            PGraphics.showWarning("Tessellation Error: " + string);
        }

        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            double[] dArray2 = new double[dArray.length];
            dArray2[0] = dArray[0];
            dArray2[1] = dArray[1];
            dArray2[2] = dArray[2];
            objectArray2[0] = dArray2;
        }
    }

    protected class ImageCache {
        int tindex = -1;
        int[] tpixels;
        IntBuffer tbuffer;
        public int twidth;
        public int theight;
        int[] tp;

        protected ImageCache() {
        }

        protected void finalize() {
            if (PGraphicsOpenGL.this.textureDeleteQueue.length == PGraphicsOpenGL.this.textureDeleteQueueCount) {
                PGraphicsOpenGL.this.textureDeleteQueue = PApplet.expand(PGraphicsOpenGL.this.textureDeleteQueue);
            }
            if (this.tindex != -1) {
                PGraphicsOpenGL.this.textureDeleteQueue[PGraphicsOpenGL.this.textureDeleteQueueCount++] = this.tindex;
            }
        }

        public void rebind(PImage pImage) {
            block29: {
                int n;
                block28: {
                    if (PGraphicsOpenGL.this.textureDeleteQueueCount != 0) {
                        PGraphicsOpenGL.this.gl.glDeleteTextures(PGraphicsOpenGL.this.textureDeleteQueueCount, PGraphicsOpenGL.this.textureDeleteQueue, 0);
                        PGraphicsOpenGL.this.textureDeleteQueueCount = 0;
                    }
                    if (this.tindex != -1) {
                        PGraphicsOpenGL.this.gl.glDeleteTextures(1, new int[]{this.tindex}, 0);
                    }
                    int[] nArray = new int[1];
                    PGraphicsOpenGL.this.gl.glGenTextures(1, nArray, 0);
                    this.tindex = nArray[0];
                    int n2 = this.nextPowerOfTwo(pImage.width);
                    int n3 = this.nextPowerOfTwo(pImage.height);
                    if (maxTextureSize == 0) {
                        int[] nArray2 = new int[1];
                        PGraphicsOpenGL.this.gl.glGetIntegerv(3379, nArray2, 0);
                        maxTextureSize = nArray2[0];
                    }
                    if (n2 > maxTextureSize || n3 > maxTextureSize) {
                        throw new RuntimeException("Image width and height cannot be larger than " + maxTextureSize + " with this graphics card.");
                    }
                    if (n2 > this.twidth || n3 > this.theight) {
                        this.tpixels = null;
                    }
                    if (this.tpixels == null) {
                        this.twidth = n2;
                        this.theight = n3;
                        this.tpixels = new int[this.twidth * this.theight];
                        this.tbuffer = BufferUtil.newIntBuffer(this.twidth * this.theight);
                    }
                    n = 0;
                    int n4 = 0;
                    if (!BIG_ENDIAN) break block28;
                    switch (pImage.format) {
                        case 4: {
                            for (int i = 0; i < pImage.height; ++i) {
                                for (int j = 0; j < pImage.width; ++j) {
                                    this.tpixels[n4++] = 0xFFFFFF00 | pImage.pixels[n++];
                                }
                                n4 += this.twidth - pImage.width;
                            }
                            break block29;
                        }
                        case 1: {
                            for (int i = 0; i < pImage.height; ++i) {
                                for (int j = 0; j < pImage.width; ++j) {
                                    int n5 = pImage.pixels[n++];
                                    this.tpixels[n4++] = n5 << 8 | 0xFF;
                                }
                                n4 += this.twidth - pImage.width;
                            }
                            break block29;
                        }
                        case 2: {
                            for (int i = 0; i < pImage.height; ++i) {
                                for (int j = 0; j < pImage.width; ++j) {
                                    int n6 = pImage.pixels[n++];
                                    this.tpixels[n4++] = n6 << 8 | n6 >> 24 & 0xFF;
                                }
                                n4 += this.twidth - pImage.width;
                            }
                            break;
                        }
                    }
                    break block29;
                }
                switch (pImage.format) {
                    case 4: {
                        for (int i = 0; i < pImage.height; ++i) {
                            for (int j = 0; j < pImage.width; ++j) {
                                this.tpixels[n4++] = pImage.pixels[n++] << 24 | 0xFFFFFF;
                            }
                            n4 += this.twidth - pImage.width;
                        }
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < pImage.height; ++i) {
                            for (int j = 0; j < pImage.width; ++j) {
                                int n7 = pImage.pixels[n++];
                                this.tpixels[n4++] = 0xFF000000 | (n7 & 0xFF) << 16 | (n7 & 0xFF0000) >> 16 | n7 & 0xFF00;
                            }
                            n4 += this.twidth - pImage.width;
                        }
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < pImage.height; ++i) {
                            for (int j = 0; j < pImage.width; ++j) {
                                int n8 = pImage.pixels[n++];
                                this.tpixels[n4++] = (n8 & 0xFF) << 16 | (n8 & 0xFF0000) >> 16 | n8 & 0xFF00FF00;
                            }
                            n4 += this.twidth - pImage.width;
                        }
                        break;
                    }
                }
            }
            this.tbuffer.put(this.tpixels);
            this.tbuffer.rewind();
            PGraphicsOpenGL.this.gl.glBindTexture(3553, this.tindex);
            PGraphicsOpenGL.this.gl.glPixelStorei(3317, 1);
            PGraphicsOpenGL.this.gl.glTexImage2D(3553, 0, 4, this.twidth, this.theight, 0, 6408, 5121, this.tbuffer);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10240, 9729.0f);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10241, 9729.0f);
            PGraphicsOpenGL.this.glu.gluBuild2DMipmaps(3553, 4, this.twidth, this.theight, 6408, 5121, this.tbuffer);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10240, 9729.0f);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10241, 9987.0f);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10242, 33071.0f);
            PGraphicsOpenGL.this.gl.glTexParameterf(3553, 10243, 33071.0f);
            PGraphicsOpenGL.this.gl.glTexEnvf(8960, 8704, 8448.0f);
        }

        private int nextPowerOfTwo(int n) {
            int n2;
            for (n2 = 1; n2 < n; n2 <<= 1) {
            }
            return n2;
        }
    }
}

