/*
 * Decompiled with CFR 0.152.
 */
package Jet.Sense;

import Jet.Sense.SenseUtils;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;

public class Category
implements Serializable {
    private String label;
    private HashSet synsets = new HashSet();
    private POS pos;
    static final long serialVersionUID = 1L;

    public Category(String string, POS pOS) {
        this.pos = pOS;
        this.label = string;
    }

    public void add(Synset synset) {
        this.synsets.add(new Long(synset.getOffset()));
    }

    public boolean contains(Synset synset) {
        return this.synsets.contains(new Long(synset.getOffset()));
    }

    public boolean equals(Object object) {
        return ((Category)object).getLabel().equals(this.label);
    }

    public String toString() {
        Iterator iterator = this.synsets.iterator();
        StringBuffer stringBuffer = new StringBuffer("*** " + this.label + " ***\n");
        while (iterator.hasNext()) {
            Long l = (Long)iterator.next();
            try {
                Synset synset = SenseUtils.dict.getSynsetAt(this.pos, l.longValue());
                stringBuffer.append(synset + "\n");
            }
            catch (JWNLException jWNLException) {
                stringBuffer.append("Java WordNet interface problem: " + jWNLException.getMessage() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public String getLabel() {
        return this.label;
    }
}

