/*
 * Decompiled with CFR 0.152.
 */
package Jet.Sense;

import Jet.Sense.Category;
import Jet.Sense.CategorySorter;
import Jet.Sense.SenseUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.PointerUtils;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetNodeList;
import net.didion.jwnl.data.list.PointerTargetTree;

public class ACECategorySorter
extends CategorySorter
implements Serializable {
    static final long serialVersionUID = 1L;

    public ACECategorySorter() throws JWNLException {
        this.buildCategories();
    }

    private void buildCategories() throws JWNLException {
        this.categories = new Category[]{new Category("gpe", POS.NOUN), new Category("person", POS.NOUN), new Category("organization", POS.NOUN), new Category("location", POS.NOUN), new Category("facility", POS.NOUN), new Category("vehicle", POS.NOUN), new Category("weapon", POS.NOUN)};
        Synset[] synsetArray = SenseUtils.getSynsetsForBaseForm("nation");
        this.categories[0].add(synsetArray[0]);
        this.categories[0].add(synsetArray[1]);
        this.categories[0].add(synsetArray[2]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("government");
        this.categories[0].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("country");
        this.categories[0].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("kingdom");
        this.categories[0].add(synsetArray[1]);
        this.categories[0].add(synsetArray[2]);
        this.categories[0].add(synsetArray[3]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("protectorate");
        this.categories[0].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("union");
        this.categories[0].add(synsetArray[6]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("domain");
        this.categories[0].add(synsetArray[1]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("administrative_district");
        this.categories[0].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("territory");
        this.categories[0].add(synsetArray[1]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("municipality");
        this.categories[0].add(synsetArray[1]);
        HashSet<Synset> hashSet = new HashSet<Synset>();
        hashSet.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("face")));
        hashSet.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("national")));
        hashSet.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("abomination")));
        hashSet.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("divider")));
        hashSet.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("counter")));
        hashSet.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("life")));
        synsetArray = SenseUtils.getSynsetsForBaseForm("person");
        this.addHyponymsExcept(this.categories[1], synsetArray[0], hashSet);
        synsetArray = SenseUtils.getSynsetsForBaseForm("organization");
        HashSet<Synset> hashSet2 = new HashSet<Synset>();
        hashSet2.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("line_of_defense")));
        hashSet2.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("force")));
        hashSet2.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("alliance")));
        hashSet2.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("mission")));
        hashSet2.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("pool")));
        this.addHyponymsExcept(this.categories[2], synsetArray[0], hashSet2);
        HashSet<Synset> hashSet3 = new HashSet<Synset>();
        hashSet3.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("top_brass")));
        hashSet3.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("executive")));
        hashSet3.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("government_officials")));
        hashSet3.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("management")));
        this.addHyponymsExcept(this.categories[2], synsetArray[2], hashSet3);
        synsetArray = SenseUtils.getSynsetsForBaseForm("region");
        this.categories[3].add(synsetArray[0]);
        this.categories[3].add(synsetArray[2]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("outer_space");
        this.categories[3].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("celestial_body");
        this.categories[3].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("pass");
        this.categories[3].add(synsetArray[3]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("aclinic_line");
        this.categories[3].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("agonic_line");
        this.categories[3].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("isogonic_line");
        this.categories[3].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("timber_line");
        this.categories[3].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("fault_line");
        this.categories[3].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("great_circle");
        this.categories[3].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("snow_line");
        this.categories[3].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("latitude");
        this.categories[3].add(synsetArray[2]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("celestial_orbit");
        this.categories[3].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("trade_route");
        this.categories[3].add(synsetArray[0]);
        this.categories[3].add(synsetArray[1]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("watershed");
        this.categories[3].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("celestial_point");
        this.categories[3].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("geographic_point");
        this.categories[3].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("thalweg");
        this.categories[3].add(synsetArray[0]);
        this.categories[3].add(synsetArray[1]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("border");
        this.categories[3].add(synsetArray[1]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("dry_land");
        this.categories[3].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("body_of_water");
        this.categories[3].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("facility");
        this.categories[4].add(synsetArray[0]);
        this.categories[4].add(synsetArray[3]);
        HashSet<Synset> hashSet4 = new HashSet<Synset>();
        hashSet4.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("boarding")));
        hashSet4.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("body")));
        hashSet4.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("coil")));
        hashSet4.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("cross")));
        hashSet4.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("house_of_cards")));
        hashSet4.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("hull")));
        hashSet4.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("lamination")));
        hashSet4.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("sign")));
        hashSet4.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("balance")));
        hashSet4.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("weapons_platform")));
        hashSet4.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("arrangement")));
        hashSet4.addAll(Arrays.asList(SenseUtils.getSynsetsForBaseForm("superstructure")));
        synsetArray = SenseUtils.getSynsetsForBaseForm("structure");
        this.addHyponymsExcept(this.categories[4], synsetArray[0], hashSet4);
        synsetArray = SenseUtils.getSynsetsForBaseForm("chamber");
        this.categories[4].add(synsetArray[2]);
        this.categories[4].add(synsetArray[4]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("airlock");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("scaffold");
        this.categories[4].add(synsetArray[0]);
        this.categories[4].add(synsetArray[1]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("bomb_shelter");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("tomb");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("hyperbaric_chamber");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("compound");
        this.categories[4].add(synsetArray[2]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("lock");
        this.categories[4].add(synsetArray[3]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("pen");
        this.categories[4].add(synsetArray[1]);
        this.categories[4].add(synsetArray[2]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("penal_facility");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("pound");
        this.categories[4].add(synsetArray[10]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("recess");
        this.categories[4].add(synsetArray[3]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("vivarium");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("yard");
        this.categories[4].add(synsetArray[1]);
        this.categories[4].add(synsetArray[2]);
        this.categories[4].add(synsetArray[3]);
        this.categories[4].add(synsetArray[4]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("baseball_diamond");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("grounds");
        this.categories[4].add(synsetArray[2]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("playing_field");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("industrial_park");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("parade_ground");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("fairground");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("park");
        this.categories[4].add(synsetArray[0]);
        this.categories[4].add(synsetArray[1]);
        this.categories[4].add(synsetArray[4]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("picnic_area");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("public_square");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("toll_plaza");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("subdivision");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("track");
        this.categories[4].add(synsetArray[2]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("trail");
        this.categories[4].add(synsetArray[1]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("road");
        this.categories[4].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("transport");
        this.categories[5].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("weapon");
        this.categories[6].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("weaponry");
        this.categories[6].add(synsetArray[0]);
        synsetArray = SenseUtils.getSynsetsForBaseForm("explosive");
        this.categories[6].add(synsetArray[0]);
        this.buildLabelIndex();
        this.addAbbreviations();
    }

    private void addAbbreviations() {
        for (int i = 0; i < this.categories.length; ++i) {
            String string = this.categories[i].getLabel();
            if (string.length() <= 3) continue;
            String string2 = string.substring(0, 3);
            this.labelIndex.put(string2, this.categories[i]);
        }
    }

    public void addHyponymsExcept(Category category, Synset synset, HashSet hashSet) throws JWNLException {
        PointerTargetNodeList pointerTargetNodeList = PointerUtils.getDirectHyponyms((Synset)synset);
        Iterator iterator = pointerTargetNodeList.iterator();
        while (iterator.hasNext()) {
            PointerTargetNode pointerTargetNode = (PointerTargetNode)iterator.next();
            Synset synset2 = pointerTargetNode.getSynset();
            if (hashSet.contains(synset2)) continue;
            category.add(synset2);
        }
    }

    public Category categorize(Synset synset) throws JWNLException {
        PointerTargetTree pointerTargetTree = PointerUtils.getHypernymTree((Synset)synset);
        List list = pointerTargetTree.toList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            PointerTargetNodeList pointerTargetNodeList = (PointerTargetNodeList)iterator.next();
            Iterator iterator2 = pointerTargetNodeList.iterator();
            while (iterator2.hasNext()) {
                PointerTargetNode pointerTargetNode = (PointerTargetNode)iterator2.next();
                Synset synset2 = (Synset)pointerTargetNode.getPointerTarget();
                for (int i = 0; i < this.categories.length; ++i) {
                    if (!this.categories[i].contains(synset2)) continue;
                    return this.categories[i];
                }
            }
        }
        return null;
    }
}

