/*
 * Decompiled with CFR 0.152.
 */
package Jet.HMM;

import Jet.Chunk.TokenClassifier;
import Jet.HMM.HMMarc;
import Jet.HMM.HMMstate;
import Jet.JetTest;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;

public class HMM
extends TokenClassifier {
    HashMap statesByName;
    ArrayList states = new ArrayList();
    ArrayList arcs;
    int startState = -1;
    int endState = -1;
    Class emitterClass;
    HashSet cache;
    String[] tagsToCache;
    double smallestDifference = 0.0;
    protected static final double UNLIKELY = -1.0E100;
    static boolean probReport = false;
    private String excludedTag = null;
    int excludedTagStart = 0;
    int excludedTagEnd = 0;
    public double viterbiProbability = 0.0;
    private double margin;
    private boolean recordMargin = false;
    private boolean recordLocalMargin = false;
    static final int NO_BACK_POINTER = -1;
    static final int MULTIPLE_BACK_POINTERS = -2;
    static /* synthetic */ Class class$Jet$HMM$BasicHMMemitter;

    public HMM() {
        this(class$Jet$HMM$BasicHMMemitter == null ? (class$Jet$HMM$BasicHMMemitter = HMM.class$("Jet.HMM.BasicHMMemitter")) : class$Jet$HMM$BasicHMMemitter);
    }

    public HMM(Class clazz) {
        this.statesByName = new HashMap();
        this.arcs = new ArrayList();
        this.emitterClass = clazz;
        this.tagsToCache = null;
        this.cache = new HashSet();
    }

    public void setTagsToCache(String[] stringArray) {
        this.tagsToCache = stringArray;
    }

    public void load(Reader reader) throws IOException {
        String string;
        HMMstate hMMstate = null;
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            try {
                String string2;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (!stringTokenizer.hasMoreTokens()) continue;
                String string3 = stringTokenizer.nextToken();
                if (string3.equalsIgnoreCase("state")) {
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        hMMstate = new HMMstate(string2, "", this.emitterClass);
                        this.addState(hMMstate);
                        hMMstate.resetForTraining();
                        continue;
                    }
                    throw new HMMerror("state name missing");
                }
                if (string3.equalsIgnoreCase("arc")) {
                    if (!stringTokenizer.hasMoreTokens() || !stringTokenizer.nextToken().equalsIgnoreCase("to")) {
                        throw new HMMerror("'to' missing");
                    }
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new HMMerror("state name missing");
                    }
                    string2 = stringTokenizer.nextToken();
                    int n = 1;
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            n = Integer.parseInt(stringTokenizer.nextToken());
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new HMMerror("invalid count for arc");
                        }
                    }
                    HMMarc hMMarc = new HMMarc(string2, n);
                    this.arcs.add(hMMarc);
                    if (hMMstate == null) {
                        throw new HMMerror("no initial state for arc");
                    }
                    hMMstate.addArc(hMMarc);
                    hMMstate.count += n;
                    continue;
                }
                if (string3.equalsIgnoreCase("emit")) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new HMMerror("token missing");
                    }
                    string2 = stringTokenizer.nextToken();
                    String string4 = "";
                    if (hMMstate == null) {
                        throw new HMMerror("no state for emit");
                    }
                    if (stringTokenizer.countTokens() > 1) {
                        string4 = string2;
                        string2 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            int n = Integer.parseInt(stringTokenizer.nextToken());
                            hMMstate.incrementEmitCount(string2, string4, n);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new HMMerror("invalid count for token");
                        }
                    }
                    hMMstate.incrementEmitCount(string2, string4, 1);
                    continue;
                }
                if (string3.equalsIgnoreCase("feature")) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new HMMerror("feature name missing");
                    }
                    string2 = stringTokenizer.nextToken();
                    if (hMMstate == null) {
                        throw new HMMerror("no state for allow");
                    }
                    hMMstate.setFeatureName(string2);
                    while (stringTokenizer.hasMoreTokens()) {
                        hMMstate.addAllowedFeatureValue(stringTokenizer.nextToken());
                    }
                    continue;
                }
                if (string3.equalsIgnoreCase("tag")) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new HMMerror("token missing");
                    }
                    string2 = stringTokenizer.nextToken();
                    if (hMMstate == null) {
                        throw new HMMerror("no state for tag");
                    }
                    hMMstate.tag = string2;
                    continue;
                }
                if (string3.equalsIgnoreCase("prevTagged")) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        throw new HMMerror("token missing");
                    }
                    string2 = stringTokenizer.nextToken();
                    if (stringTokenizer.hasMoreTokens()) {
                        try {
                            int n = Integer.parseInt(stringTokenizer.nextToken());
                            hMMstate.setCacheCount(string2, n);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new HMMerror("invalid count for token");
                        }
                    }
                    hMMstate.setCacheCount(string2, 1);
                    continue;
                }
                throw new HMMerror("unrecognized input line");
            }
            catch (HMMerror hMMerror) {
                System.out.println(">> " + string);
                System.out.println("Error:  " + hMMerror.getMessage());
            }
        }
        this.resolveNames();
        this.computeProbabilities();
    }

    public void load(String string) {
        try {
            this.load(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), JetTest.encoding)));
        }
        catch (IOException iOException) {
            System.out.println("HMM.load:  Unable to load HMM");
            System.out.println(iOException);
        }
    }

    void resolveNames() {
        Iterator iterator = this.states.iterator();
        while (iterator.hasNext()) {
            ((HMMstate)iterator.next()).resolveNames(this.statesByName, this.states.size());
        }
    }

    public void addState(HMMstate hMMstate) {
        String string = hMMstate.name;
        hMMstate.setHMM(this);
        this.statesByName.put(string, new Integer(this.states.size()));
        if (string.equalsIgnoreCase("start")) {
            this.startState = this.states.size();
        }
        if (string.equalsIgnoreCase("end")) {
            this.endState = this.states.size();
        }
        this.states.add(hMMstate);
    }

    public HMMstate getState(String string) {
        Integer n = (Integer)this.statesByName.get(string);
        if (n == null) {
            return null;
        }
        return (HMMstate)this.states.get(n);
    }

    public void resetForTraining() {
        Iterator iterator = this.states.iterator();
        while (iterator.hasNext()) {
            ((HMMstate)iterator.next()).resetForTraining();
        }
    }

    public void newDocument() {
        this.cache = new HashSet();
    }

    void addToCache(String string, String string2) {
        for (int i = 0; i < this.tagsToCache.length; ++i) {
            if (!string2.equals(this.tagsToCache[i])) continue;
            this.cache.add(string + "|" + string2);
            return;
        }
    }

    boolean inCache(String string, String string2) {
        if (string.equalsIgnoreCase("the")) {
            return false;
        }
        if (string.equalsIgnoreCase("of")) {
            return false;
        }
        return this.cache.contains(string + "|" + string2);
    }

    public void train0(Document document, Annotation[] annotationArray, String[] stringArray) {
        int n = this.startState;
        int n2 = annotationArray.length;
        int n3 = this.states.size();
        String string = "";
        for (int i = 0; i < n2; ++i) {
            Annotation annotation = annotationArray[i];
            String string2 = document.text(annotation).trim();
            String string3 = stringArray[i];
            HMMstate hMMstate = (HMMstate)this.states.get(n);
            ++hMMstate.count;
            int n4 = -1;
            for (int j = 0; j < n3; ++j) {
                if (hMMstate.arcs[j] == null) continue;
                HMMstate hMMstate2 = (HMMstate)this.states.get(j);
                if (!hMMstate2.tag.equals(string3)) continue;
                if (n4 >= 0) {
                    System.out.println("Training error:  multiple successor states");
                    System.out.print("from state " + hMMstate.name);
                    System.out.println(" with tag " + string3);
                }
                n4 = j;
            }
            if (n4 < 0) {
                System.out.println("Training error:  no successor states");
                System.out.print("from state " + hMMstate.name);
                System.out.println(" with tag " + string3);
                return;
            }
            ++hMMstate.arcs[n4].count;
            HMMstate hMMstate3 = (HMMstate)this.states.get(n4);
            hMMstate3.incrementEmitCount(string2, string, 1);
            if (this.tagsToCache != null) {
                this.addToCache(string2, string3);
            }
            n = n4;
            string = string2;
        }
        HMMstate hMMstate = (HMMstate)this.states.get(n);
        ++hMMstate.count;
        if (hMMstate.arcs[this.endState] == null) {
            System.out.println("Training error:  can't reach final state");
            System.out.println("from state " + hMMstate.name);
            return;
        }
        ++hMMstate.arcs[this.endState].count;
    }

    public void train(Document document, Annotation[] annotationArray, String[] stringArray) {
        Object object;
        int n;
        int n2;
        Object object2;
        int n3;
        int n4 = this.states.size();
        int n5 = annotationArray.length;
        int[][] nArray = new int[n5 + 1][n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[0][n3] = -1;
        }
        nArray[0][this.startState] = 0;
        for (n3 = 1; n3 <= n5; ++n3) {
            Annotation annotation = annotationArray[n3 - 1];
            object2 = stringArray[n3 - 1];
            n2 = 0;
            for (n = 0; n < n4; ++n) {
                HMMstate hMMstate = (HMMstate)this.states.get(n);
                int n6 = -1;
                if (hMMstate.tag.equals(object2) && hMMstate.allowedToken(annotation)) {
                    for (int i = 0; i < n4; ++i) {
                        object = (HMMstate)this.states.get(i);
                        if (((HMMstate)object).arcs[n] == null || nArray[n3 - 1][i] == -1) continue;
                        n2 = 1;
                        n6 = n6 == -1 ? i : -2;
                    }
                }
                nArray[n3][n] = n6;
            }
            if (n2 != 0) continue;
            System.out.println("HMM.train:  training error:  no successor states");
            System.out.print("at token " + document.text(annotation).trim());
            System.out.println(" with tag " + (String)object2);
            return;
        }
        if (this.endState < 0) {
            System.out.println("No end state for HMM.");
            return;
        }
        n3 = -1;
        for (int i = 0; i < n4; ++i) {
            object2 = (HMMstate)this.states.get(i);
            if (((HMMstate)object2).arcs[this.endState] == null || nArray[n5][i] == -1) continue;
            n3 = n3 == -1 ? i : -2;
        }
        int[] nArray2 = new int[n5 + 2];
        nArray2[n5 + 1] = this.endState;
        int n7 = n3;
        for (n2 = n5; n2 >= 0; --n2) {
            if (n7 == -1) {
                System.out.println("HMM.train:  no back pointer");
                System.out.println("Error occurred at token " + n2 + " = " + document.text(annotationArray[n2 - 1]).trim());
                return;
            }
            if (n7 == -2) {
                System.out.println("HMM.train:  multiple back pointers");
                return;
            }
            nArray2[n2] = n7;
            n7 = nArray[n2][n7];
        }
        String string = "";
        for (n = 0; n <= n5; ++n) {
            n7 = nArray2[n];
            int n8 = nArray2[n + 1];
            HMMstate hMMstate = (HMMstate)this.states.get(n7);
            ++hMMstate.count;
            ++hMMstate.arcs[n8].count;
            if (n <= 0) continue;
            String string2 = document.text(annotationArray[n - 1]).trim();
            hMMstate.incrementEmitCount(string2, string, 1);
            if (this.tagsToCache != null) {
                object = stringArray[n - 1];
                this.addToCache(string2, (String)object);
            }
            string = string2;
        }
    }

    public void computeProbabilities() {
        Iterator iterator = this.states.iterator();
        while (iterator.hasNext()) {
            ((HMMstate)iterator.next()).computeProbabilities();
        }
    }

    public void createModel() {
        this.computeProbabilities();
    }

    public void print() {
        Iterator iterator = this.states.iterator();
        while (iterator.hasNext()) {
            ((HMMstate)iterator.next()).print();
        }
    }

    public void store(PrintWriter printWriter) {
        Iterator iterator = this.states.iterator();
        while (iterator.hasNext()) {
            ((HMMstate)iterator.next()).store(printWriter);
        }
        printWriter.close();
    }

    public void store(String string) {
        try {
            this.store(new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), JetTest.encoding))));
        }
        catch (IOException iOException) {
            System.out.println("HMM.store:  unable to store HMM.");
            System.out.println(iOException);
        }
    }

    public int[] viterbiPath(Document document, Annotation[] annotationArray) {
        double d;
        double d2;
        this.viterbiProbability = 0.0;
        int n = this.states.size();
        int n2 = annotationArray.length;
        double[][] dArray = new double[n2 + 1][n];
        int[][] nArray = new int[n2 + 1][n];
        double[][] dArray2 = null;
        if (this.recordMargin | this.recordLocalMargin) {
            dArray2 = new double[n2 + 1][n];
        }
        if (this.startState < 0) {
            System.out.println("No start state for HMM.");
            return null;
        }
        for (int i = 0; i < n; ++i) {
            dArray[0][i] = i == this.startState ? 0.0 : -1.0E100;
        }
        String string = "";
        for (int i = 1; i <= n2; ++i) {
            Annotation annotation = annotationArray[i - 1];
            String string2 = document.text(annotation).trim();
            for (int j = 0; j < n; ++j) {
                HMMstate hMMstate = (HMMstate)this.states.get(j);
                double d3 = hMMstate.getEmissionProb(string2, string, annotation);
                d2 = -1.0E100;
                d = -1.0E100;
                int n3 = -1;
                for (int k = 0; k < n; ++k) {
                    double d4;
                    HMMstate hMMstate2 = (HMMstate)this.states.get(k);
                    double d5 = dArray[i - 1][k] + hMMstate2.getTransitionProb(j) + d3;
                    if (d5 > d2) {
                        if (!this.recordLocalMargin) {
                            d = d2;
                        }
                        d2 = d5;
                        n3 = k;
                    }
                    if (!this.recordLocalMargin) continue;
                    if (this.violatesConstraint(i - 1, hMMstate)) {
                        if (!(d5 > d)) continue;
                        d = d5;
                        continue;
                    }
                    if (i <= 1 || !((d4 = dArray2[i - 1][k] + hMMstate2.getTransitionProb(j) + d3) > d)) continue;
                    d = d4;
                }
                dArray[i][j] = d2;
                nArray[i][j] = n3;
                if (!(this.recordMargin | this.recordLocalMargin)) continue;
                dArray2[i][j] = d;
            }
            string = string2;
        }
        if (this.endState < 0) {
            System.out.println("No end state for HMM.");
            return null;
        }
        double d6 = -1.0E100;
        double d7 = -1.0E100;
        int n4 = -1;
        for (int i = 0; i < n; ++i) {
            HMMstate hMMstate = (HMMstate)this.states.get(i);
            d2 = dArray[n2][i] + hMMstate.getTransitionProb(this.endState);
            if (d2 > d6) {
                d6 = d2;
                n4 = i;
            }
            if (!this.recordLocalMargin || !((d = dArray2[n2][i] + hMMstate.getTransitionProb(this.endState)) > d7)) continue;
            d7 = d;
        }
        int[] nArray2 = new int[n2 + 2];
        nArray2[n2 + 1] = this.endState;
        int n5 = n4;
        this.margin = 2.0E100;
        for (int i = n2 - 1; i >= 0; --i) {
            if (n5 < 0) {
                return null;
            }
            nArray2[i + 1] = n5;
            HMMstate hMMstate = (HMMstate)this.states.get(n5);
            String string3 = hMMstate.tag;
            if (this.tagsToCache != null) {
                String string4 = document.text(annotationArray[i]).trim();
                this.addToCache(string4, string3);
            }
            nArray2[0] = this.startState;
            if (this.recordMargin && dArray[i + 1][n5] - dArray2[i + 1][n5] < this.margin) {
                this.margin = dArray[i + 1][n5] - dArray2[i + 1][n5];
            }
            n5 = nArray[i + 1][n5];
        }
        this.viterbiProbability = d6;
        if (this.recordLocalMargin) {
            this.margin = d6 - d7;
        }
        return nArray2;
    }

    public String[] viterbi(Document document, Annotation[] annotationArray) {
        int[] nArray = this.viterbiPath(document, annotationArray);
        if (nArray == null) {
            return null;
        }
        int n = annotationArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            HMMstate hMMstate = (HMMstate)this.states.get(nArray[i + 1]);
            stringArray[i] = hMMstate.tag;
        }
        return stringArray;
    }

    public void recordMargin() {
        this.recordMargin = true;
    }

    public double getMargin() {
        return this.margin;
    }

    public double getLocalMargin(Document document, Annotation[] annotationArray, String string, int n, int n2) {
        this.excludedTag = string;
        this.excludedTagStart = n;
        this.excludedTagEnd = n2;
        this.recordLocalMargin = true;
        this.viterbi(document, annotationArray);
        this.recordLocalMargin = false;
        return this.margin;
    }

    private boolean violatesConstraint(int n, HMMstate hMMstate) {
        return n == this.excludedTagStart - 1 && hMMstate.tag.equals(this.excludedTag) || n >= this.excludedTagStart && n <= this.excludedTagEnd && !hMMstate.tag.equals(this.excludedTag) || n == this.excludedTagEnd + 1 && hMMstate.tag.equals(this.excludedTag);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class HMMerror
    extends Exception {
        HMMerror(String string) {
            super(string);
        }
    }
}

