/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import AceJet.LearnRelations;
import AceJet.Mention;
import AceJet.WordSenseData;
import Jet.Control;
import Jet.JetTest;
import Jet.Lisp.FeatureSet;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

class WordSense {
    static ExternalDocument doc;
    static String currentDoc;
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String fileList = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training all.txt";
    static final String wordSenseFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/word sense.txt";
    static Vector tokens;
    static HashMap tokenStartMap;
    static DocumentBuilder builder;
    static PrintStream writer;
    static HashMap wordContextMap;
    static int trainingMentions;
    static int correct;
    static int incorrect;

    WordSense() {
    }

    public static void main(String[] stringArray) throws IOException, ParserConfigurationException, SAXException {
        System.out.println("Starting ACE Word Sense Training ...");
        JetTest.initializeFromConfig("word sense.properties");
        Pat.trace = false;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        builder = documentBuilderFactory.newDocumentBuilder();
        writer = new PrintStream(new FileOutputStream(wordSenseFile));
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileList));
        int n = 0;
        while ((currentDoc = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++n + ": " + currentDoc);
            String string = ACEdir + currentDoc + ".sgm";
            doc = new ExternalDocument("sgml", string);
            doc.setAllTags(true);
            doc.open();
            Control.processDocument(doc, null, false, n);
            WordSense.collectTokens();
            String string2 = ACEdir + currentDoc + ".sgm.tmx.rdc.xml";
            AceDocument aceDocument = new AceDocument(string, string2);
            LearnRelations.findEntityMentions(aceDocument);
            WordSense.processMentions(doc);
        }
        WordSense.writeWordContexts(writer);
        writer.close();
        System.out.println(trainingMentions + " training mentions");
        System.out.println(correct + " correct predictions, " + incorrect + " incorrect");
    }

    static void collectTokens() {
        tokens = doc.annotationsOfType("token");
        tokenStartMap = new HashMap();
        for (int i = 0; i < tokens.size(); ++i) {
            Annotation annotation = (Annotation)tokens.get(i);
            int n = annotation.start();
            tokenStartMap.put(new Integer(n), new Integer(i));
        }
    }

    static ArrayList context(Annotation annotation) {
        ArrayList<String> arrayList = new ArrayList<String>();
        FeatureSet featureSet = (FeatureSet)annotation.get("pa");
        boolean bl = featureSet != null && featureSet.get("det") == null && annotation.get("poss") == null;
        arrayList.add(bl ? "UNCOUNTABLE" : "COUNTABLE");
        return arrayList;
    }

    static void processMentions(ExternalDocument externalDocument) {
        Vector vector = Resolve.gatherMentions(externalDocument, new Span(0, externalDocument.length()));
        for (int i = 0; i < vector.size(); ++i) {
            int n;
            WordSenseData wordSenseData;
            boolean bl;
            Annotation annotation = (Annotation)vector.get(i);
            Annotation annotation2 = Resolve.getHeadC(annotation);
            String string = (String)annotation2.get("cat");
            if (string.equals("pro") || string.equals("det")) continue;
            String string2 = Resolve.normalizeName(externalDocument.text(annotation2));
            Mention mention = (Mention)LearnRelations.mentionStartMap.get(new Integer(annotation2.start()));
            String string3 = "OTHER";
            if (mention != null) {
                string3 = mention.type;
            }
            ArrayList arrayList = WordSense.context(annotation);
            boolean bl2 = bl = trainingMentions < 45000;
            if (bl) {
                ++trainingMentions;
                wordSenseData = (WordSenseData)wordContextMap.get(string2);
                if (wordSenseData == null) {
                    wordSenseData = new WordSenseData(string2);
                    wordContextMap.put(string2, wordSenseData);
                }
                wordSenseData.incrementTypeCount(string3);
                for (n = 0; n < arrayList.size(); ++n) {
                    wordSenseData.incrementContextCount(string3, (String)arrayList.get(n));
                }
                continue;
            }
            wordSenseData = (WordSenseData)wordContextMap.get(string2);
            if (wordSenseData == null) continue;
            n = wordSenseData.decodeType(arrayList);
            String string4 = WordSenseData.EDT_TYPES[n];
            if (string4.equals(string3)) {
                ++correct;
                continue;
            }
            ++incorrect;
            System.out.print("Word: " + string2);
            System.out.println(" predict " + string4 + ", should be " + string3);
        }
    }

    static void writeWordContexts(PrintStream printStream) {
        Iterator iterator = wordContextMap.values().iterator();
        while (iterator.hasNext()) {
            ((WordSenseData)iterator.next()).write(printStream);
        }
        printStream.close();
    }

    static {
        wordContextMap = new HashMap();
        trainingMentions = 0;
        correct = 0;
        incorrect = 0;
    }
}

