/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.Dictionary;

public class WordNetInterface {
    public static void initialize() {
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/jwnl13rc3/file_properties.xml";
        try {
            JWNL.initialize((InputStream)new FileInputStream(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public static boolean containsSynonym(HashSet hashSet, String string) {
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!WordNetInterface.isNounSynonym(string2, string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNounSynonym(String string, String string2) {
        try {
            IndexWord indexWord = Dictionary.getInstance().lookupIndexWord(POS.NOUN, string);
            IndexWord indexWord2 = Dictionary.getInstance().lookupIndexWord(POS.NOUN, string2);
            if (indexWord == null || indexWord2 == null) {
                return false;
            }
            Object[] objectArray = indexWord.getSenses();
            Object[] objectArray2 = indexWord2.getSenses();
            if (objectArray == null || objectArray2 == null) {
                return false;
            }
            boolean bl = WordNetInterface.intersect(objectArray, objectArray2);
            if (bl) {
                System.out.println("Found synonyms " + string + " and " + string2);
            }
            return bl;
        }
        catch (JWNLException jWNLException) {
            jWNLException.printStackTrace();
            System.exit(-1);
            return false;
        }
    }

    public static boolean isVerbSynonym(String string, String string2) {
        try {
            IndexWord indexWord = Dictionary.getInstance().lookupIndexWord(POS.VERB, string);
            IndexWord indexWord2 = Dictionary.getInstance().lookupIndexWord(POS.VERB, string2);
            if (indexWord == null || indexWord2 == null) {
                return false;
            }
            Object[] objectArray = indexWord.getSenses();
            Object[] objectArray2 = indexWord2.getSenses();
            if (objectArray == null || objectArray2 == null) {
                return false;
            }
            boolean bl = WordNetInterface.intersect(objectArray, objectArray2);
            if (!string.equals(string2) && bl) {
                System.out.println("Found verb synonyms " + string + " and " + string2);
            }
            return bl;
        }
        catch (JWNLException jWNLException) {
            jWNLException.printStackTrace();
            System.exit(-1);
            return false;
        }
    }

    private static boolean intersect(Object[] objectArray, Object[] objectArray2) {
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < objectArray2.length; ++j) {
                if (objectArray[i] == null || !objectArray[i].equals(objectArray2[j])) continue;
                return true;
            }
        }
        return false;
    }
}

