/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import Jet.Tipster.Span;
import java.io.PrintWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceEntityMention {
    String id;
    String type;
    Span extent;
    String text;
    public Span head;
    String headText;
    String role;

    public AceEntityMention(String string, String string2, Span span, Span span2, String string3) {
        this.id = string;
        this.type = string2;
        this.extent = AceEntityMention.convertSpan(span, string3);
        this.head = AceEntityMention.convertSpan(span2, string3);
        this.text = string3.substring(this.extent.start(), this.extent.end() + 1);
        this.headText = string3.substring(this.head.start(), this.head.end() + 1);
    }

    public AceEntityMention(Element element, String string) {
        this.id = element.getAttribute("ID");
        this.type = element.getAttribute("TYPE");
        this.role = element.getAttribute("ROLE");
        if (this.role == null) {
            this.role = "";
        }
        NodeList nodeList = element.getElementsByTagName("extent");
        Element element2 = (Element)nodeList.item(0);
        this.extent = AceEntityMention.decodeCharseq(element2);
        this.text = string.substring(this.extent.start(), this.extent.end() + 1);
        NodeList nodeList2 = element.getElementsByTagName("head");
        Element element3 = (Element)nodeList2.item(0);
        this.head = AceEntityMention.decodeCharseq(element3);
        this.headText = string.substring(this.head.start(), this.head.end() + 1);
    }

    static Span convertSpan(Span span, String string) {
        int n;
        int n2 = span.start();
        for (n = span.end() - 1; n > n2 && Character.isWhitespace(string.charAt(n)); --n) {
        }
        return new Span(n2, n);
    }

    void write(PrintWriter printWriter) {
        String string = AceDocument.ace2004 ? this.type.substring(0, 3) : this.type;
        printWriter.print("    <entity_mention TYPE=\"" + string + "\" ID=\"" + this.id + "\"");
        if (this.role != null && !this.role.equals("")) {
            printWriter.print(" ROLE=\"" + this.role + "\"");
        }
        printWriter.println(">");
        printWriter.println("      <extent>");
        AceEntityMention.writeCharseq(printWriter, this.extent, this.text);
        printWriter.println("      </extent>");
        printWriter.println("      <head>");
        AceEntityMention.writeCharseq(printWriter, this.head, this.headText);
        printWriter.println("      </head>");
        printWriter.println("    </entity_mention>");
    }

    static Span decodeCharseq(Element element) {
        String string;
        String string2;
        if (AceDocument.ace2004) {
            NodeList nodeList = element.getElementsByTagName("charseq");
            Element element2 = (Element)nodeList.item(0);
            string2 = element2.getAttribute("START");
            string = element2.getAttribute("END");
        } else {
            string2 = AceDocument.getElementText(element, "start");
            string = AceDocument.getElementText(element, "end");
        }
        int n = Integer.parseInt(string2);
        int n2 = Integer.parseInt(string);
        Span span = new Span(n, n2);
        return span;
    }

    static void writeCharseq(PrintWriter printWriter, Span span, String string) {
        if (AceDocument.ace2004) {
            printWriter.print("        <charseq START=\"" + span.start() + "\"" + " END=\"" + span.end() + "\">");
            printWriter.print(string);
            printWriter.println("</charseq>");
        } else {
            printWriter.println("        <charseq>");
            printWriter.println("          <start>" + span.start() + "</start>");
            printWriter.println("          <!-- string = \"" + string + "\" -->");
            printWriter.println("          <end>" + span.end() + "</end>");
            printWriter.println("        </charseq>");
        }
    }
}

