/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceEntity;
import AceJet.AceEntityMention;
import AceJet.AceRelation;
import Jet.Tipster.Document;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AceDocument {
    public static boolean ace2004 = true;
    private static DocumentBuilder builder = null;
    private String fileText;
    private StringBuffer fileTextWithXML;
    public String sourceFile;
    public String sourceType;
    public String docID;
    public ArrayList entities = new ArrayList();
    public ArrayList relations = new ArrayList();
    private static final String encoding = "ISO-8859-1";

    public AceDocument(String string, String string2, String string3, String string4) {
        this.sourceFile = string;
        this.sourceType = string2;
        this.docID = string3;
        this.fileText = string4;
    }

    public AceDocument(String string, String string2) {
        try {
            if (builder == null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                builder = documentBuilderFactory.newDocumentBuilder();
            }
            this.analyzeDocument(string, string2);
        }
        catch (SAXException sAXException) {
            System.out.println("AceDocument:  Exception in initializing APF reader: " + sAXException);
        }
        catch (IOException iOException) {
            System.out.println("AceDocument:  Exception in initializing APF reader: " + iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("AceDocument:  Exception in initializing APF reader: " + parserConfigurationException);
        }
    }

    private void analyzeDocument(String string, String string2) throws SAXException, IOException {
        org.w3c.dom.Document document = builder.parse(string2);
        this.fileTextWithXML = AceDocument.readDocument(string);
        this.fileText = AceDocument.eraseXML(this.fileTextWithXML);
        this.readAPFdocument(document, this.fileText);
    }

    void readAPFdocument(org.w3c.dom.Document document, String string) {
        Object object;
        NodeList nodeList = document.getElementsByTagName("source_file");
        Element element = (Element)nodeList.item(0);
        this.sourceFile = element.getAttribute("URI");
        this.sourceType = element.getAttribute("SOURCE");
        NodeList nodeList2 = document.getElementsByTagName("document");
        Element element2 = (Element)nodeList2.item(0);
        this.docID = element2.getAttribute("DOCID");
        if (Ace.perfectMentions & !Ace.perfectEntities) {
            this.readPerfectMentions(document, string);
            return;
        }
        NodeList nodeList3 = document.getElementsByTagName("entity");
        for (int i = 0; i < nodeList3.getLength(); ++i) {
            Element element3 = (Element)nodeList3.item(i);
            object = new AceEntity(element3, string);
            this.addEntity((AceEntity)object);
        }
        NodeList nodeList4 = document.getElementsByTagName("relation");
        for (int i = 0; i < nodeList4.getLength(); ++i) {
            object = (Element)nodeList4.item(i);
            AceRelation aceRelation = new AceRelation((Element)object, this);
            this.addRelation(aceRelation);
        }
    }

    public void addEntity(AceEntity aceEntity) {
        this.entities.add(aceEntity);
    }

    public void addRelation(AceRelation aceRelation) {
        this.relations.add(aceRelation);
    }

    static String getElementText(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        Element element2 = (Element)nodeList.item(0);
        String string2 = element2.getFirstChild().getNodeValue();
        return string2;
    }

    void readPerfectMentions(org.w3c.dom.Document document, String string) {
        NodeList nodeList = document.getElementsByTagName("entity_mention");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string2 = "E" + element.getAttribute("ID");
            String string3 = element.getAttribute("ENTITY_TYPE");
            if (AceEntity.standardType.containsKey(string3)) {
                string3 = (String)AceEntity.standardType.get(string3);
            }
            String string4 = element.getAttribute("ENTITY_SUBTYPE");
            if (!string3.equals("PERSON") && !string3.equals("") && string4.equals("")) {
                string4 = "Other";
            }
            AceEntityMention aceEntityMention = new AceEntityMention(element, string);
            AceEntity aceEntity = new AceEntity(string2, string3, string4, false);
            aceEntity.addMention(aceEntityMention);
            this.addEntity(aceEntity);
        }
    }

    static StringBuffer readDocument(String string) throws IOException {
        String string2;
        File file = new File(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2 + "\n");
        }
        return stringBuffer;
    }

    static String eraseXML(StringBuffer stringBuffer) {
        boolean bl = false;
        int n = stringBuffer.length();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (c == '<') {
                bl = true;
            }
            if (!bl) {
                stringBuffer2.append(c);
            }
            if (c != '>') continue;
            bl = false;
        }
        return stringBuffer2.toString();
    }

    public Document JetDocument() {
        Document document = new Document(this.fileTextWithXML.toString());
        document.annotateWithTag("TEXT");
        return document;
    }

    AceEntity findEntity(String string) {
        for (int i = 0; i < this.entities.size(); ++i) {
            AceEntity aceEntity = (AceEntity)this.entities.get(i);
            if (!aceEntity.id.equals(string)) continue;
            return aceEntity;
        }
        System.out.println("*** unable to find entity with id " + string);
        return null;
    }

    AceEntityMention findEntityMention(String string) {
        for (int i = 0; i < this.entities.size(); ++i) {
            AceEntity aceEntity = (AceEntity)this.entities.get(i);
            AceEntityMention aceEntityMention = aceEntity.findMention(string);
            if (aceEntityMention == null) continue;
            return aceEntityMention;
        }
        System.out.println("*** unable to find entity mention with id " + string);
        return null;
    }

    public void write(PrintWriter printWriter) {
        Object object;
        int n;
        printWriter.println("<?xml version=\"1.0\"?>");
        printWriter.println("<!DOCTYPE source_file SYSTEM \"apf.v4.0.1.dtd\">");
        printWriter.print("<source_file URI=\"" + this.sourceFile + "\"");
        printWriter.println(" SOURCE=\"" + this.sourceType + "\" TYPE=\"text\" AUTHOR=\"NYU\">");
        printWriter.println("<document DOCID=\"" + this.docID + "\">");
        for (n = 0; n < this.entities.size(); ++n) {
            object = (AceEntity)this.entities.get(n);
            ((AceEntity)object).write(printWriter);
        }
        for (n = 0; n < this.relations.size(); ++n) {
            object = (AceRelation)this.relations.get(n);
            ((AceRelation)object).write(printWriter);
        }
        printWriter.println("</document>");
        printWriter.println("</source_file>");
        printWriter.close();
    }

    public static void main(String[] stringArray) {
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/";
        String string2 = string + "ace/";
        String string3 = string2 + "training04/English/nwire/APW20001001.2021.0521.apf.xml";
        String string4 = string2 + "training04/English/nwire/APW20001001.2021.0521.sgm";
        AceDocument aceDocument = new AceDocument(string4, string3);
        aceDocument.write(new PrintWriter(System.out));
    }
}

