/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEntityMention;
import AceJet.AceEntityName;
import AceJet.EDTtype;
import AceJet.EDTtypeEnsemble;
import AceJet.Gazetteer;
import AceJet.LearnRelations;
import AceJet.PerfectAce;
import AceJet.RelationPatternSet;
import Jet.Control;
import Jet.HMM.BigramHMMemitter;
import Jet.HMM.HMMstate;
import Jet.JetTest;
import Jet.Lisp.FeatureSet;
import Jet.Parser.SynFun;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Vector;

public class Ace {
    public static final boolean useParser = true;
    static final boolean useParseCollection = true;
    public static boolean perfectMentions = false;
    public static boolean perfectEntities = false;
    static final boolean asr = false;
    static final boolean useWordNet = true;
    public static boolean preferRelations = false;
    public static boolean preferEntities = !preferRelations;
    public static boolean monocase = false;
    static PrintWriter apf;
    static ExternalDocument doc;
    public static Gazetteer gazetteer;
    static int aceEntityNo;
    static HashMap aceTypeDict;
    static final String suffix = ".sgm.apf";
    static String currentDocPath;
    static String currentDoc;
    static String sourceType;
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String dictFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/new EDT type dict.txt";
    static final String genericFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/new generic dict.txt";
    static final String fileList = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/eval04 nwire.txt";
    public static final String patternFile1 = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/relations/patterns04.log";
    public static RelationPatternSet eve;
    static final String[] locativePrepositions;
    static final String[] genericFriendlyDeterminers;
    static final String[] clearGenericPronouns;

    public static void main(String[] stringArray) throws IOException {
        System.out.println("Starting ACE Jet...");
        JetTest.initializeFromConfig("props/ace use parses.properties");
        EDTtype.readTypeDict(dictFile);
        EDTtype.readGenericDict(genericFile);
        gazetteer = new Gazetteer();
        gazetteer.load("data/loc.dict");
        eve = new RelationPatternSet();
        eve.load(patternFile1, 0);
        Pat.trace = false;
        Resolve.trace = false;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileList));
        int n = 0;
        while ((currentDocPath = bufferedReader.readLine()) != null) {
            String string;
            System.out.println("\nProcessing document " + ++n + ": " + currentDocPath);
            if (perfectMentions) {
                doc = new ExternalDocument("sgml", "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/perfect parses/" + currentDocPath + ".sgm");
                string = ACEdir + currentDocPath + ".sgm";
                String string2 = ACEdir + currentDocPath + ".entities.apf.xml";
                AceDocument aceDocument = new AceDocument(string, string2);
                PerfectAce.buildEntityMentionMap(doc, aceDocument);
            } else {
                doc = new ExternalDocument("sgml", "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/parses/" + currentDocPath + ".sgm");
            }
            doc.setAllTags(true);
            doc.setEmptyTags(new String[]{"W", "TURN"});
            doc.open();
            monocase = Ace.allLowerCase(doc);
            System.out.println(">>> Monocase is " + monocase);
            gazetteer.setMonocase(monocase);
            BigramHMMemitter.useBigrams = monocase;
            HMMstate.otherPreference = monocase ? 1.0 : 0.0;
            Control.processDocument(doc, null, n == -1, n);
            Ace.tagReciprocalRelations(doc);
            currentDoc = currentDocPath;
            if (currentDocPath.indexOf(47) >= 0) {
                currentDoc = currentDocPath.substring(currentDocPath.lastIndexOf(47) + 1);
            }
            sourceType = "text";
            if (currentDocPath.indexOf("bnews") >= 0) {
                sourceType = "broadcast news";
            } else if (currentDocPath.indexOf("nwire") >= 0) {
                sourceType = "newswire";
            } else if (currentDocPath.indexOf("npaper") >= 0) {
                sourceType = "newspaper";
            }
            string = ACEdir + currentDocPath + suffix;
            apf = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            Ace.writeAPF();
        }
    }

    public static boolean allLowerCase(Document document) {
        Vector vector = document.annotationsOfType("TEXT");
        if (vector == null || vector.size() == 0) {
            return false;
        }
        boolean bl = true;
        boolean bl2 = true;
        Annotation annotation = (Annotation)vector.get(0);
        Span span = annotation.span();
        for (int i = span.start(); i < span.end(); ++i) {
            if (Character.isUpperCase(document.charAt(i))) {
                bl = false;
            }
            if (!Character.isLowerCase(document.charAt(i))) continue;
            bl2 = false;
        }
        return bl || bl2;
    }

    private static void writeAPF() {
        aceEntityNo = 0;
        LearnRelations.resetMentions();
        String string = doc.text();
        Vector vector = doc.annotationsOfType("entity");
        AceDocument aceDocument = new AceDocument(currentDoc + ".sgm", sourceType, currentDoc, string);
        for (int i = 0; i < vector.size(); ++i) {
            AceEntity aceEntity = Ace.buildEntity((Annotation)vector.get(i), i, string);
            if (aceEntity == null) continue;
            aceDocument.addEntity(aceEntity);
        }
        LearnRelations.findAndWriteRelations(currentDoc, doc, aceDocument);
        aceDocument.write(apf);
    }

    private static AceEntity buildEntity(Annotation annotation, int n, String string) {
        boolean bl;
        Vector vector = (Vector)annotation.get("mentions");
        Annotation annotation2 = (Annotation)vector.get(0);
        String string2 = EDTtypeEnsemble.getTypeSubtype(doc, annotation, annotation2);
        String string3 = EDTtype.bareType(string2);
        System.out.println("Type of " + Resolve.normalizeName(doc.text(annotation2)) + " is " + string2);
        if (string3.equals("OTHER")) {
            return null;
        }
        String string4 = EDTtype.subtype(string2);
        boolean bl2 = bl = !AceDocument.ace2004 && Ace.isGeneric(annotation2);
        if (bl) {
            System.out.println("Identified generic mention " + Resolve.normalizeName(doc.text(annotation2)));
        }
        System.out.println("Generating ace entity " + ++aceEntityNo + " (internal entity " + n + ") = " + Resolve.normalizeName(doc.text(annotation2)) + " [" + string3 + "]");
        String string5 = currentDoc + "-" + aceEntityNo;
        AceEntity aceEntity = new AceEntity(string5, string3, string4, bl);
        for (int i = 0; i < vector.size(); ++i) {
            boolean bl3;
            Annotation annotation3 = (Annotation)vector.get(i);
            Annotation annotation4 = Resolve.getHeadC(annotation3);
            String string6 = aceEntityNo + "-" + i;
            AceEntityMention aceEntityMention = Ace.buildMention(annotation3, annotation4, string6, string3, string);
            aceEntity.addMention(aceEntityMention);
            LearnRelations.addMention(string3, string4, Ace.getNgHead(annotation3).span(), annotation4.span(), string6, string5, bl);
            boolean bl4 = bl3 = aceEntityMention.type == "NAME";
            if (!bl3) continue;
            aceEntity.addName(new AceEntityName(annotation4.span(), string));
        }
        return aceEntity;
    }

    private static AceEntityMention buildMention(Annotation annotation, Annotation annotation2, String string, String string2, String string3) {
        Span span = annotation.span();
        Span span2 = annotation2.span();
        String string4 = Ace.mentionType(annotation2, annotation);
        AceEntityMention aceEntityMention = new AceEntityMention(string, string4, span, span2, string3);
        if (string2.equals("GPE")) {
            String string5;
            aceEntityMention.role = perfectMentions ? PerfectAce.getMentionRole(annotation2) : ((string5 = Ace.governingPreposition(annotation)) != null && Ace.in(string5, locativePrepositions) || Resolve.sentenceNumber(annotation.start()) == 0 ? "LOC" : "GPE");
        }
        return aceEntityMention;
    }

    private static String mentionType(Annotation annotation, Annotation annotation2) {
        if (perfectMentions) {
            return PerfectAce.getMentionType(annotation);
        }
        String string = (String)annotation.get("cat");
        String string2 = (String)annotation2.get("cat");
        if (annotation2.get("preName-1") != null || annotation2.get("nameMod-1") != null || string == "adj") {
            return "PRE";
        }
        if (string == "n" || string == "title" || string == "tv" || string == "v") {
            return "NOMINAL";
        }
        if (string == "pro" || string == "det" || string == "adj" || string == "ven" || string == "q" || string == "np" || string == "wp" || string == "wp$") {
            return "PRONOUN";
        }
        return "NAME";
    }

    private static boolean isGeneric(Annotation annotation) {
        Annotation annotation2 = Ace.getNgHead(annotation);
        Annotation annotation3 = Resolve.getHeadC(annotation);
        if (annotation3.get("cat") == "n") {
            FeatureSet featureSet;
            String string = SynFun.getDet(annotation);
            if (string != null && Ace.in(string, genericFriendlyDeterminers)) {
                return true;
            }
            if (!EDTtype.hasGenericHead(doc, annotation)) {
                return false;
            }
            if (annotation2.get("poss") != null || string == "poss") {
                return false;
            }
            if (annotation2.get("quant") != null || string == "q") {
                return false;
            }
            Annotation annotation4 = Ace.governingVerbGroup(annotation);
            if (annotation4 != null && (featureSet = (FeatureSet)annotation4.get("pa")) != null && featureSet.get("tense") != "past" && featureSet.get("aspect") == null) {
                System.out.println("Governing verb group = " + doc.text(annotation4));
                System.out.println("Verb group pa = " + featureSet);
                return true;
            }
            return false;
        }
        if (annotation3.get("cat") == "pro" || annotation3.get("cat") == "np" || annotation3.get("cat") == "det") {
            String string = SynFun.getHead(doc, annotation);
            return Ace.in(string, clearGenericPronouns) || Ace.in(string, genericFriendlyDeterminers);
        }
        return false;
    }

    private static Annotation getNgHead(Annotation annotation) {
        Annotation annotation2 = annotation;
        while ((annotation = (Annotation)annotation2.get("headC")) != null) {
            if (annotation.get("cat") != "np" || annotation.get("possPrefix") == "true") {
                return annotation2;
            }
            annotation2 = annotation;
        }
        return annotation2;
    }

    private static boolean in(Object object, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || !objectArray[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    public static void tagReciprocalRelations(Document document) {
        Vector vector = document.annotationsOfType("constit");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Annotation annotation;
                Annotation annotation2 = (Annotation)vector.elementAt(i);
                if (annotation2.get("subject") != null && (annotation = (Annotation)annotation2.get("subject")).get("subject-1") == null) {
                    annotation.put("subject-1", annotation2);
                }
                if (annotation2.get("object") == null || (annotation = (Annotation)annotation2.get("object")).get("object-1") != null) continue;
                annotation.put("object-1", annotation2);
            }
        }
    }

    static Annotation governingVerbGroup(Annotation annotation) {
        Annotation annotation2;
        if (annotation.get("subject-1") != null) {
            annotation2 = (Annotation)annotation.get("subject-1");
        } else if (annotation.get("object-1") != null) {
            annotation2 = (Annotation)annotation.get("object-1");
        } else {
            return null;
        }
        return Resolve.getHeadC(annotation2);
    }

    static String governingPreposition(Annotation annotation) {
        Annotation annotation2 = (Annotation)annotation.get("p-obj-1");
        if (annotation2 == null) {
            return null;
        }
        Annotation[] annotationArray = (Annotation[])annotation2.get("children");
        if (annotationArray.length != 2) {
            return null;
        }
        Annotation annotation3 = annotationArray[0];
        String string = doc.text(annotation3).trim();
        return string;
    }

    static int getACEoffset(int n) {
        return n;
    }

    static int getJetOffset(int n) {
        return n;
    }

    static {
        sourceType = "text";
        locativePrepositions = new String[]{"in", "at", "to", "near"};
        genericFriendlyDeterminers = new String[]{"no", "neither", "any", "many", "every", "each"};
        clearGenericPronouns = new String[]{"everyone", "anyone", "everybody", "anybody", "something", "who", "whoever", "whomever", "wherever", "whatever", "where"};
    }
}

