/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEntityMention;
import AceJet.WordNetInterface;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashSet;

public class APFNomAnalyzer {
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String fileList = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training nwire.txt";
    static int identityCount = 0;
    static int synonymCount = 0;
    static int differentCount = 0;

    public static void main(String[] stringArray) throws Exception {
        String string;
        WordNetInterface.initialize();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileList));
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++n + ": " + string);
            String string2 = ACEdir + string + ".sgm";
            boolean bl = fileList.indexOf("03") > 0;
            String string3 = ACEdir + string + (bl ? ".apf.xml" : ".sgm.tmx.rdc.xml");
            APFNomAnalyzer.analyzeDocument(string2, string3);
        }
        APFNomAnalyzer.report();
    }

    private static void analyzeDocument(String string, String string2) {
        AceDocument aceDocument = new AceDocument(string, string2);
        APFNomAnalyzer.findEntityMentions(aceDocument);
    }

    static void findEntityMentions(AceDocument aceDocument) {
        ArrayList arrayList = aceDocument.entities;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEntity aceEntity = (AceEntity)arrayList.get(i);
            if (aceEntity.generic) continue;
            APFNomAnalyzer.analyzeMentions(aceEntity.type, aceEntity.mentions);
        }
    }

    private static void analyzeMentions(String string, ArrayList arrayList) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEntityMention aceEntityMention = (AceEntityMention)arrayList.get(i);
            String string2 = aceEntityMention.type;
            String string3 = aceEntityMention.headText.toLowerCase();
            if (!string2.equals("NOMINAL")) continue;
            if (!hashSet.isEmpty()) {
                if (hashSet.contains(string3)) {
                    ++identityCount;
                } else if (WordNetInterface.containsSynonym(hashSet, string3)) {
                    ++synonymCount;
                } else {
                    System.out.println("different heads: " + string3 + " and " + hashSet);
                    ++differentCount;
                }
            }
            hashSet.add(string3);
        }
    }

    private static void report() {
        System.out.println(identityCount + " same head pairs");
        System.out.println(synonymCount + " synonymous head pairs");
        System.out.println(differentCount + " different head pairs");
    }
}

