/*
 * Decompiled with CFR 0.152.
 */
package Jet.Tipster;

import Jet.Tipster.ExternalDocument;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class DocumentCollection {
    String fileName;
    ArrayList documents;
    boolean open;
    static final String DEFAULT_DOC_TYPE = "sgml";

    public DocumentCollection(String string) {
        this.fileName = string;
        this.documents = new ArrayList();
        this.open = false;
    }

    public boolean open() {
        if (this.open) {
            return true;
        }
        try {
            String string;
            File file = new File(this.fileName);
            String string2 = file.getParent();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(124);
                if (n != 0 && n < string.length() - 1) {
                    String string3;
                    String string4;
                    if (n > 0) {
                        string4 = string.substring(0, n);
                        string3 = string.substring(n + 1);
                    } else {
                        string4 = DEFAULT_DOC_TYPE;
                        string3 = string;
                    }
                    File file2 = new File(string3);
                    if (file2.isAbsolute()) {
                        this.documents.add(new ExternalDocument(string4, string3));
                        continue;
                    }
                    this.documents.add(new ExternalDocument(string4, string2, string3));
                    continue;
                }
                System.out.println("Error opening collection " + this.fileName);
                System.out.println("Invalid line: " + string);
                return false;
            }
            this.open = true;
            return true;
        }
        catch (IOException iOException) {
            System.out.println("Error opening collection " + this.fileName);
            System.out.println(iOException);
            return false;
        }
    }

    public void save() {
        for (int i = 0; i < this.documents.size(); ++i) {
            ExternalDocument externalDocument = (ExternalDocument)this.documents.get(i);
            externalDocument.save();
        }
    }

    public void saveAs(String string) {
        try {
            File file = new File(string);
            String string2 = file.getParent();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < this.documents.size(); ++i) {
                ExternalDocument externalDocument = (ExternalDocument)this.documents.get(i);
                externalDocument.saveIn(string2);
                String string3 = externalDocument.format();
                bufferedWriter.write(string3, 0, string3.length());
                bufferedWriter.write("|", 0, 1);
                String string4 = externalDocument.fileName();
                bufferedWriter.write(string4, 0, string4.length());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Error saving collection " + this.fileName);
            System.out.println(iOException);
        }
    }

    public int size() {
        return this.documents.size();
    }

    public ExternalDocument get(int n) {
        return (ExternalDocument)this.documents.get(n);
    }

    public String getName() {
        return new File(this.fileName).getName();
    }
}

