/*
 * Decompiled with CFR 0.152.
 */
package Jet.Tipster;

import Jet.Lisp.FeatureSet;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class Document {
    StringBuffer text;
    private Hashtable annotationsByStart;
    private Hashtable annotationsByType;
    private int nextAnnotationId;
    private int sgmlWrapMargin = 80;
    private int sgmlIndent = 0;

    public Document() {
        this.text = new StringBuffer();
        this.annotationsByStart = new Hashtable();
        this.annotationsByType = new Hashtable();
        this.nextAnnotationId = 0;
    }

    public Document(String string) {
        this.text = new StringBuffer(string);
        this.annotationsByStart = new Hashtable();
        this.annotationsByType = new Hashtable();
        this.nextAnnotationId = 0;
    }

    public void clear() {
        this.text.setLength(0);
        this.annotationsByStart.clear();
        this.annotationsByType.clear();
        this.nextAnnotationId = 0;
    }

    public void setText(String string) {
        this.text = new StringBuffer(string);
    }

    public String text() {
        return this.text.toString();
    }

    public String text(Span span) {
        return this.text.substring(span.start(), span.end());
    }

    public String text(Annotation annotation) {
        return this.text(annotation.span());
    }

    public String normalizedText(Span span) {
        return Resolve.normalizeName(this.text.substring(span.start(), span.end()));
    }

    public String normalizedText(Annotation annotation) {
        return this.normalizedText(annotation.span());
    }

    public StringBuffer append(String string) {
        return this.text.append(string);
    }

    public StringBuffer append(char c) {
        return this.text.append(c);
    }

    public int length() {
        return this.text.length();
    }

    public char charAt(int n) {
        return this.text.charAt(n);
    }

    public void setCharAt(int n, char c) {
        this.text.setCharAt(n, c);
    }

    public void clearAnnotations() {
        this.annotationsByStart.clear();
        this.annotationsByType.clear();
    }

    public Annotation addAnnotation(Annotation annotation) {
        Integer n = new Integer(annotation.span.start);
        if (!this.annotationsByStart.containsKey(n)) {
            this.annotationsByStart.put(n, new Vector());
        }
        Vector vector = (Vector)this.annotationsByStart.get(n);
        vector.add(annotation);
        String string = annotation.type;
        if (!this.annotationsByType.containsKey(string)) {
            this.annotationsByType.put(string, new Vector());
        }
        Vector vector2 = (Vector)this.annotationsByType.get(string);
        vector2.add(annotation);
        Span span = annotation.span();
        span.setDocument(this);
        return annotation;
    }

    public Annotation annotate(String string, Span span, FeatureSet featureSet) {
        return this.addAnnotation(new Annotation(string, span, featureSet));
    }

    public void removeAnnotation(Annotation annotation) {
        String string;
        Vector vector;
        Integer n = new Integer(annotation.span.start);
        Vector vector2 = (Vector)this.annotationsByStart.get(n);
        if (vector2 != null) {
            vector2.remove(annotation);
        }
        if ((vector = (Vector)this.annotationsByType.get(string = annotation.type)) != null) {
            vector.remove(annotation);
        }
    }

    public void removeAnnotationsOfType(String string) {
        Vector vector = this.annotationsOfType(string);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            this.removeAnnotation(annotation);
        }
    }

    public Vector annotationsAt(int n) {
        Integer n2 = new Integer(n);
        Vector vector = (Vector)this.annotationsByStart.get(n2);
        if (vector == null) {
            return null;
        }
        return (Vector)vector.clone();
    }

    public Vector annotationsAt(int n, String string) {
        Vector vector = this.annotationsAt(n);
        if (vector == null) {
            return null;
        }
        Vector<Annotation> vector2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            if (!annotation.type().equals(string)) continue;
            if (vector2 == null) {
                vector2 = new Vector<Annotation>();
            }
            vector2.addElement(annotation);
        }
        return vector2;
    }

    public Annotation tokenAt(int n) {
        Vector vector = this.annotationsAt(n);
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            if (!annotation.type().equals("token")) continue;
            return annotation;
        }
        return null;
    }

    public Vector annotationsOfType(String string) {
        Vector vector = (Vector)this.annotationsByType.get(string);
        if (vector == null) {
            return null;
        }
        return (Vector)vector.clone();
    }

    public Vector annotationsOfType(String string, Span span) {
        Vector vector = (Vector)this.annotationsByType.get(string);
        if (vector == null) {
            return null;
        }
        Vector<Annotation> vector2 = new Vector<Annotation>();
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            if (!annotation.span().within(span)) continue;
            vector2.add(annotation);
        }
        if (vector2.size() > 0) {
            return vector2;
        }
        return null;
    }

    public String[] getAnnotationTypes() {
        return this.annotationsByType.keySet().toArray(new String[0]);
    }

    public void annotateWithTag(String string, int n, int n2) {
        String string2 = "/" + string;
        int n3 = 0;
        int n4 = 0;
        FeatureSet featureSet = new FeatureSet();
        StringBuffer stringBuffer = null;
        boolean bl = false;
        for (int i = n; i < n2 && i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (c == '<') {
                bl = true;
                stringBuffer = new StringBuffer();
                n4 = i - 1;
                continue;
            }
            if (!bl) continue;
            if (c == '>') {
                bl = false;
                String string3 = stringBuffer.toString();
                if (string3.equalsIgnoreCase(string)) {
                    n3 = i + 1;
                    continue;
                }
                if (!string3.equalsIgnoreCase(string2)) continue;
                if (n3 != 0 && n4 != 0 && n3 < n4) {
                    this.annotate(string, new Span(n3, n4), featureSet);
                }
                n3 = 0;
                continue;
            }
            stringBuffer.append(c);
        }
    }

    public void annotateWithTag(String string) {
        this.annotateWithTag(string, 0, this.length());
    }

    public int getNextAnnotationId() {
        return this.nextAnnotationId++;
    }

    public void setSGMLwrapMargin(int n) {
        this.sgmlWrapMargin = n;
    }

    public void setSGMLindent(int n) {
        this.sgmlIndent = n;
    }

    public StringBuffer writeSGML(String string) {
        this.prepareToWriteSGML(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 999999;
        int n2 = 0;
        Stack<Object> stack = new Stack<Object>();
        for (int i = 0; i < this.text.length(); ++i) {
            Object object;
            Vector vector = string == null ? this.annotationsAt(i) : this.annotationsAt(i, string);
            if (vector != null) {
                Annotation.sort(vector);
                for (int j = 0; j < vector.size(); ++j) {
                    object = (Annotation)vector.get(j);
                    int n3 = ((Annotation)object).span().endNoWS(this);
                    if (n3 > n) {
                        System.out.println("writeSGML:  annotations not nested.");
                        System.out.println("  annotation " + object + " suppressed.");
                        System.out.println("  annEnd = " + n3 + "  nextClose = " + n);
                        continue;
                    }
                    n = n3;
                    String string2 = ((Annotation)object).toSGMLString();
                    if (this.sgmlIndent > 0) {
                        if (stack.empty()) {
                            n2 += string2.length();
                        } else {
                            string2 = "<\n" + this.blankString(stack.size() * this.sgmlIndent) + string2.substring(1);
                            n2 = string2.length() - 2;
                        }
                    } else if (this.sgmlWrapMargin > 0 && n2 + string2.length() > this.sgmlWrapMargin) {
                        string2 = string2.substring(0, string2.length() - 1) + "\n>";
                        n2 = 1;
                    } else {
                        n2 += string2.length();
                    }
                    stringBuffer.append(string2);
                    stack.push(object);
                }
            }
            while (!stack.empty() && ((Annotation)stack.peek()).span().endNoWS(this) == i) {
                String string3 = ((Annotation)stack.peek()).type();
                object = "</" + string3 + ">";
                stringBuffer.append((String)object);
                stack.pop();
                if (stack.empty()) {
                    n = 999999;
                    continue;
                }
                n = ((Annotation)stack.peek()).span().endNoWS(this);
            }
            stringBuffer.append(this.text.charAt(i));
            n2 = this.text.charAt(i) == '\n' ? 0 : ++n2;
            while (!stack.empty() && ((Annotation)stack.peek()).span().endNoWS(this) == 1 + i) {
                String string4 = ((Annotation)stack.peek()).type();
                if (this.sgmlIndent > 0) {
                    stringBuffer.append("<\n" + this.blankString((stack.size() - 1) * this.sgmlIndent) + "/" + string4 + ">");
                    n2 = string4.length() + 1;
                } else {
                    stringBuffer.append("</" + string4 + ">");
                    n2 += string4.length() + 3;
                }
                stack.pop();
                if (stack.empty()) {
                    n = 999999;
                    continue;
                }
                n = ((Annotation)stack.peek()).span().endNoWS(this);
            }
        }
        while (!stack.empty()) {
            System.out.println("Internal writeSGML error:  didn't close annotation " + stack.pop());
        }
        return stringBuffer;
    }

    private void prepareToWriteSGML(String string) {
        for (int i = 0; i < this.text.length(); ++i) {
            Vector vector = string == null ? this.annotationsAt(i) : this.annotationsAt(i, string);
            if (vector == null) continue;
            for (int j = 0; j < vector.size(); ++j) {
                Annotation annotation = (Annotation)vector.get(j);
                annotation.prepareToMakeString(1);
            }
        }
    }

    private String blankString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/perfect parses/training04/nwire/APW20001001.2021.0521.sgm";
        ExternalDocument externalDocument = new ExternalDocument("sgml", string);
        externalDocument.setAllTags(true);
        externalDocument.open();
        externalDocument.setSGMLindent(4);
        System.out.println(externalDocument.writeSGML(null));
        String string2 = "C:/Documents and Settings/Ralph Grishman/My Documents/temp.sgm";
        externalDocument.saveAs(null, string2);
        ExternalDocument externalDocument2 = new ExternalDocument("sgml", string2);
        externalDocument2.setAllTags(true);
        externalDocument2.open();
        externalDocument2.setSGMLwrapMargin(72);
        System.out.println(externalDocument2.writeSGML(null));
    }
}

