/*
 * Decompiled with CFR 0.152.
 */
package Jet.Tipster;

import Jet.JetTest;
import Jet.Refres.CorefEval;
import Jet.Refres.EntityView;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.View;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;

public class CollectionView
extends JFrame {
    public CollectionView(DocumentCollection documentCollection) {
        this(documentCollection, false);
    }

    private CollectionView(DocumentCollection documentCollection, boolean bl) {
        if (documentCollection == null) {
            return;
        }
        int n = documentCollection.size();
        Box box = Box.createHorizontalBox();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(n, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(n, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(n, 1));
        box.add(jPanel);
        box.add(jPanel2);
        box.add(jPanel3);
        BevelBorder bevelBorder = new BevelBorder(0);
        for (int i = 0; i < n; ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            String string = externalDocument.fileName();
            JLabel jLabel = new JLabel(string);
            jPanel.add(jLabel);
            JButton jButton = new JButton("view annotations");
            jButton.setBorder(bevelBorder);
            jButton.addActionListener(new ViewCreator(externalDocument, string, false, bl));
            jPanel2.add(jButton);
            boolean bl2 = externalDocument.annotationsOfType("entitiesDiffer") != null;
            JButton jButton2 = new JButton("view entities" + (bl2 ? "*" : ""));
            jButton2.setBorder(bevelBorder);
            jButton2.addActionListener(new ViewCreator(externalDocument, string, true, bl));
            jPanel3.add(jButton2);
        }
        JScrollPane jScrollPane = new JScrollPane(box);
        this.getContentPane().add(jScrollPane);
        this.setSize(600, 400);
        this.setTitle("Collection " + documentCollection.getName());
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/";
        DocumentCollection documentCollection = new DocumentCollection(string + "ACE/training nwire coref.txt");
        documentCollection.open();
        new CollectionView(documentCollection, true);
    }

    public static void task(String[] stringArray) {
        String string = null;
        String string2 = null;
        if (stringArray.length == 4 && stringArray[1].equals("-encoding")) {
            string = stringArray[2];
            string2 = stringArray[3];
        } else if (stringArray.length == 2) {
            string2 = stringArray[1];
        } else {
            System.out.println("CollectionView requires 1 argument: jet -CollectionView [-encoding e] <collection>");
            System.exit(1);
        }
        if (string != null && !JetTest.setEncoding(string)) {
            System.exit(1);
        }
        DocumentCollection documentCollection = new DocumentCollection(string2);
        documentCollection.open();
        new CollectionView(documentCollection, true);
    }

    private class ViewCreator
    implements ActionListener {
        ExternalDocument doc;
        String documentName;
        boolean showEntities;
        boolean createEntities;

        private ViewCreator(ExternalDocument externalDocument, String string, boolean bl, boolean bl2) {
            this.doc = externalDocument;
            this.showEntities = bl;
            this.createEntities = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.doc.setAllTags(true);
            this.doc.open();
            if (this.showEntities) {
                if (this.createEntities && this.doc.annotationsOfType("entity") == null) {
                    CorefEval.buildEntitiesFromMentions(this.doc);
                }
                new EntityView(this.doc, 0);
            } else {
                new View(this.doc, 0);
            }
        }
    }
}

