/*
 * Decompiled with CFR 0.152.
 */
package Jet.Scorer;

import Jet.Scorer.SGMLProcessor;
import Jet.Scorer.SGMLScorer;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class SGMLScorerWindow
extends JFrame
implements ActionListener {
    JButton jButtonScore = new JButton();
    JButton jButtonReset = new JButton();
    JLabel jLabel = new JLabel();
    JTextField jTextField = new JTextField();
    JPanel jPanelBottom = new JPanel();
    JPanel jPanelBottomLeft = new JPanel();
    JPanel jPanelBottomRight = new JPanel();
    JPanel jPanelTopLeft = new JPanel();
    JPanel jPanelTopRight = new JPanel();
    JPanel jPanelButtons = new JPanel();
    JPanel jPanelTypeText = new JPanel();
    JSplitPane jSplitPane = new JSplitPane();
    JSplitPane jSplitPaneMain = new JSplitPane(0);
    JScrollPane jScrollPaneLeft = new JScrollPane();
    JScrollPane jScrollPaneRight = new JScrollPane();
    JScrollPane jScrollPaneBottom = new JScrollPane();
    JTextPane jTextPaneLeft = new JTextPane();
    JTextPane jTextPaneRight = new JTextPane();
    JTextArea jTextAreaBottom = new JTextArea();
    final JFileChooser fc = new JFileChooser(".");
    SGMLScorer scorer = null;
    String loadedText1 = "";
    String loadedText2 = "";
    String text1 = null;
    String text2 = null;
    Document doc1 = null;
    Document doc2 = null;
    boolean keyProcessed = false;
    boolean responseProcessed = false;
    boolean editMode = false;

    public SGMLScorerWindow() {
        try {
            this.jbInit();
            this.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
            }
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
            }
            this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setTitle("SGML Scorer");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Load Key File ...");
        jMenuItem.setMnemonic(75);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Load Response File ...");
        jMenuItem.setMnemonic(80);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.setMnemonic(88);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        JMenu jMenu2 = new JMenu("Mode");
        jMenu2.setMnemonic(77);
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Edit Mode");
        jRadioButtonMenuItem.setMnemonic(69);
        jMenu2.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Non-Edit Mode");
        jRadioButtonMenuItem.setSelected(true);
        jRadioButtonMenuItem.setMnemonic(78);
        jMenu2.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(this);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.jTextPaneLeft.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.jTextPaneLeft.setFont(new Font("dialog", 0, 12));
        this.jTextPaneLeft.setEditable(false);
        this.jTextPaneLeft.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                SGMLScorerWindow.this.jTextPaneLeftCaretUpdate(caretEvent);
            }
        });
        this.jScrollPaneLeft.getViewport().add((Component)this.jTextPaneLeft, null);
        this.jPanelTopLeft.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Key File"), BorderFactory.createEmptyBorder(4, 8, 4, 4)));
        this.jPanelTopLeft.setLayout(new BorderLayout());
        this.jPanelTopLeft.add((Component)this.jScrollPaneLeft, "Center");
        this.jTextPaneRight.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.jTextPaneRight.setFont(new Font("dialog", 0, 12));
        this.jTextPaneRight.setEditable(false);
        this.jTextPaneRight.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                SGMLScorerWindow.this.jTextPaneRightCaretUpdate(caretEvent);
            }
        });
        this.jScrollPaneRight.getViewport().add((Component)this.jTextPaneRight, null);
        this.jPanelTopRight.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Response File"), BorderFactory.createEmptyBorder(4, 8, 4, 4)));
        this.jPanelTopRight.setLayout(new BorderLayout());
        this.jPanelTopRight.add((Component)this.jScrollPaneRight, "Center");
        this.jSplitPane.setPreferredSize(new Dimension(1016, 510));
        this.jSplitPane.setDividerLocation(500);
        this.jSplitPane.add((Component)this.jPanelTopLeft, "left");
        this.jSplitPane.add((Component)this.jPanelTopRight, "right");
        this.jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGMLScorerWindow.this.scorer();
            }
        });
        this.jButtonScore.setText("Score");
        this.jButtonScore.setToolTipText("Score homology of the two files");
        this.jButtonScore.setMnemonic(83);
        this.jButtonScore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGMLScorerWindow.this.scorer();
            }
        });
        this.jButtonReset.setText("Reset");
        this.jButtonReset.setToolTipText("Reset texts to original form");
        this.jButtonReset.setMnemonic(82);
        this.jButtonReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGMLScorerWindow.this.jTextPaneLeft.setText(SGMLScorerWindow.this.loadedText1);
                SGMLScorerWindow.this.jTextPaneRight.setText(SGMLScorerWindow.this.loadedText2);
                SGMLScorerWindow.this.jTextAreaBottom.setText("");
                SGMLScorerWindow.this.jTextField.selectAll();
                SGMLScorerWindow.this.doc1 = null;
                SGMLScorerWindow.this.doc2 = null;
                SGMLScorerWindow.this.keyProcessed = false;
                SGMLScorerWindow.this.responseProcessed = false;
            }
        });
        this.jPanelButtons.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jPanelButtons.setLayout(new GridLayout(1, 2));
        this.jPanelButtons.add(this.jButtonScore);
        this.jPanelButtons.add(this.jButtonReset);
        this.jLabel.setText("Type(s):  ");
        this.jLabel.setToolTipText("The type(s) to be scored, separated by ','  Case sensitive");
        this.jPanelTypeText.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jPanelTypeText.setLayout(new BorderLayout());
        this.jPanelTypeText.add((Component)this.jLabel, "West");
        this.jPanelTypeText.add((Component)this.jTextField, "Center");
        this.jPanelBottomLeft.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.jPanelBottomLeft.setLayout(new GridLayout(2, 1));
        this.jPanelBottomLeft.add(this.jPanelTypeText);
        this.jPanelBottomLeft.add(this.jPanelButtons);
        this.jTextAreaBottom.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.jTextAreaBottom.setEditable(false);
        this.jScrollPaneBottom.getViewport().add((Component)this.jTextAreaBottom, null);
        this.jPanelBottomRight.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "Statistics"), BorderFactory.createEmptyBorder(4, 8, 4, 4)));
        this.jPanelBottomRight.setLayout(new BorderLayout());
        this.jPanelBottomRight.add((Component)this.jScrollPaneBottom, "Center");
        this.jPanelBottom.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.jPanelBottom.setLayout(new BorderLayout());
        this.jPanelBottom.add((Component)this.jPanelBottomLeft, "West");
        this.jPanelBottom.add((Component)this.jPanelBottomRight, "Center");
        this.jPanelBottom.setPreferredSize(new Dimension(1016, 70));
        this.jSplitPaneMain.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        this.jSplitPaneMain.add((Component)this.jSplitPane, "top");
        this.jSplitPaneMain.add((Component)this.jPanelBottom, "bottom");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing() {
                SGMLScorerWindow.this.dispose();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jSplitPaneMain, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Load Key File ...")) {
            this.fc.setDialogTitle("Load Key File");
            this.fc.setApproveButtonText("Load");
            this.fc.setApproveButtonMnemonic(76);
            this.fc.setApproveButtonToolTipText("Load key file");
            int n = this.fc.showDialog(this, null);
            if (n == 0) {
                try {
                    File file = this.fc.getSelectedFile();
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    String string = null;
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string + "\n");
                    }
                    this.loadedText1 = stringBuffer.toString();
                    this.jTextPaneLeft.setText(this.loadedText1);
                    this.keyProcessed = false;
                    this.doc1 = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else if (actionEvent.getActionCommand().equals("Load Response File ...")) {
            this.fc.setDialogTitle("Load Response File");
            this.fc.setApproveButtonText("Load");
            this.fc.setApproveButtonMnemonic(76);
            this.fc.setApproveButtonToolTipText("Load response file");
            int n = this.fc.showDialog(this, null);
            if (n == 0) {
                try {
                    File file = this.fc.getSelectedFile();
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                    String string = null;
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string + "\n");
                    }
                    this.loadedText2 = stringBuffer.toString();
                    this.jTextPaneRight.setText(this.loadedText2);
                    this.responseProcessed = false;
                    this.doc2 = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else if (actionEvent.getActionCommand().equals("Exit")) {
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Edit Mode")) {
            this.editMode = true;
            this.jTextPaneLeft.setEditable(true);
            this.jTextPaneRight.setEditable(true);
        } else {
            this.editMode = false;
            this.jTextPaneLeft.setEditable(false);
            this.jTextPaneRight.setEditable(false);
        }
    }

    private void scorer() {
        int n;
        String[] stringArray = this.getTypes();
        if (this.editMode) {
            this.text1 = this.jTextPaneLeft.getText();
            this.text2 = this.jTextPaneRight.getText();
            this.doc1 = SGMLProcessor.sgmlToDoc(this.text1, stringArray);
            this.doc2 = SGMLProcessor.sgmlToDoc(this.text2, stringArray);
        } else {
            if (!this.keyProcessed) {
                this.doc1 = SGMLProcessor.sgmlToDoc(this.loadedText1, stringArray);
                this.keyProcessed = true;
            }
            if (!this.responseProcessed) {
                this.doc2 = SGMLProcessor.sgmlToDoc(this.loadedText2, stringArray);
                this.responseProcessed = true;
            }
        }
        this.jTextPaneLeft.setText(this.doc1.text());
        this.jTextPaneRight.setText(this.doc2.text());
        this.scorer = new SGMLScorer(this.doc1, this.doc2);
        for (n = 0; n < stringArray.length; ++n) {
            this.scorer.match(stringArray[n]);
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.highlight(stringArray[n]);
        }
        float f = this.scorer.totalTagsInDoc2 == 0 ? -100.0f : (float)(10000 * this.scorer.numOfMatchingTags / this.scorer.totalTagsInDoc2);
        f = (float)((double)f / 100.0);
        float f2 = this.scorer.totalTagsInDoc1 == 0 ? -100.0f : (float)(10000 * this.scorer.numOfMatchingTags / this.scorer.totalTagsInDoc1);
        f2 = (float)((double)f2 / 100.0);
        float f3 = this.scorer.numOfMatchingTags == 0 ? -100.0f : (float)(10000 * this.scorer.numOfMatchingAttrs / this.scorer.numOfMatchingTags);
        f3 = (float)((double)f3 / 100.0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# of matching tags = " + this.scorer.totalMatchingTags);
        stringBuffer.append(";  # of tags in key = " + this.scorer.totalTagsInDoc1);
        stringBuffer.append(";  # of tags in response = " + this.scorer.totalTagsInDoc2);
        stringBuffer.append(";\nprecision = " + (f < 0.0f ? "NA" : f + "%"));
        stringBuffer.append(";  recall = " + (f2 < 0.0f ? "NA" : f2 + "%"));
        stringBuffer.append(";  type accuracy = " + (f3 < 0.0f ? "NA" : f3 + "%"));
        this.jTextAreaBottom.setText(stringBuffer.toString());
        this.highlightMismatches();
        this.jTextField.selectAll();
    }

    private String[] getTypes() {
        Vector<String> vector = new Vector<String>();
        String string = this.jTextField.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", \t\n\r\f");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        Object[] objectArray = vector.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    private void highlight(String string) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        Color color = new Color(string.hashCode());
        StyleConstants.setForeground(simpleAttributeSet, color);
        StyleConstants.setBold(simpleAttributeSet, true);
        this.setAnnotationAttribute(string, simpleAttributeSet);
    }

    private void bleach(String string) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        this.setAnnotationAttribute(string, simpleAttributeSet);
    }

    private void setAnnotationAttribute(String string, AttributeSet attributeSet) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Vector vector = this.doc1.annotationsOfType(string);
        if (vector != null) {
            object3 = this.jTextPaneLeft.getStyledDocument();
            object2 = vector.iterator();
            while (object2.hasNext()) {
                object = (Annotation)object2.next();
                int n2 = ((Annotation)object).span().start();
                n = ((Annotation)object).span().endNoWS(this.doc1) - n2;
                object3.setCharacterAttributes(n2, n, attributeSet, true);
            }
        }
        if ((object3 = this.doc2.annotationsOfType(string)) != null) {
            object2 = this.jTextPaneRight.getStyledDocument();
            object = ((Vector)object3).iterator();
            while (object.hasNext()) {
                Annotation annotation = (Annotation)object.next();
                n = annotation.span().start();
                int n3 = annotation.span().endNoWS(this.doc2) - n;
                object2.setCharacterAttributes(n, n3, attributeSet, true);
            }
        }
    }

    private void highlightMismatches() {
        int n;
        int n2;
        Annotation annotation;
        Iterator iterator;
        StyledDocument styledDocument;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setBackground(simpleAttributeSet, Color.orange);
        if (this.scorer.mismatch1 != null) {
            styledDocument = this.jTextPaneLeft.getStyledDocument();
            iterator = this.scorer.mismatch1.iterator();
            while (iterator.hasNext()) {
                annotation = (Annotation)iterator.next();
                n2 = annotation.span().start();
                n = annotation.span().endNoWS(this.doc1) - n2;
                styledDocument.setCharacterAttributes(n2, n, simpleAttributeSet, false);
            }
        }
        if (this.scorer.mismatch2 != null) {
            styledDocument = this.jTextPaneRight.getStyledDocument();
            iterator = this.scorer.mismatch2.iterator();
            while (iterator.hasNext()) {
                annotation = (Annotation)iterator.next();
                n2 = annotation.span().start();
                n = annotation.span().endNoWS(this.doc2) - n2;
                styledDocument.setCharacterAttributes(n2, n, simpleAttributeSet, false);
            }
        }
    }

    private void jTextPaneLeftCaretUpdate(CaretEvent caretEvent) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = caretEvent.getDot();
        int n2 = caretEvent.getMark();
        if (this.doc1 == null) {
            return;
        }
        for (int i = Math.min(n, n2); i < Math.max(n, n2) || i == n && n == n2; ++i) {
            Vector vector = this.doc1.annotationsAt(i);
            if (vector == null) continue;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                stringBuffer.append(annotation.toString() + " ");
            }
        }
        string = stringBuffer.toString();
        if (string.length() != 0) {
            this.jTextPaneLeft.setToolTipText(string);
        } else {
            this.jTextPaneLeft.setToolTipText(null);
        }
    }

    private void jTextPaneRightCaretUpdate(CaretEvent caretEvent) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = caretEvent.getDot();
        int n2 = caretEvent.getMark();
        if (this.doc2 == null) {
            return;
        }
        for (int i = Math.min(n, n2); i < Math.max(n, n2) || i == n && n == n2; ++i) {
            Vector vector = this.doc2.annotationsAt(i);
            if (vector == null) continue;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                stringBuffer.append(annotation.toString() + " ");
            }
        }
        string = stringBuffer.toString();
        if (string.length() != 0) {
            this.jTextPaneRight.setToolTipText(string);
        } else {
            this.jTextPaneRight.setToolTipText(null);
        }
    }
}

