/*
 * Decompiled with CFR 0.152.
 */
package Jet.Pat;

import Jet.Console;
import Jet.Lisp.FeatureSet;
import Jet.Lisp.Variable;
import Jet.Pat.Action;
import Jet.Pat.Pat;
import Jet.Pat.PatternApplication;
import Jet.Pat.PatternSyntaxError;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Vector;

public class NewAnnotationAction
extends Action {
    String type;
    FeatureSet features;
    Variable spanVariable;
    Variable bindingVariable;

    public NewAnnotationAction(String string, FeatureSet featureSet, Variable variable) {
        this.type = string;
        this.features = featureSet;
        this.spanVariable = variable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NewAnnotationAction(StreamTokenizer streamTokenizer) throws IOException, PatternSyntaxError {
        if (streamTokenizer.nextToken() == -3 && Character.isUpperCase(streamTokenizer.sval.charAt(0))) {
            this.bindingVariable = new Variable(streamTokenizer.sval);
            if (streamTokenizer.nextToken() != 61) {
                throw new PatternSyntaxError("= expected");
            }
            streamTokenizer.nextToken();
        }
        if (streamTokenizer.ttype != 91) {
            throw new PatternSyntaxError("[ expected");
        }
        if (streamTokenizer.nextToken() != -3) {
            throw new PatternSyntaxError("annotation type expected");
        }
        this.type = streamTokenizer.sval;
        this.features = new FeatureSet(streamTokenizer, true, ']');
        if (streamTokenizer.nextToken() == -3 && streamTokenizer.sval.equalsIgnoreCase("over")) {
            if (streamTokenizer.nextToken() == -3 && Character.isUpperCase(streamTokenizer.sval.charAt(0))) {
                this.spanVariable = new Variable(streamTokenizer.sval);
                streamTokenizer.nextToken();
                return;
            } else {
                if (streamTokenizer.ttype != -2 || streamTokenizer.nval != 0.0) throw new PatternSyntaxError("variable expected after 'over'");
                this.spanVariable = new Variable("0");
                streamTokenizer.nextToken();
            }
            return;
        } else {
            this.spanVariable = null;
        }
    }

    public int perform(Document document, PatternApplication patternApplication) {
        Object object;
        Span span;
        HashMap hashMap = patternApplication.bestBindings;
        if (this.spanVariable == null) {
            span = new Span(patternApplication.startPosition, patternApplication.bestPosition);
        } else if (this.spanVariable.name.toString() == "0") {
            span = new Span(patternApplication.startPosition, patternApplication.startPosition);
        } else {
            object = hashMap.get(this.spanVariable.name);
            if (object instanceof Span) {
                span = (Span)object;
            } else if (object instanceof Annotation) {
                span = ((Annotation)object).span();
            } else {
                System.out.println("Value of " + this.spanVariable.toString() + " is not a span.or annotation");
                return -1;
            }
        }
        if (Pat.trace) {
            Console.println("Annotating " + document.text(span) + " as " + this.type + this.features.substitute(hashMap).toSGMLString());
        }
        NewAnnotationAction.hideAnnotations(document, this.type, span);
        NewAnnotationAction.hideAnnotations(document, "token", span);
        object = new Annotation(this.type, span, this.features.substitute(hashMap));
        document.addAnnotation((Annotation)object);
        if (this.bindingVariable != null) {
            hashMap.put(this.bindingVariable.name, object);
        }
        return span.end();
    }

    public static void hideAnnotations(Document document, String string, Span span) {
        for (int i = span.start(); i < span.end(); ++i) {
            Vector vector = document.annotationsAt(i, string);
            if (vector == null) continue;
            for (int j = 0; j < vector.size(); ++j) {
                Annotation annotation = (Annotation)vector.elementAt(j);
                annotation.put("hidden", "true");
            }
        }
    }

    public String toString() {
        if (this.spanVariable == null) {
            return "add [" + this.type + this.features.toSGMLString() + "]";
        }
        return "add [" + this.type + this.features.toSGMLString() + "] over " + this.spanVariable.toString();
    }
}

