/*
 * Decompiled with CFR 0.152.
 */
package Jet.Parser;

import Jet.Console;
import Jet.Lisp.Literal;
import Jet.Parser.ActiveEdge;
import Jet.Parser.Edge;
import Jet.Parser.Grammar;
import Jet.Parser.ParseTreeNode;
import Jet.Parser.ParseView;
import Jet.Parser.Production;
import Jet.Parser.Reduce;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;

public class Parsers {
    static final String NULL = "null";
    static final String SENTENCE = "sentence";
    public static final int RECOGNIZE = 1;
    public static final int TDPARSE = 2;
    public static final int BUPARSE = 3;
    public static final int CHARTPARSE = 4;
    public static int parserType = 1;
    static Vector parses = new Vector();
    public static boolean parserTrace = true;
    static Stack agenda;
    static Vector chart;
    static Hashtable sought;

    public static Vector parse(Document document, int n, int n2, Grammar grammar) {
        switch (parserType) {
            case 1: {
                parses = new Vector();
                if (Parsers.recognize(document, n, n2, grammar)) {
                    parses.addElement(null);
                }
                return parses;
            }
            case 2: {
                return Parsers.TDParse(document, n, n2, grammar);
            }
            case 3: {
                return Parsers.BUParse(document, n, n2, grammar);
            }
            case 4: {
                return Parsers.chartParse(document, n, n2, grammar);
            }
        }
        return new Vector();
    }

    public static boolean recognize(Document document, int n, int n2, Grammar grammar) {
        Stack<String> stack = new Stack<String>();
        stack.push(SENTENCE);
        return Parsers.recognize(document, n, n2, grammar, stack);
    }

    private static boolean recognize(Document document, int n, int n2, Grammar grammar, Stack stack) {
        Vector vector;
        if (stack.empty()) {
            if (n == n2) {
                Console.println("Sentence recognized.");
                return true;
            }
            return false;
        }
        Object e = stack.pop();
        Parsers.printParseTrace("Seeking " + e, n, 0);
        if (e == NULL) {
            return Parsers.recognize(document, n, n2, grammar, stack);
        }
        if (e instanceof Literal) {
            Annotation annotation = document.tokenAt(n);
            if (annotation != null && ((Literal)e).getString().equals(document.text(annotation).trim())) {
                n = annotation.span().end();
                return Parsers.recognize(document, n, n2, grammar, stack);
            }
            return false;
        }
        Vector vector2 = document.annotationsAt(n, "constit");
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                Annotation annotation = (Annotation)vector2.elementAt(i);
                if (annotation.get("cat") != e) continue;
                n = annotation.span().end();
                return Parsers.recognize(document, n, n2, grammar, stack);
            }
        }
        if ((vector = grammar.getProductions((String)e)) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Production production = (Production)vector.elementAt(i);
                Vector vector3 = production.rhs();
                Stack stack2 = (Stack)stack.clone();
                for (int j = vector3.size() - 1; j >= 0; --j) {
                    stack2.push(vector3.elementAt(j));
                }
                if (!Parsers.recognize(document, n, n2, grammar, stack2)) continue;
                return true;
            }
        }
        return false;
    }

    public static Vector TDParse(Document document, int n, int n2, Grammar grammar) {
        Stack<String> stack = new Stack<String>();
        Stack stack2 = new Stack();
        parses = new Stack();
        stack.push(SENTENCE);
        Parsers.TDParse(document, n, n2, grammar, stack, stack2);
        Console.println(parses.size() + " parse(s) obtained");
        return parses;
    }

    private static void TDParse(Document document, int n, int n2, Grammar grammar, Stack stack, Stack stack2) {
        Vector vector;
        if (stack.empty()) {
            if (n == n2) {
                if (parserTrace) {
                    Console.println("Sentence parsed.");
                }
                parses.addElement(stack2.pop());
            }
            return;
        }
        Object e = stack.pop();
        if (e instanceof Reduce) {
            int n3;
            String string = ((Reduce)e).category;
            int n4 = ((Reduce)e).numberOfChildren;
            ParseTreeNode[] parseTreeNodeArray = new ParseTreeNode[n4];
            for (n3 = n4 - 1; n3 >= 0; --n3) {
                parseTreeNodeArray[n3] = (ParseTreeNode)stack2.pop();
            }
            n3 = parseTreeNodeArray[0].start;
            stack2.push(new ParseTreeNode(string, parseTreeNodeArray, n3, n, null, null));
            Parsers.printParseTrace("Found   " + string + " = " + document.text(new Span(n3, n)), n3, n);
            Parsers.TDParse(document, n, n2, grammar, stack, stack2);
            return;
        }
        Parsers.printParseTrace("Seeking " + e, n, 0);
        if (e == NULL) {
            stack2.push(new ParseTreeNode(NULL, null, n, n, null, null));
            Parsers.TDParse(document, n, n2, grammar, stack, stack2);
            return;
        }
        if (e instanceof Literal) {
            Annotation annotation = document.tokenAt(n);
            if (annotation != null && ((Literal)e).getString().equals(document.text(annotation).trim())) {
                int n5 = annotation.span().end();
                stack2.push(new ParseTreeNode(e, null, n, n5, annotation, (String)e));
                Parsers.printParseTrace("Found   " + e, n, n5);
                Parsers.TDParse(document, n5, n2, grammar, stack, stack2);
            }
            return;
        }
        String string = (String)e;
        Vector vector2 = document.annotationsAt(n, "constit");
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                Annotation annotation = (Annotation)vector2.elementAt(i);
                if (annotation.get("cat") != string) continue;
                int n6 = annotation.span().end();
                stack2.push(new ParseTreeNode(string, null, n, n6, annotation, document.text(annotation)));
                Parsers.printParseTrace("Found   " + e + " = " + document.text(new Span(n, n6)), n, n6);
                Parsers.TDParse(document, n6, n2, grammar, stack, stack2);
                return;
            }
        }
        if ((vector = grammar.getProductions(string)) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Production production = (Production)vector.elementAt(i);
                Vector vector3 = production.rhs();
                Stack stack3 = (Stack)stack.clone();
                Stack stack4 = (Stack)stack2.clone();
                stack3.push(new Reduce(string, vector3.size()));
                for (int j = vector3.size() - 1; j >= 0; --j) {
                    stack3.push(vector3.elementAt(j));
                }
                Parsers.TDParse(document, n, n2, grammar, stack3, stack4);
            }
        }
    }

    public static Vector BUParse(Document document, int n, int n2, Grammar grammar) {
        int n3 = n;
        agenda = new Stack();
        chart = new Vector();
        parses = new Vector();
        while (n >= 0 && n < n2) {
            n = Parsers.addLexicalNodes(document, n);
            while (!agenda.empty()) {
                ParseTreeNode parseTreeNode = (ParseTreeNode)agenda.pop();
                Vector vector = grammar.getProductionsEndingIn(parseTreeNode.category);
                if (vector != null) {
                    for (int i = 0; i < vector.size(); ++i) {
                        Production production = (Production)vector.elementAt(i);
                        int n4 = production.rhs.size();
                        ParseTreeNode[] parseTreeNodeArray = new ParseTreeNode[n4];
                        parseTreeNodeArray[n4 - 1] = parseTreeNode;
                        Parsers.extend(document, production, parseTreeNode.start, parseTreeNode.end, parseTreeNodeArray, n4 - 2);
                    }
                }
                if (parseTreeNode.category != SENTENCE || parseTreeNode.start != n3 || parseTreeNode.end != n2) continue;
                parses.addElement(parseTreeNode);
            }
        }
        Console.println(parses.size() + " parse(s) obtained");
        return parses;
    }

    private static int addLexicalNodes(Document document, int n) {
        Annotation annotation = document.tokenAt(n);
        if (annotation == null) {
            return -1;
        }
        Parsers.addNode(document, document.text(annotation).trim(), null, n, annotation.span().end(), annotation, document.text(annotation));
        Vector vector = document.annotationsAt(n, "constit");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Annotation annotation2 = (Annotation)vector.elementAt(i);
                Parsers.addNode(document, annotation2.get("cat"), null, n, annotation2.span().end(), annotation2, document.text(annotation2));
            }
        }
        return annotation.span().end();
    }

    private static void addNode(Document document, Object object, ParseTreeNode[] parseTreeNodeArray, int n, int n2, Annotation annotation, String string) {
        if (object instanceof String) {
            Parsers.printParseTrace("Adding " + object, n, n2);
        } else {
            Parsers.printParseTrace("Adding " + object + " = " + document.text(new Span(n, n2)), n, n2);
        }
        ParseTreeNode parseTreeNode = new ParseTreeNode(object, parseTreeNodeArray, n, n2, annotation, string);
        chart.addElement(parseTreeNode);
        if (parserType == 3) {
            agenda.push(parseTreeNode);
        }
    }

    private static void extend(Document document, Production production, int n, int n2, ParseTreeNode[] parseTreeNodeArray, int n3) {
        if (n3 >= 0) {
            Object e = production.rhs.elementAt(n3);
            for (int i = 0; i < chart.size(); ++i) {
                ParseTreeNode parseTreeNode = (ParseTreeNode)chart.elementAt(i);
                if (parseTreeNode.category != e || parseTreeNode.end != n) continue;
                parseTreeNodeArray[n3] = parseTreeNode;
                Parsers.extend(document, production, parseTreeNode.start, n2, parseTreeNodeArray, n3 - 1);
            }
        } else {
            ParseTreeNode[] parseTreeNodeArray2 = (ParseTreeNode[])parseTreeNodeArray.clone();
            Parsers.addNode(document, production.lhs, parseTreeNodeArray2, n, n2, null, null);
        }
    }

    public static Vector chartParse(Document document, int n, int n2, Grammar grammar) {
        int n3 = n;
        agenda = new Stack();
        chart = new Vector();
        parses = new Vector();
        sought = new Hashtable();
        while (n >= 0 && n < n2) {
            n = Parsers.addLexicalNodes(document, n);
        }
        Parsers.seek(SENTENCE, n3, grammar);
        while (!agenda.empty()) {
            Edge edge = (Edge)agenda.pop();
            chart.addElement(edge);
            if (edge.end > edge.start) {
                Parsers.printParseTrace("Adding " + edge + " = " + document.text(new Span(edge.start, edge.end)), edge.start, edge.end);
            } else {
                Parsers.printParseTrace("Adding " + edge, edge.start, edge.end);
            }
            if (edge instanceof ParseTreeNode) {
                ParseTreeNode parseTreeNode = (ParseTreeNode)edge;
                if (parseTreeNode.category == SENTENCE && parseTreeNode.start == n3 && parseTreeNode.end == n2) {
                    parses.addElement(parseTreeNode);
                }
            }
            if (edge instanceof ActiveEdge) {
                Parsers.extendActiveEdge((ActiveEdge)edge, grammar);
                continue;
            }
            Parsers.extendInactiveEdge((ParseTreeNode)edge, grammar);
        }
        Console.println(parses.size() + " parse(s) obtained");
        return parses;
    }

    private static void seek(String string, int n, Grammar grammar) {
        Parsers.printParseTrace("Seeking " + string, n, 0);
        if (!sought.containsKey(string)) {
            sought.put(string, new Hashtable());
        }
        Hashtable hashtable = (Hashtable)sought.get(string);
        hashtable.put(new Integer(n), Boolean.TRUE);
        Vector vector = grammar.getProductions(string);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Production production = (Production)vector.elementAt(i);
                Vector vector2 = production.rhs();
                ActiveEdge activeEdge = new ActiveEdge(string, vector2, new ParseTreeNode[0], n, n);
                agenda.push(activeEdge);
            }
        }
    }

    private static boolean getSought(String string, int n) {
        Hashtable hashtable = (Hashtable)sought.get(string);
        if (hashtable == null) {
            return false;
        }
        return hashtable.containsKey(new Integer(n));
    }

    private static void extendActiveEdge(ActiveEdge activeEdge, Grammar grammar) {
        String string;
        String string2 = activeEdge.needs();
        int n = activeEdge.end;
        if (string2 instanceof String && grammar.defines(string = string2) && !Parsers.getSought(string, n)) {
            Parsers.seek(string, n, grammar);
            return;
        }
        for (int i = 0; i < chart.size(); ++i) {
            if (!(chart.elementAt(i) instanceof ParseTreeNode)) continue;
            ParseTreeNode parseTreeNode = (ParseTreeNode)chart.elementAt(i);
            if (parseTreeNode.start != n || parseTreeNode.category != string2) continue;
            Parsers.extendEdge(activeEdge, parseTreeNode, grammar);
        }
    }

    private static void extendInactiveEdge(ParseTreeNode parseTreeNode, Grammar grammar) {
        int n = parseTreeNode.start;
        for (int i = 0; i < chart.size(); ++i) {
            if (!(chart.elementAt(i) instanceof ActiveEdge)) continue;
            ActiveEdge activeEdge = (ActiveEdge)chart.elementAt(i);
            if (activeEdge.end != n || activeEdge.needs() != parseTreeNode.category) continue;
            Parsers.extendEdge(activeEdge, parseTreeNode, grammar);
        }
    }

    private static void extendEdge(ActiveEdge activeEdge, ParseTreeNode parseTreeNode, Grammar grammar) {
        if (parserTrace) {
            Console.println("Extending " + activeEdge + " with " + parseTreeNode);
        }
        ParseTreeNode[] parseTreeNodeArray = activeEdge.children;
        ParseTreeNode[] parseTreeNodeArray2 = new ParseTreeNode[parseTreeNodeArray.length + 1];
        for (int i = 0; i < parseTreeNodeArray.length; ++i) {
            parseTreeNodeArray2[i] = parseTreeNodeArray[i];
        }
        parseTreeNodeArray2[parseTreeNodeArray.length] = parseTreeNode;
        if (parseTreeNodeArray2.length == activeEdge.rhs.size()) {
            ParseTreeNode parseTreeNode2 = new ParseTreeNode(activeEdge.category, parseTreeNodeArray2, activeEdge.start, parseTreeNode.end, null, null);
            agenda.push(parseTreeNode2);
        } else {
            ActiveEdge activeEdge2 = new ActiveEdge(activeEdge.category, activeEdge.rhs, parseTreeNodeArray2, activeEdge.start, parseTreeNode.end);
            agenda.push(activeEdge2);
        }
    }

    private static void printParseTrace(String string, int n, int n2) {
        if (parserTrace) {
            int n3;
            StringBuffer stringBuffer;
            if (string.length() < 40) {
                stringBuffer = new StringBuffer(string);
                for (n3 = string.length(); n3 < 40; ++n3) {
                    stringBuffer.append(' ');
                }
            } else {
                Console.println(string);
                stringBuffer = new StringBuffer("                                        ");
            }
            for (n3 = 0; n3 < n; ++n3) {
                stringBuffer.append(' ');
            }
            if (n >= n2) {
                stringBuffer.append('+');
            } else {
                for (n3 = n; n3 < n2; ++n3) {
                    stringBuffer.append('=');
                }
            }
            Console.println(stringBuffer.toString());
        }
    }

    public static JMenu parserMenu() {
        JMenu jMenu = new JMenu("Parser");
        jMenu.setMnemonic(65);
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Use Recognizer");
        jRadioButtonMenuItem.setMnemonic(82);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                parserType = 1;
            }
        });
        jRadioButtonMenuItem.setSelected(true);
        jMenu.add(jRadioButtonMenuItem);
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Use Top-Down Parser");
        jRadioButtonMenuItem2.setMnemonic(84);
        jRadioButtonMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                parserType = 2;
            }
        });
        jMenu.add(jRadioButtonMenuItem2);
        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem("Use Bottom-Up Parser");
        jRadioButtonMenuItem3.setMnemonic(66);
        jRadioButtonMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                parserType = 3;
            }
        });
        jMenu.add(jRadioButtonMenuItem3);
        JRadioButtonMenuItem jRadioButtonMenuItem4 = new JRadioButtonMenuItem("Use Top-Down Chart Parser");
        jRadioButtonMenuItem4.setMnemonic(67);
        jRadioButtonMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                parserType = 4;
            }
        });
        jMenu.add(jRadioButtonMenuItem4);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem3);
        buttonGroup.add(jRadioButtonMenuItem4);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Parser Trace", parserTrace);
        jCheckBoxMenuItem.setMnemonic(65);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                parserTrace = jCheckBoxMenuItem.getState();
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        JMenuItem jMenuItem = new JMenuItem("Draw Tree");
        jMenuItem.setMnemonic(69);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!parses.isEmpty()) {
                    Object[] objectArray;
                    int n;
                    int n2 = parses.size();
                    if (n2 == 1) {
                        n = 0;
                    } else {
                        objectArray = new Integer[n2];
                        for (int i = 0; i < n2; ++i) {
                            objectArray[i] = new Integer(i + 1);
                        }
                        n = JOptionPane.showOptionDialog(null, "Draw which parse?", "Select a parse", -1, 3, null, objectArray, new Integer(1));
                    }
                    objectArray = (ParseTreeNode)parses.elementAt(n);
                    if (objectArray != null) {
                        new ParseView("Parse Tree " + (n + 1), objectArray.ann);
                    }
                }
            }
        });
        jMenu.add(jMenuItem);
        return jMenu;
    }
}

