/*
 * Decompiled with CFR 0.152.
 */
package Jet.HMM;

import AceJet.Ace;
import Jet.HMM.HMM;
import Jet.HMM.HMMemitter;
import Jet.Lisp.FeatureSet;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BigramHMMemitter
extends HMMemitter {
    private static final float VOCAB_SIZE = 5000.0f;
    public static boolean useBigrams = true;
    int count;
    HashMap tokenCount;
    HashMap tokenProbability;
    HashMap priorTokenCount;
    HashMap bigramCount;
    HashMap LCbigramCount;
    HashMap bigramProbability;
    HashMap LCtokenCount;
    HashMap LCtokenProbability;
    HashMap featureCount;
    HashMap featureProbability;
    HashMap cacheCount;
    double[] inCacheProbability;
    double[] notInCacheProbability;
    double discount;
    double unseenTokenProbability;

    public void resetForTraining() {
        this.count = 0;
        this.tokenCount = new HashMap();
        this.priorTokenCount = new HashMap();
        this.bigramCount = new HashMap();
        this.LCbigramCount = new HashMap();
        this.LCtokenCount = new HashMap();
        this.featureCount = new HashMap();
        this.cacheCount = new HashMap();
    }

    public void setCacheCount(String string, int n) {
        this.cacheCount.put(string, new Integer(n));
    }

    public void trainOnInstances(String string, String string2, int n) {
        this.count += n;
        if (Ace.monocase && (this.stateName.startsWith("b-") || this.stateName.startsWith("m-") || this.stateName.startsWith("e-") || this.stateName.startsWith("i-"))) {
            string = this.capitalize(string);
        }
        BigramHMMemitter.incrementHashMap(this.tokenCount, string, n);
        BigramHMMemitter.incrementHashMap(this.priorTokenCount, string2.toLowerCase(), n);
        BigramHMMemitter.incrementTwoLevelHashMap(this.bigramCount, string2, string, n);
        BigramHMMemitter.incrementTwoLevelHashMap(this.LCbigramCount, string2.toLowerCase(), string.toLowerCase(), n);
        BigramHMMemitter.incrementHashMap(this.LCtokenCount, string.toLowerCase(), n);
        BigramHMMemitter.incrementHashMap(this.featureCount, BigramHMMemitter.wordFeature(string), n);
        if (this.hmm.tagsToCache != null) {
            for (int i = 0; i < this.hmm.tagsToCache.length; ++i) {
                if (!this.hmm.inCache(string, this.hmm.tagsToCache[i])) continue;
                BigramHMMemitter.incrementHashMap(this.cacheCount, this.hmm.tagsToCache[i], 1);
            }
        }
    }

    private String capitalize(String string) {
        if (Character.isLowerCase(string.charAt(0))) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public void computeProbabilities() {
        Integer n;
        Object object;
        Iterator iterator;
        Object object2;
        this.tokenProbability = new HashMap();
        int n2 = 0;
        Iterator iterator2 = this.tokenCount.entrySet().iterator();
        while (iterator2.hasNext()) {
            object2 = iterator2.next();
            iterator = (String)object2.getKey();
            int n3 = (Integer)object2.getValue();
            double d = (double)n3 / (double)this.count;
            this.tokenProbability.put(iterator, new Double(d));
            if (n3 != 1) continue;
            ++n2;
        }
        this.bigramProbability = new HashMap();
        object2 = this.LCbigramCount.entrySet().iterator();
        while (object2.hasNext()) {
            iterator = (Map.Entry)object2.next();
            String string = (String)iterator.getKey();
            int n4 = (Integer)this.priorTokenCount.get(string);
            HashMap hashMap = (HashMap)iterator.getValue();
            HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
            Iterator iterator3 = hashMap.entrySet().iterator();
            while (iterator3.hasNext()) {
                object = iterator3.next();
                String string2 = (String)object.getKey();
                int n5 = (Integer)object.getValue();
                double d = (double)n5 / (double)n4;
                hashMap2.put(string2, new Double(d));
            }
            this.bigramProbability.put(string, hashMap2);
        }
        this.LCtokenProbability = new HashMap();
        iterator = this.LCtokenCount.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            int n6 = (Integer)entry.getValue();
            double d = (double)n6 / (double)this.count;
            this.LCtokenProbability.put(string, new Double(d));
        }
        this.featureProbability = new HashMap();
        Iterator iterator4 = this.featureCount.entrySet().iterator();
        while (iterator4.hasNext()) {
            Map.Entry entry = iterator4.next();
            String string = (String)entry.getKey();
            int n7 = (Integer)entry.getValue();
            double d = Math.log((double)n7 / (double)this.count);
            this.featureProbability.put(string, new Double(d));
        }
        Integer n8 = (Integer)this.featureCount.get("initCap");
        int n9 = (n8 == null ? 0 : n8) + ((n = (Integer)this.featureCount.get("lowerCase")) == null ? 0 : n);
        if (n9 != 0) {
            double d = Math.log((double)n9 / (double)this.count);
            this.featureProbability.put("forcedCap", new Double(d));
        }
        this.unseenTokenProbability = Math.log((double)n2 / (double)this.count / 5000.0);
        if (this.hmm.tagsToCache != null) {
            this.inCacheProbability = new double[this.hmm.tagsToCache.length];
            this.notInCacheProbability = new double[this.hmm.tagsToCache.length];
            if (HMM.probReport) {
                System.out.println("For state " + this.stateName);
            }
            for (int i = 0; i < this.hmm.tagsToCache.length; ++i) {
                int n10;
                object = (Integer)this.cacheCount.get(this.hmm.tagsToCache[i]);
                int n11 = n10 = object == null ? 0 : (Integer)object;
                if (HMM.probReport) {
                    System.out.println("Cache count[" + this.hmm.tagsToCache[i] + "]=" + n10);
                    System.out.println("inCacheProbability[" + this.hmm.tagsToCache[i] + "]=" + (double)n10 / (double)this.count);
                }
                this.inCacheProbability[i] = Math.log((double)n10 / (double)this.count);
                this.notInCacheProbability[i] = Math.log(1.0 - (double)n10 / (double)this.count);
            }
        }
    }

    public double getProbability(String string, String string2, FeatureSet featureSet) {
        Object object;
        double d;
        Double d2;
        int n;
        double d3 = -8.0;
        boolean bl = featureSet.get("case") == "forcedCap";
        double d4 = 0.0;
        double d5 = 0.0;
        HashMap hashMap = (HashMap)this.bigramProbability.get(string2 = string2.toLowerCase());
        if (hashMap != null) {
            Double d6 = (Double)hashMap.get(string.toLowerCase());
            if (d6 != null) {
                d4 = d6;
            }
            d5 = hashMap.size();
        }
        double d7 = 0.0;
        if (useBigrams && this.priorTokenCount.get(string2) != null) {
            n = (Integer)this.priorTokenCount.get(string2);
            if ((this.stateName.startsWith("m-") || this.stateName.startsWith("e-")) & d4 > 0.0) {
                d7 = 1.0 / (1.0 + d5 / (double)n);
            }
        }
        if ((d2 = bl || Ace.monocase ? (Double)this.LCtokenProbability.get(string.toLowerCase()) : (Double)this.tokenProbability.get(string)) != null) {
            d = d7 * d4 + (1.0 - d7) * d2;
            d = Math.log(d);
        } else {
            String string3 = BigramHMMemitter.wordFeature(string);
            if (bl && string3 == "initCap" || Ace.monocase) {
                string3 = "forcedCap";
            }
            d = (object = (Double)this.featureProbability.get(string3)) != null ? this.unseenTokenProbability + (Double)object : this.unseenTokenProbability + d3;
        }
        if (this.hmm.tagsToCache != null) {
            for (n = 0; n < this.hmm.tagsToCache.length; ++n) {
                object = this.hmm.tagsToCache[n];
                boolean bl2 = this.hmm.inCache(string, (String)object);
                if (bl2) {
                    d += this.inCacheProbability[n];
                    continue;
                }
                d += this.notInCacheProbability[n];
            }
        }
        return d;
    }

    public void print() {
        Iterator iterator = this.bigramCount.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            HashMap hashMap = (HashMap)entry.getValue();
            Iterator iterator2 = hashMap.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = iterator2.next();
                String string2 = (String)entry2.getKey();
                int n = (Integer)entry2.getValue();
                System.out.println("EMIT " + string + " " + string2 + " " + n);
            }
        }
    }

    public void store(PrintWriter printWriter) {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator = this.bigramCount.entrySet().iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            object2 = (String)object3.getKey();
            object = (HashMap)object3.getValue();
            Iterator iterator2 = ((HashMap)object).entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                String string = (String)entry.getKey();
                int n = (Integer)entry.getValue();
                printWriter.println("EMIT " + (String)object2 + " " + string + " " + n);
            }
        }
        object3 = this.cacheCount.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = (Map.Entry)object3.next();
            object = (String)object2.getKey();
            int n = (Integer)object2.getValue();
            printWriter.println("PREVTAGGED " + (String)object + " " + n);
        }
    }

    static String wordFeature(String string) {
        int n = string.length();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) {
                bl = false;
            }
            if (!Character.isUpperCase(c)) {
                bl2 = false;
            }
            if (!Character.isLowerCase(c)) {
                bl4 = false;
            }
            if (!Character.isLetter(c) && c != '-') {
                bl5 = false;
            }
            if ((i != 0 || Character.isUpperCase(c)) && (i <= 0 || Character.isLowerCase(c))) continue;
            bl3 = false;
        }
        if (bl) {
            if (n == 2) {
                return "twoDigitNum";
            }
            if (n == 4) {
                return "fourDigitNum";
            }
            return "otherNum";
        }
        if (bl2) {
            return "allCaps";
        }
        if (bl3) {
            return "initCap";
        }
        if (bl4) {
            return "lowerCase";
        }
        if (bl5) {
            return "hyphenated";
        }
        return "other";
    }

    private static void incrementHashMap(HashMap hashMap, String string, int n) {
        Integer n2 = (Integer)hashMap.get(string);
        int n3 = n2 == null ? 0 : n2;
        hashMap.put(string, new Integer(n3 + n));
    }

    private static void incrementTwoLevelHashMap(HashMap hashMap, String string, String string2, int n) {
        HashMap hashMap2 = (HashMap)hashMap.get(string);
        if (hashMap2 == null) {
            hashMap2 = new HashMap();
            hashMap.put(string, hashMap2);
        }
        BigramHMMemitter.incrementHashMap(hashMap2, string2, n);
    }
}

