/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class WordSenseData {
    static final String[] EDT_TYPES = new String[]{"OTHER", "PERSON", "ORGANIZATION", "GPE", "LOCATION", "FACILITY"};
    static final int numTypes = 6;
    String word;
    String uniqueType;
    int count;
    int[] typeCount;
    HashMap[] typeContext;
    int ccount = 0;
    int ucount = 0;

    WordSenseData(String string) {
        this.word = string;
        this.typeCount = new int[6];
        this.typeContext = new HashMap[6];
    }

    void write(PrintStream printStream) {
        printStream.println("WORD " + this.word);
        printStream.println("COUNT " + this.count);
        this.checkForUniqueType();
        if (this.uniqueType != null) {
            printStream.println("TYPE " + this.uniqueType);
        } else {
            for (int i = 0; i < 6; ++i) {
                printStream.println("COUNT " + EDT_TYPES[i] + " " + this.typeCount[i]);
                if (this.typeContext[i] == null) continue;
                Iterator iterator = this.typeContext[i].keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    int n = (Integer)this.typeContext[i].get(string);
                    printStream.println("CONTEXT " + EDT_TYPES[i] + " " + string + " " + n);
                }
            }
        }
        printStream.println("END");
    }

    void incrementTypeCount(String string) {
        int n;
        ++this.count;
        int n2 = n = WordSenseData.typeIndex(string);
        this.typeCount[n2] = this.typeCount[n2] + 1;
    }

    void incrementContextCount(String string, String string2) {
        Integer n;
        int n2 = WordSenseData.typeIndex(string);
        if (this.typeContext[n2] == null) {
            this.typeContext[n2] = new HashMap();
        }
        int n3 = (n = (Integer)this.typeContext[n2].get(string2)) == null ? 0 : n;
        this.typeContext[n2].put(string2, new Integer(n3 + 1));
        if (string2 == "COUNTABLE") {
            ++this.ccount;
        } else {
            ++this.ucount;
        }
    }

    private static int typeIndex(String string) {
        for (int i = 0; i < 6; ++i) {
            if (!string.equals(EDT_TYPES[i])) continue;
            return i;
        }
        System.out.println("typeIndex:  unexpected type " + string);
        return 0;
    }

    private void checkForUniqueType() {
        String string = null;
        for (int i = 0; i < 6; ++i) {
            if (this.typeCount[i] <= 0) continue;
            if (string == null) {
                string = EDT_TYPES[i];
                continue;
            }
            return;
        }
        this.uniqueType = string;
    }

    int decodeType(ArrayList arrayList) {
        String string = (String)arrayList.get(0);
        int n = string == "COUNTABLE" ? this.ccount : this.ucount;
        double d = -1.0;
        int n2 = -1;
        for (int i = 0; i < 6; ++i) {
            double d2 = (double)this.typeCount[i] / (double)this.count;
            for (int j = 0; j < arrayList.size(); ++j) {
                String string2 = (String)arrayList.get(j);
                int n3 = 0;
                if (this.typeContext[i] != null) {
                    Integer n4 = (Integer)this.typeContext[i].get(string2);
                    int n5 = n3 = n4 == null ? 0 : n4;
                }
                if (n <= 5) continue;
                d2 = (double)n3 / (double)this.count;
            }
            if (!(d2 > d)) continue;
            d = d2;
            n2 = i;
        }
        return n2;
    }
}

