/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEntityMention;
import AceJet.AceRelation;
import AceJet.AceRelationMention;
import AceJet.Mention;
import AceJet.RelationMention;
import AceJet.RelationPattern;
import Jet.Control;
import Jet.Lex.Tokenizer;
import Jet.Lisp.FeatureSet;
import Jet.Parser.StatParser;
import Jet.Parser.SynFun;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import Jet.Tipster.View;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public class LearnRelations {
    static final boolean useParser = true;
    static final boolean useParseCollection = true;
    static ExternalDocument doc;
    static String currentDoc;
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String[] relations;
    static final String rootDir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/relations/";
    static final String patternFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/relations/patterns04.log";
    static HashMap mentionIDMap;
    static HashMap mentionStartMap;
    static TreeSet mentionSet;
    static TreeSet allMentionSet;
    static ArrayList relMentionList;
    static ArrayList candidates;
    static ArrayList relationList;
    static TreeMap patternSet;
    static PrintStream writer;
    static String docName;
    static boolean writingRelations;
    static final boolean expandConjuncts = true;
    private static final int mentionWindow = 3;
    private static final int maxPatternLength = 100;
    static HashMap categoryRankTable;
    static HashMap standardType;

    public static void main(String[] stringArray) throws IOException {
    }

    static void learnFromFileList(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n = 0;
        while ((currentDoc = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++n + ": " + currentDoc);
            String string2 = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/parses/" + currentDoc + ".sgm";
            doc = new ExternalDocument("sgml", string2);
            doc.setAllTags(true);
            doc.open();
            Ace.monocase = Ace.allLowerCase(doc);
            System.out.println(">>> Monocase is " + Ace.monocase);
            Control.processDocument(doc, null, n < 0, n);
            if (n < 3) {
                new View(doc, n);
            }
            LearnRelations.readACErelations(string2, ACEdir + currentDoc + ".apf.xml");
            candidates = new ArrayList();
            LearnRelations.findSyntacticPatterns(doc);
            LearnRelations.findAdjacencyPatterns();
            LearnRelations.processCandidates();
            LearnRelations.processLeftovers();
        }
    }

    static void findAndWriteRelations(String string, ExternalDocument externalDocument, AceDocument aceDocument) {
        doc = externalDocument;
        docName = string;
        candidates = new ArrayList();
        LearnRelations.findConjuncts(doc);
        LearnRelations.findSyntacticPatterns(doc);
        LearnRelations.findAdjacencyPatterns();
        LearnRelations.predictRelations();
        LearnRelations.relationCoref(aceDocument);
    }

    private static void findSyntacticPatterns(ExternalDocument externalDocument) {
        Vector vector = externalDocument.annotationsOfType("constit");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Annotation[] annotationArray;
                Annotation annotation;
                Object object;
                Annotation annotation2 = (Annotation)vector.elementAt(i);
                for (int j = 0; j < relations.length; ++j) {
                    object = relations[j];
                    if (annotation2.get((String)object) == null) continue;
                    annotation = (Annotation)annotation2.get((String)object);
                    LearnRelations.checkSyntacticRelation(annotation2, (String)object, annotation);
                }
                String string = SynFun.getImmediateHead(annotation2);
                if (string == null) continue;
                object = (Annotation)annotation2.get("subject");
                annotation = (Annotation)annotation2.get("object");
                Annotation annotation3 = (Annotation)annotation2.get("pp");
                if (object != null && annotation != null) {
                    LearnRelations.checkSyntacticRelation((Annotation)object, string, annotation);
                }
                if (annotation3 == null || !((annotationArray = StatParser.children(annotation3)) != null & annotationArray.length == 2)) continue;
                Annotation annotation4 = annotationArray[0];
                Annotation annotation5 = annotationArray[1];
                String string2 = SynFun.getHead(externalDocument, annotation4);
                if (object != null) {
                    LearnRelations.checkSyntacticRelation((Annotation)object, "s-" + string + "-" + string2, annotation5);
                }
                if (annotation == null) continue;
                LearnRelations.checkSyntacticRelation(annotation, "o-" + string + "-" + string2, annotation5);
            }
        }
    }

    private static void checkSyntacticRelation(Annotation annotation, String string, Annotation annotation2) {
        Annotation annotation3 = Resolve.getHeadC(annotation);
        Span span = annotation3.span();
        int n = span.start();
        Mention mention = (Mention)mentionStartMap.get(new Integer(n));
        if (mention == null) {
            return;
        }
        Annotation annotation4 = Resolve.getHeadC(annotation2);
        Span span2 = annotation4.span();
        int n2 = span2.start();
        Mention mention2 = (Mention)mentionStartMap.get(new Integer(n2));
        if (mention2 == null) {
            return;
        }
        if (mention.entityID.equals(mention2.entityID)) {
            return;
        }
        if (mention.compareTo(mention2) < 0) {
            ArrayList arrayList = LearnRelations.recordCandidateWithConjuncts(mention, mention2);
            LearnRelations.recordSyntacticLink(arrayList, string);
        } else {
            ArrayList arrayList = LearnRelations.recordCandidateWithConjuncts(mention2, mention);
            LearnRelations.recordSyntacticLink(arrayList, string + "-1");
        }
    }

    private static void findAdjacencyPatterns() {
        if (mentionSet.isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList(mentionSet);
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            for (int j = 1; j <= 3 && i + j < arrayList.size(); ++j) {
                ArrayList arrayList2;
                Mention mention = (Mention)arrayList.get(i);
                Mention mention2 = (Mention)arrayList.get(i + j);
                if (mention.entityID.equals(mention2.entityID) || (arrayList2 = LearnRelations.patternBetweenMentions(mention, mention2)) == null || arrayList2.size() > 100) continue;
                ArrayList arrayList3 = LearnRelations.recordCandidateWithConjuncts(mention, mention2);
                LearnRelations.recordLinearLink(arrayList3, arrayList2);
            }
        }
    }

    private static RelationMention recordCandidate(Mention mention, Mention mention2) {
        for (int i = 0; i < candidates.size(); ++i) {
            RelationMention relationMention = (RelationMention)candidates.get(i);
            if (relationMention.mention1 != mention || relationMention.mention2 != mention2) continue;
            return relationMention;
        }
        RelationMention relationMention = new RelationMention(mention, mention2);
        candidates.add(relationMention);
        return relationMention;
    }

    private static void processCandidates() {
        for (int i = 0; i < candidates.size(); ++i) {
            RelationMention relationMention = (RelationMention)candidates.get(i);
            Mention mention = relationMention.mention1;
            Mention mention2 = relationMention.mention2;
            if (mention.generic || mention2.generic) continue;
            String string = mention.subtype.equals("") ? "*" : mention.subtype;
            String string2 = mention2.subtype.equals("") ? "*" : mention2.subtype;
            String string3 = "arg1-arg2 " + mention.type + " " + string + " " + LearnRelations.getHead(mention) + " [ " + relationMention.syntacticLink + " : " + LearnRelations.concat(relationMention.linearLink) + " ] " + mention2.type + " " + string2 + " " + LearnRelations.getHead(mention2);
            LearnRelations.checkRelation(mention, string3, mention2);
        }
    }

    private static void checkRelation(Mention mention, String string, Mention mention2) {
        if (mention.entityID.equals(mention2.entityID)) {
            return;
        }
        System.out.println("For " + doc.text(mention.headSpan) + " and " + doc.text(mention2.headSpan));
        boolean bl = false;
        for (int i = 0; i < relMentionList.size(); ++i) {
            RelationMention relationMention = (RelationMention)relMentionList.get(i);
            if (relationMention.mention1.equals(mention) && relationMention.mention2.equals(mention2)) {
                LearnRelations.recordPattern(string + " --> " + relationMention.relationType + " " + relationMention.relationSubtype);
                relationMention.setAnalyzed();
                bl = true;
                continue;
            }
            if (!relationMention.mention1.equals(mention2) || !relationMention.mention2.equals(mention)) continue;
            String string2 = string.substring(0, 9);
            string = string2.equals("arg1-arg2") ? "arg2-arg1" + string.substring(9) : "arg1-arg2" + string.substring(9);
            LearnRelations.recordPattern(string + " --> " + relationMention.relationType + " " + relationMention.relationSubtype);
            relationMention.setAnalyzed();
            bl = true;
        }
        if (!bl) {
            LearnRelations.recordPattern(string + " --> 0");
        }
    }

    private static void processLeftovers() {
        for (int i = 0; i < relMentionList.size(); ++i) {
            String string;
            String string2;
            RelationMention relationMention = (RelationMention)relMentionList.get(i);
            if (relationMention.analyzed) continue;
            Mention mention = relationMention.mention1;
            Mention mention2 = relationMention.mention2;
            String string3 = mention.subtype.equals("") ? "*" : mention.subtype;
            String string4 = string2 = mention2.subtype.equals("") ? "*" : mention2.subtype;
            if (mention.compareTo(mention2) < 0) {
                string = "arg1-arg2 " + mention.type + " " + string3 + " " + LearnRelations.getHead(mention) + " [ " + "0 : " + LearnRelations.concat(LearnRelations.patternBetweenMentions(mention, mention2)) + " ] " + mention2.type + " " + string2 + " " + LearnRelations.getHead(mention2);
            } else if (mention.compareTo(mention2) > 0) {
                string = "arg2-arg1 " + mention2.type + " " + string2 + " " + LearnRelations.getHead(mention2) + " [ " + "0 : " + LearnRelations.concat(LearnRelations.patternBetweenMentions(mention2, mention)) + " ] " + mention.type + " " + string3 + " " + LearnRelations.getHead(mention);
            } else {
                System.out.println("*** Relation with two identical arguments -- ignored.");
                return;
            }
            System.out.println("Leftover -- for " + doc.text(mention.headSpan) + " and " + doc.text(mention2.headSpan));
            LearnRelations.recordPattern(string + " --> " + relationMention.relationType + " " + relationMention.relationSubtype);
        }
    }

    private static ArrayList patternBetweenMentions(Mention mention, Mention mention2) {
        ArrayList arrayList = mention.extent.start() <= mention2.extent.start() && mention.extent.end() >= mention2.extent.end() ? LearnRelations.patternBetweenSpans(mention, mention2, mention.headSpan, mention2.extent) : (mention2.extent.start() <= mention.extent.start() && mention2.extent.end() >= mention.extent.end() ? LearnRelations.patternBetweenSpans(mention, mention2, mention.extent, mention2.headSpan) : LearnRelations.patternBetweenSpans(mention, mention2, mention.extent, mention2.extent));
        return arrayList;
    }

    private static ArrayList patternBetweenSpans(Mention mention, Mention mention2, Span span, Span span2) {
        ArrayList arrayList = null;
        if (span.start() < span2.start()) {
            arrayList = LearnRelations.buildPattern(span.end(), span2.start());
        } else {
            System.out.println("*** Unexpected span order.");
            System.out.println("Span1 = " + doc.text(span));
            System.out.println("Span2 = " + doc.text(span2));
            arrayList = null;
        }
        return arrayList;
    }

    private static ArrayList buildPattern(int n, int n2) {
        int n3 = Tokenizer.skipWS(doc, n, doc.length());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (n3 < n2) {
            Object object;
            Vector vector = doc.annotationsAt(n3, "constit");
            if (vector != null) {
                Object object2;
                object = null;
                int n4 = -1;
                int n5 = -1;
                for (int i = 0; i < vector.size(); ++i) {
                    object2 = (Annotation)vector.get(i);
                    String string = (String)((Annotation)object2).get("cat");
                    int n6 = ((Annotation)object2).span().end();
                    if (n6 <= n4 && (n6 != n4 || LearnRelations.categoryRank(string) <= n5) || n6 > n2) continue;
                    n4 = ((Annotation)object2).span().end();
                    object = object2;
                    n5 = LearnRelations.categoryRank(string);
                }
                if (object == null) {
                    return null;
                }
                String string = (String)((Annotation)object).get("cat");
                if (string.equals(".")) {
                    return null;
                }
                object2 = string == "adv" || string == "timex" || string == "q" ? string + "(" + SynFun.getHead(doc, (Annotation)object) + ")" : SynFun.getHead(doc, (Annotation)object);
                if (writingRelations || !RelationPattern.noiseToken((String)object2)) {
                    arrayList.add(object2);
                }
                n3 = n4;
                continue;
            }
            Annotation annotation = doc.tokenAt(n3);
            if (annotation != null) {
                object = doc.text(annotation).trim();
                if (((String)object).equals(".")) {
                    return null;
                }
                arrayList.add(object);
                n3 = annotation.span().end();
                continue;
            }
            System.out.println("buildPattern:  no constits at position " + n3);
            return null;
        }
        return arrayList;
    }

    static int categoryRank(String string) {
        Integer n = (Integer)categoryRankTable.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    static String concat(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer((String)arrayList.get(0));
        for (int i = 1; i < arrayList.size(); ++i) {
            stringBuffer.append(" ");
            stringBuffer.append((String)arrayList.get(i));
        }
        return stringBuffer.toString();
    }

    static String getHead(Mention mention) {
        Vector vector = doc.annotationsAt(mention.headSpan.start(), "constit");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string;
                String[] stringArray;
                Annotation annotation = (Annotation)vector.get(i);
                String string2 = (String)annotation.get("cat");
                if (string2 != "n" && string2 != "pro" && string2 != "name" && string2 != "adj" && string2 != "ven" && (string2 != "det" || annotation.get("tposs") != "t")) continue;
                if (string2 == "name") {
                    stringArray = Resolve.getNameTokens(doc, annotation);
                    if (Ace.gazetteer.isCountry(stringArray)) {
                        return "country";
                    }
                    if (Ace.gazetteer.isNationality(stringArray)) {
                        return "nationality";
                    }
                }
                if ((stringArray = (FeatureSet)annotation.get("pa")) == null || (string = (String)stringArray.get("head")) == null) continue;
                return string;
            }
        }
        return doc.text(mention.headSpan).trim().replace(' ', '-').replace('\n', '-');
    }

    static void findConjuncts(ExternalDocument externalDocument) {
        Vector vector = externalDocument.annotationsOfType("constit");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Annotation annotation = (Annotation)vector.elementAt(i);
                Annotation annotation2 = (Annotation)annotation.get("conj");
                if (annotation2 == null) continue;
                ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
                arrayList.add(annotation);
                while (annotation2 != null) {
                    arrayList.add(annotation2);
                    annotation2 = (Annotation)annotation2.get("conj");
                }
                LearnRelations.recordConjunct(arrayList);
            }
        }
    }

    static void recordConjunct(ArrayList arrayList) {
        Object object;
        int n;
        String string = "";
        ArrayList<Mention> arrayList2 = new ArrayList<Mention>();
        for (n = 0; n < arrayList.size(); ++n) {
            object = (Annotation)arrayList.get(n);
            Mention mention = LearnRelations.mentionForAnnotation((Annotation)object);
            if (mention == null) {
                return;
            }
            arrayList2.add(mention);
            if (n == 0) {
                string = mention.type;
                continue;
            }
            if (string.equals(mention.type)) continue;
            return;
        }
        for (n = 0; n < arrayList2.size() - 1; ++n) {
            Mention mention;
            object = (Mention)arrayList2.get(n);
            ((Mention)object).conjunctf = mention = (Mention)arrayList2.get(n + 1);
            mention.conjunctb = object;
            System.out.println("Found conjuncts " + doc.text(((Mention)object).headSpan) + " and " + doc.text(mention.headSpan));
        }
    }

    static Mention mentionForAnnotation(Annotation annotation) {
        Annotation annotation2 = Resolve.getHeadC(annotation);
        Span span = annotation2.span();
        int n = span.start();
        return (Mention)mentionStartMap.get(new Integer(n));
    }

    static ArrayList getConjuncts(Mention mention) {
        ArrayList<Mention> arrayList = new ArrayList<Mention>();
        arrayList.add(mention);
        Mention mention2 = mention;
        while (mention2.conjunctf != null) {
            mention2 = mention2.conjunctf;
            arrayList.add(mention2);
        }
        mention2 = mention;
        while (mention2.conjunctb != null) {
            mention2 = mention2.conjunctb;
            arrayList.add(mention2);
        }
        return arrayList;
    }

    static ArrayList recordCandidateWithConjuncts(Mention mention, Mention mention2) {
        ArrayList<RelationMention> arrayList = new ArrayList<RelationMention>();
        if (mention.extent.end() < mention2.extent.start() || mention2.extent.end() < mention.extent.start()) {
            ArrayList arrayList2 = LearnRelations.getConjuncts(mention);
            ArrayList arrayList3 = LearnRelations.getConjuncts(mention2);
            if (arrayList2.contains(mention2)) {
                return arrayList;
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                for (int j = 0; j < arrayList3.size(); ++j) {
                    Mention mention3 = (Mention)arrayList2.get(i);
                    Mention mention4 = (Mention)arrayList3.get(j);
                    RelationMention relationMention = LearnRelations.recordCandidate(mention3, mention4);
                    arrayList.add(relationMention);
                }
            }
        } else {
            RelationMention relationMention = LearnRelations.recordCandidate(mention, mention2);
            arrayList.add(relationMention);
        }
        return arrayList;
    }

    static void recordSyntacticLink(ArrayList arrayList, String string) {
        for (int i = 0; i < arrayList.size(); ++i) {
            RelationMention relationMention = (RelationMention)arrayList.get(i);
            relationMention.syntacticLink = string;
        }
    }

    static void recordLinearLink(ArrayList arrayList, ArrayList arrayList2) {
        for (int i = 0; i < arrayList.size(); ++i) {
            RelationMention relationMention = (RelationMention)arrayList.get(i);
            if (relationMention.linearLink.size() <= arrayList2.size() && (relationMention.linearLink.size() <= 0 || !relationMention.linearLink.get(0).equals("0"))) continue;
            relationMention.linearLink = arrayList2;
        }
    }

    private static void readACErelations(String string, String string2) {
        AceDocument aceDocument = new AceDocument(string, string2);
        LearnRelations.findEntityMentions(aceDocument);
        LearnRelations.findRelationMentions(aceDocument);
    }

    static void findEntityMentions(AceDocument aceDocument) {
        LearnRelations.resetMentions();
        ArrayList arrayList = aceDocument.entities;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEntity aceEntity = (AceEntity)arrayList.get(i);
            String string = aceEntity.type;
            String string2 = aceEntity.subtype;
            if (standardType.containsKey(string)) {
                string = (String)standardType.get(string);
            }
            ArrayList arrayList2 = aceEntity.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEntityMention aceEntityMention = (AceEntityMention)arrayList2.get(j);
                Span span = LearnRelations.aceSpanToJetSpan(aceEntityMention.extent);
                Span span2 = LearnRelations.aceSpanToJetSpan(aceEntityMention.head);
                LearnRelations.addMention(string, string2, span, span2, aceEntityMention.id, aceEntity.id, aceEntity.generic);
            }
        }
    }

    static Span aceSpanToJetSpan(Span span) {
        int n = span.start();
        int n2 = span.end();
        int n3 = Tokenizer.skipWS(doc, n2 + 1, doc.length());
        Span span2 = new Span(n, n3);
        return span2;
    }

    static void resetMentions() {
        mentionStartMap = new HashMap();
        mentionIDMap = new HashMap();
        mentionSet = new TreeSet();
        allMentionSet = new TreeSet();
    }

    static void addMention(String string, String string2, Span span, Span span2, String string3, String string4, boolean bl) {
        Mention mention = new Mention(string, string2, span, span2, string3, string4);
        mention.generic = bl;
        if (!bl) {
            mentionSet.add(mention);
        }
        allMentionSet.add(mention);
        mentionStartMap.put(new Integer(span2.start()), mention);
        mentionIDMap.put(string3, mention);
    }

    private static void findRelationMentions(AceDocument aceDocument) {
        relMentionList = new ArrayList();
        ArrayList arrayList = aceDocument.relations;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceRelation aceRelation = (AceRelation)arrayList.get(i);
            String string = aceRelation.type;
            String string2 = aceRelation.subtype;
            String string3 = aceRelation.relClass;
            if (string3.equals("IMPLICIT")) continue;
            ArrayList arrayList2 = aceRelation.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceRelationMention aceRelationMention = (AceRelationMention)arrayList2.get(j);
                RelationMention relationMention = new RelationMention(string, string2);
                relMentionList.add(relationMention);
                Mention mention = (Mention)mentionIDMap.get(aceRelationMention.arg1.id);
                if (mention == null) {
                    System.out.println("Undefined mention " + aceRelationMention.arg1.id);
                } else {
                    relationMention.setArg(1, mention);
                }
                Mention mention2 = (Mention)mentionIDMap.get(aceRelationMention.arg2.id);
                if (mention2 == null) {
                    System.out.println("Undefined mention " + aceRelationMention.arg2.id);
                    continue;
                }
                relationMention.setArg(2, mention2);
            }
        }
    }

    private static void recordPattern(String string) {
        System.out.println(">> " + string);
        Integer n = (Integer)patternSet.get(string);
        int n2 = n == null ? 0 : n;
        patternSet.put(string, new Integer(n2 + 1));
        writer.println(string);
    }

    private static void reportPatterns() {
        Iterator iterator = patternSet.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = (Integer)patternSet.get(string);
            if (n <= 1) continue;
            System.out.println(n + "X: " + string);
        }
    }

    private static void predictRelations() {
        relMentionList = new ArrayList();
        for (int i = 0; i < candidates.size(); ++i) {
            RelationMention relationMention = (RelationMention)candidates.get(i);
            System.out.println("For relation mention " + i + " = " + relationMention);
            if (relationMention.mention1.generic || relationMention.mention2.generic) {
                System.out.println(" mention is generic -- suppressed");
                continue;
            }
            Object var2_2 = null;
            RelationPattern relationPattern = Ace.eve.findMatch(relationMention, 21);
            Object var4_4 = null;
            String string = "0";
            String string2 = "";
            if (var2_2 != null) {
                string = var2_2.relationType;
                string2 = var2_2.relationSubtype;
                System.out.println("Best Adam pattern = " + var2_2.string);
            } else if (relationPattern != null) {
                System.out.println("Best corpus pattern = " + relationPattern.string);
                string = relationPattern.relationType;
                string2 = relationPattern.relationSubtype;
            } else if (var4_4 != null) {
                System.out.println("Best general pattern = " + var4_4.string);
                string = var4_4.relationType;
                string2 = var4_4.relationSubtype;
            }
            if (!string.equals("0")) {
                if (string.endsWith("-1")) {
                    relationMention.swapArgs();
                    string = string.substring(0, string.length() - 2);
                }
                relationMention.relationType = string;
                relationMention.relationSubtype = string2;
                relMentionList.add(relationMention);
                relationMention.id = relMentionList.size() + "";
            }
            System.out.println("     Predicting ACE relation " + string);
        }
    }

    private static String[] buildPredictFeatures(RelationMention relationMention) {
        String[] stringArray = new String[7];
        stringArray[0] = "mType1=" + relationMention.mention1.type;
        stringArray[1] = "mType2=" + relationMention.mention2.type;
        stringArray[2] = "mHead1=" + LearnRelations.getHead(relationMention.mention1);
        stringArray[3] = "mHead2=" + LearnRelations.getHead(relationMention.mention2);
        stringArray[4] = "synLink=" + relationMention.syntacticLink;
        ArrayList arrayList = relationMention.linearLink;
        stringArray[5] = "nConstit=" + arrayList.size();
        stringArray[6] = arrayList.size() > 0 ? "lastConstit=" + arrayList.get(arrayList.size() - 1) : " ";
        return stringArray;
    }

    private static void relationCoref(AceDocument aceDocument) {
        relationList = new ArrayList();
        System.out.println("RelationCoref: " + relMentionList.size() + " relation mentions");
        block0: for (int i = 0; i < relMentionList.size(); ++i) {
            AceRelation aceRelation;
            RelationMention relationMention = (RelationMention)relMentionList.get(i);
            String string = relationMention.mention1.entityID;
            String string2 = relationMention.mention2.entityID;
            for (int j = 0; j < relationList.size(); ++j) {
                aceRelation = (AceRelation)relationList.get(j);
                if (string != aceRelation.arg1.id || string2 != aceRelation.arg2.id) continue;
                aceRelation.addMention(relationMention.toAce(aceDocument));
                continue block0;
            }
            String string3 = docName + "-R" + (relationList.size() + 1);
            aceRelation = new AceRelation(string3, relationMention.relationType, relationMention.relationSubtype, "EXPLICIT", aceDocument.findEntity(string), aceDocument.findEntity(string2));
            aceRelation.addMention(relationMention.toAce(aceDocument));
            relationList.add(aceRelation);
            aceDocument.addRelation(aceRelation);
        }
        System.out.println("RelationCoref: " + relationList.size() + " relations");
    }

    static {
        relations = new String[]{"of", "poss", "nameMod"};
        patternSet = new TreeMap();
        writingRelations = false;
        categoryRankTable = new HashMap();
        categoryRankTable.put("name", new Integer(1));
        categoryRankTable.put("timex", new Integer(1));
        categoryRankTable.put("np", new Integer(2));
        categoryRankTable.put("np-pro", new Integer(2));
        categoryRankTable.put("vgroup", new Integer(2));
        categoryRankTable.put("vgroup-inf", new Integer(2));
        categoryRankTable.put("vgroup-pass", new Integer(2));
        categoryRankTable.put("vgroup-ving", new Integer(2));
        categoryRankTable.put("vgroup-ven", new Integer(2));
        categoryRankTable.put("vp", new Integer(3));
        categoryRankTable.put("vp-inf", new Integer(3));
        categoryRankTable.put("vingo", new Integer(3));
        categoryRankTable.put("s", new Integer(4));
        standardType = new HashMap();
        standardType.put("GSP", "GPE");
        standardType.put("PER", "PERSON");
        standardType.put("ORG", "ORGANIZATION");
        standardType.put("LOC", "LOCATION");
        standardType.put("FAC", "FACILITY");
    }
}

