/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.RelationInstance;
import AceJet.RelationPattern;
import AceJet.RelationPatternSet;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class BuildRelationModel {
    static RelationPattern relPat;
    static StringBuffer features;
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String rootDir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/relations/";
    static final String testPatternFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/relations/patterns.log";
    static final String patternFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/relations/patterns.log";
    static final String handPatternFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/lisp/patterns.log";
    static final String generalPatternFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/lisp/generalPatterns.log";
    static RelationPatternSet adam;
    static RelationPatternSet eve;
    static RelationPatternSet general;
    static final int testCorpusSize = 2000;
    static final String[] typeSubtype;
    private static final int TYPELENGTH = 9;
    private static final int TOTAL = 0;
    static final int NO_RELATION = 1;
    private static final int N_SUBTYPES;
    private static int[] subtypeCount;
    private static int relationCount;
    private static int MAX_SIZE;
    private static int[] relationLengthCount;
    private static int[] lengthCount;
    private static HashMap[] nonFinalWordCount;
    private static HashMap[] finalWordCount;
    static final double NO_RELATION_BIAS = 0.2;
    static final double VOCAB_SIZE = 4000.0;
    static final boolean trace = false;
    private static double BETA;

    BuildRelationModel() {
    }

    public static void main(String[] stringArray) throws IOException {
        String string = RelationPattern.prepositionOfLink("s-verb-in");
        System.out.println(string);
        boolean bl = RelationPattern.matchingRelations("s-verb-in", "s-werb-in");
        System.out.println(bl);
    }

    static void buildProbModel(RelationPatternSet relationPatternSet) {
        for (int i = 0; i < N_SUBTYPES; ++i) {
            BuildRelationModel.nonFinalWordCount[i] = new HashMap();
            BuildRelationModel.finalWordCount[i] = new HashMap();
        }
        Iterator iterator = relationPatternSet.iterator();
        while (iterator.hasNext()) {
            ArrayList arrayList;
            int n;
            int n2;
            RelationPattern relationPattern = (RelationPattern)iterator.next();
            String string = relationPattern.relationType;
            String string2 = relationPattern.relationSubtype;
            if (string.equals("0")) {
                n2 = 1;
            } else {
                n2 = BuildRelationModel.typeSubtypeToIndex(string, string2);
                if (n2 < 0) {
                    System.out.println("*** unknown type/subtype" + string + ":" + string2);
                    continue;
                }
            }
            if ((n = (arrayList = relationPattern.linearLink).size()) <= 0 || n >= MAX_SIZE || arrayList.get(0).equals("0")) continue;
            if (!string.equals("0")) {
                ++relationCount;
                int n3 = n;
                relationLengthCount[n3] = relationLengthCount[n3] + 1;
            }
            int n4 = n;
            lengthCount[n4] = lengthCount[n4] + 1;
            subtypeCount[0] = subtypeCount[0] + 1;
            int n5 = n2;
            subtypeCount[n5] = subtypeCount[n5] + 1;
            for (int i = 0; i < n - 1; ++i) {
                BuildRelationModel.incrementHashMap(nonFinalWordCount[0], (String)arrayList.get(i), 1);
                BuildRelationModel.incrementHashMap(nonFinalWordCount[n2], (String)arrayList.get(i), 1);
            }
            BuildRelationModel.incrementHashMap(finalWordCount[0], (String)arrayList.get(n - 1), 1);
            BuildRelationModel.incrementHashMap(finalWordCount[n2], (String)arrayList.get(n - 1), 1);
        }
    }

    static int mostLikelySubtype(RelationInstance relationInstance) {
        String string = relationInstance.getType1();
        String string2 = relationInstance.getType2();
        int n = -1;
        double d = -1.0;
        for (int i = 1; i < N_SUBTYPES; ++i) {
            double d2 = BuildRelationModel.subtypeProb(i, relationInstance.linearLink);
            if (!(d2 > d)) continue;
            n = i;
            d = d2;
        }
        if (n > 0) {
            System.out.println(">>> Best stat. type = " + typeSubtype[n]);
        }
        return n;
    }

    private static double subtypeProb(int n, ArrayList arrayList) {
        int n2 = arrayList.size();
        if (n2 == 0 || n2 >= MAX_SIZE || arrayList.get(0).equals("0")) {
            return -1.0;
        }
        double d = 1.0;
        for (int i = 0; i < n2 - 1; ++i) {
            d *= BuildRelationModel.wordSubtypeProb(n, (String)arrayList.get(i), false);
        }
        d *= BuildRelationModel.wordSubtypeProb(n, (String)arrayList.get(n2 - 1), true);
        if (n == 1) {
            double d2 = 1.0 - (double)relationLengthCount[n2] / (double)lengthCount[n2];
            d *= d2 * 0.2;
        } else {
            double d3 = (double)subtypeCount[n] / (double)relationCount;
            double d4 = (double)relationLengthCount[n2] / (double)lengthCount[n2];
            d *= d3 * d4;
        }
        return d;
    }

    private static double wordSubtypeProb(int n, String string, boolean bl) {
        double d;
        int n2;
        Integer n3 = bl ? (Integer)finalWordCount[n].get(string) : (Integer)nonFinalWordCount[n].get(string);
        int n4 = n2 = n3 == null ? 0 : n3;
        if (n2 > 0) {
            d = (double)n2 / (double)subtypeCount[n];
        } else {
            n3 = bl ? (Integer)finalWordCount[0].get(string) : (Integer)nonFinalWordCount[0].get(string);
            n2 = n3 == null ? 0 : n3;
            d = n2 > 0 ? BETA * (double)n2 / (double)subtypeCount[0] : 2.5E-4;
        }
        return d;
    }

    private static int typeSubtypeToIndex(String string, String string2) {
        if (string.equals("0")) {
            return 1;
        }
        for (int i = 2; i < N_SUBTYPES; ++i) {
            String string3 = typeSubtype[i];
            String string4 = string3.substring(0, 9).trim();
            String string5 = string3.substring(10);
            if (!string.equals(string4) || !string2.equals(string5)) continue;
            return i;
        }
        return -1;
    }

    static void incrementHashMap(HashMap hashMap, String string, int n) {
        Integer n2 = (Integer)hashMap.get(string);
        int n3 = n2 == null ? 0 : n2;
        hashMap.put(string, new Integer(n3 + n));
    }

    private static void predict() throws IOException {
        String string;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        BufferedReader bufferedReader = new BufferedReader(new FileReader("C:/Documents and Settings/Ralph Grishman/My Documents/ACE/relations/patterns.log"));
        while ((string = bufferedReader.readLine()) != null && ++n <= 2000) {
            int n6;
            relPat = new RelationPattern(string);
            RelationPattern relationPattern = adam.findMatch(relPat, 5);
            RelationPattern relationPattern2 = eve.findMatch(relPat, 21);
            RelationPattern relationPattern3 = general.findMatch(relPat, 5);
            String string2 = relationPattern != null ? relationPattern.relationType : (relationPattern2 != null ? relationPattern2.relationType : (relationPattern3 != null ? relationPattern3.relationType : ((n6 = BuildRelationModel.mostLikelySubtype(relPat)) < 0 || n6 == 1 ? "0" : typeSubtype[n6].substring(0, 4).trim())));
            if (!BuildRelationModel.relPat.relationType.equals(string2)) {
                System.out.println(string);
                System.out.println("Correct type: " + BuildRelationModel.relPat.relationType + " Predicted type:  " + string2);
                if (relationPattern != null) {
                    System.out.println("Best Adam pattern = " + relationPattern.string);
                } else if (relationPattern2 != null) {
                    System.out.println("Best corpus pattern = " + relationPattern2.string);
                } else if (relationPattern3 != null) {
                    System.out.println("Best gen'l pattern = " + relationPattern3.string);
                } else {
                    System.out.println("No pattern matched.");
                }
            }
            if (BuildRelationModel.relPat.relationType.equals("0")) {
                if (string2.equals("0")) continue;
                ++n3;
                continue;
            }
            if (BuildRelationModel.relPat.relationType.equals(string2)) {
                ++n2;
                continue;
            }
            if (string2.equals("0")) {
                ++n4;
                continue;
            }
            ++n5;
        }
        System.out.println(n2 + " correct predictions");
        System.out.println(n3 + " spurious");
        System.out.println(n4 + " missing");
        System.out.println(n5 + " incorrect");
        System.out.println("Recall = " + (float)n2 / (float)(n2 + n5 + n4));
        System.out.println("Precision = " + (float)n2 / (float)(n2 + n5 + n3));
        System.out.println("Value = " + (n2 - n3 - n4 - n5));
    }

    static {
        features = new StringBuffer();
        typeSubtype = new String[]{"total", "no relation", "PHYS      Located", "PHYS      Near", "PHYS      Part-Whole", "PER-SOC   Business", "PER-SOC   Family", "PER-SOC   Other", "EMP-ORG   Employ-Executive", "EMP-ORG   Employ-Staff", "EMP-ORG   Employ-Undetermined", "EMP-ORG   Member-of-Group", "EMP-ORG   Subsidiary", "EMP-ORG   Partner", "EMP-ORG   Other", "ART       User-or-Owner", "ART       Inventor-Manufacturer", "ART       Other", "OTHER-AFF Ethnic", "OTHER-AFF Ideology", "OTHER-AFF Other", "GPE-AFF   Citizen-or-Resident", "GPE-AFF   Based-In", "GPE-AFF   Other", "DISC      "};
        N_SUBTYPES = typeSubtype.length;
        subtypeCount = new int[N_SUBTYPES];
        relationCount = 0;
        MAX_SIZE = 25;
        relationLengthCount = new int[MAX_SIZE];
        lengthCount = new int[MAX_SIZE];
        nonFinalWordCount = new HashMap[N_SUBTYPES];
        finalWordCount = new HashMap[N_SUBTYPES];
        BETA = 0.1;
    }
}

