package AceJet;

import java.util.*;
import java.io.*;

import org.w3c.dom.*;
import org.xml.sax.*;
import javax.xml.parsers.*;
// for WordNet
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.dictionary.Dictionary;

public class WordNetInterface {
	
	// initialize WordNet
	public static void initialize () {
		String propsFile = "C:/Documents and Settings/Ralph Grishman/My Documents/jwnl13rc3/file_properties.xml";
		try {
			// initialize JWNL (this must be done before JWNL can be used)
			JWNL.initialize(new FileInputStream(propsFile));
		} catch (Exception ex) {
			ex.printStackTrace();
			System.exit(-1);
		}
	}

	public static boolean containsSynonym (HashSet h, String w) {
		Iterator hi = h.iterator();
		while (hi.hasNext()) {
			String v = (String) hi.next();
			if (isNounSynonym(v,w)) return true;
		}
		return false;
	}
		
	public static boolean isNounSynonym (String v, String w) {
		try {
		  IndexWord vWord = Dictionary.getInstance().lookupIndexWord(POS.NOUN, v);
		  IndexWord wWord = Dictionary.getInstance().lookupIndexWord(POS.NOUN, w);
		  if (vWord == null || wWord == null) return false;
			Synset[] vSenses = vWord.getSenses();
			Synset[] wSenses = wWord.getSenses();
			if (vSenses == null || wSenses == null) return false;
			// any senses equal
			boolean match = intersect (vSenses, wSenses);
			// primary senses equal
			// boolean match = vSenses[0].equals(wSenses[0]);
			if (match) System.out.println ("Found synonyms " + v + " and " + w);
			return match;
		} catch (JWNLException ex) {
			ex.printStackTrace();
			System.exit(-1);
		}
		return false; 
	}
	
	public static boolean isVerbSynonym (String v, String w) {
		try {
		  IndexWord vWord = Dictionary.getInstance().lookupIndexWord(POS.VERB, v);
		  IndexWord wWord = Dictionary.getInstance().lookupIndexWord(POS.VERB, w);
		  if (vWord == null || wWord == null) return false;
			Synset[] vSenses = vWord.getSenses();
			Synset[] wSenses = wWord.getSenses();
			if (vSenses == null || wSenses == null) return false;
			// any senses equal
			boolean match = intersect (vSenses, wSenses);
			// primary senses equal
			// boolean match = vSenses[0].equals(wSenses[0]);
			if (!(v.equals(w)) && match) System.out.println ("Found verb synonyms " + v + " and " + w);
			return match;
		} catch (JWNLException ex) {
			ex.printStackTrace();
			System.exit(-1);
		}
		return false; 
	}
	
	private static boolean intersect (Object a[], Object b[]) {
		for (int i = 0; i < a.length; i++)
			for (int j = 0; j < b.length; j++)
				if (a[i] != null && a[i].equals(b[j]))
					return true;
		return false;
	}
	
}