/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.types;

import edu.umass.cs.mallet.base.pipe.FeatureSequence2FeatureVector;
import edu.umass.cs.mallet.base.pipe.Pipe;
import edu.umass.cs.mallet.base.pipe.PipeOutputAccumulator;
import edu.umass.cs.mallet.base.pipe.SerialPipes;
import edu.umass.cs.mallet.base.pipe.Target2Label;
import edu.umass.cs.mallet.base.pipe.TokenSequence2FeatureSequence;
import edu.umass.cs.mallet.base.pipe.iterator.PipeInputIterator;
import edu.umass.cs.mallet.base.pipe.iterator.RandomTokenSequenceIterator;
import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.DenseVector;
import edu.umass.cs.mallet.base.types.Dirichlet;
import edu.umass.cs.mallet.base.types.FeatureSelection;
import edu.umass.cs.mallet.base.types.Instance;
import edu.umass.cs.mallet.base.types.LabelAlphabet;
import edu.umass.cs.mallet.base.types.LabelVector;
import edu.umass.cs.mallet.base.types.Labeling;
import edu.umass.cs.mallet.base.types.MatrixOps;
import edu.umass.cs.mallet.base.util.DoubleList;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Logger;

public class InstanceList
implements Serializable,
PipeOutputAccumulator {
    private static Logger logger = MalletLogger.getLogger(InstanceList.class.getName());
    ArrayList instances;
    DoubleList instanceWeights = null;
    FeatureSelection featureSelection = null;
    FeatureSelection[] perLabelFeatureSelection = null;
    Pipe pipe;
    Alphabet dataVocab;
    Alphabet targetVocab;
    Class dataClass = null;
    Class targetClass = null;
    static final Pipe notYetSetPipe = new NotYetSetPipe();
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public InstanceList(Pipe pipe, int capacity) {
        this.pipe = pipe;
        this.instances = new ArrayList(capacity);
    }

    public InstanceList(Pipe pipe) {
        this(pipe, 10);
    }

    public InstanceList(Alphabet dataVocab, Alphabet targetVocab) {
        this(null, 10);
        this.dataVocab = dataVocab;
        this.targetVocab = targetVocab;
    }

    public InstanceList subList(int start, int end) {
        InstanceList other = new InstanceList(this.getPipe());
        int i = start;
        while (i < end) {
            other.add(this.getInstance(i));
            ++i;
        }
        return other;
    }

    public InstanceList() {
        this(notYetSetPipe);
    }

    public InstanceList(edu.umass.cs.mallet.base.util.Random r, Dirichlet classCentroidDistribution, double classCentroidAverageAlphaMean, double classCentroidAverageAlphaVariance, double featureVectorSizePoissonLambda, double classInstanceCountPoissonLambda, String[] classNames) {
        this(new SerialPipes(new Pipe[]{new TokenSequence2FeatureSequence(), new FeatureSequence2FeatureVector(), new Target2Label()}));
        RandomTokenSequenceIterator iter = new RandomTokenSequenceIterator(r, classCentroidDistribution, classCentroidAverageAlphaMean, classCentroidAverageAlphaVariance, featureVectorSizePoissonLambda, classInstanceCountPoissonLambda, classNames);
        this.add(iter);
    }

    private static Alphabet dictOfSize(int size) {
        Alphabet ret = new Alphabet();
        int i = 0;
        while (i < size) {
            ret.lookupIndex("feature" + i);
            ++i;
        }
        return ret;
    }

    private static String[] classNamesOfSize(int size) {
        String[] ret = new String[size];
        int i = 0;
        while (i < size) {
            ret[i] = "class" + i;
            ++i;
        }
        return ret;
    }

    public InstanceList(edu.umass.cs.mallet.base.util.Random r, Alphabet vocab, String[] classNames, int meanInstancesPerLabel) {
        this(r, new Dirichlet(vocab, 2.0), 30.0, 0.0, 10.0, meanInstancesPerLabel, classNames);
    }

    public InstanceList(edu.umass.cs.mallet.base.util.Random r, int vocabSize, int numClasses) {
        this(r, new Dirichlet(InstanceList.dictOfSize(vocabSize), 2.0), 30.0, 0.0, 10.0, 20.0, InstanceList.classNamesOfSize(numClasses));
    }

    public InstanceList shallowClone() {
        InstanceList ret = new InstanceList(this.pipe, this.instances.size());
        int i = 0;
        while (i < this.instances.size()) {
            ret.add(this.getInstance(i));
            ++i;
        }
        ret.instanceWeights = this.instanceWeights == null ? null : this.instanceWeights.cloneDoubleList();
        return ret;
    }

    public double noisify(double ratio) {
        assert (ratio >= 0.0 && ratio <= 1.0);
        int instance_size = this.instances.size();
        int noise_instance_num = (int)(ratio * (double)instance_size);
        Random r = new Random();
        ArrayList<Integer> randnumlist = new ArrayList<Integer>(noise_instance_num);
        int i = 0;
        while (i < noise_instance_num) {
            int randIndex = r.nextInt(instance_size);
            Integer nn = new Integer(randIndex);
            if (randnumlist.indexOf(nn) != -1) {
                --i;
            } else {
                randnumlist.add(nn);
            }
            ++i;
        }
        LabelAlphabet targets = (LabelAlphabet)this.pipe.getTargetAlphabet();
        int realRandNum = 0;
        int i2 = 0;
        while (i2 < randnumlist.size()) {
            String newTargetStr;
            int index = (Integer)randnumlist.get(i2);
            Instance inst = this.getInstance(index);
            int randIndex = r.nextInt(targets.size());
            String oldTargetStr = inst.getTarget().toString();
            if (!oldTargetStr.equals(newTargetStr = targets.lookupLabel(randIndex).toString())) {
                inst.unLock();
                inst.setTarget(targets.lookupLabel(randIndex));
                inst.setLock();
                ++realRandNum;
            }
            this.setInstance(index, inst);
            ++i2;
        }
        double realRatio = (double)realRandNum / (double)instance_size;
        return realRatio;
    }

    public InstanceList cloneEmpty() {
        InstanceList ret = new InstanceList(this.pipe);
        ret.instanceWeights = this.instanceWeights == null ? null : (DoubleList)this.instanceWeights.clone();
        ret.featureSelection = this.featureSelection;
        ret.perLabelFeatureSelection = this.perLabelFeatureSelection;
        ret.dataClass = this.dataClass;
        ret.targetClass = this.targetClass;
        ret.dataVocab = this.dataVocab;
        ret.targetVocab = this.targetVocab;
        return ret;
    }

    public InstanceList[] split(Random r, double[] proportions) {
        ArrayList shuffled = (ArrayList)this.instances.clone();
        Collections.shuffle(shuffled, r);
        return InstanceList.splitInOrder(shuffled, proportions, this);
    }

    public InstanceList[] split(double[] proportions) {
        return this.split(new Random(System.currentTimeMillis()), proportions);
    }

    public InstanceList[] splitInOrder(double[] proportions) {
        return InstanceList.splitInOrder(this.instances, proportions, this);
    }

    /*
     * Unable to fully structure code
     */
    private static InstanceList[] splitInOrder(List instances, double[] proportions, InstanceList cloneMe) {
        maxind = new double[proportions.length];
        System.arraycopy(proportions, 0, maxind, 0, proportions.length);
        ret = new InstanceList[proportions.length];
        DenseVector.normalize(maxind);
        i = 0;
        while (i < maxind.length) {
            ret[i] = cloneMe.cloneEmpty();
            if (i > 0) {
                v0 = i;
                maxind[v0] = maxind[v0] + maxind[i - 1];
            }
            ++i;
        }
        i = 0;
        while (i < maxind.length) {
            maxind[i] = Math.rint(maxind[i] * (double)instances.size());
            ++i;
        }
        j = 0;
        i = 0;
        ** GOTO lbl28
        {
            ++j;
            do {
                if ((double)i >= maxind[j]) continue block2;
                ret[j].instances.add(instances.get(i));
                ++i;
lbl28:
                // 2 sources

            } while (i < instances.size());
        }
        return ret;
    }

    public InstanceList[] splitByModulo(int m) {
        InstanceList[] ret = new InstanceList[]{this.cloneEmpty(), this.cloneEmpty()};
        int i = 0;
        while (i < this.size()) {
            if (i % m == 0) {
                ret[0].instances.add(this.getInstance(i));
            } else {
                ret[1].instances.add(this.getInstance(i));
            }
            ++i;
        }
        return ret;
    }

    public InstanceList sampleWithReplacement(Random r, int numSamples) {
        InstanceList ret = this.cloneEmpty();
        int i = 0;
        while (i < numSamples) {
            ret.instances.add(this.getInstance(r.nextInt(this.instances.size())));
            ++i;
        }
        return ret;
    }

    public Instance getInstance(int index) {
        return (Instance)this.instances.get(index);
    }

    public InstanceList sampleWithInstanceWeights(Random r) {
        double[] weights = new double[this.size()];
        int i = 0;
        while (i < weights.length) {
            weights[i] = this.getInstanceWeight(i);
            ++i;
        }
        return this.sampleWithWeights(r, weights);
    }

    public InstanceList sampleWithWeights(Random r, double[] weights) {
        if (weights.length != this.size()) {
            throw new IllegalArgumentException("length of weight vector must equal number of instances");
        }
        if (this.size() == 0) {
            return this.cloneEmpty();
        }
        double sumOfWeights = 0.0;
        int i = 0;
        while (i < this.size()) {
            if (weights[i] < 0.0) {
                throw new IllegalArgumentException("weight vector must be non-negative");
            }
            sumOfWeights += weights[i];
            ++i;
        }
        if (sumOfWeights <= 0.0) {
            throw new IllegalArgumentException("weights must sum to positive value");
        }
        InstanceList newList = new InstanceList();
        double[] probabilities = new double[this.size()];
        double sumProbs = 0.0;
        int i2 = 0;
        while (i2 < this.size()) {
            probabilities[i2] = sumProbs += r.nextDouble();
            ++i2;
        }
        MatrixOps.timesEquals(probabilities, sumOfWeights / sumProbs);
        probabilities[this.size() - 1] = sumOfWeights;
        int a = 0;
        int b = 0;
        sumProbs = 0.0;
        while (a < this.size() && b < this.size()) {
            sumProbs += weights[b];
            while (a < this.size() && probabilities[a] <= sumProbs) {
                newList.add(this.getInstance(b));
                newList.setInstanceWeight(a, 1.0);
                ++a;
            }
            ++b;
        }
        return newList;
    }

    public void setInstance(int index, Instance instance) {
        this.instances.set(index, instance);
    }

    public double getInstanceWeight(int index) {
        if (this.instanceWeights == null) {
            return 1.0;
        }
        return this.instanceWeights.get(index);
    }

    public void setInstanceWeight(int index, double weight) {
        if (weight != this.getInstanceWeight(index)) {
            if (this.instanceWeights == null) {
                this.instanceWeights = new DoubleList(this.instances.size(), 1.0);
            }
            this.instanceWeights.set(index, weight);
        }
    }

    public void setFeatureSelection(FeatureSelection selectedFeatures) {
        if (selectedFeatures != null && selectedFeatures.getAlphabet() != null && selectedFeatures.getAlphabet() != this.getDataAlphabet()) {
            throw new IllegalArgumentException("Vocabularies do not match");
        }
        this.featureSelection = selectedFeatures;
    }

    public FeatureSelection getFeatureSelection() {
        return this.featureSelection;
    }

    public void setPerLabelFeatureSelection(FeatureSelection[] selectedFeatures) {
        if (selectedFeatures != null) {
            int i = 0;
            while (i < selectedFeatures.length) {
                if (selectedFeatures[i].getAlphabet() != this.getDataAlphabet()) {
                    throw new IllegalArgumentException("Vocabularies do not match");
                }
                ++i;
            }
        }
        this.perLabelFeatureSelection = selectedFeatures;
    }

    public FeatureSelection[] getPerLabelFeatureSelection() {
        return this.perLabelFeatureSelection;
    }

    public void removeTargets() {
        int i = 0;
        while (i < this.instances.size()) {
            this.getInstance(i).setTarget(null);
            ++i;
        }
    }

    public void removeSources() {
        int i = 0;
        while (i < this.instances.size()) {
            this.getInstance(i).clearSource();
            ++i;
        }
    }

    public Object get(int index) {
        return this.getInstance(index);
    }

    public static InstanceList load(File file) {
        try {
            ObjectInputStream ois = file.toString().equals("-") ? new ObjectInputStream(System.in) : new ObjectInputStream(new FileInputStream(file));
            InstanceList ilist = (InstanceList)ois.readObject();
            ois.close();
            return ilist;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Couldn't read InstanceList from file " + file);
        }
    }

    public void save(File file) {
        try {
            ObjectOutputStream ois = file.toString().equals("-") ? new ObjectOutputStream(System.out) : new ObjectOutputStream(new FileOutputStream(file));
            ois.writeObject(this);
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Couldn't save InstanceList to file " + file);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.instances);
        out.writeObject(this.instanceWeights);
        out.writeObject(this.pipe);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.instances = (ArrayList)in.readObject();
        this.instanceWeights = (DoubleList)in.readObject();
        this.pipe = (Pipe)in.readObject();
    }

    public int size() {
        return this.instances.size();
    }

    public Class getDataClass() {
        if (this.instances.size() == 0) {
            return null;
        }
        return this.getInstance(0).getData().getClass();
    }

    public Pipe getPipe() {
        return this.pipe;
    }

    public Alphabet getDataAlphabet() {
        if (this.dataVocab == null && this.pipe != null) {
            this.dataVocab = this.pipe.getDataAlphabet();
        }
        assert (this.pipe == null || this.pipe.getDataAlphabet() == null || this.pipe.getDataAlphabet() == this.dataVocab);
        return this.dataVocab;
    }

    public Alphabet getTargetAlphabet() {
        if (this.targetVocab == null && this.pipe != null) {
            this.targetVocab = this.pipe.getTargetAlphabet();
        }
        assert (this.pipe == null || this.pipe.getTargetAlphabet() == null || this.pipe.getTargetAlphabet() == this.targetVocab);
        return this.targetVocab;
    }

    public LabelVector targetLabelDistribution() {
        if (this.instances.size() == 0) {
            return null;
        }
        if (!(this.getInstance(0).getTarget() instanceof Labeling)) {
            throw new IllegalStateException("Target is not a labeling.");
        }
        double[] counts = new double[this.getTargetAlphabet().size()];
        int i = 0;
        while (i < this.instances.size()) {
            Instance instance = this.getInstance(i);
            Labeling l = (Labeling)instance.getTarget();
            l.addTo(counts, this.getInstanceWeight(i));
            ++i;
        }
        return new LabelVector((LabelAlphabet)this.getTargetAlphabet(), counts);
    }

    public void pipeOutputAccumulate(Instance carrier, Pipe iteratedPipe) {
        if (carrier.getData() instanceof InstanceList) {
            this.add((InstanceList)carrier.getData());
        } else if (carrier.getData() instanceof PipeInputIterator) {
            this.add((PipeInputIterator)carrier.getData());
        } else if (carrier.getData() instanceof Instance) {
            this.add((Instance)carrier.getData());
        } else {
            if (this.pipe == notYetSetPipe) {
                this.pipe = iteratedPipe;
            }
            this.add(carrier);
        }
    }

    public PipeOutputAccumulator clonePipeOutputAccumulator() {
        return this.shallowClone();
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public CrossValidationIterator crossValidationIterator(int nfolds, int seed) {
        return new CrossValidationIterator(nfolds, seed);
    }

    public CrossValidationIterator crossValidationIterator(int nfolds) {
        return this.crossValidationIterator(nfolds);
    }

    public void add(PipeInputIterator pi) {
        boolean i = false;
        while (pi.hasNext()) {
            Instance carrier = pi.nextInstance();
            this.add(new Instance(carrier.getData(), carrier.getTarget(), carrier.name, carrier.getSource(), this.pipe));
        }
    }

    public void add(InstanceList ilist) {
        if (ilist.pipe == this.pipe) {
            Iterator iter = ilist.iterator();
            while (iter.hasNext()) {
                this.add(iter.nextInstance());
            }
        } else if (this.pipe == notYetSetPipe) {
            if (this.instances.size() > 0) {
                throw new IllegalArgumentException("Trying to set this InstanceList's pipe, but it already has instances.");
            }
            this.pipe = ilist.pipe;
            Iterator iter = ilist.iterator();
            while (iter.hasNext()) {
                this.add(iter.nextInstance());
            }
        } else if (ilist.pipe == null) {
            Iterator iter = ilist.iterator();
            while (iter.hasNext()) {
                this.add(iter.nextInstance());
            }
        } else {
            throw new IllegalArgumentException("Instances to be added to a InstanceList cannot already have been piped, unless the pipes are equal, or one of the pipes is null.");
        }
    }

    public boolean add(Object data, Object target, Object name, Object source, double instanceWeight) {
        return this.add(new Instance(data, target, name, source, this.pipe), instanceWeight);
    }

    public boolean add(Object data, Object target, Object name, Object source) {
        return this.add(data, target, name, source, 1.0);
    }

    public boolean add(Instance instance) {
        if (this.pipe == notYetSetPipe) {
            this.pipe = instance.getPipe();
        } else if (instance.getPipe() != this.pipe) {
            throw new IllegalArgumentException("pipes don't match: instance: " + instance.getPipe() + " Instance.list: " + this.pipe);
        }
        if (this.dataClass == null) {
            this.dataClass = instance.data.getClass();
            if (this.pipe != null && this.pipe.isTargetProcessing() && instance.target != null) {
                this.targetClass = instance.target.getClass();
            }
        }
        return this.instances.add(instance);
    }

    public boolean add(Instance instance, double instanceWeight) {
        boolean ret = this.add(instance);
        if (instanceWeight != 1.0 || this.instanceWeights != null) {
            if (this.instanceWeights == null) {
                if (this.instances.size() == 1) {
                    this.instanceWeights = new DoubleList(1, instanceWeight);
                } else {
                    this.instanceWeights = new DoubleList(this.instances.size() - 1, 1.0);
                    this.instanceWeights.add(instanceWeight);
                }
            } else {
                this.instanceWeights.add(instanceWeight);
            }
        }
        return ret;
    }

    private static class NotYetSetPipe
    extends Pipe {
        private static final long serialVersionUID = 1L;

        private NotYetSetPipe() {
        }

        public Instance pipe(Instance carrier) {
            throw new UnsupportedOperationException("The InstanceList has yet to have its pipe set; this could happen by calling InstanceList.add(InstanceList)");
        }

        public Object readResolve() throws ObjectStreamException {
            return notYetSetPipe;
        }
    }

    public class CrossValidationIterator
    implements java.util.Iterator,
    Serializable {
        int nfolds;
        InstanceList[] folds;
        int index;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !CrossValidationIterator.class.desiredAssertionStatus();
        }

        public CrossValidationIterator(int _nfolds, int seed) {
            if (!$assertionsDisabled && _nfolds <= 0) {
                throw new AssertionError((Object)("nfolds: " + this.nfolds));
            }
            this.nfolds = _nfolds;
            this.index = 0;
            this.folds = new InstanceList[_nfolds];
            double fraction = 1.0 / (double)_nfolds;
            double[] proportions = new double[_nfolds];
            int i = 0;
            while (i < _nfolds) {
                proportions[i] = fraction;
                ++i;
            }
            this.folds = InstanceList.this.split(new Random(seed), proportions);
        }

        public CrossValidationIterator(int _nfolds) {
            this(_nfolds, 1);
        }

        public boolean hasNext() {
            return this.index < this.nfolds;
        }

        public InstanceList[] nextSplit() {
            InstanceList[] ret = new InstanceList[2];
            ret[0] = new InstanceList(InstanceList.this.pipe);
            int i = 0;
            while (i < this.folds.length) {
                if (i != this.index) {
                    Iterator iter = this.folds[i].iterator();
                    while (iter.hasNext()) {
                        ret[0].add(iter.nextInstance());
                    }
                }
                ++i;
            }
            ret[1] = this.folds[this.index].shallowClone();
            ++this.index;
            return ret;
        }

        public InstanceList[] nextSplit(int numTrainFolds) {
            InstanceList[] ret = new InstanceList[]{new InstanceList(InstanceList.this.pipe), new InstanceList(InstanceList.this.pipe)};
            int i = 0;
            while (i < this.folds.length) {
                int foldno = (this.index + i) % this.folds.length;
                InstanceList addTo = i < numTrainFolds ? ret[0] : ret[1];
                Iterator iter = this.folds[foldno].iterator();
                while (iter.hasNext()) {
                    addTo.add(iter.nextInstance());
                }
                ++i;
            }
            ++this.index;
            return ret;
        }

        public Object next() {
            return this.nextSplit();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class Iterator
    implements java.util.Iterator,
    Serializable {
        int index = 0;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;

        public boolean hasNext() {
            return this.index < InstanceList.this.instances.size();
        }

        public Instance nextInstance() {
            return InstanceList.this.getInstance(this.index++);
        }

        public double getInstanceWeight() {
            return InstanceList.this.instanceWeights == null ? 1.0 : InstanceList.this.instanceWeights.get(this.index);
        }

        public Object next() {
            return this.nextInstance();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
            out.writeInt(this.index);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            this.index = in.readInt();
        }
    }

    protected static interface Stream
    extends PipeOutputAccumulator {
        public Iterator iterator();

        public int size();

        public Pipe getInstancePipe();

        public Alphabet getTargetAlphabet();

        public Alphabet getDataAlphabet();
    }
}

