/*
 * Decompiled with CFR 0.152.
 */
package tratz.cmdline;

import java.util.HashMap;
import java.util.Map;

public class ParsedCommandLine {
    private Map<String, String> mArgToValue = new HashMap<String, String>();

    public void setArgumentValue(String argument, String value) {
        this.mArgToValue.put(argument, value);
    }

    public String getStringValue(String argument, String defaultValue) {
        String value = this.mArgToValue.get(argument);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getStringValue(String argument) {
        return this.getStringValue(argument, null);
    }

    public double getDoubleValue(String argument, double defaultValue) {
        String value = this.mArgToValue.get(argument);
        double dval = -1.0;
        dval = value == null ? defaultValue : Double.parseDouble(value);
        return dval;
    }

    public double getDoubleValue(String argument) {
        return this.getDoubleValue(argument, 0.0);
    }

    public Integer getIntegerValue(String argument, Integer defaultValue) {
        String value = this.mArgToValue.get(argument);
        int dval = -1;
        dval = value == null ? defaultValue : Integer.parseInt(value);
        return dval;
    }

    public Integer getIntegerValue(String argument) {
        return this.getIntegerValue(argument, null);
    }

    public Boolean getBooleanValue(String argument) {
        return this.getBooleanValue(argument, null);
    }

    public Boolean getBooleanValue(String argument, Boolean defaultValue) {
        String value = this.mArgToValue.get(argument);
        Boolean dval = null;
        if (value == null) {
            if (defaultValue != null) {
                dval = defaultValue;
            }
        } else {
            dval = Boolean.parseBoolean(value);
        }
        return dval;
    }
}

