/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import pnuts.lang.Configuration;
import pnuts.lang.Context;
import pnuts.lang.PnutsException;

public abstract class JavaBeansConfiguration
extends Configuration {
    private Class stopClass;

    public JavaBeansConfiguration() {
    }

    public JavaBeansConfiguration(Class stopClass) {
        this.stopClass = stopClass;
    }

    protected Class getStopClass() {
        return this.stopClass;
    }

    public Method[] getMethods(Class cls) {
        try {
            BeanInfo beanInfo = this.stopClass != null ? Introspector.getBeanInfo(cls, this.stopClass) : Introspector.getBeanInfo(cls);
            MethodDescriptor[] methodDesc = beanInfo.getMethodDescriptors();
            Method[] m = new Method[methodDesc.length];
            for (int i = 0; i < methodDesc.length; ++i) {
                m[i] = methodDesc[i].getMethod();
            }
            return m;
        }
        catch (IntrospectionException e) {
            return new Method[0];
        }
    }

    public Constructor[] getConstructors(final Class cls) {
        return (Constructor[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return cls.getConstructors();
            }
        });
    }

    public Object getField(Context context, Object target, String name) {
        return this.getBeanProperty(context, target, name);
    }

    protected Object getBeanProperty(Context context, Object target, String name) {
        try {
            return context.runtime.getBeanProperty(target, name, this.stopClass);
        }
        catch (InvocationTargetException e1) {
            throw new PnutsException(e1.getTargetException(), context);
        }
        catch (IllegalAccessException e2) {
            throw new PnutsException(e2, context);
        }
    }

    public void putField(Context context, Object target, String name, Object value) {
        this.setBeanProperty(context, target, name, value);
    }

    protected void setBeanProperty(Context context, Object target, String name, Object value) {
        try {
            context.runtime.setBeanProperty(target, name, value, this.stopClass);
        }
        catch (InvocationTargetException e1) {
            throw new PnutsException(e1.getTargetException(), context);
        }
        catch (IllegalAccessException e2) {
            throw new PnutsException(e2, context);
        }
    }

    public Object callMethod(Context context, Class c, String name, Object[] args, Class[] types, Object target) {
        try {
            return context.runtime._callMethod(context, c, name, args, types, target);
        }
        catch (PnutsException pe) {
            PnutsException.TraceInfo trace = new PnutsException.TraceInfo(target, name, args, context.getScriptSource(), context.beginLine, context.beginColumn);
            pe.backtrace(trace);
            throw pe;
        }
    }

    public Object callConstructor(Context context, Class c, Object[] args, Class[] types) {
        try {
            return context.runtime._callConstructor(context, c, args, types);
        }
        catch (PnutsException pe) {
            PnutsException.TraceInfo trace = new PnutsException.TraceInfo(c, args, context.getScriptSource(), context.beginLine, context.beginColumn);
            pe.backtrace(trace);
            throw pe;
        }
    }
}

