/*
 * Decompiled with CFR 0.152.
 */
package pnuts.lang;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import pnuts.lang.Context;
import pnuts.lang.Pnuts;

class Import
implements Serializable {
    static final long serialVersionUID = 5497516072354034892L;
    private String name;
    private transient Hashtable table;

    public Import(String name) {
        this.name = name;
        this.table = new Hashtable(64);
    }

    public String getName() {
        return this.name;
    }

    public Class get(String className, Context context) {
        Class c = (Class)this.table.get(className);
        if (c != null) {
            return c;
        }
        String fullName = className;
        try {
            Class clazz = null;
            if (this.name.length() > 0) {
                fullName = this.name + "." + className;
            }
            if ((clazz = Pnuts.loadClass(fullName, context)) != null) {
                this.table.put(className, clazz);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    void reset() {
        this.table = new Hashtable(64);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.table = new Hashtable(64);
    }

    public String toString() {
        return "import " + this.name;
    }
}

