/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import tratz.parse.ArcSorter;
import tratz.parse.types.Arc;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Arc> mArcs;
    private Token mRoot;
    private List[] mTokenToChildren;
    private Arc[] mTokenToHead;
    private Sentence mSentence;

    public Parse(Sentence sentence, Token root, List<Arc> arcs, List[] tokenToChildren, Arc[] tokenToHead) {
        this.mSentence = sentence;
        this.mRoot = root;
        this.mArcs = arcs;
        this.mTokenToChildren = tokenToChildren;
        this.mTokenToHead = tokenToHead;
    }

    public Parse(Sentence sentence, Token root, List<Arc> arcs) {
        this.mSentence = sentence;
        this.mRoot = root;
        this.mArcs = arcs;
        this.mTokenToChildren = this.buildTokenToChildren();
        this.mTokenToHead = this.buildTokenToHeadArcs();
    }

    private List[] buildTokenToChildren() {
        List[] tokenToChildren = new List[this.mSentence.getTokens().size() + 1];
        if (this.mArcs != null) {
            for (Arc a : this.mArcs) {
                ArrayList<Arc> arcs = tokenToChildren[a.getHead().getIndex()];
                if (arcs == null) {
                    tokenToChildren[a.getHead().getIndex()] = arcs = new ArrayList<Arc>();
                }
                arcs.add(a);
            }
            ArcSorter sorter = new ArcSorter();
            for (List arcList : tokenToChildren) {
                if (arcList == null) continue;
                Collections.sort(arcList, sorter);
            }
        }
        return tokenToChildren;
    }

    private Arc[] buildTokenToHeadArcs() {
        int numTokens = this.mSentence.getTokens().size();
        Arc[] tokenToHead = new Arc[numTokens + 1];
        if (this.mArcs != null) {
            Iterator<Arc> i$ = this.mArcs.iterator();
            while (i$.hasNext()) {
                Arc arc;
                tokenToHead[arc.getChild().getIndex()] = arc = i$.next();
            }
        }
        return tokenToHead;
    }

    public List<Arc> getArcs() {
        return this.mArcs;
    }

    public Token getRoot() {
        return this.mRoot;
    }

    public Sentence getSentence() {
        return this.mSentence;
    }

    public Arc[] getHeadArcs() {
        return this.mTokenToHead;
    }

    public List[] getDependentArcLists() {
        return this.mTokenToChildren;
    }
}

