/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Iterator;
import tratz.parse.FullSystemWrapper;
import tratz.parse.SimpleParseServer;
import tratz.parse.types.Arc;
import tratz.parse.types.Parse;
import tratz.parse.types.Sentence;
import tratz.parse.types.Token;
import tratz.pos.PosTagger;

public class SimpleParseClient {
    private Socket mSocket;
    private ObjectInputStream mInputStream;
    private ObjectOutputStream mOutputStream;

    public SimpleParseClient(String address, int portNumber) throws IOException {
        this.mSocket = new Socket(address, portNumber);
        this.mInputStream = new ObjectInputStream(this.mSocket.getInputStream());
        this.mOutputStream = new ObjectOutputStream(this.mSocket.getOutputStream());
    }

    public SimpleParseServer.ParseResult sendRequest(SimpleParseServer.ParseRequest request) throws IOException, ClassNotFoundException {
        this.mOutputStream.writeObject(request);
        this.mOutputStream.flush();
        this.mOutputStream.reset();
        SimpleParseServer.ParseResult result = (SimpleParseServer.ParseResult)this.mInputStream.readObject();
        return result;
    }

    public void closeClient() throws IOException {
        this.mSocket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int portNumber = Integer.parseInt(args[0]);
        SimpleParseClient client = new SimpleParseClient("127.0.0.1", portNumber);
        try {
            block3: while (true) {
                Sentence sentence = new Sentence(PosTagger.makeMeSomeTokens("The bear went over the mountain to see what he could see .".split("\\s+")));
                SimpleParseServer.ParseRequest request = null;
                request = new SimpleParseServer.ParseRequest(sentence);
                SimpleParseServer.ParseResult result = client.sendRequest(request);
                if (result.getException() != null) {
                    System.err.println("Blah... something wrong");
                    result.getException().printStackTrace();
                    break;
                }
                FullSystemWrapper.FullSystemResult fullResult = result.getResult();
                Parse syntacticParse = fullResult.getParse();
                Parse srlLinks = fullResult.getSrlParse();
                Arc[] srlArcs = srlLinks == null ? null : srlLinks.getHeadArcs();
                Sentence sentenceCopy = syntacticParse.getSentence();
                Iterator<Token> i$ = sentenceCopy.getTokens().iterator();
                while (true) {
                    if (!i$.hasNext()) continue block3;
                    Token t = i$.next();
                    Arc arcHead = syntacticParse.getHeadArcs()[t.getIndex()];
                    Arc srlArc = srlArcs == null ? null : srlArcs[t.getIndex()];
                    System.err.println(t.getIndex() + "\t" + t.getText() + "\t" + t.getPos() + "\t" + arcHead.getDependency() + "\t" + arcHead.getHead().getIndex() + "\t" + (t.getLexSense() == null ? "_" : t.getLexSense()) + "\t" + (srlArc == null ? "_" : srlArc.getSemanticAnnotation()) + "\t" + (srlArc == null ? "_" : Integer.valueOf(srlArc.getHead().getIndex())));
                }
                break;
            }
        }
        finally {
            client.closeClient();
        }
    }
}

