/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.util.Set;
import tratz.featgen.fer.AbstractFeatureRule;
import tratz.jwni.POS;
import tratz.jwni.WordNet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordNetPosTypesFER
extends AbstractFeatureRule {
    public static final long serialVersionUID = 1L;

    @Override
    public Set<String> getProductions(String term, String type, Set<String> features) {
        WordNet wn = WordNet.getInstance();
        if (wn.lookupIndexEntry(POS.ADJECTIVE, term) != null) {
            features.add("ISj");
        } else {
            features.add("notISj");
        }
        if (wn.lookupIndexEntry(POS.ADVERB, term) != null) {
            features.add("ISr");
        } else {
            features.add("notISr");
        }
        if (wn.lookupIndexEntry(POS.VERB, term) != null) {
            features.add("ISv");
        } else {
            features.add("notISv");
        }
        if (wn.lookupIndexEntry(POS.NOUN, term) != null) {
            features.add("ISn");
        } else {
            features.add("notISn");
        }
        return features;
    }
}

