/*
 * Decompiled with CFR 0.152.
 */
package tratz.pos.train;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPOutputStream;
import tratz.cmdline.CommandLineOptions;
import tratz.cmdline.CommandLineOptionsParser;
import tratz.cmdline.ParsedCommandLine;
import tratz.ml.LiblinearModelReader;
import tratz.ml.LinearClassificationModel;
import tratz.pos.featgen.PosFeatureGenerator;

public class FinalizePosModel {
    public static final String OPT_ALPHABET_FILE = "alphabet";
    public static final String OPT_MODEL_FILE = "inputmodel";
    public static final String OPT_TRIM_FACTOR = "trimfactor";
    public static final String OPT_OUTPUT_FILE = "output";
    public static final String OPT_FEATURE_GENERATOR_CLASS = "featgenclass";

    public static CommandLineOptions createOptions() {
        CommandLineOptions options = new CommandLineOptions();
        options.addOption(OPT_ALPHABET_FILE, "file", "file containing the feature and class alphabets");
        options.addOption(OPT_MODEL_FILE, "file", "file containing the output of the LIBLINEAR trainer");
        options.addOption(OPT_TRIM_FACTOR, "double", "factor by which to reduce the size of the model (should be no greater than 1.0)");
        options.addOption(OPT_OUTPUT_FILE, "file", "file for the new gzipped, serialized model");
        options.addOption(OPT_FEATURE_GENERATOR_CLASS, "string", "class name of the feature generation class");
        return options;
    }

    public static void main(String[] args) throws Exception {
        ParsedCommandLine cmdLine = new CommandLineOptionsParser().parseOptions(FinalizePosModel.createOptions(), args);
        String alphabetFile = cmdLine.getStringValue(OPT_ALPHABET_FILE);
        String modelFile = cmdLine.getStringValue(OPT_MODEL_FILE);
        double trimFactor = cmdLine.getDoubleValue(OPT_TRIM_FACTOR);
        String outputFile = cmdLine.getStringValue(OPT_OUTPUT_FILE);
        String featureGenerator = cmdLine.getStringValue(OPT_FEATURE_GENERATOR_CLASS);
        PosFeatureGenerator featGen = (PosFeatureGenerator)Class.forName(featureGenerator).newInstance();
        LinearClassificationModel originalModel = LiblinearModelReader.readLiblinearModel(modelFile, alphabetFile);
        LinearClassificationModel shrunkenModel = originalModel.createTrimmedModel((float)trimFactor);
        ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(outputFile)));
        out.writeObject(shrunkenModel);
        out.writeObject(featGen);
        out.close();
    }
}

