/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.util.Set;
import tratz.featgen.fer.AbstractWordNetFER;
import tratz.jwni.IndexEntry;
import tratz.jwni.POS;
import tratz.jwni.Pointer;
import tratz.jwni.PointerType;
import tratz.jwni.Sense;
import tratz.jwni.WordNet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdjectiveAttributesAndSimilars
extends AbstractWordNetFER {
    private static final long serialVersionUID = 1L;

    @Override
    public Set<String> generateFeatures(String term, String type, Set<String> productions) {
        IndexEntry entry;
        POS pos = this.getPosForType(type);
        if (pos != null && (entry = WordNet.getInstance().lookupIndexEntry(pos, term)) != null) {
            Sense[] senses = entry.getSenses();
            for (int i = 0; i < senses.length && i < this.mMaxSenseNum; ++i) {
                Pointer[] pointers;
                Sense sense = senses[i];
                for (Pointer ptr : pointers = sense.getPointers(PointerType.ATTRIBUTE)) {
                    productions.add((Object)((Object)ptr.getPointerType()) + ":" + ptr.getTargetSense().getKeys()[0].toString());
                }
                Pointer[] antonyms = sense.getPointers(PointerType.ANTONYM);
                if (antonyms.length <= 0) continue;
                productions.add((Object)((Object)PointerType.ANTONYM) + ":" + sense.getKeys()[0].toString());
                for (Pointer anto : antonyms) {
                    productions.add((Object)((Object)PointerType.ANTONYM) + ":" + anto.getTargetSense().getKeys()[0].toString());
                }
            }
        }
        return productions;
    }
}

