/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.types;

import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.Label;
import edu.umass.cs.mallet.base.types.LabelAlphabet;
import edu.umass.cs.mallet.base.types.Labeling;
import edu.umass.cs.mallet.base.types.RankedFeatureVector;

public class LabelVector
extends RankedFeatureVector
implements Labeling {
    public LabelVector(LabelAlphabet dict, int[] features, double[] values) {
        super((Alphabet)dict, features, values);
    }

    private static int[] indicesForLabels(Label[] labels) {
        int[] indices = new int[labels.length];
        int i = 0;
        while (i < labels.length) {
            indices[i] = labels[i].getIndex();
            ++i;
        }
        return indices;
    }

    public LabelVector(Label[] labels, double[] values) {
        super((Alphabet)labels[0].dictionary, LabelVector.indicesForLabels(labels), values);
    }

    public LabelVector(LabelAlphabet dict, double[] values) {
        super((Alphabet)dict, values);
    }

    public final Label labelAtLocation(int loc) {
        return ((LabelAlphabet)this.dictionary).lookupLabel(this.indexAtLocation(loc));
    }

    public LabelAlphabet getLabelAlphabet() {
        return (LabelAlphabet)this.dictionary;
    }

    public int getBestIndex() {
        if (this.rankOrder == null) {
            this.setRankOrder();
        }
        return this.rankOrder[0];
    }

    public Label getBestLabel() {
        return ((LabelAlphabet)this.dictionary).lookupLabel(this.getBestIndex());
    }

    public double getBestValue() {
        if (this.rankOrder == null) {
            this.setRankOrder();
        }
        return this.values[this.rankOrder[0]];
    }

    public double value(Label label) {
        assert (label.dictionary == this.dictionary);
        return this.values[this.location(label.toString())];
    }

    public int getRank(Label label) {
        throw new UnsupportedOperationException();
    }

    public int getRank(int labelIndex) {
        throw new UnsupportedOperationException();
    }

    public Label getLabelAtRank(int rank) {
        if (this.rankOrder == null) {
            this.setRankOrder();
        }
        return ((LabelAlphabet)this.dictionary).lookupLabel(this.rankOrder[rank]);
    }

    public double getValueAtRank(int rank) {
        if (this.rankOrder == null) {
            this.setRankOrder();
        }
        return this.values[this.rankOrder[rank]];
    }

    public LabelVector toLabelVector() {
        return this;
    }
}

