/*
 * Decompiled with CFR 0.152.
 */
package Jet.Refres;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.EDTtype;
import AceJet.PerfectAce;
import Jet.Concepts.ConceptHierarchy;
import Jet.Console;
import Jet.JetTest;
import Jet.Lex.Tokenizer;
import Jet.Lisp.FeatureSet;
import Jet.Parser.ParseTreeNode;
import Jet.Parser.SynFun;
import Jet.Refres.Hobbs;
import Jet.Refres.MaxEntResolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import Jet.Zoner.SentenceSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolve {
    static Vector<Annotation> clauses;
    static Vector<Annotation> entities;
    public static SentenceSet sentenceSet;
    static boolean fullParse;
    public static boolean linkAppositesAndPredComps;
    public static boolean nameTypeMatch;
    static HashMap<Annotation, Annotation> mentionToEntity;
    static HashMap<Annotation, Annotation> syntacticAntecedent;
    public static boolean trace;
    static Annotation parseTree;
    static HashMap<Annotation, Annotation> parents;
    static HashSet<String> pronounsNotHandled;
    public static boolean useMaxEnt;
    public static boolean ACE;
    private static final String[] maleHeads;
    private static final String[] femaleHeads;
    private static HashMap<String, String> genderDict;
    private static final String[] definiteDets;
    private static final String[] indefiniteDets;
    private static final String[] genericPersonTerms;
    private static final String[] genericOrganizationTerms;
    private static final String[] genericCountryTerms;
    private static final String[] genericStateTerms;
    private static final String[] genericGpeTerms;
    private static final String[] genericLocationTerms;
    private static final String[] genericFacilityTerms;
    private static HashMap<String, String> nominative;
    static HashSet<String> reflexives;

    public static void references(Document document, Span span) {
        Object object;
        if (useMaxEnt) {
            MaxEntResolve.references(document, span);
            return;
        }
        int n = span.start();
        Vector<Annotation> vector = document.annotationsAt(n, "sentence");
        if (vector != null && vector.size() > 0) {
            object = vector.get(0);
            fullParse = ((Annotation)object).get("parse") != null;
            parseTree = (Annotation)((Annotation)object).get("parse");
            parents = SynFun.collectParents(parseTree);
        } else {
            fullParse = false;
        }
        object = Resolve.gatherMentions(document, span);
        Vector<Annotation> vector2 = Resolve.gatherClauses(document, span);
        Resolve.references(document, span, (Vector<Annotation>)object, vector2);
    }

    public static void references(Document document, Span span, Vector<Annotation> vector, Vector<Annotation> vector2) {
        entities = document.annotationsOfType("entity");
        if (entities == null) {
            entities = new Vector();
        }
        mentionToEntity = new HashMap();
        if (trace) {
            Console.println("Resolving references");
        }
        sentenceSet = new SentenceSet(document);
        Resolve.markMentions(vector);
        syntacticAntecedent = Resolve.gatherSyntacticCoref(document, vector, vector2);
        pronounsNotHandled = new HashSet();
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = vector.get(i);
            Resolve.resolveMention(document, annotation);
        }
        Resolve.updateEvents(document, span, mentionToEntity);
    }

    public static Vector<Annotation> gatherMentions(Document document, Span span) {
        Vector<Annotation> vector = new Vector<Annotation>();
        Vector<Object> vector2 = new Vector<Object>();
        Set<Integer> set = null;
        set = Resolve.gatherNameTokens(document, span);
        for (int i = span.start(); i < span.end(); ++i) {
            Vector<Annotation> vector3 = document.annotationsAt(i, "constit");
            if (vector3 == null) continue;
            for (int j = 0; j < vector3.size(); ++j) {
                Object object;
                Annotation annotation;
                Annotation annotation2 = vector3.elementAt(j);
                String string = (String)annotation2.get("cat");
                if (!(string != null && (string.equals("ngroup") || string.equals("np") && !Resolve.conjoinedNP(document, annotation2) || string.equals("det") && annotation2.get("tposs") == "t" || ACE && string.equals("name") || ACE && AceDocument.ace2004 && string.equals("title") || ACE && AceDocument.ace2004 && (string.equals("n") || string.equals("nnp") || string.equals("nnps")) && !set.contains(i) || (ACE && fullParse || Ace.perfectMentions) && (string.equals("whnp") || string.equals("np-pro")) || Ace.perfectMentions && (string.equals("adj") || string.equals("adv")) && !set.contains(i)) && (annotation = Resolve.getHeadC(annotation2)).get("cat") != "timex" && annotation.get("cat") != "ordinal" && (Ace.perfectMentions || annotation.get("cat") != "adv" && !"there".equalsIgnoreCase((String)(object = SynFun.getHead(document, annotation2)))) && annotation.get("cat") != "ving" && (!Ace.perfectMentions || PerfectAce.validMention(document, annotation, string)))) continue;
                vector.add(annotation2);
                object = (Annotation)annotation2.get("headC");
                if (object == null) continue;
                vector2.add(object);
            }
        }
        vector.removeAll(vector2);
        return vector;
    }

    private static Set<Integer> gatherNameTokens(Document document, Span span) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = span.start(); i < span.end(); ++i) {
            Vector<Annotation> vector = document.annotationsAt(i, "constit");
            if (vector == null) continue;
            block1: for (int j = 0; j < vector.size(); ++j) {
                Annotation annotation = vector.elementAt(j);
                String string = (String)annotation.get("cat");
                if (string != "name") continue;
                int n = annotation.start();
                while (n < annotation.end()) {
                    hashSet.add(n);
                    Annotation annotation2 = document.tokenAt(n);
                    if (annotation2 == null) continue block1;
                    n = annotation2.span().end();
                }
            }
        }
        return hashSet;
    }

    public static Vector<Annotation> gatherClauses(Document document, Span span) {
        clauses = new Vector();
        for (int i = span.start(); i < span.end(); ++i) {
            Vector<Annotation> vector = document.annotationsAt(i, "constit");
            if (vector == null) continue;
            for (int j = 0; j < vector.size(); ++j) {
                Annotation annotation = vector.elementAt(j);
                String string = (String)annotation.get("cat");
                if (string == null || !string.equals("s") && !string.equals("rn-wh") && !string.equals("rn-vingo")) continue;
                clauses.add(annotation);
            }
        }
        return clauses;
    }

    private static boolean conjoinedNP(Document document, Annotation annotation) {
        Annotation[] annotationArray = ParseTreeNode.children(annotation);
        if (annotationArray == null || annotationArray.length != 3) {
            return false;
        }
        if (annotationArray[0] == null || annotationArray[1] == null || annotationArray[2] == null) {
            return false;
        }
        boolean bl = annotationArray[0].get("cat") == "np" && annotationArray[1].get("cat") == "cconj" && annotationArray[2].get("cat") == "np";
        return bl;
    }

    public static void markMentions(Vector vector) {
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            annotation.put("mention", "true");
        }
    }

    public static HashMap<Annotation, Annotation> gatherSyntacticCoref(Document document, Vector<Annotation> vector, Vector<Annotation> vector2) {
        Annotation annotation;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HashMap<Annotation, Annotation> hashMap = new HashMap<Annotation, Annotation>();
        Vector<Annotation> vector3 = new Vector<Annotation>(vector);
        for (Annotation annotation2 : vector3) {
            object4 = Resolve.getHeadC(annotation2);
            object3 = SynFun.getHead(document, annotation2);
            object2 = Resolve.getNgHead(annotation2);
            if (object3 == null) {
                System.err.println("No head for annotation " + annotation2 + " over " + document.text(annotation2));
                continue;
            }
            if (annotation2.get("preName") != null) {
                object = (Annotation)annotation2.get("preName");
                Resolve.recordSyntacticCoref((Annotation)object, annotation2, document, vector, hashMap);
            }
            object = SynFun.getNumber(annotation2);
            if (object3 != null && (((String)object3).equals("city") || ((String)object3).equals("state") || ((String)object3).equals("county") || ((String)object3).equals("village") || ((String)object3).equals("town") || ((String)object3).equals("island") || ((String)object3).equals("port") || ((String)object3).equals("province")) && (object == null || !((String)object).equals("plural")) && (annotation = (Annotation)annotation2.get("of")) != null && Resolve.isName(Resolve.getHeadC(annotation))) {
                Resolve.recordSyntacticCoref(annotation2, annotation, document, vector, hashMap);
                if (trace) {
                    System.out.println("Found X of Y coref pair: " + document.text(annotation2));
                }
            }
            if (object3 != null && (((String)object3).equals("all") || ((String)object3).equals("both")) && (annotation = (Annotation)annotation2.get("of")) != null) {
                Resolve.recordSyntacticCoref(annotation, annotation2, document, vector, hashMap);
                if (trace) {
                    System.out.println("Found X of Y coref pair: " + document.text(annotation2));
                }
            }
            if (linkAppositesAndPredComps && annotation2.get("apposite") != null) {
                annotation = (Annotation)annotation2.get("apposite");
                if (nameTypeMatch && !Resolve.typeMatch(document, annotation2, annotation)) continue;
                Resolve.recordSyntacticCoref(annotation, annotation2, document, vector, hashMap);
                if (trace) {
                    System.out.println("Refres: found apposition coref pair: " + document.text(annotation2));
                }
            }
            if (linkAppositesAndPredComps && annotation2.get("predComp") != null) {
                annotation = (Annotation)annotation2.get("predComp");
                if (!vector.contains(annotation) || nameTypeMatch && !Resolve.typeMatch(document, annotation2, annotation)) continue;
                Resolve.recordSyntacticCoref(annotation, annotation2, document, vector, hashMap);
                if (trace) {
                    System.out.println("Refres: found predComp coref pair: " + document.text(annotation2) + " = " + document.text(annotation));
                }
            }
            if (annotation2.get("paren") != null) {
                annotation = (Annotation)annotation2.get("paren");
                Resolve.recordSyntacticCoref(annotation, annotation2, document, vector, hashMap);
                if (trace) {
                    System.out.println("Refres: found parenthesized apposition coref pair: " + document.text(annotation2));
                }
            }
            if (annotation2.get("host") == null) continue;
            annotation = (Annotation)annotation2.get("host");
            Resolve.recordSyntacticCoref(annotation2, annotation, document, vector, hashMap);
        }
        for (int i = 0; i < vector2.size(); ++i) {
            Annotation annotation2;
            annotation2 = vector2.get(i);
            object4 = SynFun.getHead(document, annotation2);
            if (object4 == null) {
                System.err.println("No head for annotation " + annotation2 + " over " + document.text(annotation2));
                continue;
            }
            if (annotation2.get("subject") == null || "there".equalsIgnoreCase((String)(object2 = SynFun.getHead(document, (Annotation)(object3 = (Annotation)annotation2.get("subject"))))) || "it".equalsIgnoreCase((String)object2) || (object = (Annotation)annotation2.get("headC")) == null || ((Annotation)object).get("object") == null) continue;
            annotation = (Annotation)((Annotation)object).get("object");
            if (!((String)object4).equals("be") && !((String)object4).equals("become")) continue;
            Resolve.recordSyntacticCoref(annotation, (Annotation)object3, document, vector, hashMap);
            if (!trace) continue;
            System.out.println("Found copula relation: " + document.text(annotation2));
        }
        return hashMap;
    }

    private static void recordSyntacticCoref(Annotation annotation, Annotation annotation2, Document document, Vector<Annotation> vector, Map<Annotation, Annotation> map) {
        Annotation annotation3;
        int n = vector.indexOf(annotation2);
        if (n < 0) {
            System.err.println("Antecedent not in mentions: " + document.text(annotation2));
            return;
        }
        int n2 = vector.indexOf(annotation);
        if (n2 < 0) {
            System.err.println("Anaphor not in mentions: " + document.text(annotation));
            return;
        }
        if (n > n2) {
            vector.set(n, annotation);
            vector.set(n2, annotation2);
        }
        if ((annotation3 = map.get(annotation)) != null) {
            int n3;
            n = vector.indexOf(annotation2);
            if (n < (n3 = vector.indexOf(annotation3))) {
                map.put(annotation3, annotation2);
            } else {
                map.put(annotation, annotation2);
                map.put(annotation2, annotation3);
            }
        } else {
            map.put(annotation, annotation2);
        }
    }

    private static boolean typeMatch(Document document, Annotation annotation, Annotation annotation2) {
        String string;
        String string2 = EDTtype.bareType(EDTtype.getTypeSubtype(document, null, annotation));
        return string2.equals(string = EDTtype.bareType(EDTtype.getTypeSubtype(document, null, annotation2)));
    }

    public static void updateEvents(Document document, Span span, Map map) {
        for (int i = span.start(); i < span.end(); ++i) {
            Vector<Annotation> vector = document.annotationsAt(i, "event");
            if (vector == null) continue;
            Annotation annotation = vector.elementAt(0);
            FeatureSet featureSet = new FeatureSet(annotation.attributes());
            Enumeration enumeration = featureSet.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = featureSet.get(string);
                if (!map.containsKey(object)) continue;
                featureSet.put(string, map.get(object));
            }
            document.annotate("r-event", annotation.span(), featureSet);
        }
    }

    private static void resolveMention(Document document, Annotation annotation) {
        int n;
        Object object;
        ArrayList<Annotation> arrayList = null;
        if (fullParse) {
            arrayList = Hobbs.collectAntecedents(annotation, parents, document);
        }
        Annotation annotation2 = Resolve.getHeadC(annotation);
        String string = (String)annotation2.get("cat");
        int n2 = annotation.span().start();
        String string2 = SynFun.getHead(document, annotation);
        if (string2.equals("?") && string.equalsIgnoreCase("name") && (object = document.annotationsAt(n2, "ENAMEX")) != null && ((Vector)object).size() >= 1) {
            Annotation annotation3 = (Annotation)((Vector)object).firstElement();
            FeatureSet featureSet = annotation3.attributes();
            string2 = (String)featureSet.get("TYPE");
        }
        if (string2 == null) {
            return;
        }
        object = Resolve.getNameTokens(document, annotation);
        boolean bl = object != null;
        boolean bl2 = false;
        if (bl) {
            int n3 = n = annotation.get("cat") != "np" ? 1 : 0;
            if (n != 0 && Ace.gazetteer.isNationality((String[])object)) {
                bl2 = true;
            }
            object = Resolve.normalizeGazName((String[])object, n != 0, trace);
        }
        n = 9999;
        int n4 = 999;
        Annotation annotation4 = null;
        boolean bl3 = false;
        if (syntacticAntecedent.containsKey(annotation) && !Ace.perfectEntities) {
            Annotation annotation5;
            if (trace) {
                System.out.println("Using syntactically-determined antecedent.");
            }
            if ((annotation4 = mentionToEntity.get(annotation5 = syntacticAntecedent.get(annotation))) == null) {
                System.err.println("Resolve:  syntactic antecedent not in entity");
                System.err.println("          mention:    " + document.text(annotation));
                System.err.println("          antecedent: " + document.text(annotation5));
            }
        } else {
            for (int i = 0; i < entities.size(); ++i) {
                int n5;
                Object object2;
                String string3;
                int n6 = 0;
                Annotation annotation6 = entities.elementAt(i);
                boolean bl4 = false;
                if (Ace.perfectMentions & !Ace.perfectEntities) {
                    string3 = (String)annotation6.get("typeSubtype");
                    object2 = PerfectAce.getTypeSubtype(annotation2);
                    if (string3 != null && object2 != null && !((String)object2).equals("") && !((String)object2).equals(string3)) continue;
                }
                if (Ace.perfectEntities) {
                    string3 = PerfectAce.getEntityID(annotation2);
                    bl4 = annotation6.get("entityID") != null && annotation6.get("entityID").equals(string3);
                } else if (bl) {
                    n6 = Resolve.matchName((String[])object, string2, annotation6);
                    bl4 = n6 >= 0;
                } else if (string == "pro" || string == "det" || string == "np") {
                    string3 = string2.toLowerCase().intern();
                    bl4 = Resolve.matchPronoun(document, annotation, string3, annotation6);
                    bl3 = reflexives.contains(string3);
                } else if (string == "n" || string == "adj" || string == "ven" || string == "v" || string == "tv" || string == "hyphword" || string == "title" || string == "nnp" || string == "nnps" || string == "adv") {
                    bl4 = Resolve.matchNom(document, annotation, annotation6);
                } else if (string == "$") {
                    bl4 = false;
                } else if (string == "q") {
                    bl4 = false;
                } else {
                    System.err.println("Unexpected head cat " + string + " for " + document.text(annotation));
                    bl4 = false;
                    break;
                }
                if (!bl4) continue;
                boolean bl5 = false;
                if (bl3) {
                    object2 = (Annotation)annotation6.get("lastMention");
                    bl5 = Hobbs.sameSimplex((Annotation)object2, annotation, parents);
                }
                int n7 = n5 = bl3 & bl5 ? 0 : Resolve.distance(document, annotation6, annotation, fullParse, arrayList);
                if (n6 >= n4 && (n6 != n4 || n5 >= n)) continue;
                n = n5;
                n4 = n6;
                annotation4 = annotation6;
            }
        }
        if (annotation4 == null) {
            annotation4 = Resolve.createNewEntity(document, annotation, string2, bl2, entities);
        } else {
            if (annotation4.get("properAdjective") != null && !bl2) {
                annotation4.put("properAdjective", null);
            }
            if (trace) {
                Console.println("Resolving " + document.text(annotation) + " to " + document.text(annotation4));
            }
        }
        Resolve.addMentionToEntity(document, annotation, string2, (String[])object, annotation4, mentionToEntity);
    }

    static Annotation createNewEntity(Document document, Annotation annotation, String string, boolean bl, Vector<Annotation> vector) {
        boolean bl2;
        String string2;
        Annotation annotation2;
        Annotation annotation3;
        Annotation annotation4 = document.annotate("entity", annotation.span(), new FeatureSet("mentions", new Vector()));
        String string3 = SynFun.getNumber(annotation);
        if (string3 == null) {
            string3 = "singular";
        }
        if (string.equals("they") || string.equals("them") || string.equals("their") || string.equals("these") || string.equals("those") || string.equals("some") || string.equals("many") || string.equals("everybody") || string.equals("everyone")) {
            string3 = "plural";
        }
        if ((annotation3 = Resolve.getHeadC(annotation)).get("cat") == "q" && (annotation2 = document.tokenAt(annotation3.start())) != null && annotation2.get("intvalue") != null) {
            string3 = "plural";
        }
        annotation4.put("number", string3);
        if (EDTtype.isDictLoaded()) {
            string2 = EDTtype.getTypeSubtype(document, null, annotation);
            annotation4.put("ACEtype", string2);
            bl2 = EDTtype.bareType(string2).equals("PERSON");
        } else {
            bl2 = SynFun.getHuman(annotation) || string == "PERSON";
        }
        string2 = Resolve.nominativeFormOf(string);
        if (string2 == "he" || string2 == "she") {
            bl2 = true;
        }
        if (bl2) {
            annotation4.put("human", "t");
        }
        vector.addElement(annotation4);
        if (bl) {
            annotation4.put("properAdjective", "true");
        }
        if (Ace.perfectEntities) {
            annotation4.put("entityID", PerfectAce.getEntityID(Resolve.getHeadC(annotation)));
        }
        if (trace) {
            Console.println("Creating new entity for " + document.text(annotation));
        }
        return annotation4;
    }

    static void addMentionToEntity(Document document, Annotation annotation, String string, String[] stringArray, Annotation annotation2, Map<Annotation, Annotation> map) {
        Object object;
        boolean bl;
        annotation2.put("lastMention", annotation);
        annotation2.put("position", new Integer(annotation.span().start()));
        Vector vector = (Vector)annotation2.get("mentions");
        vector.addElement(annotation);
        map.put(annotation, annotation2);
        boolean bl2 = bl = stringArray != null;
        if (bl) {
            if (annotation2.get("name") == null) {
                annotation2.put("name", stringArray);
                object = Resolve.getNgHead(annotation);
                String[] stringArray2 = Tokenizer.gatherTokenStrings(document, ((Annotation)object).span());
                annotation2.put("nameWithMods", stringArray2);
                annotation2.put("nameType", string);
            }
        } else if (annotation2.get("head") == null) {
            annotation2.put("head", Resolve.nominativeFormOf(string));
        }
        Resolve.assignGenderFeature(string, stringArray, annotation2);
        if (Ace.perfectMentions && annotation2.get("typeSubtype") == null && (object = PerfectAce.getTypeSubtype(Resolve.getHeadC(annotation))) != null && !((String)object).equals("")) {
            annotation2.put("typeSubtype", object);
        }
    }

    static void assignGenderFeature(String string, String[] stringArray, Annotation annotation) {
        String string2 = string.toLowerCase();
        if (annotation.get("gender") != null) {
            return;
        }
        if (Resolve.in(string2, maleHeads)) {
            annotation.put("gender", "male");
        } else if (Resolve.in(string2, femaleHeads)) {
            annotation.put("gender", "female");
        } else if (string == "PERSON" && stringArray != null && genderDict != null) {
            String string3 = stringArray[0].toLowerCase();
            String string4 = genderDict.get(string3);
            if (string4 != null && string4.equals("M")) {
                annotation.put("gender", "male");
            } else if (string4 != null && string4.equals("F")) {
                annotation.put("gender", "female");
            }
        }
    }

    public static void readGenderDict(String string, Properties properties) {
        String string2 = properties.getProperty("NameGender.fileName");
        if (string2 == null) {
            return;
        }
        System.err.println("Reading gender dictionary " + string2);
        genderDict = new HashMap();
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string + File.separatorChar + string2));
            while ((string3 = bufferedReader.readLine()) != null) {
                String[] stringArray = string3.split(" +");
                String string4 = stringArray[0];
                String string5 = stringArray[1];
                genderDict.put(string4, string5);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println("Error in readGenderDict:" + iOException);
        }
    }

    static int distance(Document document, Annotation annotation, Annotation annotation2, boolean bl, ArrayList<Annotation> arrayList) {
        int n = annotation2.span().start();
        int n2 = 999999;
        Vector vector = (Vector)annotation.get("mentions");
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation3 = (Annotation)vector.get(i);
            int n3 = annotation3.span().start();
            int n4 = bl ? Hobbs.distance(document, annotation3, annotation2, arrayList, sentenceSet.sentences()) : sentenceSet.pseudoHobbsDistance(n3, n);
            n2 = Math.min(n2, n4);
        }
        return n2;
    }

    public static String[] normalizeGazName(String[] stringArray, boolean bl, boolean bl2) {
        String[] stringArray2;
        if (Ace.gazetteer == null) {
            return stringArray;
        }
        if (bl && Ace.gazetteer.isNationality(stringArray)) {
            stringArray2 = stringArray;
            stringArray = Ace.gazetteer.nationalityToCountry(stringArray);
            if (bl2) {
                System.out.println("Refres: using country " + Resolve.concat(stringArray) + " for nationality " + Resolve.concat(stringArray2));
            }
        }
        if (Ace.gazetteer.isCountryAlias(stringArray)) {
            stringArray2 = stringArray;
            stringArray = Ace.gazetteer.canonicalCountryName(stringArray);
            if (bl2) {
                System.out.println("Refres: using country " + Resolve.concat(stringArray) + " for alias " + Resolve.concat(stringArray2));
            }
        }
        return stringArray;
    }

    /*
     * Unable to fully structure code
     */
    static boolean matchNom(Document var0, Annotation var1_1, Annotation var2_2) {
        var3_3 = (Integer)var2_2.get("position");
        var4_4 = var1_1.span().start();
        var5_5 = ((Vector)var2_2.get("mentions")).size();
        var6_6 = SynFun.getHead(var0, var1_1);
        if (var6_6 == null) {
            return false;
        }
        var7_7 = SynFun.getDet(var1_1);
        var8_8 = SynFun.getNumber(var1_1);
        if (var8_8 == null) {
            var8_8 = "singular";
        }
        var9_9 = Resolve.getNgHead(var1_1);
        var10_10 = null;
        if (JetTest.conceptHierarchy != null) {
            var10_10 = JetTest.conceptHierarchy.getConceptFor(var6_6);
        }
        var11_11 = (String)var2_2.get("number");
        if (Resolve.in(var7_7, Resolve.indefiniteDets)) {
            return false;
        }
        if (var9_9.get("quant") != null || var7_7 == "q") {
            return false;
        }
        if (var9_9.get("poss") != null) {
            return false;
        }
        if (var8_8 != null && var11_11 != null && !var8_8.equals(var11_11)) {
            return false;
        }
        if (Resolve.nameNomCoref(var0, var7_7, var6_6, var1_1, var2_2)) {
            return true;
        }
        var12_12 = Resolve.getNgTokens(var0, var1_1);
        var13_13 = Resolve.getLeftModifierTokens(var0, var1_1);
        var14_14 = Resolve.getRightModifierTokens(var0, var1_1);
        var15_15 = Resolve.concat((String[])var13_13, (String[])var14_14);
        var16_16 = (Vector)var2_2.get("mentions");
        for (var17_17 = 0; var17_17 < var16_16.size(); ++var17_17) {
            block18: {
                var18_18 = (Annotation)var16_16.get(var17_17);
                var19_19 = Resolve.getHeadC(var18_18);
                var20_20 = (String)var19_19.get("cat");
                if (var20_20 == "pro" || var20_20 == "det") continue;
                var21_21 = SynFun.getDet(var18_18);
                var22_22 = SynFun.getHead(var0, var18_18);
                if (var22_22 == null) continue;
                var23_23 = null;
                if (JetTest.conceptHierarchy != null) {
                    var23_23 = JetTest.conceptHierarchy.getConceptFor(var22_22);
                }
                var24_24 = false;
                if (var10_10 == null || var23_23 == null) break block18;
                if (ConceptHierarchy.isaStar(var23_23, var10_10)) ** GOTO lbl-1000
            }
            if (var6_6.equals(var22_22) || var24_24) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = var25_25 = false;
            }
            if (!var25_25) continue;
            if (var21_21 == null && (var15_15.length > 0 || var7_7 != null)) {
                return false;
            }
            var26_26 = Resolve.getNgTokens(var0, var18_18);
            var27_27 = Resolve.getLeftModifierTokens(var0, var18_18);
            var28_28 = Resolve.getRightModifierTokens(var0, var18_18);
            var29_29 = Resolve.concat((String[])var27_27, (String[])var28_28);
            var30_30 = Resolve.intersect(var13_13, var27_27);
            var31_31 = Resolve.intersect(var14_14, var28_28);
            var32_32 = Resolve.intersect(var15_15, var29_29);
            if (!var30_30 || !var31_31) {
                if (Resolve.trace) {
                    System.out.println("Refres: modifier compability rejects merge of");
                    System.out.println("        " + var0.text(var18_18) + " and " + var0.text(var1_1));
                }
                return false;
            }
            if (Resolve.equalArray(var12_12, var26_26) && Resolve.equalArray(var14_14, var28_28)) {
                return true;
            }
            if (var5_5 == 1 && Resolve.sentenceSet.sentencesBetween(var3_3, var4_4) > 4) {
                return false;
            }
            if (var24_24) {
                System.out.println("******* WordNet allowed merge of ");
                System.out.println("        " + var0.text(var18_18) + " and " + var0.text(var1_1));
            }
            return true;
        }
        return false;
    }

    private static String[] getNgTokens(Document document, Annotation annotation) {
        Annotation annotation2 = Resolve.getNgHead(annotation);
        return Tokenizer.gatherTokenStrings(document, annotation2.span());
    }

    private static String[] getLeftModifierTokens(Document document, Annotation annotation) {
        Annotation annotation2 = Resolve.getNgHead(annotation);
        int n = annotation2.start();
        Annotation annotation3 = Resolve.getHeadC(annotation);
        int n2 = annotation3.start();
        int n3 = n;
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: while (n3 < n2) {
            Annotation annotation4;
            Vector<Annotation> vector = document.annotationsAt(n3, "constit");
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Annotation annotation5 = vector.get(i);
                    String string = (String)annotation5.get("cat");
                    if (string != "det" && string != "ving" && string != "ven") continue;
                    n3 = annotation5.span().end();
                    continue block0;
                }
            }
            if ((annotation4 = document.tokenAt(n3)) == null) {
                ++n3;
                continue;
            }
            String string = document.text(annotation4);
            if (string != null) {
                string = string.trim();
                arrayList.add(string);
            }
            n3 = annotation4.span().end();
            if (annotation4.span().start() != annotation4.span().end()) continue;
            ++n3;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String[] getRightModifierTokens(Document document, Annotation annotation) {
        int n;
        Annotation annotation2 = Resolve.getHeadC(annotation);
        int n2 = annotation2.end();
        if (n2 == (n = annotation.end())) {
            return new String[0];
        }
        String[] stringArray = Tokenizer.gatherTokenStrings(document, new Span(n2, n));
        if (stringArray.length > 0 && stringArray[0] == ",") {
            return new String[0];
        }
        return stringArray;
    }

    public static Annotation getNgHead(Annotation annotation) {
        Annotation annotation2 = annotation;
        while ((annotation = (Annotation)annotation2.get("headC")) != null) {
            if (annotation.get("cat") != "np") {
                return annotation2;
            }
            annotation2 = annotation;
        }
        return annotation2;
    }

    private static String[] getOfModifierTokens(Document document, Annotation annotation) {
        Annotation annotation2 = (Annotation)annotation.get("of");
        if (annotation2 == null) {
            return new String[0];
        }
        return Tokenizer.gatherTokenStrings(document, annotation2.span());
    }

    private static String[] concat(String[] stringArray, String[] stringArray2) {
        int n;
        if (stringArray.length == 0) {
            return stringArray2;
        }
        if (stringArray2.length == 0) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[n + stringArray.length] = stringArray2[n];
        }
        return stringArray3;
    }

    public static boolean nameNomCoref(Document document, String string, String string2, Annotation annotation, Annotation annotation2) {
        if (string == null) {
            return false;
        }
        if (!(string.equals("the") || string.equals("this") || string.equals("that"))) {
            return false;
        }
        String[] stringArray = (String[])annotation2.get("name");
        if (stringArray == null) {
            return false;
        }
        if (stringArray[0].equals("AP")) {
            return false;
        }
        return Resolve.nomInName(document, annotation, annotation2);
    }

    public static boolean nomInName(Document document, Annotation annotation, Annotation annotation2) {
        String[] stringArray = (String[])annotation2.get("nameWithMods");
        if (stringArray == null) {
            return false;
        }
        Annotation annotation3 = Resolve.getNgHead(annotation);
        String[] stringArray2 = Tokenizer.gatherTokenStrings(document, annotation3.span());
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].equalsIgnoreCase("the")) continue;
            boolean bl = false;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray2[i].equalsIgnoreCase(stringArray[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    static int matchName(String[] stringArray, String string, Annotation annotation) {
        String[] stringArray2 = (String[])annotation.get("name");
        if (stringArray2 == null) {
            return -1;
        }
        String string2 = (String)annotation.get("nameType");
        if (nameTypeMatch && !string.equals(string2)) {
            return -1;
        }
        int n = Resolve.matchFullName(stringArray, string, stringArray2, string2);
        if (n >= 0) {
            return n;
        }
        n = Resolve.matchFullName(stringArray2, string2, stringArray, string);
        if (n >= 0) {
            return n;
        }
        if (stringArray.length == 1) {
            n = Resolve.isAcronym(stringArray2, stringArray[0]);
            if (n >= 0) {
                return n;
            }
            n = Resolve.isAbbreviation(stringArray2, stringArray[0]);
            if (n >= 0) {
                return n;
            }
        }
        if (stringArray2.length == 1) {
            n = Resolve.isAcronym(stringArray, stringArray2[0]);
            if (n >= 0) {
                return n;
            }
            n = Resolve.isAbbreviation(stringArray, stringArray2[0]);
            if (n >= 0) {
                return n;
            }
        }
        return -1;
    }

    public static int matchFullName(String[] stringArray, String string, String[] stringArray2, String string2) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            while (n < stringArray2.length && !stringArray[i].equalsIgnoreCase(stringArray2[n])) {
                ++n;
            }
            if (n >= stringArray2.length) {
                return -1;
            }
            ++n;
        }
        if (stringArray.length < stringArray2.length) {
            if ((Ace.gazetteer.isNationality(stringArray) || Ace.gazetteer.isLocation(stringArray) || string == "GPE") && string2 != "PERSON") {
                if (trace) {
                    System.out.println("Refres: rejecting (location) " + Resolve.concat(stringArray) + " as alias of " + Resolve.concat(stringArray2));
                }
                return -1;
            }
            if (trace) {
                System.out.println("Refres: recognizing " + Resolve.concat(stringArray) + " as alias of " + Resolve.concat(stringArray2));
            }
        }
        return stringArray2.length - stringArray.length;
    }

    public static int isAcronym(String[] stringArray, String string) {
        if (stringArray.length < 2 || string.length() < 2) {
            return -1;
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            while (n < stringArray.length && 0 < stringArray[n].length() && stringArray[n].charAt(0) != string.charAt(i)) {
                ++n;
            }
            if (n >= stringArray.length) {
                return -1;
            }
            ++n;
        }
        if (trace) {
            System.out.println("Refres: recognizing " + string + " as acronym of " + Resolve.concat(stringArray));
        }
        return stringArray.length - string.length();
    }

    public static int isAbbreviation(String[] stringArray, String string) {
        if (stringArray.length < 2 || string.length() < 4 || string.length() % 2 == 1) {
            return -1;
        }
        int n = 0;
        for (int i = 0; i < string.length() / 2; ++i) {
            if (string.charAt(2 * i + 1) != '.') {
                return -1;
            }
            while (n < stringArray.length && stringArray[n].charAt(0) != string.charAt(2 * i)) {
                ++n;
            }
            if (n >= stringArray.length) {
                return -1;
            }
            ++n;
        }
        if (trace) {
            System.out.println("Refres: recognizing " + string + " as abbreviation of " + Resolve.concat(stringArray));
        }
        return stringArray.length - (string.length() - 2);
    }

    static String nominativeFormOf(String string) {
        if (nominative.containsKey(string)) {
            return nominative.get(string);
        }
        return string;
    }

    public static boolean matchPronoun(Document document, Annotation annotation, String string, Annotation annotation2) {
        boolean bl;
        if (annotation2.get("properAdjective") != null) {
            return false;
        }
        Annotation annotation3 = (Annotation)annotation2.get("lastMention");
        String string2 = (String)annotation3.get("cat");
        if (string2 != "np" && string2 != "det" && string2 != "ngroup") {
            return false;
        }
        int n = (Integer)annotation2.get("position");
        int n2 = annotation.span().start();
        String string3 = (String)annotation2.get("head");
        String string4 = Resolve.nominativeFormOf(string);
        if (string4 == "he") {
            bl = annotation2.get("human") != null && annotation2.get("number") == "singular" && annotation2.get("gender") != "female";
        } else if (string4 == "she") {
            bl = annotation2.get("human") != null && annotation2.get("number") == "singular" && annotation2.get("gender") != "male";
        } else if (string4 == "it") {
            bl = annotation2.get("human") == null && annotation2.get("number") == "singular";
        } else if (string4 == "they") {
            bl = annotation2.get("number") == "plural" || annotation2.get("nameType") == "ORGANIZATION" || annotation2.get("nameType") == "GPE";
        } else if (string4 == "I" || string4 == "i" || string4 == "we" || string4 == "you") {
            bl = string4.equals(string3);
        } else if (string == "some" || string == "either" || string == "neither" || string == "any" || string == "each" || string == "all" || string == "both" || string == "none" || string == "many" || string == "afew" || string == "most" || string == "q" || string == "one") {
            bl = false;
        } else if (string == "everyone" || string == "everything" || string == "everybody" || string == "nobody" || string == "noone" || string == "nothing" || string == "anyone" || string == "anything" || string == "anybody" || string == "someone" || string == "somebody" || string == "something" || string == "another") {
            bl = false;
        } else if (string == "this" || string == "these" || string == "that" || string == "those") {
            bl = false;
        } else {
            if (pronounsNotHandled.contains(string)) {
                System.err.println("Pronoun not being handled:  " + string);
                pronounsNotHandled.add(string);
            }
            bl = false;
        }
        return bl;
    }

    public static String normalizeName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    public static String concat(String[] stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        String string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string = string + " " + stringArray[i];
        }
        return string;
    }

    public static boolean isName(Annotation annotation) {
        return annotation != null && annotation.get("cat") == "name";
    }

    public static Annotation getHeadC(Annotation annotation) {
        while (annotation.get("headC") != null) {
            annotation = (Annotation)annotation.get("headC");
        }
        return annotation;
    }

    public static String[] getNameTokens(Document document, Annotation annotation) {
        Annotation annotation2 = Resolve.getHeadC(annotation);
        if (annotation2.get("cat") != "name") {
            return null;
        }
        return Tokenizer.gatherTokenStrings(document, annotation2.span());
    }

    public static String[] getHeadTokens(Document document, Annotation annotation) {
        Annotation annotation2 = Resolve.getHeadC(annotation);
        return Tokenizer.gatherTokenStrings(document, annotation2.span());
    }

    public static boolean in(Object object, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || !objectArray[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean intersect(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length == 0) {
            return true;
        }
        if (objectArray2.length == 0) {
            return true;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!Resolve.in(objectArray[i], objectArray2)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalArray(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null && objectArray[i].equals(objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    static {
        fullParse = false;
        linkAppositesAndPredComps = true;
        nameTypeMatch = false;
        trace = true;
        parseTree = null;
        parents = null;
        useMaxEnt = false;
        ACE = false;
        maleHeads = new String[]{"mr", "mr.", "husband", "father", "grandfather", "son", "grandson", "uncle", "brother", "man", "gentleman", "sir", "boy", "boyfriend", "groom", "bridegroom"};
        femaleHeads = new String[]{"mrs", "mrs.", "ms", "ms.", "wife", "mother", "grandmother", "daughter", "granddaughter", "aunt", "sister", "woman", "lady", "girl", "girlfriend", "bride"};
        genderDict = null;
        definiteDets = new String[]{"the", "this", "these", "that", "those"};
        indefiniteDets = new String[]{"few", "afew", "more", "many", "most", "some", "any", "several", "less", "neither", "another", "such", "no", "either"};
        genericPersonTerms = new String[]{"man", "human", "person", "individual", "gentleman", "fellow", "boy", "woman", "lady", "girl", "official", "player", "diplomat", "chairman", "officer", "executive", "leader", "lawyer", "friend", "father", "president", "spokesman", "governor", "coach", "attorney", "member", "director", "body"};
        genericOrganizationTerms = new String[]{"academy", "administration", "agency", "airline", "army", "association", "board", "business", "college", "church", "company", "corporation", "establishment", "institute", "institution", "firm", "group", "military", "office", "panel", "partnership", "party", "police", "school", "synagogue", "syndicate", "team", "trust", "union", "university", "organization", "cathedral", "coalition", "temple", "bank", "commission", "committee", "council", "court", "department", "division", "federation", "force", "guild", "industry", "mosque", "league", "parliament", "seminary", "society"};
        genericCountryTerms = new String[]{"government", "country", "nation", "people", "kingdom"};
        genericStateTerms = new String[]{"state"};
        genericGpeTerms = new String[]{"village", "capital", "metropolis", "capital", "city", "town", "province"};
        genericLocationTerms = new String[]{"area", "region", "mount", "mountain", "hill", "ridge", "lake", "pond", "ocean", "sea", "river", "creek", "brook", "bayou", "stream"};
        genericFacilityTerms = new String[]{"tower", "castle", "hotel", "palace", "hall", "house", "road", "route", "bridge", "pass", "tunnel", "home", "street", "stadium"};
        nominative = new HashMap();
        nominative.put("me", "i");
        nominative.put("my", "i");
        nominative.put("myself", "i");
        nominative.put("your", "you");
        nominative.put("yourself", "you");
        nominative.put("him", "he");
        nominative.put("his", "he");
        nominative.put("himself", "he");
        nominative.put("her", "she");
        nominative.put("hers", "she");
        nominative.put("herself", "she");
        nominative.put("its", "it");
        nominative.put("itself", "it");
        nominative.put("us", "we");
        nominative.put("our", "we");
        nominative.put("ourselves", "we");
        nominative.put("them", "they");
        nominative.put("their", "they");
        nominative.put("themselves", "they");
        reflexives = new HashSet();
        reflexives.add("myself");
        reflexives.add("yourself");
        reflexives.add("himself");
        reflexives.add("herself");
        reflexives.add("itself");
        reflexives.add("ourselves");
        reflexives.add("themselves");
    }
}

