/*
 * Decompiled with CFR 0.152.
 */
package Jet.Pat;

import Jet.Console;
import Jet.JetTest;
import Jet.Pat.Action;
import Jet.Pat.PatternCollection;
import Jet.Pat.PatternRule;
import Jet.Pat.PatternSet;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public class PatternApplication {
    public boolean matchFound = false;
    Document document;
    public int startPosition;
    public int bestPosition;
    public String bestPatternName;
    public HashMap bestBindings;
    public Vector bestActions;
    public static boolean patternMatchTrace = false;
    public static boolean patternApplyTrace = false;
    private static Hashtable matchTracedPatterns = new Hashtable();
    private static Hashtable applyTracedPatterns = new Hashtable();
    private static JCheckBoxMenuItem item;
    private static String patternName;
    private static String patternSetName;
    private static JMenu matchSubmenu;
    private static JMenu applySubmenu;
    private static int numOfPatterns;
    private static int numOfApplyPatterns;
    private static PatternCollection pc;
    private static PatternSet ps;
    private static PatternRule pr;

    public PatternApplication(Document document, int n) {
        this.document = document;
        this.startPosition = n;
        this.bestPosition = -1;
    }

    public void recordMatch(int n, String string, HashMap hashMap, Vector vector) {
        Object v = matchTracedPatterns.get(string);
        if (v != null && v.equals("true")) {
            Console.println("Matched pattern " + string + " over " + this.document.text(new Span(this.startPosition, n)));
            if (Console.pv != null) {
                Console.pv.addMatchedPattern(string);
                Console.pv.refresh();
            }
        }
        if (n > this.bestPosition) {
            this.matchFound = true;
            this.bestPosition = n;
            this.bestPatternName = string;
            this.bestBindings = hashMap;
            this.bestActions = vector;
        }
    }

    public int performActions() {
        if (this.matchFound) {
            int n = -1;
            Object v = applyTracedPatterns.get(this.bestPatternName);
            if (v != null && v.equals("true")) {
                Console.println("Applying pattern " + this.bestPatternName + " over " + this.document.text(new Span(this.startPosition, this.bestPosition)));
                if (Console.pv != null) {
                    Console.pv.addAppliedPattern(this.bestPatternName);
                    Console.pv.refresh();
                }
            }
            for (int i = 0; i < this.bestActions.size(); ++i) {
                Action action = (Action)this.bestActions.get(i);
                n = Math.max(n, action.perform(this.document, this));
            }
            return n;
        }
        return -1;
    }

    public static JMenu patternMenu() {
        JMenu jMenu = new JMenu("Patterns");
        jMenu.setMnemonic(80);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("Pattern Match Trace", patternMatchTrace);
        jCheckBoxMenuItem.setMnemonic(77);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                patternMatchTrace = jCheckBoxMenuItem.getState();
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("Pattern Apply Trace", patternApplyTrace);
        jCheckBoxMenuItem2.setMnemonic(65);
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                patternApplyTrace = jCheckBoxMenuItem2.getState();
            }
        });
        jMenu.add(jCheckBoxMenuItem2);
        return jMenu;
    }

    public static JMenu matchSubmenu() {
        pc = JetTest.pc;
        numOfPatterns = PatternApplication.pc.patternNames.size();
        matchSubmenu = new JMenu("Pattern Match Trace");
        matchSubmenu.setMnemonic(77);
        item = new JCheckBoxMenuItem("All");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBoxMenuItem)actionEvent.getSource()).getState()) {
                    for (int i = 2; i < numOfPatterns + 2; ++i) {
                        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)matchSubmenu.getItem(i);
                        jCheckBoxMenuItem.setState(true);
                        matchTracedPatterns.put(jCheckBoxMenuItem.getText(), "true");
                    }
                } else {
                    for (int i = 2; i < numOfPatterns + 2; ++i) {
                        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)matchSubmenu.getItem(i);
                        jCheckBoxMenuItem.setState(false);
                        matchTracedPatterns.put(jCheckBoxMenuItem.getText(), "false");
                    }
                }
            }
        });
        matchSubmenu.add(item);
        matchSubmenu.addSeparator();
        for (int i = 0; i < numOfPatterns; ++i) {
            patternName = (String)PatternApplication.pc.patternNames.get(i);
            item = new JCheckBoxMenuItem(patternName);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (((JCheckBoxMenuItem)actionEvent.getSource()).getState()) {
                        matchTracedPatterns.put(actionEvent.getActionCommand(), "true");
                    } else {
                        matchTracedPatterns.put(actionEvent.getActionCommand(), "false");
                        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)matchSubmenu.getItem(0);
                        jCheckBoxMenuItem.setState(false);
                    }
                }
            });
            matchSubmenu.add(item);
        }
        return matchSubmenu;
    }

    public static JMenu applySubmenu() {
        pc = JetTest.pc;
        numOfApplyPatterns = 0;
        applySubmenu = new JMenu("Pattern Apply Trace");
        applySubmenu.setMnemonic(65);
        item = new JCheckBoxMenuItem("All");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBoxMenuItem)actionEvent.getSource()).getState()) {
                    for (int i = 2; i < numOfApplyPatterns + 2; ++i) {
                        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)applySubmenu.getItem(i);
                        jCheckBoxMenuItem.setState(true);
                        applyTracedPatterns.put(jCheckBoxMenuItem.getText(), "true");
                    }
                } else {
                    for (int i = 2; i < numOfApplyPatterns + 2; ++i) {
                        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)applySubmenu.getItem(i);
                        jCheckBoxMenuItem.setState(false);
                        applyTracedPatterns.put(jCheckBoxMenuItem.getText(), "false");
                    }
                }
            }
        });
        applySubmenu.add(item);
        applySubmenu.addSeparator();
        for (int i = 0; i < PatternApplication.pc.patternSetNames.size(); ++i) {
            patternSetName = (String)PatternApplication.pc.patternSetNames.get(i);
            ps = (PatternSet)PatternApplication.pc.patternSets.get(patternSetName);
            for (int j = 0; j < PatternApplication.ps.rules.size(); ++j) {
                pr = (PatternRule)PatternApplication.ps.rules.get(j);
                item = new JCheckBoxMenuItem(PatternApplication.pr.patternName);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (((JCheckBoxMenuItem)actionEvent.getSource()).getState()) {
                            applyTracedPatterns.put(actionEvent.getActionCommand(), "true");
                        } else {
                            applyTracedPatterns.put(actionEvent.getActionCommand(), "false");
                            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)applySubmenu.getItem(0);
                            jCheckBoxMenuItem.setState(false);
                        }
                    }
                });
                applySubmenu.add(item);
            }
            numOfApplyPatterns += PatternApplication.ps.rules.size();
        }
        return applySubmenu;
    }
}

