/*
 * Decompiled with CFR 0.152.
 */
package Jet.NE;

import Jet.Lisp.FeatureSet;
import Jet.NE.Dictionary;
import Jet.NE.DictionaryTagger;
import Jet.NE.NamedEntityAttribute;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import edu.umass.cs.mallet.base.pipe.Pipe;
import edu.umass.cs.mallet.base.types.Instance;
import edu.umass.cs.mallet.base.types.Token;
import edu.umass.cs.mallet.base.types.TokenSequence;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;

public class NamedEntityInDictionaryFeature
extends Pipe {
    private String prefix;

    public NamedEntityInDictionaryFeature(String string) {
        this.prefix = string;
    }

    public Instance pipe(Instance instance) {
        TokenSequence tokenSequence = (TokenSequence)instance.getData();
        Dictionary dictionary = (Dictionary)instance.getProperty("dictionary");
        if (dictionary == null) {
            return instance;
        }
        Document document = (Document)instance.getProperty("document");
        Span span = (Span)instance.getProperty("span");
        DictionaryTagger dictionaryTagger = new DictionaryTagger();
        dictionaryTagger.setDictionary(dictionary);
        Logger.global.info(Integer.toString(tokenSequence.size()));
        this.annotateNETokens(document, tokenSequence);
        dictionaryTagger.annotate(document, span);
        Vector<Annotation> vector = document.annotationsOfType("NE_INTERNAL", span);
        assert (tokenSequence.size() == vector.size()) : tokenSequence.size() + " != " + vector.size();
        for (int i = 0; i < vector.size(); ++i) {
            Token token = tokenSequence.getToken(i);
            Annotation annotation = (Annotation)vector.get(i);
            Set set = (Set)annotation.get("categories");
            for (NamedEntityAttribute namedEntityAttribute : set) {
                String string = namedEntityAttribute.toString();
                String string2 = (this.prefix + string).intern();
                token.setFeatureValue(string2, 1.0);
            }
        }
        document.removeAnnotationsOfType("NE_INTERNAL");
        return instance;
    }

    private void annotateNETokens(Document document, TokenSequence tokenSequence) {
        for (int i = 0; i < tokenSequence.size(); ++i) {
            Token token = tokenSequence.getToken(i);
            Span span = (Span)token.getProperty("span");
            HashSet hashSet = new HashSet();
            FeatureSet featureSet = new FeatureSet();
            featureSet.put("categories", hashSet);
            document.annotate("NE_INTERNAL", span, featureSet);
        }
    }
}

