/*
 * Decompiled with CFR 0.152.
 */
package Jet.NE;

import Jet.NE.ClassHierarchyResolver;
import Jet.NE.MatchType;
import Jet.NE.NamedEntityAttribute;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassRule {
    private static Pattern hourMinutePattern = Pattern.compile("(\\d{1,2}):(\\d{2})");
    private static final int YEAR_MIN = 1000;
    private static final int YEAR_MAX = 2030;
    private MatchType type;
    private String[] categories;

    public ClassRule(MatchType matchType, String[] stringArray) {
        this.type = matchType;
        this.categories = stringArray;
    }

    public boolean accept(Document document, Annotation[] annotationArray, int n, ClassHierarchyResolver classHierarchyResolver) {
        if (this.type == MatchType.ANY) {
            return true;
        }
        if (this.type == MatchType.SPECIAL) {
            if (this.categories.length != 1) {
                throw new UnsupportedOperationException();
            }
            try {
                SpecialType specialType = SpecialType.valueOf(this.categories[0]);
                return specialType.accept(document, annotationArray, n, classHierarchyResolver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = this.categories[0] + " is not supported.";
                throw new UnsupportedOperationException(string);
            }
        }
        boolean bl = false;
        Set set = (Set)annotationArray[n].get("categories");
        block6: for (NamedEntityAttribute namedEntityAttribute : set) {
            for (String string : this.categories) {
                if (!classHierarchyResolver.isSubClassOf(namedEntityAttribute.getCategory(), string)) continue;
                bl = true;
                break block6;
            }
        }
        switch (this.type) {
            case NORMAL: {
                return bl;
            }
            case NOT: {
                return !bl;
            }
        }
        throw new InternalError();
    }

    static boolean isCapital(Document document, Annotation[] annotationArray, int n) {
        String string = document.text(annotationArray[n]).trim();
        if (string.length() == 0 || !Character.isUpperCase(string.charAt(0))) {
            return false;
        }
        String string2 = (String)annotationArray[n].get("pos");
        if (string2 != null && (string2.equals("NNP") || string2.equals("NNPS"))) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        String string3 = document.text(annotationArray[n - 1]).trim();
        return !string3.equals("\"") && !string3.equals("``") && !string3.equals("`");
    }

    static boolean isYear(String string) {
        if (string.length() != 4) {
            return false;
        }
        try {
            int n = Integer.parseInt(string);
            if (n < 1000 || n > 2030) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    static boolean isTwoDigitYear(String string) {
        if (string.length() != 2) {
            return false;
        }
        return Character.isDigit(string.charAt(0)) && Character.isDigit(string.charAt(1));
    }

    static boolean isHourMinute(String string) {
        Matcher matcher = hourMinutePattern.matcher(string);
        if (!matcher.matches()) {
            return false;
        }
        int n = Integer.parseInt(matcher.group(1));
        int n2 = Integer.parseInt(matcher.group(2));
        if (n < 0 || n > 24) {
            return false;
        }
        return n2 >= 0 && n2 <= 60;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SpecialType {
        CAPITAL{

            public boolean accept(Document document, Annotation[] annotationArray, int n, ClassHierarchyResolver classHierarchyResolver) {
                return ClassRule.isCapital(document, annotationArray, n);
            }
        }
        ,
        DCAPITAL{

            public boolean accept(Document document, Annotation[] annotationArray, int n, ClassHierarchyResolver classHierarchyResolver) {
                return !ClassRule.isCapital(document, annotationArray, n);
            }
        }
        ,
        YEAR{

            public boolean accept(Document document, Annotation[] annotationArray, int n, ClassHierarchyResolver classHierarchyResolver) {
                String string = document.normalizedText(annotationArray[n]);
                return ClassRule.isYear(string);
            }
        }
        ,
        HOUR_MINUTE{

            public boolean accept(Document document, Annotation[] annotationArray, int n, ClassHierarchyResolver classHierarchyResolver) {
                String string = document.normalizedText(annotationArray[n]);
                return ClassRule.isHourMinute(string);
            }
        }
        ,
        TWO_DIGIT_YEAR{

            public boolean accept(Document document, Annotation[] annotationArray, int n, ClassHierarchyResolver classHierarchyResolver) {
                String string = document.normalizedText(annotationArray[n]);
                return ClassRule.isTwoDigitYear(string);
            }
        };


        abstract boolean accept(Document var1, Annotation[] var2, int var3, ClassHierarchyResolver var4);
    }
}

