/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import Jet.JetTest;
import Jet.Lex.Lexicon;
import Jet.Lisp.FeatureSet;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class Gazetteer {
    HashMap<String, String> nationalityToCountry = new HashMap();
    HashMap<String, String> nationalToCountry = new HashMap();
    HashMap<String, String> nationalsToCountry = new HashMap();
    HashMap<String, String> aliasToCountry = new HashMap();
    HashMap<String, String> capitalToCountry = new HashMap();
    HashMap<String, String> locations = new HashMap();
    LineNumberReader reader;
    boolean monocase = false;
    HashMap<String, String> monocaseMap = new HashMap();

    public void load() throws IOException {
        String string = JetTest.getConfigFile("Gazetteer.fileName");
        if (string != null) {
            this.load(string);
        } else {
            System.err.println("Gazetteer.load:  no file name specified in config file");
        }
    }

    public void load(String string) throws IOException {
        System.err.println("Loading gazetteer.");
        this.reader = new LineNumberReader(new FileReader(string));
        StreamTokenizer streamTokenizer = new StreamTokenizer(this.reader);
        while (streamTokenizer.nextToken() != -1) {
            this.readGazetteerEntry(streamTokenizer);
        }
        for (String string2 : this.locations.keySet()) {
            Lexicon.addEntry(Gazetteer.splitAtWS(string2), new FeatureSet("TYPE", "GPE", "SUBTYPE", this.aceSubtype(this.locations.get(string2))), "onoma");
        }
    }

    private String aceSubtype(String string) {
        if (string.equals("continent")) {
            return "Continent";
        }
        if (string.equals("region")) {
            return "Region-International";
        }
        if (string.equals("country")) {
            return "Nation";
        }
        if (string.equals("usstate")) {
            return "State-or-Province";
        }
        return "Population-Center";
    }

    private void readGazetteerEntry(StreamTokenizer streamTokenizer) throws IOException {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        do {
            int n;
            if (streamTokenizer.ttype != -3) {
                n = this.reader.getLineNumber();
                System.err.println("*** Syntax error in gazetteer: " + streamTokenizer);
                return;
            }
            String string6 = streamTokenizer.sval.intern();
            if (streamTokenizer.nextToken() != 34) {
                n = this.reader.getLineNumber();
                System.err.println("*** Syntax error in gazetteer, line" + n);
                return;
            }
            String string7 = streamTokenizer.sval;
            this.monocaseMap.put(string7.toLowerCase(), string7);
            if (string6 == "country" || string6 == "continent" || string6 == "region" || string6 == "usstate" || string6 == "city") {
                string = string7;
                string2 = string6;
                this.locations.put(string7, string6);
                continue;
            }
            if (string6 == "nationality") {
                string3 = string7;
                this.nationalityToCountry.put(string3, string);
                continue;
            }
            if (string6 == "aka") {
                this.aliasToCountry.put(string7, string);
                this.locations.put(string7, string2);
                continue;
            }
            if (string6 == "national") {
                string4 = string7;
                continue;
            }
            if (string6 == "nationals") {
                string5 = string7;
                continue;
            }
            if (string6 == "capital") {
                this.capitalToCountry.put(string7, string);
                this.locations.put(string7, "city");
                continue;
            }
            n = this.reader.getLineNumber();
            System.err.println("*** Syntax error in gazetteer, line" + n);
        } while (streamTokenizer.nextToken() != 59);
        if (string2 == "country" && string3 != "") {
            if (string4 == "") {
                string4 = string3;
            }
            if (string5 == "") {
                string5 = string4 + "s";
                this.monocaseMap.put(string5.toLowerCase(), string5);
            }
            this.nationalToCountry.put(string4, string);
            this.nationalsToCountry.put(string5, string);
        }
    }

    public void setMonocase(boolean bl) {
        this.monocase = bl;
    }

    public boolean isNationality(String[] stringArray) {
        return this.nationalityToCountry.containsKey(this.foldArg(stringArray));
    }

    public String[] nationalityToCountry(String[] stringArray) {
        return Gazetteer.splitAtWS(this.nationalityToCountry.get(this.foldArg(stringArray)));
    }

    public boolean isNational(String[] stringArray) {
        return this.nationalToCountry.containsKey(this.foldArg(stringArray));
    }

    public String[] nationalToCountry(String[] stringArray) {
        return Gazetteer.splitAtWS(this.nationalToCountry.get(this.foldArg(stringArray)));
    }

    public boolean isNationals(String[] stringArray) {
        return this.nationalsToCountry.containsKey(this.foldArg(stringArray));
    }

    public String[] nationalsToCountry(String[] stringArray) {
        return Gazetteer.splitAtWS(this.nationalsToCountry.get(this.foldArg(stringArray)));
    }

    public String[] capitalToCountry(String[] stringArray) {
        return Gazetteer.splitAtWS(this.capitalToCountry.get(this.foldArg(stringArray)));
    }

    public boolean isLocation(String[] stringArray) {
        return this.locations.containsKey(this.foldArg(stringArray));
    }

    public boolean isCountry(String[] stringArray) {
        return this.locations.get(this.foldArg(stringArray)) == "country";
    }

    public boolean isCountryAlias(String[] stringArray) {
        return this.aliasToCountry.containsKey(this.foldArg(stringArray));
    }

    public boolean isState(String[] stringArray) {
        return this.locations.get(this.foldArg(stringArray)) == "usstate";
    }

    public boolean isRegionOrContinent(String[] stringArray) {
        String string = this.locations.get(this.foldArg(stringArray));
        return string == "region" || string == "continent";
    }

    public String[] canonicalCountryName(String[] stringArray) {
        return Gazetteer.splitAtWS(this.aliasToCountry.get(this.foldArg(stringArray)));
    }

    public static void main(String[] stringArray) throws IOException {
        Gazetteer gazetteer = new Gazetteer();
        gazetteer.load("data/loc.dict");
        gazetteer.setMonocase(true);
        System.out.println(gazetteer.isNationals(new String[]{"palestinians"}));
    }

    public static String[] splitAtWS(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private String foldArg(String[] stringArray) {
        String string = Resolve.concat(stringArray);
        if (this.monocase && this.monocaseMap.containsKey(string)) {
            string = this.monocaseMap.get(string);
        }
        return string;
    }

    public String locationType(Document document, String string) {
        Object object;
        String[] stringArray = string.split(" ");
        if (this.isCountry(stringArray) || this.isNationality(stringArray)) {
            return "country";
        }
        if (this.isState(stringArray)) {
            return "stateorprovince";
        }
        if (this.capitalToCountry(stringArray) != null) {
            return "city";
        }
        Vector<Annotation> vector = document.annotationsOfType("entity");
        if (vector != null) {
            object = vector.iterator();
            block0: while (object.hasNext()) {
                Annotation annotation = object.next();
                String[] stringArray2 = (String[])annotation.get("name");
                if (stringArray2 == null || stringArray2.length != stringArray.length) continue;
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!stringArray2[i].equals(stringArray[i])) continue block0;
                }
                Vector vector2 = (Vector)annotation.get("mentions");
                for (Annotation annotation2 : vector2) {
                    Object object2 = annotation2.get("pa");
                    if (!(object2 instanceof FeatureSet)) continue;
                    FeatureSet featureSet = (FeatureSet)object2;
                    String string2 = (String)featureSet.get("head");
                    if (string2.equals("city")) {
                        return "city";
                    }
                    if (string2.equals("town")) {
                        return "city";
                    }
                    if (string2.equals("village")) {
                        return "city";
                    }
                    if (string2.equals("port")) {
                        return "city";
                    }
                    if (string2.equals("province")) {
                        return "stateorprovince";
                    }
                    if (string2.equals("state")) {
                        return "stateorprovince";
                    }
                    if (string2.equals("county")) {
                        return "stateorprovince";
                    }
                    if (!string2.equals("district")) continue;
                    return "stateorprovince";
                }
            }
        }
        if (((String)(object = stringArray[stringArray.length - 1])).equals("Province")) {
            return "stateorprovince";
        }
        if (((String)object).equals("District")) {
            return "stateorprovince";
        }
        if (((String)object).equals("County")) {
            return "stateorprovince";
        }
        if (((String)object).equals("State")) {
            return "stateorprovince";
        }
        if (((String)object).equals("City")) {
            return "city";
        }
        return null;
    }
}

