/*
 * Decompiled with CFR 0.152.
 */
package opennlp.model;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import opennlp.maxent.io.BinaryGISModelWriter;
import opennlp.maxent.io.PlainTextGISModelWriter;
import opennlp.model.AbstractModel;
import opennlp.model.AbstractModelWriter;
import opennlp.perceptron.BinaryPerceptronModelWriter;
import opennlp.perceptron.PlainTextPerceptronModelWriter;

public class GenericModelWriter
extends AbstractModelWriter {
    private AbstractModelWriter delegateWriter;

    public GenericModelWriter(AbstractModel abstractModel, File file) throws IOException {
        OutputStream outputStream;
        String string = file.getName();
        if (string.endsWith(".gz")) {
            outputStream = new GZIPOutputStream(new FileOutputStream(file));
            string = string.substring(0, string.length() - 3);
        } else {
            outputStream = new FileOutputStream(file);
        }
        if (string.endsWith(".bin")) {
            this.init(abstractModel, new DataOutputStream(outputStream));
        } else {
            this.init(abstractModel, new BufferedWriter(new OutputStreamWriter(outputStream)));
        }
    }

    public GenericModelWriter(AbstractModel abstractModel, DataOutputStream dataOutputStream) {
        this.init(abstractModel, dataOutputStream);
    }

    private void init(AbstractModel abstractModel, DataOutputStream dataOutputStream) {
        if (abstractModel.getModelType() == AbstractModel.ModelType.Perceptron) {
            this.delegateWriter = new BinaryPerceptronModelWriter(abstractModel, dataOutputStream);
        } else if (abstractModel.getModelType() == AbstractModel.ModelType.Maxent) {
            this.delegateWriter = new BinaryGISModelWriter(abstractModel, dataOutputStream);
        }
    }

    private void init(AbstractModel abstractModel, BufferedWriter bufferedWriter) {
        if (abstractModel.getModelType() == AbstractModel.ModelType.Perceptron) {
            this.delegateWriter = new PlainTextPerceptronModelWriter(abstractModel, bufferedWriter);
        } else if (abstractModel.getModelType() == AbstractModel.ModelType.Maxent) {
            this.delegateWriter = new PlainTextGISModelWriter(abstractModel, bufferedWriter);
        }
    }

    public void close() throws IOException {
        this.delegateWriter.close();
    }

    public void persist() throws IOException {
        this.delegateWriter.persist();
    }

    public void writeDouble(double d) throws IOException {
        this.delegateWriter.writeDouble(d);
    }

    public void writeInt(int n) throws IOException {
        this.delegateWriter.writeInt(n);
    }

    public void writeUTF(String string) throws IOException {
        this.delegateWriter.writeUTF(string);
    }
}

