/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tratz.featgen.CombinationEntry;
import tratz.featgen.MultiStepFeatureGeneratorConfigParser;
import tratz.featgen.WfrEntry;
import tratz.featgen.fer.FERProductionException;
import tratz.featgen.fer.FeatureExtractionRule;
import tratz.parse.types.Parse;
import tratz.parse.types.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiStepFeatureGenerator
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static Map<FeatureExtractionRule, Long> ferTimes = new HashMap<FeatureExtractionRule, Long>();
    protected WfrEntry[] mWfrEntries;
    protected CombinationEntry[] mComboEntries;

    public MultiStepFeatureGenerator() {
    }

    public MultiStepFeatureGenerator(String wfrRulesFile, String ferRulesFile, String comboRulesFile) throws Exception {
        MultiStepFeatureGeneratorConfigParser configReader = new MultiStepFeatureGeneratorConfigParser();
        Map<String, FeatureExtractionRule> featureRuleMap = configReader.readFeatureExtractionRuleMap(ferRulesFile);
        this.mWfrEntries = configReader.readComplexRules(wfrRulesFile, featureRuleMap);
        this.mComboEntries = configReader.readCombinationEntries(new File(comboRulesFile));
    }

    public Set<String> generateFeatures(List<Token> tokens, Parse parse, int wordIndex) {
        HashSet<String> feats = new HashSet<String>();
        HashMap fullPrefixToProductions = new HashMap();
        HashMap tokenToFerToProductions = new HashMap();
        for (WfrEntry wfrEntry : this.mWfrEntries) {
            Set<Token> wfrResults = wfrEntry.getWfrRule().getProductions(tokens, parse, wordIndex);
            if (wfrResults == null || wfrResults.size() <= 0) continue;
            List<FeatureExtractionRule> fers = wfrEntry.getFERs();
            for (FeatureExtractionRule fer : fers) {
                long start = System.nanoTime();
                for (Token token : wfrResults) {
                    try {
                        HashMap<FeatureExtractionRule, Set<String>> ferToFeats = (HashMap<FeatureExtractionRule, Set<String>>)tokenToFerToProductions.get(token);
                        Set<String> productions = null;
                        if (ferToFeats == null) {
                            ferToFeats = new HashMap<FeatureExtractionRule, Set<String>>();
                            tokenToFerToProductions.put(token, ferToFeats);
                        }
                        if ((productions = (Set<String>)ferToFeats.get(fer)) == null && (productions = fer.getProductions(token.getText(), token.getPos())) != null) {
                            ferToFeats.put(fer, productions);
                        }
                        if (productions == null) continue;
                        String fullPrefix = wfrEntry.getPrefix() + ":" + fer.getPrefix() + ":";
                        HashSet<String> prod = (HashSet<String>)fullPrefixToProductions.get(fullPrefix);
                        if (prod == null) {
                            prod = new HashSet<String>(productions.size());
                            fullPrefixToProductions.put(fullPrefix, prod);
                        }
                        for (String production : productions) {
                            prod.add(production);
                        }
                    }
                    catch (FERProductionException ferp) {
                        ferp.printStackTrace();
                    }
                }
                Long time = ferTimes.get(fer);
                if (time == null) {
                    time = new Long(0L);
                    ferTimes.put(fer, time);
                }
                ferTimes.put(fer, time + (System.nanoTime() - start));
            }
        }
        for (Serializable serializable : this.mComboEntries) {
            Set feats1 = (Set)fullPrefixToProductions.get(((CombinationEntry)serializable).getFullPrefix1());
            Set feats2 = (Set)fullPrefixToProductions.get(((CombinationEntry)serializable).getFullPrefix2());
            CombinationEntry.ComboType comboType = ((CombinationEntry)serializable).getComboType();
            String comboPrefix = ((CombinationEntry)serializable).getComboPrefix();
            Set<String> comboResults = null;
            if (comboType == CombinationEntry.ComboType.CROSS_PRODUCT) {
                comboResults = this.cross(feats1, feats2);
            } else if (comboType == CombinationEntry.ComboType.INTERSECTION) {
                comboResults = this.intersect(feats1, feats2);
            } else if (comboType == CombinationEntry.ComboType.UNION) {
                comboResults = this.union(feats1, feats2);
            }
            if (comboResults == null) continue;
            String prefix = comboPrefix + ":";
            for (String result : comboResults) {
                feats.add(prefix + result);
            }
        }
        for (String fullPrefix : fullPrefixToProductions.keySet()) {
            Set productions = (Set)fullPrefixToProductions.get(fullPrefix);
            for (String production : productions) {
                feats.add(fullPrefix + production);
            }
        }
        return feats;
    }

    protected Set<String> intersect(Set<String> s1, Set<String> s2) {
        HashSet<String> intersection = null;
        if (s1 != null && s2 != null) {
            intersection = new HashSet<String>(s1);
            intersection.retainAll(s2);
        }
        return intersection;
    }

    protected Set<String> union(Set<String> s1, Set<String> s2) {
        HashSet<String> union = new HashSet<String>(s1);
        union.addAll(s2);
        return union;
    }

    protected Set<String> cross(Set<String> s1, Set<String> s2) {
        HashSet<String> cross = null;
        if (s1 != null && s2 != null) {
            cross = new HashSet<String>(s1.size() * s2.size());
            for (String s1s : s1) {
                for (String s2s : s2) {
                    cross.add(s1s + "\u2ea2" + s2s);
                }
            }
        }
        return cross;
    }
}

