/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.princeton.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.file.DictionaryFile;
import net.didion.jwnl.dictionary.file.DictionaryFileType;
import net.didion.jwnl.dictionary.file.ObjectDictionaryFile;
import net.didion.jwnl.princeton.file.AbstractPrincetonDictionaryFile;

public class PrincetonObjectDictionaryFile
extends AbstractPrincetonDictionaryFile
implements ObjectDictionaryFile {
    private File _file = null;
    private ObjectInputStream _in = null;
    private ObjectOutputStream _out = null;

    public PrincetonObjectDictionaryFile() {
    }

    public DictionaryFile newInstance(String string, POS pOS, DictionaryFileType dictionaryFileType) {
        return new PrincetonObjectDictionaryFile(string, pOS, dictionaryFileType);
    }

    public PrincetonObjectDictionaryFile(String string, POS pOS, DictionaryFileType dictionaryFileType) {
        super(string, pOS, dictionaryFileType);
    }

    public boolean isOpen() {
        return this._file != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.canRead()) {
                this.getInputStream().close();
            }
            if (this.canWrite()) {
                this.getOutputStream().close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this._in = null;
            this._out = null;
            this._file = null;
        }
    }

    public void openStreams() throws IOException {
        if (!this.canWrite()) {
            this.openOutputStream();
        }
        if (!this.canRead()) {
            this.openInputStream();
        }
    }

    private void openOutputStream() throws IOException {
        this._out = new ObjectOutputStream(new FileOutputStream(this._file));
    }

    private void openInputStream() throws IOException {
        this._in = new ObjectInputStream(new FileInputStream(this._file));
    }

    public ObjectInputStream getInputStream() throws IOException {
        if (!this.canRead()) {
            this.openInputStream();
        }
        return this._in;
    }

    public ObjectOutputStream getOutputStream() throws IOException {
        if (!this.canWrite()) {
            this.openOutputStream();
        }
        return this._out;
    }

    public boolean canRead() {
        return this._in != null;
    }

    public boolean canWrite() {
        return this._out != null;
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        if (this.isOpen() && this.canRead()) {
            return this.getInputStream().readObject();
        }
        throw new JWNLRuntimeException("PRINCETON_EXCEPTION_001");
    }

    public void writeObject(Object object) throws IOException {
        if (!this.isOpen() || !this.canWrite()) {
            throw new JWNLRuntimeException("PRINCETON_EXCEPTION_002");
        }
        this.getOutputStream().writeObject(object);
    }

    protected void openFile(File file) throws IOException {
        this._file = file;
        if (!this._file.exists()) {
            this._file.createNewFile();
            this.openOutputStream();
        } else {
            this.openInputStream();
        }
    }
}

