/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.util.search;

import edu.umass.cs.mallet.base.util.search.PriorityQueue;
import edu.umass.cs.mallet.base.util.search.QueueElement;

public class MinHeap
implements PriorityQueue {
    private QueueElement[] elts;
    private int size = 0;
    private static final int MIN_CAPACITY = 16;

    public MinHeap(int capacity) {
        if (capacity < 16) {
            capacity = 16;
        }
        this.elts = new QueueElement[capacity];
        this.size = 0;
    }

    public MinHeap() {
        this(16);
    }

    private void heapify(int i) {
        int l = 2 * i + 1;
        int r = 2 * i + 2;
        int first = l < this.size && this.elts[l].getPriority() < this.elts[i].getPriority() ? l : i;
        if (r < this.size && this.elts[r].getPriority() < this.elts[first].getPriority()) {
            first = r;
        }
        if (first != i) {
            QueueElement e = this.elts[i];
            this.elts[i] = this.elts[first];
            this.elts[i].setPosition(i);
            this.elts[first] = e;
            e.setPosition(first);
            this.heapify(first);
        }
    }

    public int size() {
        return this.size;
    }

    public QueueElement min() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("queue empty");
        }
        return this.elts[0];
    }

    public QueueElement extractMin() {
        if (this.size == 0) {
            throw new IndexOutOfBoundsException("queue empty");
        }
        QueueElement min = this.elts[0];
        this.elts[0] = this.elts[--this.size];
        this.heapify(0);
        min.setPosition(-1);
        return min;
    }

    public void decreaseKey(QueueElement e, double priority) {
        int j;
        if (!this.contains(e)) {
            throw new IllegalArgumentException("Element not in queue");
        }
        if (priority > e.getPriority()) {
            throw new IllegalArgumentException("new priority higher than older");
        }
        e.setPriority(priority);
        int i = e.getPosition();
        while (i > 0 && this.elts[j = (i - 1) / 2].getPriority() > this.elts[i].getPriority()) {
            QueueElement p = this.elts[j];
            this.elts[j] = this.elts[i];
            this.elts[j].setPosition(j);
            this.elts[i] = p;
            p.setPosition(i);
            i = j;
        }
    }

    public void insert(QueueElement e) {
        if (this.size == this.elts.length) {
            QueueElement[] newElts = new QueueElement[this.size + this.size / 2];
            int i = 0;
            while (i < this.size) {
                newElts[i] = this.elts[i];
                ++i;
            }
            this.elts = newElts;
        }
        e.setPosition(this.size);
        this.elts[this.size++] = e;
        this.decreaseKey(e, e.getPriority());
    }

    public boolean contains(QueueElement e) {
        int pos = e.getPosition();
        return pos >= 0 && pos < this.size && e == this.elts[pos];
    }
}

