/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.types;

import edu.umass.cs.mallet.base.pipe.Pipe;
import edu.umass.cs.mallet.base.types.Labeling;
import edu.umass.cs.mallet.base.util.MalletLogger;
import edu.umass.cs.mallet.base.util.PropertyList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Logger;

public class Instance
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(Instance.class.getName());
    Object data;
    Object target;
    Object name;
    Object source;
    Pipe pipe = null;
    PropertyList properties = null;
    boolean locked = false;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public Instance(Object data, Object target, Object name, Object source) {
        this.data = data;
        this.target = target;
        this.name = name;
        this.source = source;
    }

    public Instance(Object data, Object target, Object name, Object source, Pipe p) {
        this(data, target, name, source);
        if (p != null) {
            p.pipe(this);
            this.locked = true;
        }
        this.pipe = p;
    }

    public Object getData() {
        return this.data;
    }

    public Object getTarget() {
        return this.target;
    }

    public Object getName() {
        return this.name;
    }

    public Object getSource() {
        return this.source;
    }

    public Pipe getPipe() {
        return this.pipe;
    }

    public PropertyList getPropertyList() {
        return this.properties;
    }

    public Object getData(Pipe p) {
        if (p != this.pipe) {
            throw new IllegalArgumentException("Pipe doesn't match.");
        }
        return this.data;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLock() {
        this.locked = true;
    }

    public void unLock() {
        this.locked = false;
    }

    public Instance getPipedCopy(Pipe p) {
        if (this.pipe != null) {
            throw new IllegalStateException("This method can only be called on Instances that have not yet already been piped");
        }
        Instance ret = p.pipe(this.shallowCopy());
        ret.pipe = p;
        return ret;
    }

    public Labeling getLabeling() {
        if (this.target == null || this.target instanceof Labeling) {
            return (Labeling)this.target;
        }
        throw new IllegalStateException("Target is not a Labeling; it is a " + this.target.getClass().getName());
    }

    protected void setPipe(Pipe p) {
        if (this.locked) {
            throw new IllegalStateException("Instance is locked.");
        }
        this.pipe = p;
    }

    public void setData(Object d) {
        if (this.locked) {
            throw new IllegalStateException("Instance is locked.");
        }
        this.data = d;
    }

    public void setTarget(Object t) {
        if (this.locked) {
            throw new IllegalStateException("Instance is locked.");
        }
        this.target = t;
    }

    public void setLabeling(Labeling l) {
        assert (this.target == null || this.target instanceof Labeling);
        if (this.locked) {
            throw new IllegalStateException("Instance is locked.");
        }
        this.target = l;
    }

    public void setName(Object n) {
        if (this.locked) {
            throw new IllegalStateException("Instance is locked.");
        }
        this.name = n;
    }

    public void setSource(Object s) {
        if (this.locked) {
            throw new IllegalStateException("Instance is locked.");
        }
        this.source = s;
    }

    public void clearSource() {
        this.source = null;
    }

    public void setPropertyList(PropertyList p) {
        if (this.locked) {
            throw new IllegalStateException("Instance is locked.");
        }
        this.properties = p;
    }

    public Instance shallowCopy() {
        Instance ret = new Instance(this.data, this.target, this.name, this.source);
        ret.pipe = this.pipe;
        ret.locked = this.locked;
        ret.properties = this.properties;
        return ret;
    }

    public void setProperty(String key, Object value) {
        this.properties = PropertyList.add(key, value, this.properties);
    }

    public void setNumericProperty(String key, double value) {
        this.properties = PropertyList.add(key, value, this.properties);
    }

    public PropertyList getProperties() {
        return this.properties;
    }

    public Object getProperty(String key) {
        return this.properties == null ? null : this.properties.lookupObject(key);
    }

    public double getNumericProperty(String key) {
        return this.properties == null ? 0.0 : this.properties.lookupNumber(key);
    }

    public boolean hasProperty(String key) {
        return this.properties == null ? false : this.properties.hasProperty(key);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.data);
        out.writeObject(this.target);
        out.writeObject(this.name);
        out.writeObject(this.source);
        out.writeObject(this.properties);
        out.writeObject(this.pipe);
        out.writeBoolean(this.locked);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.data = in.readObject();
        this.target = in.readObject();
        this.name = in.readObject();
        this.source = in.readObject();
        this.properties = (PropertyList)in.readObject();
        if (version > 0) {
            this.pipe = (Pipe)in.readObject();
            this.locked = in.readBoolean();
        }
    }

    public static interface Iterator
    extends java.util.Iterator {
        public Instance nextInstance();

        public double getInstanceWeight();
    }
}

