/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.mallet.base.fst;

import edu.umass.cs.mallet.base.fst.Segment;
import edu.umass.cs.mallet.base.pipe.Pipe;
import edu.umass.cs.mallet.base.types.Alphabet;
import edu.umass.cs.mallet.base.types.ArraySequence;
import edu.umass.cs.mallet.base.types.DenseVector;
import edu.umass.cs.mallet.base.types.Instance;
import edu.umass.cs.mallet.base.types.InstanceList;
import edu.umass.cs.mallet.base.types.LabelAlphabet;
import edu.umass.cs.mallet.base.types.LabelVector;
import edu.umass.cs.mallet.base.types.MatrixOps;
import edu.umass.cs.mallet.base.types.Sequence;
import edu.umass.cs.mallet.base.types.SequencePair;
import edu.umass.cs.mallet.base.types.SequencePairAlignment;
import edu.umass.cs.mallet.base.util.MalletLogger;
import edu.umass.cs.mallet.base.util.search.AStar;
import edu.umass.cs.mallet.base.util.search.AStarState;
import edu.umass.cs.mallet.base.util.search.SearchNode;
import edu.umass.cs.mallet.base.util.search.SearchState;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Transducer
implements Serializable {
    private static Logger logger = MalletLogger.getLogger(Transducer.class.getName());
    public static final double ZERO_COST = 0.0;
    public static final double INFINITE_COST = Double.POSITIVE_INFINITY;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 3;
    private static final int NO_PIPE_VERSION = 0;
    boolean UseForwardBackwardBeam = false;
    private int beamWidth = 0;
    private double KLeps = 0.0;
    private double Rmin = 0.1;
    private double[] nstatesExpl;
    private int curIter = 0;
    int tctIter = 0;
    private double curAvgNstatesExpl;
    protected Pipe inputPipe;
    protected Pipe outputPipe;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(3);
        out.writeObject(this.inputPipe);
        out.writeObject(this.outputPipe);
        out.writeInt(this.beamWidth);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 0) {
            this.inputPipe = null;
            this.outputPipe = null;
        } else {
            this.inputPipe = (Pipe)in.readObject();
            this.outputPipe = (Pipe)in.readObject();
        }
        this.beamWidth = version < 3 ? 50 : in.readInt();
    }

    public Pipe getInputPipe() {
        return this.inputPipe;
    }

    public Pipe getOutputPipe() {
        return this.outputPipe;
    }

    public int getBeamWidth() {
        return this.beamWidth;
    }

    public void setBeamWidth(int beamWidth) {
        this.beamWidth = beamWidth;
    }

    public void setCurIter(int curIter) {
        this.curIter = curIter;
        this.tctIter = 0;
    }

    public void incIter() {
        ++this.tctIter;
    }

    public void setKLeps(double KLeps) {
        this.KLeps = KLeps;
    }

    public void setRmin(double Rmin) {
        this.Rmin = Rmin;
    }

    public double[] getNstatesExpl() {
        return this.nstatesExpl;
    }

    public void setUseForwardBackwardBeam(boolean state) {
        this.UseForwardBackwardBeam = state;
    }

    public Instance pipe(Instance carrier) {
        carrier.setTarget(this.viterbiPath((Sequence)carrier.getData()));
        return carrier;
    }

    public Sequence transduce(Sequence input) {
        ViterbiPath lattice = this.viterbiPath(input);
        return lattice.output();
    }

    public abstract int numStates();

    public abstract State getState(int var1);

    public abstract Iterator initialStateIterator();

    public boolean canIterateAllTransitions() {
        return false;
    }

    public boolean isGenerative() {
        return false;
    }

    public boolean isTrainable() {
        return false;
    }

    public void setTrainable(boolean f) {
        if (f) {
            throw new IllegalStateException("Cannot be trainable.");
        }
    }

    public boolean train(InstanceList instances) {
        throw new UnsupportedOperationException("Not trainable.");
    }

    public double averageTokenAccuracy(InstanceList ilist) {
        double accuracy = 0.0;
        int i = 0;
        while (i < ilist.size()) {
            Instance instance = ilist.getInstance(i);
            Sequence input = (Sequence)instance.getData();
            Sequence output = (Sequence)instance.getTarget();
            assert (input.size() == output.size());
            double pathAccuracy = this.viterbiPath(input).tokenAccuracy(output);
            accuracy += pathAccuracy;
            logger.info("Transducer path accuracy = " + pathAccuracy);
            ++i;
        }
        return accuracy / (double)ilist.size();
    }

    public double averageTokenAccuracy(InstanceList ilist, String fileName) {
        PrintWriter out;
        double accuracy = 0.0;
        File f = new File(fileName);
        try {
            out = new PrintWriter(new FileWriter(f));
        }
        catch (IOException e) {
            out = null;
        }
        int i = 0;
        while (i < ilist.size()) {
            Instance instance = ilist.getInstance(i);
            Sequence input = (Sequence)instance.getData();
            Sequence output = (Sequence)instance.getTarget();
            assert (input.size() == output.size());
            double pathAccuracy = this.viterbiPath(input).tokenAccuracy(output, out);
            accuracy += pathAccuracy;
            logger.info("Transducer path accuracy = " + pathAccuracy);
            ++i;
        }
        out.close();
        return accuracy / (double)ilist.size();
    }

    public SequencePairAlignment generatePath() {
        if (!this.isGenerative()) {
            throw new IllegalStateException("Transducer is not generative.");
        }
        ArrayList initialStates = new ArrayList();
        Iterator iter = this.initialStateIterator();
        while (iter.hasNext()) {
            initialStates.add(iter.next());
        }
        throw new UnsupportedOperationException();
    }

    public Lattice forwardBackward(Sequence inputSequence) {
        return this.forwardBackward(inputSequence, null, false);
    }

    public Lattice forwardBackward(Sequence inputSequence, boolean increment) {
        return this.forwardBackward(inputSequence, null, increment);
    }

    public Lattice forwardBackward(Sequence inputSequence, Sequence outputSequence) {
        return this.forwardBackward(inputSequence, outputSequence, false);
    }

    public Lattice forwardBackward(Sequence inputSequence, Sequence outputSequence, boolean increment) {
        return this.forwardBackward(inputSequence, outputSequence, increment, null);
    }

    public Lattice forwardBackward(Sequence inputSequence, Sequence outputSequence, boolean increment, LabelAlphabet outputAlphabet) {
        return this.forwardBackward(inputSequence, outputSequence, increment, false, outputAlphabet);
    }

    public Lattice forwardBackward(Sequence inputSequence, Sequence outputSequence, boolean increment, boolean saveXis, LabelAlphabet outputAlphabet) {
        assert (outputSequence == null || inputSequence.size() == outputSequence.size());
        return new Lattice(this, inputSequence, outputSequence, increment, saveXis, outputAlphabet);
    }

    public Lattice forwardBackward(Sequence inputSequence, Sequence outputSequence, Segment requiredSegment, Sequence constrainedSequence) {
        if (constrainedSequence.size() != inputSequence.size()) {
            throw new IllegalArgumentException("constrainedSequence.size [" + constrainedSequence.size() + "] != inputSequence.size [" + inputSequence.size() + "]");
        }
        int[] constraints = new int[constrainedSequence.size() + 1];
        int c = 0;
        while (c < constraints.length) {
            constraints[c] = 0;
            ++c;
        }
        int i = requiredSegment.getStart();
        while (i <= requiredSegment.getEnd()) {
            int si = this.stateIndexOfString((String)constrainedSequence.get(i));
            if (si == -1) {
                logger.warning("Could not find state " + constrainedSequence.get(i) + ". Check that state labels match startTages and inTags, and that all labels are seen in training data.");
            }
            constraints[i + 1] = si + 1;
            ++i;
        }
        if (requiredSegment.getEnd() + 2 < constraints.length) {
            String endTag = requiredSegment.getInTag().toString();
            int statei = this.stateIndexOfString(endTag);
            if (statei == -1) {
                logger.fine("Could not find state " + endTag + ". Check that state labels match startTags and InTags.");
            } else {
                constraints[requiredSegment.getEnd() + 2] = -(statei + 1);
            }
        }
        logger.fine("Segment:\n" + requiredSegment.sequenceToString() + "\nconstrainedSequence:\n" + constrainedSequence + "\nConstraints:\n");
        i = 0;
        while (i < constraints.length) {
            logger.fine(String.valueOf(constraints[i]) + "\t");
            ++i;
        }
        logger.fine("");
        return this.forwardBackward(inputSequence, outputSequence, constraints);
    }

    public int stateIndexOfString(String s) {
        int i = 0;
        while (i < this.numStates()) {
            String state = this.getState(i).getName();
            if (state.equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void printStates() {
        int i = 0;
        while (i < this.numStates()) {
            logger.fine(String.valueOf(i) + ":" + this.getState(i).getName());
            ++i;
        }
    }

    public void print() {
        logger.fine("Transducer " + this);
        this.printStates();
    }

    public Lattice forwardBackward(Sequence inputSequence, Sequence outputSequence, int[] constraints) {
        return new Lattice(this, inputSequence, outputSequence, false, null, constraints);
    }

    private Lattice forwardBackward(SequencePair inputOutputPair, boolean increment) {
        return this.forwardBackward(inputOutputPair.input(), inputOutputPair.output(), increment);
    }

    public BeamLattice forwardBackwardBeam(Sequence inputSequence) {
        return this.forwardBackwardBeam(inputSequence, null, false);
    }

    public BeamLattice forwardBackwardBeam(Sequence inputSequence, boolean increment) {
        return this.forwardBackwardBeam(inputSequence, null, increment);
    }

    public BeamLattice forwardBackwardBeam(Sequence inputSequence, Sequence outputSequence) {
        return this.forwardBackwardBeam(inputSequence, outputSequence, false);
    }

    public BeamLattice forwardBackwardBeam(Sequence inputSequence, Sequence outputSequence, boolean increment) {
        return this.forwardBackwardBeam(inputSequence, outputSequence, increment, null);
    }

    public BeamLattice forwardBackwardBeam(Sequence inputSequence, Sequence outputSequence, boolean increment, LabelAlphabet outputAlphabet) {
        return this.forwardBackwardBeam(inputSequence, outputSequence, increment, false, outputAlphabet);
    }

    public BeamLattice forwardBackwardBeam(Sequence inputSequence, Sequence outputSequence, boolean increment, boolean saveXis, LabelAlphabet outputAlphabet) {
        assert (outputSequence == null || inputSequence.size() == outputSequence.size());
        return new BeamLattice(this, inputSequence, outputSequence, increment, saveXis, outputAlphabet);
    }

    public BeamLattice forwardBackwardBeam(Sequence inputSequence, Sequence outputSequence, Segment requiredSegment, Sequence constrainedSequence) {
        if (constrainedSequence.size() != inputSequence.size()) {
            throw new IllegalArgumentException("constrainedSequence.size [" + constrainedSequence.size() + "] != inputSequence.size [" + inputSequence.size() + "]");
        }
        int[] constraints = new int[constrainedSequence.size() + 1];
        int c = 0;
        while (c < constraints.length) {
            constraints[c] = 0;
            ++c;
        }
        int i = requiredSegment.getStart();
        while (i <= requiredSegment.getEnd()) {
            int si = this.stateIndexOfString((String)constrainedSequence.get(i));
            if (si == -1) {
                logger.warning("Could not find state " + constrainedSequence.get(i) + ". Check that state labels match startTages and inTags, and that all labels are seen in training data.");
            }
            constraints[i + 1] = si + 1;
            ++i;
        }
        if (requiredSegment.getEnd() + 2 < constraints.length) {
            String endTag = requiredSegment.getInTag().toString();
            int statei = this.stateIndexOfString(endTag);
            if (statei == -1) {
                throw new IllegalArgumentException("Could not find state " + endTag + ". Check that state labels match startTags and InTags.");
            }
            constraints[requiredSegment.getEnd() + 2] = -(statei + 1);
        }
        logger.fine("Segment:\n" + requiredSegment.sequenceToString() + "\nconstrainedSequence:\n" + constrainedSequence + "\nConstraints:\n");
        i = 0;
        while (i < constraints.length) {
            logger.fine(String.valueOf(constraints[i]) + "\t");
            ++i;
        }
        logger.fine("");
        return this.forwardBackwardBeam(inputSequence, outputSequence, constraints);
    }

    public BeamLattice forwardBackwardBeam(Sequence inputSequence, Sequence outputSequence, int[] constraints) {
        return new BeamLattice(this, inputSequence, outputSequence, false, null, constraints);
    }

    private BeamLattice forwardBackwardBeam(SequencePair inputOutputPair, boolean increment) {
        return this.forwardBackwardBeam(inputOutputPair.input(), inputOutputPair.output(), increment);
    }

    public ViterbiPath viterbiPath(Object unpipedObject) {
        Instance carrier = new Instance(unpipedObject, null, null, null, this.inputPipe);
        return this.viterbiPath((Sequence)carrier.getData());
    }

    public ViterbiPath viterbiPath(Sequence inputSequence) {
        return this.viterbiPath(inputSequence, null);
    }

    public ViterbiPath viterbiPath(Sequence inputSequence, Sequence outputSequence) {
        assert (outputSequence == null || inputSequence.size() == outputSequence.size());
        return new ViterbiPath(inputSequence, outputSequence);
    }

    public ViterbiPath_NBest viterbiPath_NBest(Sequence inputSequence, int N) {
        return this.viterbiPath_NBest(inputSequence, null, N);
    }

    public ViterbiPath_NBest viterbiPath_NBest(Sequence inputSequence, Sequence outputSequence, int N) {
        assert (outputSequence == null || inputSequence.size() == outputSequence.size());
        assert (N > 0);
        return new ViterbiPath_NBest(inputSequence, outputSequence, N);
    }

    public ViterbiPathBeam viterbiPathBeam(Sequence inputSequence) {
        return this.viterbiPathBeam(inputSequence, this.beamWidth);
    }

    public ViterbiPathBeam viterbiPathBeam(Sequence inputSequence, int Bwidth) {
        return this.viterbiPathBeam(inputSequence, null, Bwidth);
    }

    public ViterbiPathBeam viterbiPathBeam(Sequence inputSequence, Sequence outputSequence, int Bwidth) {
        assert (outputSequence == null || inputSequence.size() == outputSequence.size());
        return new ViterbiPathBeam(inputSequence, outputSequence, Bwidth);
    }

    public ViterbiPathBeamKL viterbiPathBeamKL(Sequence inputSequence) {
        return this.viterbiPathBeamKL(inputSequence, this.beamWidth);
    }

    public ViterbiPathBeamKL viterbiPathBeamKL(Sequence inputSequence, int Bwidth) {
        return this.viterbiPathBeamKL(inputSequence, null, Bwidth);
    }

    public ViterbiPathBeamKL viterbiPathBeamKL(Sequence inputSequence, Sequence outputSequence, int Bwidth) {
        assert (outputSequence == null || inputSequence.size() == outputSequence.size());
        return new ViterbiPathBeamKL(inputSequence, outputSequence, Bwidth);
    }

    public ViterbiPathBeamB viterbiPathBeamB(Sequence inputSequence) {
        return this.viterbiPathBeamB(inputSequence, this.beamWidth);
    }

    public ViterbiPathBeamB viterbiPathBeamB(Object unpipedObject) {
        Instance carrier = new Instance(unpipedObject, null, null, null, this.inputPipe);
        return this.viterbiPathBeamB((Sequence)carrier.getData());
    }

    public ViterbiPathBeamB viterbiPathBeamB(Sequence inputSequence, int Bwidth) {
        return this.viterbiPathBeamB(inputSequence, null, Bwidth);
    }

    public ViterbiPathBeamB viterbiPathBeamB(Sequence inputSequence, Sequence outputSequence, int Bwidth) {
        assert (outputSequence == null || inputSequence.size() == outputSequence.size());
        return new ViterbiPathBeamB(inputSequence, outputSequence, Bwidth);
    }

    public ViterbiPathBeamFB viterbiPathBeamFB(Sequence inputSequence) {
        return this.viterbiPathBeamFB(inputSequence, this.beamWidth);
    }

    public ViterbiPathBeamFB viterbiPathBeamFB(Object unpipedObject) {
        Instance carrier = new Instance(unpipedObject, null, null, null, this.inputPipe);
        return this.viterbiPathBeamFB((Sequence)carrier.getData());
    }

    public ViterbiPathBeamFB viterbiPathBeamFB(Sequence inputSequence, int Bwidth) {
        return this.viterbiPathBeamFB(inputSequence, null, Bwidth);
    }

    public ViterbiPathBeamFB viterbiPathBeamFB(Sequence inputSequence, Sequence outputSequence, int Bwidth) {
        assert (outputSequence == null || inputSequence.size() == outputSequence.size());
        return new ViterbiPathBeamFB(inputSequence, outputSequence, Bwidth);
    }

    public ViterbiLattice getViterbiLattice(Sequence input, Sequence output, int cacheSize) {
        return new ViterbiLattice(input, output, 1 + cacheSize / (this.numStates() * this.numStates()));
    }

    public static double sumNegLogProb(double a, double b) {
        if (a == Double.POSITIVE_INFINITY && b == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (a > b) {
            return b - Math.log(1.0 + Math.exp(b - a));
        }
        return a - Math.log(1.0 + Math.exp(a - b));
    }

    public static abstract class State
    implements Serializable {
        protected double initialCost = 0.0;
        protected double finalCost = 0.0;
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;

        public abstract String getName();

        public abstract int getIndex();

        public double getInitialCost() {
            return this.initialCost;
        }

        public void setInitialCost(double c) {
            this.initialCost = c;
        }

        public double getFinalCost() {
            return this.finalCost;
        }

        public void setFinalCost(double c) {
            this.finalCost = c;
        }

        public abstract TransitionIterator transitionIterator(Sequence var1, int var2, Sequence var3, int var4);

        public TransitionIterator transitionIterator(Sequence input, int inputPosition) {
            return this.transitionIterator(input, inputPosition, null, 0);
        }

        public TransitionIterator transitionIterator() {
            return this.transitionIterator(null, 0, null, 0);
        }

        public void incrementInitialCount(double count) {
            throw new UnsupportedOperationException();
        }

        public void incrementFinalCount(double count) {
            throw new UnsupportedOperationException();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
            out.writeDouble(this.initialCost);
            out.writeDouble(this.finalCost);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
            this.initialCost = in.readDouble();
            this.finalCost = in.readDouble();
        }
    }

    public static abstract class TransitionIterator
    implements Iterator,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final int CURRENT_SERIAL_VERSION = 0;

        public abstract boolean hasNext();

        public int numberNext() {
            return -1;
        }

        public abstract State nextState();

        public Object next() {
            return this.nextState();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public abstract Object getInput();

        public abstract Object getOutput();

        public abstract double getCost();

        public abstract State getSourceState();

        public abstract State getDestinationState();

        public int getInputPositionIncrement() {
            return 1;
        }

        public int getOutputPositionIncrement() {
            return 1;
        }

        public void incrementCount(double count) {
            throw new UnsupportedOperationException();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeInt(0);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int version = in.readInt();
        }

        public String describeTransition(double cutoff) {
            return "";
        }
    }

    /*
     * Exception performing whole class analysis.
     */
    public class Lattice {
        double cost;
        Sequence input;
        Sequence output;
        LatticeNode[][] nodes;
        int latticeLength;
        double[][] gammas;
        double[][][] xis;
        LabelVector[] labelings;
        final /* synthetic */ Transducer this$0;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !Lattice.class.desiredAssertionStatus();
        }

        private LatticeNode getLatticeNode(int ip, int stateIndex) {
            if (this.nodes[ip][stateIndex] == null) {
                this.nodes[ip][stateIndex] = new LatticeNode(ip, this.this$0.getState(stateIndex));
            }
            return this.nodes[ip][stateIndex];
        }

        protected Lattice(Transducer transducer, Sequence input, Sequence output, boolean increment) {
            this(transducer, input, output, increment, false, null);
        }

        protected Lattice(Transducer transducer, Sequence input, Sequence output, boolean increment, boolean saveXis) {
            this(transducer, input, output, increment, saveXis, null);
        }

        protected Lattice(Transducer transducer, Sequence input, Sequence output, boolean increment, boolean saveXis, LabelAlphabet outputAlphabet) {
            State destination;
            TransitionIterator iter;
            State s;
            int ip;
            this.this$0 = transducer;
            this.input = input;
            this.output = output;
            this.latticeLength = input.size() + 1;
            int numStates = transducer.numStates();
            this.nodes = new LatticeNode[this.latticeLength][numStates];
            this.gammas = new double[this.latticeLength][numStates];
            if (saveXis) {
                this.xis = new double[this.latticeLength][numStates][numStates];
            }
            double[][] outputCounts = null;
            if (outputAlphabet != null) {
                outputCounts = new double[this.latticeLength][outputAlphabet.size()];
            }
            int i = 0;
            while (i < numStates) {
                ip = 0;
                while (ip < this.latticeLength) {
                    this.gammas[ip][i] = Double.POSITIVE_INFINITY;
                    ++ip;
                }
                if (saveXis) {
                    int j = 0;
                    while (j < numStates) {
                        int ip2 = 0;
                        while (ip2 < this.latticeLength) {
                            this.xis[ip2][i][j] = Double.POSITIVE_INFINITY;
                            ++ip2;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            logger.fine("Starting Foward pass");
            boolean atLeastOneInitialState = false;
            int i2 = 0;
            while (i2 < numStates) {
                double initialCost = transducer.getState((int)i2).initialCost;
                if (initialCost < Double.POSITIVE_INFINITY) {
                    this.getLatticeNode((int)0, (int)i2).alpha = initialCost;
                    atLeastOneInitialState = true;
                }
                ++i2;
            }
            if (!atLeastOneInitialState) {
                logger.warning("There are no starting states!");
            }
            ip = 0;
            while (ip < this.latticeLength - 1) {
                int i3 = 0;
                while (i3 < numStates) {
                    if (this.nodes[ip][i3] != null && this.nodes[ip][i3].alpha != Double.POSITIVE_INFINITY) {
                        s = transducer.getState(i3);
                        iter = s.transitionIterator(input, ip, output, ip);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(" Starting Foward transition iteration from state " + s.getName() + " on input " + input.get(ip).toString() + " and output " + (output == null ? "(null)" : output.get(ip).toString()));
                        }
                        while (iter.hasNext()) {
                            destination = iter.nextState();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Forward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                            }
                            LatticeNode destinationNode = this.getLatticeNode(ip + 1, destination.getIndex());
                            destinationNode.output = iter.getOutput();
                            double transitionCost = iter.getCost();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("transitionCost=" + transitionCost + " nodes[" + ip + "][" + i3 + "].alpha=" + this.nodes[ip][i3].alpha + " destinationNode.alpha=" + destinationNode.alpha);
                            }
                            destinationNode.alpha = Transducer.sumNegLogProb(destinationNode.alpha, this.nodes[ip][i3].alpha + transitionCost);
                        }
                    }
                    ++i3;
                }
                ++ip;
            }
            this.cost = Double.POSITIVE_INFINITY;
            i2 = 0;
            while (i2 < numStates) {
                if (this.nodes[this.latticeLength - 1][i2] != null) {
                    this.cost = Transducer.sumNegLogProb(this.cost, this.nodes[this.latticeLength - 1][i2].alpha + transducer.getState((int)i2).finalCost);
                }
                ++i2;
            }
            if (this.cost == Double.POSITIVE_INFINITY) {
                return;
            }
            i2 = 0;
            while (i2 < numStates) {
                if (this.nodes[this.latticeLength - 1][i2] != null) {
                    State s2 = transducer.getState(i2);
                    this.nodes[this.latticeLength - 1][i2].beta = s2.finalCost;
                    this.gammas[this.latticeLength - 1][i2] = this.nodes[this.latticeLength - 1][i2].alpha + this.nodes[this.latticeLength - 1][i2].beta - this.cost;
                    if (increment) {
                        double p = Math.exp(-this.gammas[this.latticeLength - 1][i2]);
                        if (!($assertionsDisabled || p < Double.POSITIVE_INFINITY && !Double.isNaN(p))) {
                            throw new AssertionError((Object)("p=" + p + " gamma=" + this.gammas[this.latticeLength - 1][i2]));
                        }
                        s2.incrementFinalCount(p);
                    }
                }
                ++i2;
            }
            ip = this.latticeLength - 2;
            while (ip >= 0) {
                int i4 = 0;
                while (i4 < numStates) {
                    if (this.nodes[ip][i4] != null && this.nodes[ip][i4].alpha != Double.POSITIVE_INFINITY) {
                        s = transducer.getState(i4);
                        iter = s.transitionIterator(input, ip, output, ip);
                        while (iter.hasNext()) {
                            int j;
                            LatticeNode destinationNode;
                            destination = iter.nextState();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Backward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                            }
                            if ((destinationNode = this.nodes[ip + 1][j = destination.getIndex()]) == null) continue;
                            double transitionCost = iter.getCost();
                            if (!$assertionsDisabled && Double.isNaN(transitionCost)) {
                                throw new AssertionError();
                            }
                            double oldBeta = this.nodes[ip][i4].beta;
                            if (!$assertionsDisabled && Double.isNaN(this.nodes[ip][i4].beta)) {
                                throw new AssertionError();
                            }
                            this.nodes[ip][i4].beta = Transducer.sumNegLogProb(this.nodes[ip][i4].beta, destinationNode.beta + transitionCost);
                            if (!$assertionsDisabled && Double.isNaN(this.nodes[ip][i4].beta)) {
                                throw new AssertionError((Object)("dest.beta=" + destinationNode.beta + " trans=" + transitionCost + " sum=" + (destinationNode.beta + transitionCost) + " oldBeta=" + oldBeta));
                            }
                            double xi = this.nodes[ip][i4].alpha + transitionCost + this.nodes[ip + 1][j].beta - this.cost;
                            if (saveXis) {
                                this.xis[ip][i4][j] = xi;
                            }
                            if (!$assertionsDisabled && Double.isNaN(this.nodes[ip][i4].alpha)) {
                                throw new AssertionError();
                            }
                            if (!$assertionsDisabled && Double.isNaN(transitionCost)) {
                                throw new AssertionError();
                            }
                            if (!$assertionsDisabled && Double.isNaN(this.nodes[ip + 1][j].beta)) {
                                throw new AssertionError();
                            }
                            if (!$assertionsDisabled && Double.isNaN(this.cost)) {
                                throw new AssertionError();
                            }
                            if (!increment && outputAlphabet == null) continue;
                            double p = Math.exp(-xi);
                            if (!($assertionsDisabled || p < Double.POSITIVE_INFINITY && !Double.isNaN(p))) {
                                throw new AssertionError((Object)("xis[" + ip + "][" + i4 + "][" + j + "]=" + -xi));
                            }
                            if (increment) {
                                iter.incrementCount(p);
                            }
                            if (outputAlphabet == null) continue;
                            int outputIndex = outputAlphabet.lookupIndex(iter.getOutput(), false);
                            if (!$assertionsDisabled && outputIndex < 0) {
                                throw new AssertionError();
                            }
                            double[] dArray = outputCounts[ip];
                            int n = outputIndex;
                            dArray[n] = dArray[n] + p;
                        }
                        this.gammas[ip][i4] = this.nodes[ip][i4].alpha + this.nodes[ip][i4].beta - this.cost;
                    }
                    ++i4;
                }
                --ip;
            }
            if (increment) {
                i2 = 0;
                while (i2 < numStates) {
                    double p = Math.exp(-this.gammas[0][i2]);
                    if (!($assertionsDisabled || p < Double.POSITIVE_INFINITY && !Double.isNaN(p))) {
                        throw new AssertionError();
                    }
                    transducer.getState(i2).incrementInitialCount(p);
                    ++i2;
                }
            }
            if (outputAlphabet != null) {
                this.labelings = new LabelVector[this.latticeLength];
                ip = this.latticeLength - 2;
                while (ip >= 0) {
                    if (!$assertionsDisabled && !(Math.abs(1.0 - DenseVector.sum(outputCounts[ip])) < 1.0E-6)) {
                        throw new AssertionError();
                    }
                    this.labelings[ip] = new LabelVector(outputAlphabet, outputCounts[ip]);
                    --ip;
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        protected Lattice(Transducer var1_1, Sequence input, Sequence output, boolean increment, LabelAlphabet outputAlphabet, int[] constraints) {
            this.this$0 = var1_1;
            super();
            this.input = input;
            this.output = output;
            this.latticeLength = input.size() + 1;
            numStates = var1_1.numStates();
            this.nodes = new LatticeNode[this.latticeLength][numStates];
            this.gammas = new double[this.latticeLength][numStates];
            outputCounts = null;
            if (outputAlphabet != null) {
                outputCounts = new double[this.latticeLength][outputAlphabet.size()];
            }
            i = 0;
            while (i < numStates) {
                ip = 0;
                while (ip < this.latticeLength) {
                    this.gammas[ip][i] = Infinity;
                    ++ip;
                }
                ++i;
            }
            Transducer.access$0().fine("Starting Constrained Foward pass");
            atLeastOneInitialState = false;
            i = 0;
            while (i < numStates) {
                initialCost = var1_1.getState((int)i).initialCost;
                if (initialCost < Infinity) {
                    this.getLatticeNode((int)0, (int)i).alpha = initialCost;
                    atLeastOneInitialState = true;
                }
                ++i;
            }
            if (!atLeastOneInitialState) {
                Transducer.access$0().warning("There are no starting states!");
            }
            ip = 0;
            while (ip < this.latticeLength - 1) {
                i = 0;
                while (i < numStates) {
                    block51: {
                        block50: {
                            Transducer.access$0().fine("ip=" + ip + ", i=" + i);
                            if (constraints[ip] <= 0) break block50;
                            if (constraints[ip] - 1 == i) ** GOTO lbl-1000
                            Transducer.access$0().fine("Current state does not match positive constraint. position=" + ip + ", constraint=" + (constraints[ip] - 1) + ", currState=" + i);
                            break block51;
                        }
                        if (constraints[ip] < 0 && constraints[ip] + 1 == -i) {
                            Transducer.access$0().fine("Current state does not match negative constraint. position=" + ip + ", constraint=" + (constraints[ip] + 1) + ", currState=" + i);
                        } else if (this.nodes[ip][i] == null || this.nodes[ip][i].alpha == Infinity) {
                            if (this.nodes[ip][i] == null) {
                                Transducer.access$0().fine("nodes[ip][i] is NULL");
                            } else if (this.nodes[ip][i].alpha == Infinity) {
                                Transducer.access$0().fine("nodes[ip][i].alpha is Inf");
                            }
                            Transducer.access$0().fine("INFINITE cost or NULL...skipping");
                        } else {
                            s = var1_1.getState(i);
                            iter = s.transitionIterator(input, ip, output, ip);
                            if (Transducer.access$0().isLoggable(Level.FINE)) {
                                Transducer.access$0().fine(" Starting Forward transition iteration from state " + s.getName() + " on input " + input.get(ip).toString() + " and output " + (output == null ? "(null)" : output.get(ip).toString()));
                            }
                            while (iter.hasNext()) {
                                destination = iter.nextState();
                                legalTransition = true;
                                if (ip + 1 < constraints.length && constraints[ip + 1] > 0 && constraints[ip + 1] - 1 != destination.getIndex()) {
                                    Transducer.access$0().fine("Destination state does not match positive constraint. Assigning infinite cost. position=" + (ip + 1) + ", constraint=" + (constraints[ip + 1] - 1) + ", source =" + i + ", destination=" + destination.getIndex());
                                    legalTransition = false;
                                } else if (ip + 1 < constraints.length && constraints[ip + 1] < 0 && -(constraints[ip + 1] + 1) == destination.getIndex()) {
                                    Transducer.access$0().fine("Destination state does not match negative constraint. Assigning infinite cost. position=" + (ip + 1) + ", constraint=" + (constraints[ip + 1] + 1) + ", destination=" + destination.getIndex());
                                    legalTransition = false;
                                }
                                if (Transducer.access$0().isLoggable(Level.FINE)) {
                                    Transducer.access$0().fine("Forward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                                }
                                destinationNode = this.getLatticeNode(ip + 1, destination.getIndex());
                                destinationNode.output = iter.getOutput();
                                transitionCost = iter.getCost();
                                if (legalTransition) {
                                    Transducer.access$0().fine("transitionCost=" + transitionCost + " nodes[" + ip + "][" + i + "].alpha=" + this.nodes[ip][i].alpha + " destinationNode.alpha=" + destinationNode.alpha);
                                    destinationNode.alpha = Transducer.sumNegLogProb(destinationNode.alpha, this.nodes[ip][i].alpha + transitionCost);
                                    Transducer.access$0().fine("Set alpha of latticeNode at ip = " + (ip + 1) + " stateIndex = " + destination.getIndex() + ", destinationNode.alpha = " + destinationNode.alpha);
                                    continue;
                                }
                                Transducer.access$0().fine("Illegal transition from state " + i + " to state " + destination.getIndex() + ". Setting alpha to Inf");
                            }
                        }
                    }
                    ++i;
                }
                ++ip;
            }
            this.cost = Infinity;
            i = 0;
            while (i < numStates) {
                if (!(this.nodes[this.latticeLength - 1][i] == null || constraints[this.latticeLength - 1] > 0 && i != constraints[this.latticeLength - 1] - 1 || constraints[this.latticeLength - 1] < 0 && -i == constraints[this.latticeLength - 1] + 1)) {
                    Transducer.access$0().fine("Summing final lattice cost. state=" + i + ", alpha=" + this.nodes[this.latticeLength - 1][i].alpha + ", final cost = " + var1_1.getState((int)i).finalCost);
                    this.cost = Transducer.sumNegLogProb(this.cost, this.nodes[this.latticeLength - 1][i].alpha + var1_1.getState((int)i).finalCost);
                }
                ++i;
            }
            if (this.cost == Infinity) {
                return;
            }
            i = 0;
            while (i < numStates) {
                if (this.nodes[this.latticeLength - 1][i] != null) {
                    s = var1_1.getState(i);
                    this.nodes[this.latticeLength - 1][i].beta = s.finalCost;
                    this.gammas[this.latticeLength - 1][i] = this.nodes[this.latticeLength - 1][i].alpha + this.nodes[this.latticeLength - 1][i].beta - this.cost;
                    if (increment) {
                        p = Math.exp(-this.gammas[this.latticeLength - 1][i]);
                        if (!(Lattice.$assertionsDisabled || p < Infinity && !Double.isNaN(p))) {
                            throw new AssertionError((Object)("p=" + p + " gamma=" + this.gammas[this.latticeLength - 1][i]));
                        }
                        s.incrementFinalCount(p);
                    }
                }
                ++i;
            }
            ip = this.latticeLength - 2;
            while (ip >= 0) {
                i = 0;
                while (i < numStates) {
                    if (this.nodes[ip][i] != null && this.nodes[ip][i].alpha != Infinity) {
                        s = var1_1.getState(i);
                        iter = s.transitionIterator(input, ip, output, ip);
                        while (iter.hasNext()) {
                            destination = iter.nextState();
                            if (Transducer.access$0().isLoggable(Level.FINE)) {
                                Transducer.access$0().fine("Backward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                            }
                            if ((destinationNode = this.nodes[ip + 1][j = destination.getIndex()]) == null) continue;
                            transitionCost = iter.getCost();
                            if (!Lattice.$assertionsDisabled && Double.isNaN(transitionCost)) {
                                throw new AssertionError();
                            }
                            oldBeta = this.nodes[ip][i].beta;
                            if (!Lattice.$assertionsDisabled && Double.isNaN(this.nodes[ip][i].beta)) {
                                throw new AssertionError();
                            }
                            this.nodes[ip][i].beta = Transducer.sumNegLogProb(this.nodes[ip][i].beta, destinationNode.beta + transitionCost);
                            if (!Lattice.$assertionsDisabled && Double.isNaN(this.nodes[ip][i].beta)) {
                                throw new AssertionError((Object)("dest.beta=" + destinationNode.beta + " trans=" + transitionCost + " sum=" + (destinationNode.beta + transitionCost) + " oldBeta=" + oldBeta));
                            }
                            if (!Lattice.$assertionsDisabled && Double.isNaN(this.nodes[ip][i].alpha)) {
                                throw new AssertionError();
                            }
                            if (!Lattice.$assertionsDisabled && Double.isNaN(transitionCost)) {
                                throw new AssertionError();
                            }
                            if (!Lattice.$assertionsDisabled && Double.isNaN(this.nodes[ip + 1][j].beta)) {
                                throw new AssertionError();
                            }
                            if (!Lattice.$assertionsDisabled && Double.isNaN(this.cost)) {
                                throw new AssertionError();
                            }
                            if (!increment && outputAlphabet == null) continue;
                            xi = this.nodes[ip][i].alpha + transitionCost + this.nodes[ip + 1][j].beta - this.cost;
                            p = Math.exp(-xi);
                            if (!(Lattice.$assertionsDisabled || p < Infinity && !Double.isNaN(p))) {
                                throw new AssertionError((Object)("xis[" + ip + "][" + i + "][" + j + "]=" + -xi));
                            }
                            if (increment) {
                                iter.incrementCount(p);
                            }
                            if (outputAlphabet == null) continue;
                            outputIndex = outputAlphabet.lookupIndex(iter.getOutput(), false);
                            if (!Lattice.$assertionsDisabled && outputIndex < 0) {
                                throw new AssertionError();
                            }
                            v0 = outputCounts[ip];
                            v1 = outputIndex;
                            v0[v1] = v0[v1] + p;
                        }
                        this.gammas[ip][i] = this.nodes[ip][i].alpha + this.nodes[ip][i].beta - this.cost;
                    }
                    ++i;
                }
                --ip;
            }
            if (increment) {
                i = 0;
                while (i < numStates) {
                    p = Math.exp(-this.gammas[0][i]);
                    if (!(Lattice.$assertionsDisabled || p < Infinity && !Double.isNaN(p))) {
                        throw new AssertionError();
                    }
                    var1_1.getState(i).incrementInitialCount(p);
                    ++i;
                }
            }
            if (outputAlphabet != null) {
                this.labelings = new LabelVector[this.latticeLength];
                ip = this.latticeLength - 2;
                while (ip >= 0) {
                    if (!Lattice.$assertionsDisabled && !(Math.abs(1.0 - DenseVector.sum(outputCounts[ip])) < 1.0E-6)) {
                        throw new AssertionError();
                    }
                    this.labelings[ip] = new LabelVector(outputAlphabet, outputCounts[ip]);
                    --ip;
                }
            }
        }

        public double getCost() {
            if (!$assertionsDisabled && Double.isNaN(this.cost)) {
                throw new AssertionError();
            }
            return this.cost;
        }

        public double getGammaCost(int inputPosition, State s) {
            return this.gammas[inputPosition][s.getIndex()];
        }

        public double getGammaProbability(int inputPosition, State s) {
            return Math.exp(-this.gammas[inputPosition][s.getIndex()]);
        }

        public double getXiProbability(int ip, State s1, State s2) {
            if (this.xis == null) {
                throw new IllegalStateException("xis were not saved.");
            }
            int i = s1.getIndex();
            int j = s2.getIndex();
            return Math.exp(-this.xis[ip][i][j]);
        }

        public double getXiCost(int ip, State s1, State s2) {
            if (this.xis == null) {
                throw new IllegalStateException("xis were not saved.");
            }
            int i = s1.getIndex();
            int j = s2.getIndex();
            return this.xis[ip][i][j];
        }

        public int length() {
            return this.latticeLength;
        }

        public double getAlpha(int ip, State s) {
            LatticeNode node = this.getLatticeNode(ip, s.getIndex());
            return node.alpha;
        }

        public double getBeta(int ip, State s) {
            LatticeNode node = this.getLatticeNode(ip, s.getIndex());
            return node.beta;
        }

        public LabelVector getLabelingAtPosition(int outputPosition) {
            if (this.labelings != null) {
                return this.labelings[outputPosition];
            }
            return null;
        }

        public Transducer getTransducer() {
            return this.this$0;
        }

        private class LatticeNode {
            int inputPosition;
            State state;
            Object output;
            double alpha = Double.POSITIVE_INFINITY;
            double beta = Double.POSITIVE_INFINITY;
            static final /* synthetic */ boolean $assertionsDisabled;

            static {
                $assertionsDisabled = !LatticeNode.class.desiredAssertionStatus();
            }

            LatticeNode(int inputPosition, State state) {
                this.inputPosition = inputPosition;
                this.state = state;
                if (!$assertionsDisabled && this.alpha != Double.POSITIVE_INFINITY) {
                    throw new AssertionError();
                }
            }
        }
    }

    /*
     * Exception performing whole class analysis.
     */
    public class BeamLattice {
        double cost;
        Sequence input;
        Sequence output;
        LatticeNode[][] nodes;
        int latticeLength;
        int curBeamWidth;
        double[][] gammas;
        double[][][] xis;
        LabelVector[] labelings;
        final /* synthetic */ Transducer this$0;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !BeamLattice.class.desiredAssertionStatus();
        }

        private LatticeNode getLatticeNode(int ip, int stateIndex) {
            if (this.nodes[ip][stateIndex] == null) {
                this.nodes[ip][stateIndex] = new LatticeNode(ip, this.this$0.getState(stateIndex));
            }
            return this.nodes[ip][stateIndex];
        }

        protected BeamLattice(Transducer transducer, Sequence input, Sequence output, boolean increment) {
            this(transducer, input, output, increment, false, null);
        }

        protected BeamLattice(Transducer transducer, Sequence input, Sequence output, boolean increment, boolean saveXis) {
            this(transducer, input, output, increment, saveXis, null);
        }

        protected BeamLattice(Transducer transducer, Sequence input, Sequence output, boolean increment, boolean saveXis, LabelAlphabet outputAlphabet) {
            this.this$0 = transducer;
            this.input = input;
            this.output = output;
            this.latticeLength = input.size() + 1;
            int numStates = transducer.numStates();
            this.nodes = new LatticeNode[this.latticeLength][numStates];
            this.gammas = new double[this.latticeLength][numStates];
            if (saveXis) {
                this.xis = new double[this.latticeLength][numStates][numStates];
            }
            double[][] outputCounts = null;
            if (outputAlphabet != null) {
                outputCounts = new double[this.latticeLength][outputAlphabet.size()];
            }
            int i = 0;
            while (i < numStates) {
                int ip = 0;
                while (ip < this.latticeLength) {
                    this.gammas[ip][i] = Double.POSITIVE_INFINITY;
                    ++ip;
                }
                if (saveXis) {
                    int j = 0;
                    while (j < numStates) {
                        int ip2 = 0;
                        while (ip2 < this.latticeLength) {
                            this.xis[ip2][i][j] = Double.POSITIVE_INFINITY;
                            ++ip2;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            logger.fine("Starting Foward pass");
            boolean atLeastOneInitialState = false;
            int i2 = 0;
            while (i2 < numStates) {
                double initialCost = transducer.getState((int)i2).initialCost;
                if (initialCost < Double.POSITIVE_INFINITY) {
                    this.getLatticeNode((int)0, (int)i2).alpha = initialCost;
                    atLeastOneInitialState = true;
                }
                ++i2;
            }
            if (!atLeastOneInitialState) {
                logger.warning("There are no starting states!");
            }
            NBestSlist[] slists = new NBestSlist[this.latticeLength];
            transducer.nstatesExpl = new double[this.latticeLength];
            this.curBeamWidth = transducer.curIter == 0 ? numStates : (transducer.tctIter > 1 && transducer.curIter != 0 ? transducer.beamWidth : transducer.beamWidth);
            int ip = 0;
            while (ip < this.latticeLength - 1) {
                slists[ip] = new NBestSlist(numStates);
                slists[ip].setKLMinE(this.curBeamWidth);
                slists[ip].setKLeps(transducer.KLeps);
                slists[ip].setRmin(transducer.Rmin);
                int i3 = 0;
                while (i3 < numStates) {
                    if (this.nodes[ip][i3] != null && this.nodes[ip][i3].alpha != Double.POSITIVE_INFINITY) {
                        NBForBackNode cnode = new NBForBackNode(this.nodes[ip][i3].alpha, i3);
                        slists[ip].push(cnode);
                    }
                    ++i3;
                }
                int KLMaxPos = 1;
                int RminPos = 1;
                if (transducer.KLeps > 0.0) {
                    KLMaxPos = slists[ip].getKLpos();
                    ((Transducer)transducer).nstatesExpl[ip] = KLMaxPos;
                } else if (transducer.KLeps == 0.0) {
                    if (transducer.Rmin > 0.0) {
                        RminPos = slists[ip].getTHRpos();
                    } else {
                        slists[ip].setRmin(-transducer.Rmin);
                        RminPos = slists[ip].getTHRposSTRAWMAN();
                    }
                    ((Transducer)transducer).nstatesExpl[ip] = RminPos;
                } else {
                    slists[ip].setKLeps(-transducer.KLeps);
                    KLMaxPos = slists[ip].getKLpos();
                    if (transducer.Rmin > 0.0) {
                        RminPos = slists[ip].getTHRpos();
                    } else {
                        slists[ip].setRmin(-transducer.Rmin);
                        RminPos = slists[ip].getTHRposSTRAWMAN();
                    }
                    ((Transducer)transducer).nstatesExpl[ip] = KLMaxPos > RminPos ? (double)KLMaxPos : (double)RminPos;
                }
                int i4 = (int)transducer.nstatesExpl[ip] + 1;
                while (i4 < slists[ip].size()) {
                    int tmppos = slists[ip].getPosByIndex(i4);
                    this.nodes[ip][tmppos].alpha = Double.POSITIVE_INFINITY;
                    this.nodes[ip][tmppos] = null;
                    ++i4;
                }
                int jj = 0;
                while ((double)jj < transducer.nstatesExpl[ip]) {
                    int i5 = slists[ip].getPosByIndex(jj);
                    State s = transducer.getState(i5);
                    TransitionIterator iter = s.transitionIterator(input, ip, output, ip);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(" Starting Foward transition iteration from state " + s.getName() + " on input " + input.get(ip).toString() + " and output " + (output == null ? "(null)" : output.get(ip).toString()));
                    }
                    while (iter.hasNext()) {
                        State destination = iter.nextState();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Forward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                        }
                        LatticeNode destinationNode = this.getLatticeNode(ip + 1, destination.getIndex());
                        destinationNode.output = iter.getOutput();
                        double transitionCost = iter.getCost();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("transitionCost=" + transitionCost + " nodes[" + ip + "][" + i5 + "].alpha=" + this.nodes[ip][i5].alpha + " destinationNode.alpha=" + destinationNode.alpha);
                        }
                        destinationNode.alpha = Transducer.sumNegLogProb(destinationNode.alpha, this.nodes[ip][i5].alpha + transitionCost);
                    }
                    ++jj;
                }
                ++ip;
            }
            transducer.curAvgNstatesExpl = MatrixOps.mean(transducer.nstatesExpl);
            this.cost = Double.POSITIVE_INFINITY;
            int i6 = 0;
            while (i6 < numStates) {
                if (this.nodes[this.latticeLength - 1][i6] != null) {
                    this.cost = Transducer.sumNegLogProb(this.cost, this.nodes[this.latticeLength - 1][i6].alpha + transducer.getState((int)i6).finalCost);
                }
                ++i6;
            }
            if (this.cost == Double.POSITIVE_INFINITY) {
                return;
            }
            i6 = 0;
            while (i6 < numStates) {
                if (this.nodes[this.latticeLength - 1][i6] != null) {
                    State s = transducer.getState(i6);
                    this.nodes[this.latticeLength - 1][i6].beta = s.finalCost;
                    this.gammas[this.latticeLength - 1][i6] = this.nodes[this.latticeLength - 1][i6].alpha + this.nodes[this.latticeLength - 1][i6].beta - this.cost;
                    if (increment) {
                        double p = Math.exp(-this.gammas[this.latticeLength - 1][i6]);
                        if (!($assertionsDisabled || p < Double.POSITIVE_INFINITY && !Double.isNaN(p))) {
                            throw new AssertionError((Object)("p=" + p + " gamma=" + this.gammas[this.latticeLength - 1][i6]));
                        }
                        s.incrementFinalCount(p);
                    }
                }
                ++i6;
            }
            ip = this.latticeLength - 2;
            while (ip >= 0) {
                int i7 = 0;
                while (i7 < numStates) {
                    if (this.nodes[ip][i7] != null && this.nodes[ip][i7].alpha != Double.POSITIVE_INFINITY) {
                        State s = transducer.getState(i7);
                        TransitionIterator iter = s.transitionIterator(input, ip, output, ip);
                        while (iter.hasNext()) {
                            int j;
                            LatticeNode destinationNode;
                            State destination = iter.nextState();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Backward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                            }
                            if ((destinationNode = this.nodes[ip + 1][j = destination.getIndex()]) == null) continue;
                            double transitionCost = iter.getCost();
                            if (!$assertionsDisabled && Double.isNaN(transitionCost)) {
                                throw new AssertionError();
                            }
                            double oldBeta = this.nodes[ip][i7].beta;
                            if (!$assertionsDisabled && Double.isNaN(this.nodes[ip][i7].beta)) {
                                throw new AssertionError();
                            }
                            this.nodes[ip][i7].beta = Transducer.sumNegLogProb(this.nodes[ip][i7].beta, destinationNode.beta + transitionCost);
                            if (!$assertionsDisabled && Double.isNaN(this.nodes[ip][i7].beta)) {
                                throw new AssertionError((Object)("dest.beta=" + destinationNode.beta + " trans=" + transitionCost + " sum=" + (destinationNode.beta + transitionCost) + " oldBeta=" + oldBeta));
                            }
                            double xi = this.nodes[ip][i7].alpha + transitionCost + this.nodes[ip + 1][j].beta - this.cost;
                            if (saveXis) {
                                this.xis[ip][i7][j] = xi;
                            }
                            if (!$assertionsDisabled && Double.isNaN(this.nodes[ip][i7].alpha)) {
                                throw new AssertionError();
                            }
                            if (!$assertionsDisabled && Double.isNaN(transitionCost)) {
                                throw new AssertionError();
                            }
                            if (!$assertionsDisabled && Double.isNaN(this.nodes[ip + 1][j].beta)) {
                                throw new AssertionError();
                            }
                            if (!$assertionsDisabled && Double.isNaN(this.cost)) {
                                throw new AssertionError();
                            }
                            if (!increment && outputAlphabet == null) continue;
                            double p = Math.exp(-xi);
                            if (!($assertionsDisabled || p < Double.POSITIVE_INFINITY && !Double.isNaN(p))) {
                                throw new AssertionError((Object)("xis[" + ip + "][" + i7 + "][" + j + "]=" + -xi));
                            }
                            if (increment) {
                                iter.incrementCount(p);
                            }
                            if (outputAlphabet == null) continue;
                            int outputIndex = outputAlphabet.lookupIndex(iter.getOutput(), false);
                            if (!$assertionsDisabled && outputIndex < 0) {
                                throw new AssertionError();
                            }
                            double[] dArray = outputCounts[ip];
                            int n = outputIndex;
                            dArray[n] = dArray[n] + p;
                        }
                        this.gammas[ip][i7] = this.nodes[ip][i7].alpha + this.nodes[ip][i7].beta - this.cost;
                    }
                    ++i7;
                }
                double checknorm = Double.POSITIVE_INFINITY;
                int i8 = 0;
                while (i8 < numStates) {
                    if (this.nodes[ip][i8] != null) {
                        checknorm = Transducer.sumNegLogProb(checknorm, this.gammas[ip][i8]);
                    }
                    ++i8;
                }
                i8 = 0;
                while (i8 < numStates) {
                    if (this.nodes[ip][i8] != null) {
                        this.gammas[ip][i8] = this.gammas[ip][i8] - checknorm;
                    }
                    ++i8;
                }
                --ip;
            }
            if (increment) {
                i6 = 0;
                while (i6 < numStates) {
                    double p = Math.exp(-this.gammas[0][i6]);
                    if (!($assertionsDisabled || p < Double.POSITIVE_INFINITY && !Double.isNaN(p))) {
                        throw new AssertionError();
                    }
                    transducer.getState(i6).incrementInitialCount(p);
                    ++i6;
                }
            }
            if (outputAlphabet != null) {
                this.labelings = new LabelVector[this.latticeLength];
                ip = this.latticeLength - 2;
                while (ip >= 0) {
                    if (!$assertionsDisabled && !(Math.abs(1.0 - DenseVector.sum(outputCounts[ip])) < 1.0E-6)) {
                        throw new AssertionError();
                    }
                    this.labelings[ip] = new LabelVector(outputAlphabet, outputCounts[ip]);
                    --ip;
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        protected BeamLattice(Transducer var1_1, Sequence input, Sequence output, boolean increment, LabelAlphabet outputAlphabet, int[] constraints) {
            this.this$0 = var1_1;
            super();
            this.input = input;
            this.output = output;
            this.latticeLength = input.size() + 1;
            numStates = var1_1.numStates();
            this.nodes = new LatticeNode[this.latticeLength][numStates];
            this.gammas = new double[this.latticeLength][numStates];
            outputCounts = null;
            if (outputAlphabet != null) {
                outputCounts = new double[this.latticeLength][outputAlphabet.size()];
            }
            i = 0;
            while (i < numStates) {
                ip = 0;
                while (ip < this.latticeLength) {
                    this.gammas[ip][i] = Infinity;
                    ++ip;
                }
                ++i;
            }
            Transducer.access$0().fine("Starting Constrained Foward pass");
            atLeastOneInitialState = false;
            i = 0;
            while (i < numStates) {
                initialCost = var1_1.getState((int)i).initialCost;
                if (initialCost < Infinity) {
                    this.getLatticeNode((int)0, (int)i).alpha = initialCost;
                    atLeastOneInitialState = true;
                }
                ++i;
            }
            if (!atLeastOneInitialState) {
                Transducer.access$0().warning("There are no starting states!");
            }
            ip = 0;
            while (ip < this.latticeLength - 1) {
                i = 0;
                while (i < numStates) {
                    block51: {
                        block50: {
                            Transducer.access$0().fine("ip=" + ip + ", i=" + i);
                            if (constraints[ip] <= 0) break block50;
                            if (constraints[ip] - 1 == i) ** GOTO lbl-1000
                            Transducer.access$0().fine("Current state does not match positive constraint. position=" + ip + ", constraint=" + (constraints[ip] - 1) + ", currState=" + i);
                            break block51;
                        }
                        if (constraints[ip] < 0 && constraints[ip] + 1 == -i) {
                            Transducer.access$0().fine("Current state does not match negative constraint. position=" + ip + ", constraint=" + (constraints[ip] + 1) + ", currState=" + i);
                        } else if (this.nodes[ip][i] == null || this.nodes[ip][i].alpha == Infinity) {
                            if (this.nodes[ip][i] == null) {
                                Transducer.access$0().fine("nodes[ip][i] is NULL");
                            } else if (this.nodes[ip][i].alpha == Infinity) {
                                Transducer.access$0().fine("nodes[ip][i].alpha is Inf");
                            }
                            Transducer.access$0().fine("INFINITE cost or NULL...skipping");
                        } else {
                            s = var1_1.getState(i);
                            iter = s.transitionIterator(input, ip, output, ip);
                            if (Transducer.access$0().isLoggable(Level.FINE)) {
                                Transducer.access$0().fine(" Starting Forward transition iteration from state " + s.getName() + " on input " + input.get(ip).toString() + " and output " + (output == null ? "(null)" : output.get(ip).toString()));
                            }
                            while (iter.hasNext()) {
                                destination = iter.nextState();
                                legalTransition = true;
                                if (ip + 1 < constraints.length && constraints[ip + 1] > 0 && constraints[ip + 1] - 1 != destination.getIndex()) {
                                    Transducer.access$0().fine("Destination state does not match positive constraint. Assigning infinite cost. position=" + (ip + 1) + ", constraint=" + (constraints[ip + 1] - 1) + ", source =" + i + ", destination=" + destination.getIndex());
                                    legalTransition = false;
                                } else if (ip + 1 < constraints.length && constraints[ip + 1] < 0 && -(constraints[ip + 1] + 1) == destination.getIndex()) {
                                    Transducer.access$0().fine("Destination state does not match negative constraint. Assigning infinite cost. position=" + (ip + 1) + ", constraint=" + (constraints[ip + 1] + 1) + ", destination=" + destination.getIndex());
                                    legalTransition = false;
                                }
                                if (Transducer.access$0().isLoggable(Level.FINE)) {
                                    Transducer.access$0().fine("Forward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                                }
                                destinationNode = this.getLatticeNode(ip + 1, destination.getIndex());
                                destinationNode.output = iter.getOutput();
                                transitionCost = iter.getCost();
                                if (legalTransition) {
                                    Transducer.access$0().fine("transitionCost=" + transitionCost + " nodes[" + ip + "][" + i + "].alpha=" + this.nodes[ip][i].alpha + " destinationNode.alpha=" + destinationNode.alpha);
                                    destinationNode.alpha = Transducer.sumNegLogProb(destinationNode.alpha, this.nodes[ip][i].alpha + transitionCost);
                                    Transducer.access$0().fine("Set alpha of latticeNode at ip = " + (ip + 1) + " stateIndex = " + destination.getIndex() + ", destinationNode.alpha = " + destinationNode.alpha);
                                    continue;
                                }
                                Transducer.access$0().fine("Illegal transition from state " + i + " to state " + destination.getIndex() + ". Setting alpha to Inf");
                            }
                        }
                    }
                    ++i;
                }
                ++ip;
            }
            this.cost = Infinity;
            i = 0;
            while (i < numStates) {
                if (!(this.nodes[this.latticeLength - 1][i] == null || constraints[this.latticeLength - 1] > 0 && i != constraints[this.latticeLength - 1] - 1 || constraints[this.latticeLength - 1] < 0 && -i == constraints[this.latticeLength - 1] + 1)) {
                    Transducer.access$0().fine("Summing final lattice cost. state=" + i + ", alpha=" + this.nodes[this.latticeLength - 1][i].alpha + ", final cost = " + var1_1.getState((int)i).finalCost);
                    this.cost = Transducer.sumNegLogProb(this.cost, this.nodes[this.latticeLength - 1][i].alpha + var1_1.getState((int)i).finalCost);
                }
                ++i;
            }
            if (this.cost == Infinity) {
                return;
            }
            i = 0;
            while (i < numStates) {
                if (this.nodes[this.latticeLength - 1][i] != null) {
                    s = var1_1.getState(i);
                    this.nodes[this.latticeLength - 1][i].beta = s.finalCost;
                    this.gammas[this.latticeLength - 1][i] = this.nodes[this.latticeLength - 1][i].alpha + this.nodes[this.latticeLength - 1][i].beta - this.cost;
                    if (increment) {
                        p = Math.exp(-this.gammas[this.latticeLength - 1][i]);
                        if (!(BeamLattice.$assertionsDisabled || p < Infinity && !Double.isNaN(p))) {
                            throw new AssertionError((Object)("p=" + p + " gamma=" + this.gammas[this.latticeLength - 1][i]));
                        }
                        s.incrementFinalCount(p);
                    }
                }
                ++i;
            }
            ip = this.latticeLength - 2;
            while (ip >= 0) {
                i = 0;
                while (i < numStates) {
                    if (this.nodes[ip][i] != null && this.nodes[ip][i].alpha != Infinity) {
                        s = var1_1.getState(i);
                        iter = s.transitionIterator(input, ip, output, ip);
                        while (iter.hasNext()) {
                            destination = iter.nextState();
                            if (Transducer.access$0().isLoggable(Level.FINE)) {
                                Transducer.access$0().fine("Backward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                            }
                            if ((destinationNode = this.nodes[ip + 1][j = destination.getIndex()]) == null) continue;
                            transitionCost = iter.getCost();
                            if (!BeamLattice.$assertionsDisabled && Double.isNaN(transitionCost)) {
                                throw new AssertionError();
                            }
                            oldBeta = this.nodes[ip][i].beta;
                            if (!BeamLattice.$assertionsDisabled && Double.isNaN(this.nodes[ip][i].beta)) {
                                throw new AssertionError();
                            }
                            this.nodes[ip][i].beta = Transducer.sumNegLogProb(this.nodes[ip][i].beta, destinationNode.beta + transitionCost);
                            if (!BeamLattice.$assertionsDisabled && Double.isNaN(this.nodes[ip][i].beta)) {
                                throw new AssertionError((Object)("dest.beta=" + destinationNode.beta + " trans=" + transitionCost + " sum=" + (destinationNode.beta + transitionCost) + " oldBeta=" + oldBeta));
                            }
                            if (!BeamLattice.$assertionsDisabled && Double.isNaN(this.nodes[ip][i].alpha)) {
                                throw new AssertionError();
                            }
                            if (!BeamLattice.$assertionsDisabled && Double.isNaN(transitionCost)) {
                                throw new AssertionError();
                            }
                            if (!BeamLattice.$assertionsDisabled && Double.isNaN(this.nodes[ip + 1][j].beta)) {
                                throw new AssertionError();
                            }
                            if (!BeamLattice.$assertionsDisabled && Double.isNaN(this.cost)) {
                                throw new AssertionError();
                            }
                            if (!increment && outputAlphabet == null) continue;
                            xi = this.nodes[ip][i].alpha + transitionCost + this.nodes[ip + 1][j].beta - this.cost;
                            p = Math.exp(-xi);
                            if (!(BeamLattice.$assertionsDisabled || p < Infinity && !Double.isNaN(p))) {
                                throw new AssertionError((Object)("xis[" + ip + "][" + i + "][" + j + "]=" + -xi));
                            }
                            if (increment) {
                                iter.incrementCount(p);
                            }
                            if (outputAlphabet == null) continue;
                            outputIndex = outputAlphabet.lookupIndex(iter.getOutput(), false);
                            if (!BeamLattice.$assertionsDisabled && outputIndex < 0) {
                                throw new AssertionError();
                            }
                            v0 = outputCounts[ip];
                            v1 = outputIndex;
                            v0[v1] = v0[v1] + p;
                        }
                        this.gammas[ip][i] = this.nodes[ip][i].alpha + this.nodes[ip][i].beta - this.cost;
                    }
                    ++i;
                }
                --ip;
            }
            if (increment) {
                i = 0;
                while (i < numStates) {
                    p = Math.exp(-this.gammas[0][i]);
                    if (!(BeamLattice.$assertionsDisabled || p < Infinity && !Double.isNaN(p))) {
                        throw new AssertionError();
                    }
                    var1_1.getState(i).incrementInitialCount(p);
                    ++i;
                }
            }
            if (outputAlphabet != null) {
                this.labelings = new LabelVector[this.latticeLength];
                ip = this.latticeLength - 2;
                while (ip >= 0) {
                    if (!BeamLattice.$assertionsDisabled && !(Math.abs(1.0 - DenseVector.sum(outputCounts[ip])) < 1.0E-6)) {
                        throw new AssertionError();
                    }
                    this.labelings[ip] = new LabelVector(outputAlphabet, outputCounts[ip]);
                    --ip;
                }
            }
        }

        public double getCost() {
            if (!$assertionsDisabled && Double.isNaN(this.cost)) {
                throw new AssertionError();
            }
            return this.cost;
        }

        public double getGammaCost(int inputPosition, State s) {
            return this.gammas[inputPosition][s.getIndex()];
        }

        public double getGammaProbability(int inputPosition, State s) {
            return Math.exp(-this.gammas[inputPosition][s.getIndex()]);
        }

        public double getXiProbability(int ip, State s1, State s2) {
            if (this.xis == null) {
                throw new IllegalStateException("xis were not saved.");
            }
            int i = s1.getIndex();
            int j = s2.getIndex();
            return Math.exp(-this.xis[ip][i][j]);
        }

        public double getXiCost(int ip, State s1, State s2) {
            if (this.xis == null) {
                throw new IllegalStateException("xis were not saved.");
            }
            int i = s1.getIndex();
            int j = s2.getIndex();
            return this.xis[ip][i][j];
        }

        public int length() {
            return this.latticeLength;
        }

        public double getAlpha(int ip, State s) {
            LatticeNode node = this.getLatticeNode(ip, s.getIndex());
            return node.alpha;
        }

        public double getBeta(int ip, State s) {
            LatticeNode node = this.getLatticeNode(ip, s.getIndex());
            return node.beta;
        }

        public LabelVector getLabelingAtPosition(int outputPosition) {
            if (this.labelings != null) {
                return this.labelings[outputPosition];
            }
            return null;
        }

        public Transducer getTransducer() {
            return this.this$0;
        }

        private class NBForBackNode {
            double cost;
            int pos;

            NBForBackNode(double cost, int pos) {
                this.cost = cost;
                this.pos = pos;
            }
        }

        private class NBestSlist {
            ArrayList list = new ArrayList();
            int MaxElements;
            int KLMinElements;
            int KLMaxPos;
            double KLeps;
            double Rmin;

            NBestSlist(int MaxElements) {
                this.MaxElements = MaxElements;
            }

            boolean setKLMinE(int KLMinElements) {
                this.KLMinElements = KLMinElements;
                return true;
            }

            int size() {
                return this.list.size();
            }

            boolean empty() {
                return this.list.isEmpty();
            }

            Object pop() {
                return this.list.remove(0);
            }

            int getPosByIndex(int ii) {
                NBForBackNode tn = (NBForBackNode)this.list.get(ii);
                return tn.pos;
            }

            double getCostByIndex(int ii) {
                NBForBackNode tn = (NBForBackNode)this.list.get(ii);
                return tn.cost;
            }

            void setKLeps(double KLeps) {
                this.KLeps = KLeps;
            }

            void setRmin(double Rmin) {
                this.Rmin = Rmin;
            }

            int getTHRpos() {
                NBForBackNode tn = (NBForBackNode)this.list.get(0);
                double lc1 = tn.cost;
                tn = (NBForBackNode)this.list.get(this.list.size() - 1);
                double lc2 = tn.cost;
                double minc = lc1 - lc2;
                double mincTHR = minc - minc * this.Rmin;
                int i = 1;
                while (i < this.list.size()) {
                    tn = (NBForBackNode)this.list.get(i);
                    lc1 = tn.cost - lc2;
                    if (lc1 > mincTHR) {
                        return i + 1;
                    }
                    ++i;
                }
                return this.list.size();
            }

            int getTHRposSTRAWMAN() {
                NBForBackNode tn = (NBForBackNode)this.list.get(0);
                double lc1 = tn.cost;
                double mincTHR = -lc1 * this.Rmin;
                int i = 1;
                while (i < this.list.size()) {
                    tn = (NBForBackNode)this.list.get(i);
                    lc1 = -tn.cost;
                    if (lc1 < mincTHR) {
                        return i + 1;
                    }
                    ++i;
                }
                return this.list.size();
            }

            int getKLpos() {
                double[] CSNLP = new double[this.MaxElements];
                NBForBackNode tn = (NBForBackNode)this.list.get(this.list.size() - 1);
                double worstc = tn.cost;
                int i = 0;
                while (i < this.list.size()) {
                    tn = (NBForBackNode)this.list.get(i);
                    double lc = tn.cost;
                    CSNLP[i] = i == 0 ? lc : Transducer.sumNegLogProb(CSNLP[i - 1], lc);
                    ++i;
                }
                i = 0;
                while (i < this.list.size()) {
                    CSNLP[i] = CSNLP[i] - CSNLP[this.list.size() - 1];
                    if (CSNLP[i] < this.KLeps) {
                        this.KLMaxPos = i + 1;
                        if (this.KLMaxPos >= this.KLMinElements) {
                            return this.KLMaxPos;
                        }
                        if (this.list.size() >= this.KLMinElements) {
                            return this.KLMinElements;
                        }
                    }
                    ++i;
                }
                this.KLMaxPos = this.list.size();
                return this.KLMaxPos;
            }

            ArrayList push(NBForBackNode vn) {
                double tc = vn.cost;
                boolean atEnd = true;
                int i = 0;
                while (i < this.list.size()) {
                    NBForBackNode tn = (NBForBackNode)this.list.get(i);
                    double lc = tn.cost;
                    if (tc < lc) {
                        this.list.add(i, vn);
                        atEnd = false;
                        break;
                    }
                    ++i;
                }
                if (atEnd) {
                    this.list.add(vn);
                }
                if (this.list.size() > this.MaxElements) {
                    this.list.remove(this.MaxElements);
                }
                return this.list;
            }
        }

        private class LatticeNode {
            int inputPosition;
            State state;
            Object output;
            double alpha = Double.POSITIVE_INFINITY;
            double beta = Double.POSITIVE_INFINITY;
            static final /* synthetic */ boolean $assertionsDisabled;

            static {
                $assertionsDisabled = !LatticeNode.class.desiredAssertionStatus();
            }

            LatticeNode(int inputPosition, State state) {
                this.inputPosition = inputPosition;
                this.state = state;
                if (!$assertionsDisabled && this.alpha != Double.POSITIVE_INFINITY) {
                    throw new AssertionError();
                }
            }
        }
    }

    public class ViterbiPath
    extends SequencePairAlignment {
        Sequence providedOutput;
        ViterbiNode[] nodePath;
        int latticeLength;
        ViterbiNode[][] lattice;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !ViterbiPath.class.desiredAssertionStatus();
        }

        public double getDelta(int ip, int stateIndex) {
            if (this.lattice != null) {
                return this.getViterbiNode((ViterbiNode[][])this.lattice, (int)ip, (int)stateIndex).delta;
            }
            throw new RuntimeException("Attempt to called getDelta() when lattice not stored.");
        }

        public State getBestState(int ip) {
            return this.getStateAtRank(ip, 0);
        }

        public State getStateAtRank(final int ip, int rank) {
            if (this.lattice != null) {
                Integer[] rankedStates = new Integer[Transducer.this.numStates()];
                int k = 0;
                while (k < Transducer.this.numStates()) {
                    rankedStates[k] = new Integer(k);
                    ++k;
                }
                Arrays.sort(rankedStates, new Comparator(){

                    public int compare(Object o, Object o1) {
                        int i1 = (Integer)o;
                        int i2 = (Integer)o1;
                        return Double.compare(ViterbiPath.this.getDelta(ip, i1), ViterbiPath.this.getDelta(ip, i2));
                    }
                });
                return Transducer.this.getState(rankedStates[rank]);
            }
            throw new RuntimeException("Attempt to called getMaxState() when lattice not stored.");
        }

        protected ViterbiNode getViterbiNode(ViterbiNode[][] nodes, int ip, int stateIndex) {
            if (nodes[ip][stateIndex] == null) {
                nodes[ip][stateIndex] = new ViterbiNode(ip, Transducer.this.getState(stateIndex));
            }
            return nodes[ip][stateIndex];
        }

        protected ViterbiPath(Sequence inputSequence, Sequence outputSequence) {
            this(inputSequence, outputSequence, false);
        }

        protected ViterbiPath(Sequence inputSequence, Sequence outputSequence, boolean saveLattice) {
            if (!$assertionsDisabled && inputSequence == null) {
                throw new AssertionError();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting ViterbiPath");
                logger.fine("Input: ");
                int ip = 0;
                while (ip < inputSequence.size()) {
                    logger.fine(" " + inputSequence.get(ip));
                    ++ip;
                }
                logger.fine("\nOutput: ");
                if (outputSequence == null) {
                    logger.fine("null");
                } else {
                    int op = 0;
                    while (op < outputSequence.size()) {
                        logger.fine(" " + outputSequence.get(op));
                        ++op;
                    }
                }
                logger.fine("\n");
            }
            this.input = inputSequence;
            this.providedOutput = outputSequence;
            this.latticeLength = this.input.size() + 1;
            int numStates = Transducer.this.numStates();
            ViterbiNode[][] nodes = new ViterbiNode[this.latticeLength][numStates];
            if (saveLattice) {
                this.lattice = nodes;
            }
            Transducer.this.nstatesExpl = new double[1];
            ((Transducer)Transducer.this).nstatesExpl[0] = numStates;
            logger.fine("Starting Viterbi");
            boolean anyInitialState = false;
            int i = 0;
            while (i < numStates) {
                double initialCost = Transducer.this.getState((int)i).initialCost;
                if (initialCost < Double.POSITIVE_INFINITY) {
                    ViterbiNode n = this.getViterbiNode(nodes, 0, i);
                    n.delta = initialCost;
                    anyInitialState = true;
                }
                ++i;
            }
            if (!anyInitialState) {
                logger.warning("Viterbi: No initial states!");
            }
            int ip = 0;
            while (ip < this.latticeLength - 1) {
                int i2 = 0;
                while (i2 < numStates) {
                    if (nodes[ip][i2] != null && nodes[ip][i2].delta != Double.POSITIVE_INFINITY) {
                        State s = Transducer.this.getState(i2);
                        TransitionIterator iter = s.transitionIterator(this.input, ip, this.providedOutput, ip);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(" Starting Viterbi transition iteration from state " + s.getName() + " on input " + this.input.get(ip));
                        }
                        while (iter.hasNext()) {
                            State destination = iter.nextState();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Viterbi[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                            }
                            ViterbiNode destinationNode = this.getViterbiNode(nodes, ip + 1, destination.getIndex());
                            destinationNode.output = iter.getOutput();
                            this.cost = nodes[ip][i2].delta + iter.getCost();
                            if (ip == this.latticeLength - 2) {
                                this.cost += destination.getFinalCost();
                            }
                            if (!(this.cost < destinationNode.delta)) continue;
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Viterbi[inputPos=" + ip + "][source][dest=" + destination.getName() + "] cost reduced to " + this.cost + " by source=" + s.getName());
                            }
                            destinationNode.delta = this.cost;
                            destinationNode.minCostPredecessor = nodes[ip][i2];
                        }
                    }
                    ++i2;
                }
                ++ip;
            }
            int ip2 = this.latticeLength - 1;
            this.cost = Double.POSITIVE_INFINITY;
            ViterbiNode minCostNode = null;
            int i3 = 0;
            while (i3 < numStates) {
                if (nodes[ip2][i3] != null && nodes[ip2][i3].delta < this.cost) {
                    minCostNode = nodes[ip2][i3];
                    this.cost = minCostNode.delta;
                }
                ++i3;
            }
            if (minCostNode == null) {
                logger.warning("Viterbi: Sequence has infinite cost.  Output will be empty...");
                this.output = new ArraySequence(new ArrayList());
                return;
            }
            this.nodePath = new ViterbiNode[this.latticeLength];
            Object[] outputArray = new Object[this.input.size()];
            ip2 = this.latticeLength - 1;
            while (ip2 >= 0) {
                this.nodePath[ip2] = minCostNode;
                if (ip2 > 0) {
                    outputArray[ip2 - 1] = minCostNode.output;
                }
                minCostNode = minCostNode.minCostPredecessor;
                --ip2;
            }
            this.output = new ArraySequence(outputArray, false);
        }

        public void incrementTransducerCounts() {
            this.nodePath[0].state.incrementInitialCount(1.0);
            this.nodePath[this.nodePath.length - 1].state.incrementFinalCount(1.0);
            int ip = 0;
            while (ip < this.nodePath.length - 1) {
                TransitionIterator iter = this.nodePath[ip].state.transitionIterator(this.input, ip, this.providedOutput, ip);
                int numIncrements = 0;
                while (iter.hasNext()) {
                    if (!iter.nextState().equals(this.nodePath[ip + 1].state) || !iter.getOutput().equals(this.nodePath[ip].output)) continue;
                    iter.incrementCount(1.0);
                    ++numIncrements;
                }
                if (numIncrements > 1) {
                    throw new IllegalStateException("More than one satisfying transition found.");
                }
                if (numIncrements == 0) {
                    throw new IllegalStateException("No satisfying transition found.");
                }
                ++ip;
            }
        }

        public SequencePairAlignment trimStateInfo() {
            return new SequencePairAlignment(this.input, this.output, this.cost);
        }

        public double tokenAccuracy(Sequence referenceOutput) {
            int accuracy = 0;
            if (!$assertionsDisabled && referenceOutput.size() != this.output.size()) {
                throw new AssertionError();
            }
            int i = 0;
            while (i < this.output.size()) {
                if (referenceOutput.get(i).toString().equals(this.output.get(i).toString())) {
                    ++accuracy;
                }
                ++i;
            }
            logger.info("Number correct: " + accuracy + " out of " + this.output.size());
            return (double)accuracy / (double)this.output.size();
        }

        public double tokenAccuracy(Sequence referenceOutput, PrintWriter out) {
            int accuracy = 0;
            if (!$assertionsDisabled && referenceOutput.size() != this.output.size()) {
                throw new AssertionError();
            }
            int i = 0;
            while (i < this.output.size()) {
                String testString = this.output.get(i).toString();
                if (out != null) {
                    out.println(testString);
                }
                if (referenceOutput.get(i).toString().equals(testString)) {
                    ++accuracy;
                }
                ++i;
            }
            logger.info("Number correct: " + accuracy + " out of " + this.output.size());
            return (double)accuracy / (double)this.output.size();
        }

        public Transducer getTransducer() {
            return Transducer.this;
        }

        public Sequence getBestStates() {
            Object[] stateNames = new String[this.nodePath.length];
            int i = 0;
            while (i < this.nodePath.length) {
                ViterbiNode node = this.nodePath[i];
                stateNames[i] = node.state.getName();
                ++i;
            }
            return new ArraySequence(stateNames);
        }

        private class ViterbiNode {
            int inputPosition;
            State state;
            Object output;
            double delta = Double.POSITIVE_INFINITY;
            ViterbiNode minCostPredecessor = null;

            ViterbiNode(int inputPosition, State state) {
                this.inputPosition = inputPosition;
                this.state = state;
            }
        }
    }

    public class ViterbiLattice {
        private Sequence input;
        private Sequence providedOutput;
        private int latticeLength;
        private ViterbiNode[][] lattice;
        private CostCache first;
        private CostCache last;
        private CostCache[] caches;
        private int numCaches;
        private int maxCaches;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !ViterbiLattice.class.desiredAssertionStatus();
        }

        private CostCache getCache(int position) {
            CostCache cache = this.caches[position];
            if (cache == null) {
                if (this.numCaches < this.maxCaches) {
                    cache = new CostCache(position);
                    if (this.numCaches++ == 0) {
                        this.first = this.last = cache;
                    }
                } else {
                    cache = this.last;
                    this.caches[((CostCache)cache).position] = null;
                    cache.init(position);
                }
                int i = 0;
                while (i < Transducer.this.numStates()) {
                    if (this.lattice[position][i] != null && this.lattice[position][i].delta != Double.POSITIVE_INFINITY) {
                        State s = Transducer.this.getState(i);
                        TransitionIterator iter = s.transitionIterator(this.input, position, this.providedOutput, position);
                        while (iter.hasNext()) {
                            State d = iter.nextState();
                            ((CostCache)cache).cost[i][d.getIndex()] = iter.getCost();
                        }
                    }
                    ++i;
                }
                this.caches[position] = cache;
            }
            if (cache != this.first) {
                if (cache == this.last) {
                    this.last = cache.prev;
                }
                if (cache.prev != null) {
                    cache.prev.next = cache.next;
                }
                cache.next = this.first;
                cache.prev = null;
                this.first.prev = cache;
                this.first = cache;
            }
            return cache;
        }

        protected ViterbiNode getViterbiNode(int ip, int stateIndex) {
            if (this.lattice[ip][stateIndex] == null) {
                this.lattice[ip][stateIndex] = new ViterbiNode(ip, Transducer.this.getState(stateIndex));
            }
            return this.lattice[ip][stateIndex];
        }

        protected ViterbiLattice(Sequence inputSequence, Sequence outputSequence, int maxCaches) {
            if (maxCaches < 1) {
                maxCaches = 1;
            }
            this.maxCaches = maxCaches;
            if (!$assertionsDisabled && inputSequence == null) {
                throw new AssertionError();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting ViterbiLattice");
                logger.fine("Input: ");
                int ip = 0;
                while (ip < inputSequence.size()) {
                    logger.fine(" " + inputSequence.get(ip));
                    ++ip;
                }
                logger.fine("\nOutput: ");
                if (outputSequence == null) {
                    logger.fine("null");
                } else {
                    int op = 0;
                    while (op < outputSequence.size()) {
                        logger.fine(" " + outputSequence.get(op));
                        ++op;
                    }
                }
                logger.fine("\n");
            }
            this.input = inputSequence;
            this.providedOutput = outputSequence;
            this.latticeLength = this.input.size() + 1;
            int numStates = Transducer.this.numStates();
            this.lattice = new ViterbiNode[this.latticeLength][numStates];
            this.caches = new CostCache[this.latticeLength - 1];
            logger.fine("Starting Viterbi");
            boolean anyInitialState = false;
            int i = 0;
            while (i < numStates) {
                double initialCost = Transducer.this.getState((int)i).initialCost;
                if (initialCost < Double.POSITIVE_INFINITY) {
                    ViterbiNode n = this.getViterbiNode(0, i);
                    n.delta = initialCost;
                    anyInitialState = true;
                }
                ++i;
            }
            if (!anyInitialState) {
                logger.warning("Viterbi: No initial states!");
            }
            int ip = 0;
            while (ip < this.latticeLength - 1) {
                int i2 = 0;
                while (i2 < numStates) {
                    if (this.lattice[ip][i2] != null && this.lattice[ip][i2].delta != Double.POSITIVE_INFINITY) {
                        State s = Transducer.this.getState(i2);
                        TransitionIterator iter = s.transitionIterator(this.input, ip, this.providedOutput, ip);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(" Starting Viterbi transition iteration from state " + s.getName() + " on input " + this.input.get(ip));
                        }
                        while (iter.hasNext()) {
                            State destination = iter.nextState();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Viterbi[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                            }
                            ViterbiNode destinationNode = this.getViterbiNode(ip + 1, destination.getIndex());
                            destinationNode.output = iter.getOutput();
                            double cost = this.lattice[ip][i2].delta + iter.getCost();
                            if (ip == this.latticeLength - 2) {
                                cost += destination.getFinalCost();
                            }
                            if (!(cost < destinationNode.delta)) continue;
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Viterbi[inputPos=" + ip + "][source][dest=" + destination.getName() + "] cost reduced to " + cost + " by source=" + s.getName());
                            }
                            destinationNode.delta = cost;
                            destinationNode.minCostPredecessor = this.lattice[ip][i2];
                        }
                    }
                    ++i2;
                }
                ++ip;
            }
        }

        public Sequence[] outputNBest(int n) {
            int numFinal = 0;
            int i = 0;
            while (i < Transducer.this.numStates()) {
                if (this.lattice[this.latticeLength - 1][i] != null && this.lattice[this.latticeLength - 1][i].delta < Double.POSITIVE_INFINITY) {
                    ++numFinal;
                }
                ++i;
            }
            AStarState[] finalNodes = new ViterbiNode[numFinal];
            int f = 0;
            int i2 = 0;
            while (i2 < Transducer.this.numStates()) {
                if (this.lattice[this.latticeLength - 1][i2] != null && this.lattice[this.latticeLength - 1][i2].delta < Double.POSITIVE_INFINITY) {
                    finalNodes[f++] = this.lattice[this.latticeLength - 1][i2];
                }
                ++i2;
            }
            AStar search = new AStar(finalNodes, this.latticeLength * Transducer.this.numStates());
            ArrayList<ArraySequence> outputs = new ArrayList<ArraySequence>(n);
            int i3 = 0;
            while (i3 < n && search.hasNext()) {
                SearchNode ans = (SearchNode)search.next();
                Object[] seq = new Object[this.input.size()];
                ans = ans.getParent();
                int j = 0;
                while (j < this.input.size()) {
                    ViterbiNode v = (ViterbiNode)ans.getState();
                    if (!$assertionsDisabled && v.inputPosition != j + 1) {
                        throw new AssertionError();
                    }
                    seq[j] = v.output;
                    ans = ans.getParent();
                    ++j;
                }
                outputs.add(new ArraySequence(seq, false));
                ++i3;
            }
            return outputs.toArray(new Sequence[0]);
        }

        private class ViterbiNode
        implements AStarState {
            int inputPosition;
            State state;
            Object output;
            double delta = Double.POSITIVE_INFINITY;
            ViterbiNode minCostPredecessor = null;

            ViterbiNode(int inputPosition, State state) {
                this.inputPosition = inputPosition;
                this.state = state;
            }

            public double completionCost() {
                return this.delta;
            }

            public boolean isFinal() {
                return this.inputPosition == 0 && this.state.getInitialCost() < Double.POSITIVE_INFINITY;
            }

            public SearchState.NextStateIterator getNextStates() {
                return new PreviousStateIterator();
            }

            private class PreviousStateIterator
            extends SearchState.NextStateIterator {
                private int prev = 0;
                private boolean found;
                private double cost;
                private double[] costs;

                private PreviousStateIterator() {
                    if (ViterbiNode.this.inputPosition > 0) {
                        int t = ViterbiNode.this.state.getIndex();
                        this.costs = new double[Transducer.this.numStates()];
                        CostCache c = ViterbiLattice.this.getCache(ViterbiNode.this.inputPosition - 1);
                        int s = 0;
                        while (s < Transducer.this.numStates()) {
                            this.costs[s] = c.cost[s][t];
                            ++s;
                        }
                    }
                }

                private void lookAhead() {
                    if (this.costs != null && !this.found) {
                        while (this.prev < Transducer.this.numStates()) {
                            if (this.costs[this.prev] < Double.POSITIVE_INFINITY) {
                                this.found = true;
                                return;
                            }
                            ++this.prev;
                        }
                    }
                }

                public boolean hasNext() {
                    this.lookAhead();
                    return this.costs != null && this.prev < Transducer.this.numStates();
                }

                public SearchState nextState() {
                    this.lookAhead();
                    this.cost = this.costs[this.prev++];
                    this.found = false;
                    return ViterbiLattice.this.getViterbiNode(ViterbiNode.this.inputPosition - 1, this.prev - 1);
                }

                public double cost() {
                    return this.cost;
                }
            }
        }

        private class CostCache {
            private CostCache prev;
            private CostCache next;
            private double[][] cost;
            private int position;

            private CostCache(int position) {
                this.cost = new double[Transducer.this.numStates()][Transducer.this.numStates()];
                this.init(position);
            }

            private void init(int position) {
                this.position = position;
                int i = 0;
                while (i < Transducer.this.numStates()) {
                    int j = 0;
                    while (j < Transducer.this.numStates()) {
                        this.cost[i][j] = Double.POSITIVE_INFINITY;
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    public class ViterbiPathBeam
    extends SequencePairAlignment {
        Sequence providedOutput;
        ViterbiNode[] nodePath;
        int latticeLength;
        ViterbiNode[][] lattice;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !ViterbiPathBeam.class.desiredAssertionStatus();
        }

        public double getDelta(int ip, int stateIndex) {
            if (this.lattice != null) {
                return this.getViterbiNode((ViterbiNode[][])this.lattice, (int)ip, (int)stateIndex).delta;
            }
            throw new RuntimeException("Attempt to called getDelta() when lattice not stored.");
        }

        public State getBestState(int ip) {
            return this.getStateAtRank(ip, 0);
        }

        public State getStateAtRank(final int ip, int rank) {
            if (this.lattice != null) {
                Integer[] rankedStates = new Integer[Transducer.this.numStates()];
                int k = 0;
                while (k < Transducer.this.numStates()) {
                    rankedStates[k] = new Integer(k);
                    ++k;
                }
                Arrays.sort(rankedStates, new Comparator(){

                    public int compare(Object o, Object o1) {
                        int i1 = (Integer)o;
                        int i2 = (Integer)o1;
                        return Double.compare(ViterbiPathBeam.this.getDelta(ip, i1), ViterbiPathBeam.this.getDelta(ip, i2));
                    }
                });
                return Transducer.this.getState(rankedStates[rank]);
            }
            throw new RuntimeException("Attempt to called getMaxState() when lattice not stored.");
        }

        protected ViterbiNode getViterbiNode(ViterbiNode[][] nodes, int ip, int stateIndex) {
            if (nodes[ip][stateIndex] == null) {
                nodes[ip][stateIndex] = new ViterbiNode(ip, Transducer.this.getState(stateIndex));
            }
            return nodes[ip][stateIndex];
        }

        protected ViterbiPathBeam(Sequence inputSequence, Sequence outputSequence, int Bwidth) {
            this(inputSequence, outputSequence, false, Bwidth);
        }

        protected ViterbiPathBeam(Sequence inputSequence, Sequence outputSequence, boolean saveLattice, int Bwidth) {
            if (!$assertionsDisabled && inputSequence == null) {
                throw new AssertionError();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting ViterbiPath");
                logger.fine("Input: ");
                int ip = 0;
                while (ip < inputSequence.size()) {
                    logger.fine(" " + inputSequence.get(ip));
                    ++ip;
                }
                logger.fine("\nOutput: ");
                if (outputSequence == null) {
                    logger.fine("null");
                } else {
                    int op = 0;
                    while (op < outputSequence.size()) {
                        logger.fine(" " + outputSequence.get(op));
                        ++op;
                    }
                }
                logger.fine("\n");
            }
            this.input = inputSequence;
            this.providedOutput = outputSequence;
            this.latticeLength = this.input.size() + 1;
            int numStates = Transducer.this.numStates();
            ViterbiNode[][] nodes = new ViterbiNode[this.latticeLength][numStates];
            if (saveLattice) {
                this.lattice = nodes;
            }
            Transducer.this.nstatesExpl = new double[1];
            ((Transducer)Transducer.this).nstatesExpl[0] = Bwidth;
            logger.fine("Starting Viterbi");
            boolean anyInitialState = false;
            int i = 0;
            while (i < numStates) {
                double initialCost = Transducer.this.getState((int)i).initialCost;
                if (initialCost < Double.POSITIVE_INFINITY) {
                    ViterbiNode n = this.getViterbiNode(nodes, 0, i);
                    n.delta = initialCost;
                    anyInitialState = true;
                }
                ++i;
            }
            if (!anyInitialState) {
                logger.warning("Viterbi: No initial states!");
            }
            NBestSlist[] slists = new NBestSlist[this.latticeLength];
            int ip = 0;
            while (ip < this.latticeLength - 1) {
                slists[ip] = new NBestSlist(Bwidth);
                int i2 = 0;
                while (i2 < numStates) {
                    if (nodes[ip][i2] != null && nodes[ip][i2].delta != Double.POSITIVE_INFINITY) {
                        NBViterbiNode cnode = new NBViterbiNode(nodes[ip][i2].delta, i2);
                        slists[ip].push(cnode);
                    }
                    ++i2;
                }
                int jj = 0;
                while (jj < slists[ip].size()) {
                    int i3 = slists[ip].getPosByIndex(jj);
                    State s = Transducer.this.getState(i3);
                    TransitionIterator iter = s.transitionIterator(this.input, ip, this.providedOutput, ip);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(" Starting Viterbi transition iteration from state " + s.getName() + " on input " + this.input.get(ip));
                    }
                    while (iter.hasNext()) {
                        State destination = iter.nextState();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Viterbi[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                        }
                        ViterbiNode destinationNode = this.getViterbiNode(nodes, ip + 1, destination.getIndex());
                        destinationNode.output = iter.getOutput();
                        this.cost = nodes[ip][i3].delta + iter.getCost();
                        if (ip == this.latticeLength - 2) {
                            this.cost += destination.getFinalCost();
                        }
                        if (!(this.cost < destinationNode.delta)) continue;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Viterbi[inputPos=" + ip + "][source][dest=" + destination.getName() + "] cost reduced to " + this.cost + " by source=" + s.getName());
                        }
                        destinationNode.delta = this.cost;
                        destinationNode.minCostPredecessor = nodes[ip][i3];
                    }
                    ++jj;
                }
                ++ip;
            }
            int ip2 = this.latticeLength - 1;
            this.cost = Double.POSITIVE_INFINITY;
            ViterbiNode minCostNode = null;
            int i4 = 0;
            while (i4 < numStates) {
                if (nodes[ip2][i4] != null && nodes[ip2][i4].delta < this.cost) {
                    minCostNode = nodes[ip2][i4];
                    this.cost = minCostNode.delta;
                }
                ++i4;
            }
            if (minCostNode == null) {
                logger.warning("Viterbi: Sequence has infinite cost.  Output will be empty...");
                this.output = new ArraySequence(new ArrayList());
                return;
            }
            this.nodePath = new ViterbiNode[this.latticeLength];
            Object[] outputArray = new Object[this.input.size()];
            ip2 = this.latticeLength - 1;
            while (ip2 >= 0) {
                this.nodePath[ip2] = minCostNode;
                if (ip2 > 0) {
                    outputArray[ip2 - 1] = minCostNode.output;
                }
                minCostNode = minCostNode.minCostPredecessor;
                --ip2;
            }
            this.output = new ArraySequence(outputArray, false);
        }

        public void incrementTransducerCounts() {
            this.nodePath[0].state.incrementInitialCount(1.0);
            this.nodePath[this.nodePath.length - 1].state.incrementFinalCount(1.0);
            int ip = 0;
            while (ip < this.nodePath.length - 1) {
                TransitionIterator iter = this.nodePath[ip].state.transitionIterator(this.input, ip, this.providedOutput, ip);
                int numIncrements = 0;
                while (iter.hasNext()) {
                    if (!iter.nextState().equals(this.nodePath[ip + 1].state) || !iter.getOutput().equals(this.nodePath[ip].output)) continue;
                    iter.incrementCount(1.0);
                    ++numIncrements;
                }
                if (numIncrements > 1) {
                    throw new IllegalStateException("More than one satisfying transition found.");
                }
                if (numIncrements == 0) {
                    throw new IllegalStateException("No satisfying transition found.");
                }
                ++ip;
            }
        }

        public SequencePairAlignment trimStateInfo() {
            return new SequencePairAlignment(this.input, this.output, this.cost);
        }

        public double tokenAccuracy(Sequence referenceOutput) {
            int accuracy = 0;
            if (!$assertionsDisabled && referenceOutput.size() != this.output.size()) {
                throw new AssertionError();
            }
            int i = 0;
            while (i < this.output.size()) {
                if (referenceOutput.get(i).toString().equals(this.output.get(i).toString())) {
                    ++accuracy;
                }
                ++i;
            }
            logger.info("Number correct: " + accuracy + " out of " + this.output.size());
            return (double)accuracy / (double)this.output.size();
        }

        public double tokenAccuracy(Sequence referenceOutput, PrintWriter out) {
            int accuracy = 0;
            if (!$assertionsDisabled && referenceOutput.size() != this.output.size()) {
                throw new AssertionError();
            }
            int i = 0;
            while (i < this.output.size()) {
                String testString = this.output.get(i).toString();
                if (out != null) {
                    out.println(testString);
                }
                if (referenceOutput.get(i).toString().equals(testString)) {
                    ++accuracy;
                }
                ++i;
            }
            logger.info("Number correct: " + accuracy + " out of " + this.output.size());
            return (double)accuracy / (double)this.output.size();
        }

        public Transducer getTransducer() {
            return Transducer.this;
        }

        private class ViterbiNode {
            int inputPosition;
            State state;
            Object output;
            double delta = Double.POSITIVE_INFINITY;
            ViterbiNode minCostPredecessor = null;

            ViterbiNode(int inputPosition, State state) {
                this.inputPosition = inputPosition;
                this.state = state;
            }
        }

        private class NBViterbiNode {
            double cost;
            int pos;

            NBViterbiNode(double cost, int pos) {
                this.cost = cost;
                this.pos = pos;
            }
        }

        private class NBestSlist {
            ArrayList list = new ArrayList();
            int MaxElements;

            NBestSlist(int MaxElements) {
                this.MaxElements = MaxElements;
            }

            int size() {
                return this.list.size();
            }

            boolean empty() {
                return this.list.isEmpty();
            }

            Object pop() {
                return this.list.remove(0);
            }

            int getPosByIndex(int ii) {
                NBViterbiNode tn = (NBViterbiNode)this.list.get(ii);
                return tn.pos;
            }

            ArrayList push(NBViterbiNode vn) {
                double tc = vn.cost;
                boolean atEnd = true;
                int i = 0;
                while (i < this.list.size()) {
                    NBViterbiNode tn = (NBViterbiNode)this.list.get(i);
                    double lc = tn.cost;
                    if (tc < lc) {
                        this.list.add(i, vn);
                        atEnd = false;
                        break;
                    }
                    ++i;
                }
                if (atEnd) {
                    this.list.add(vn);
                }
                if (this.list.size() > this.MaxElements) {
                    this.list.remove(this.MaxElements);
                }
                return this.list;
            }
        }
    }

    public class ViterbiPathBeamKL
    extends SequencePairAlignment {
        Sequence providedOutput;
        ViterbiNode[] nodePath;
        int latticeLength;
        ViterbiNode[][] lattice;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !ViterbiPathBeamKL.class.desiredAssertionStatus();
        }

        public double getDelta(int ip, int stateIndex) {
            if (this.lattice != null) {
                return this.getViterbiNode((ViterbiNode[][])this.lattice, (int)ip, (int)stateIndex).delta;
            }
            throw new RuntimeException("Attempt to called getDelta() when lattice not stored.");
        }

        public State getBestState(int ip) {
            return this.getStateAtRank(ip, 0);
        }

        public State getStateAtRank(final int ip, int rank) {
            if (this.lattice != null) {
                Integer[] rankedStates = new Integer[Transducer.this.numStates()];
                int k = 0;
                while (k < Transducer.this.numStates()) {
                    rankedStates[k] = new Integer(k);
                    ++k;
                }
                Arrays.sort(rankedStates, new Comparator(){

                    public int compare(Object o, Object o1) {
                        int i1 = (Integer)o;
                        int i2 = (Integer)o1;
                        return Double.compare(ViterbiPathBeamKL.this.getDelta(ip, i1), ViterbiPathBeamKL.this.getDelta(ip, i2));
                    }
                });
                return Transducer.this.getState(rankedStates[rank]);
            }
            throw new RuntimeException("Attempt to called getMaxState() when lattice not stored.");
        }

        protected ViterbiNode getViterbiNode(ViterbiNode[][] nodes, int ip, int stateIndex) {
            if (nodes[ip][stateIndex] == null) {
                nodes[ip][stateIndex] = new ViterbiNode(ip, Transducer.this.getState(stateIndex));
            }
            return nodes[ip][stateIndex];
        }

        protected ViterbiPathBeamKL(Sequence inputSequence, Sequence outputSequence, int Bwidth) {
            this(inputSequence, outputSequence, false, Bwidth);
        }

        protected ViterbiPathBeamKL(Sequence inputSequence, Sequence outputSequence, boolean saveLattice, int Bwidth) {
            if (!$assertionsDisabled && inputSequence == null) {
                throw new AssertionError();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting ViterbiPath");
                logger.fine("Input: ");
                int ip = 0;
                while (ip < inputSequence.size()) {
                    logger.fine(" " + inputSequence.get(ip));
                    ++ip;
                }
                logger.fine("\nOutput: ");
                if (outputSequence == null) {
                    logger.fine("null");
                } else {
                    int op = 0;
                    while (op < outputSequence.size()) {
                        logger.fine(" " + outputSequence.get(op));
                        ++op;
                    }
                }
                logger.fine("\n");
            }
            this.input = inputSequence;
            this.providedOutput = outputSequence;
            this.latticeLength = this.input.size() + 1;
            int numStates = Transducer.this.numStates();
            ViterbiNode[][] nodes = new ViterbiNode[this.latticeLength][numStates];
            if (saveLattice) {
                this.lattice = nodes;
            }
            logger.fine("Starting Viterbi");
            boolean anyInitialState = false;
            int i = 0;
            while (i < numStates) {
                double initialCost = Transducer.this.getState((int)i).initialCost;
                if (initialCost < Double.POSITIVE_INFINITY) {
                    ViterbiNode n = this.getViterbiNode(nodes, 0, i);
                    n.delta = initialCost;
                    anyInitialState = true;
                }
                ++i;
            }
            if (!anyInitialState) {
                logger.warning("Viterbi: No initial states!");
            }
            NBestSlist[] slists = new NBestSlist[this.latticeLength];
            Transducer.this.nstatesExpl = new double[this.latticeLength];
            int ip = 0;
            while (ip < this.latticeLength - 1) {
                slists[ip] = new NBestSlist(numStates);
                slists[ip].setKLMinE(Transducer.this.beamWidth);
                slists[ip].setKLeps(Transducer.this.KLeps);
                slists[ip].setRmin(Transducer.this.Rmin);
                int i2 = 0;
                while (i2 < numStates) {
                    if (nodes[ip][i2] != null && nodes[ip][i2].delta != Double.POSITIVE_INFINITY) {
                        NBViterbiNode cnode = new NBViterbiNode(nodes[ip][i2].delta, i2);
                        slists[ip].push(cnode);
                    }
                    ++i2;
                }
                int KLMaxPos = 1;
                int RminPos = 1;
                if (Transducer.this.KLeps > 0.0) {
                    KLMaxPos = slists[ip].getKLpos();
                    ((Transducer)Transducer.this).nstatesExpl[ip] = KLMaxPos;
                } else if (Transducer.this.KLeps == 0.0) {
                    if (Transducer.this.Rmin > 0.0) {
                        RminPos = slists[ip].getTHRpos();
                    } else {
                        slists[ip].setRmin(-Transducer.this.Rmin);
                        RminPos = slists[ip].getTHRposSTRAWMAN();
                    }
                    ((Transducer)Transducer.this).nstatesExpl[ip] = RminPos;
                } else {
                    slists[ip].setKLeps(-Transducer.this.KLeps);
                    KLMaxPos = slists[ip].getKLpos();
                    if (Transducer.this.Rmin > 0.0) {
                        RminPos = slists[ip].getTHRpos();
                    } else {
                        slists[ip].setRmin(-Transducer.this.Rmin);
                        RminPos = slists[ip].getTHRposSTRAWMAN();
                    }
                    ((Transducer)Transducer.this).nstatesExpl[ip] = KLMaxPos > RminPos ? (double)KLMaxPos : (double)RminPos;
                }
                int jj = 0;
                while ((double)jj < Transducer.this.nstatesExpl[ip]) {
                    int i3 = slists[ip].getPosByIndex(jj);
                    State s = Transducer.this.getState(i3);
                    TransitionIterator iter = s.transitionIterator(this.input, ip, this.providedOutput, ip);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(" Starting Viterbi transition iteration from state " + s.getName() + " on input " + this.input.get(ip));
                    }
                    while (iter.hasNext()) {
                        State destination = iter.nextState();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Viterbi[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                        }
                        ViterbiNode destinationNode = this.getViterbiNode(nodes, ip + 1, destination.getIndex());
                        destinationNode.output = iter.getOutput();
                        this.cost = nodes[ip][i3].delta + iter.getCost();
                        if (ip == this.latticeLength - 2) {
                            this.cost += destination.getFinalCost();
                        }
                        if (!(this.cost < destinationNode.delta)) continue;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Viterbi[inputPos=" + ip + "][source][dest=" + destination.getName() + "] cost reduced to " + this.cost + " by source=" + s.getName());
                        }
                        destinationNode.delta = this.cost;
                        destinationNode.minCostPredecessor = nodes[ip][i3];
                    }
                    ++jj;
                }
                ++ip;
            }
            int ip2 = this.latticeLength - 1;
            this.cost = Double.POSITIVE_INFINITY;
            ViterbiNode minCostNode = null;
            int i4 = 0;
            while (i4 < numStates) {
                if (nodes[ip2][i4] != null && nodes[ip2][i4].delta < this.cost) {
                    minCostNode = nodes[ip2][i4];
                    this.cost = minCostNode.delta;
                }
                ++i4;
            }
            if (minCostNode == null) {
                logger.warning("Viterbi: Sequence has infinite cost.  Output will be empty...");
                this.output = new ArraySequence(new ArrayList());
                return;
            }
            this.nodePath = new ViterbiNode[this.latticeLength];
            Object[] outputArray = new Object[this.input.size()];
            ip2 = this.latticeLength - 1;
            while (ip2 >= 0) {
                this.nodePath[ip2] = minCostNode;
                if (ip2 > 0) {
                    outputArray[ip2 - 1] = minCostNode.output;
                }
                minCostNode = minCostNode.minCostPredecessor;
                --ip2;
            }
            this.output = new ArraySequence(outputArray, false);
        }

        public void incrementTransducerCounts() {
            this.nodePath[0].state.incrementInitialCount(1.0);
            this.nodePath[this.nodePath.length - 1].state.incrementFinalCount(1.0);
            int ip = 0;
            while (ip < this.nodePath.length - 1) {
                TransitionIterator iter = this.nodePath[ip].state.transitionIterator(this.input, ip, this.providedOutput, ip);
                int numIncrements = 0;
                while (iter.hasNext()) {
                    if (!iter.nextState().equals(this.nodePath[ip + 1].state) || !iter.getOutput().equals(this.nodePath[ip].output)) continue;
                    iter.incrementCount(1.0);
                    ++numIncrements;
                }
                if (numIncrements > 1) {
                    throw new IllegalStateException("More than one satisfying transition found.");
                }
                if (numIncrements == 0) {
                    throw new IllegalStateException("No satisfying transition found.");
                }
                ++ip;
            }
        }

        public SequencePairAlignment trimStateInfo() {
            return new SequencePairAlignment(this.input, this.output, this.cost);
        }

        public double tokenAccuracy(Sequence referenceOutput) {
            int accuracy = 0;
            if (!$assertionsDisabled && referenceOutput.size() != this.output.size()) {
                throw new AssertionError();
            }
            int i = 0;
            while (i < this.output.size()) {
                if (referenceOutput.get(i).toString().equals(this.output.get(i).toString())) {
                    ++accuracy;
                }
                ++i;
            }
            logger.info("Number correct: " + accuracy + " out of " + this.output.size());
            return (double)accuracy / (double)this.output.size();
        }

        public double tokenAccuracy(Sequence referenceOutput, PrintWriter out) {
            int accuracy = 0;
            if (!$assertionsDisabled && referenceOutput.size() != this.output.size()) {
                throw new AssertionError();
            }
            int i = 0;
            while (i < this.output.size()) {
                String testString = this.output.get(i).toString();
                if (out != null) {
                    out.println(testString);
                }
                if (referenceOutput.get(i).toString().equals(testString)) {
                    ++accuracy;
                }
                ++i;
            }
            logger.info("Number correct: " + accuracy + " out of " + this.output.size());
            return (double)accuracy / (double)this.output.size();
        }

        public Transducer getTransducer() {
            return Transducer.this;
        }

        private class ViterbiNode {
            int inputPosition;
            State state;
            Object output;
            double delta = Double.POSITIVE_INFINITY;
            ViterbiNode minCostPredecessor = null;

            ViterbiNode(int inputPosition, State state) {
                this.inputPosition = inputPosition;
                this.state = state;
            }
        }

        private class NBViterbiNode {
            double cost;
            int pos;

            NBViterbiNode(double cost, int pos) {
                this.cost = cost;
                this.pos = pos;
            }
        }

        private class NBestSlist {
            ArrayList list = new ArrayList();
            int MaxElements;
            int KLMinElements;
            int KLMaxPos;
            double KLeps;
            double Rmin;

            NBestSlist(int MaxElements) {
                this.MaxElements = MaxElements;
            }

            boolean setKLMinE(int KLMinElements) {
                this.KLMinElements = KLMinElements;
                return true;
            }

            int size() {
                return this.list.size();
            }

            boolean empty() {
                return this.list.isEmpty();
            }

            Object pop() {
                return this.list.remove(0);
            }

            int getPosByIndex(int ii) {
                NBViterbiNode tn = (NBViterbiNode)this.list.get(ii);
                return tn.pos;
            }

            void setKLeps(double KLeps) {
                this.KLeps = KLeps;
            }

            void setRmin(double Rmin) {
                this.Rmin = Rmin;
            }

            int getTHRpos() {
                NBViterbiNode tn = (NBViterbiNode)this.list.get(0);
                double lc1 = tn.cost;
                tn = (NBViterbiNode)this.list.get(this.list.size() - 1);
                double lc2 = tn.cost;
                double minc = lc1 - lc2;
                double mincTHR = minc - minc * this.Rmin;
                int i = 1;
                while (i < this.list.size()) {
                    tn = (NBViterbiNode)this.list.get(i);
                    lc1 = tn.cost - lc2;
                    if (lc1 > mincTHR) {
                        return i + 1;
                    }
                    ++i;
                }
                return this.list.size();
            }

            int getTHRposSTRAWMAN() {
                NBViterbiNode tn = (NBViterbiNode)this.list.get(0);
                double lc1 = tn.cost;
                double mincTHR = -lc1 * this.Rmin;
                int i = 1;
                while (i < this.list.size()) {
                    tn = (NBViterbiNode)this.list.get(i);
                    lc1 = -tn.cost;
                    if (lc1 < mincTHR) {
                        return i + 1;
                    }
                    ++i;
                }
                return this.list.size();
            }

            int getKLpos() {
                double[] CSNLP = new double[this.MaxElements];
                NBViterbiNode tn = (NBViterbiNode)this.list.get(this.list.size() - 1);
                double worstc = tn.cost;
                int i = 0;
                while (i < this.list.size()) {
                    tn = (NBViterbiNode)this.list.get(i);
                    double lc = tn.cost - worstc;
                    CSNLP[i] = i == 0 ? lc : Transducer.sumNegLogProb(CSNLP[i - 1], lc);
                    ++i;
                }
                i = 0;
                while (i < this.list.size()) {
                    CSNLP[i] = CSNLP[i] - CSNLP[this.list.size() - 1];
                    if (CSNLP[i] < this.KLeps) {
                        this.KLMaxPos = i + 1;
                        if (this.KLMaxPos >= this.KLMinElements) {
                            return this.KLMaxPos;
                        }
                        if (this.list.size() > this.KLMinElements) {
                            return this.KLMinElements;
                        }
                    }
                    ++i;
                }
                this.KLMaxPos = this.list.size();
                return this.KLMaxPos;
            }

            ArrayList push(NBViterbiNode vn) {
                double tc = vn.cost;
                boolean atEnd = true;
                int i = 0;
                while (i < this.list.size()) {
                    NBViterbiNode tn = (NBViterbiNode)this.list.get(i);
                    double lc = tn.cost;
                    if (tc < lc) {
                        this.list.add(i, vn);
                        atEnd = false;
                        break;
                    }
                    ++i;
                }
                if (atEnd) {
                    this.list.add(vn);
                }
                if (this.list.size() > this.MaxElements) {
                    this.list.remove(this.MaxElements);
                }
                return this.list;
            }
        }
    }

    public class ViterbiPathBeamB
    extends SequencePairAlignment {
        Sequence providedOutput;
        ViterbiNode[] nodePath;
        int latticeLength;
        ViterbiNode[][] lattice;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !ViterbiPathBeamB.class.desiredAssertionStatus();
        }

        public double getDelta(int ip, int stateIndex) {
            if (this.lattice != null) {
                return this.getViterbiNode((ViterbiNode[][])this.lattice, (int)ip, (int)stateIndex).delta;
            }
            throw new RuntimeException("Attempt to called getDelta() when lattice not stored.");
        }

        public State getBestState(int ip) {
            return this.getStateAtRank(ip, 0);
        }

        public State getStateAtRank(final int ip, int rank) {
            if (this.lattice != null) {
                Integer[] rankedStates = new Integer[Transducer.this.numStates()];
                int k = 0;
                while (k < Transducer.this.numStates()) {
                    rankedStates[k] = new Integer(k);
                    ++k;
                }
                Arrays.sort(rankedStates, new Comparator(){

                    public int compare(Object o, Object o1) {
                        int i1 = (Integer)o;
                        int i2 = (Integer)o1;
                        return Double.compare(ViterbiPathBeamB.this.getDelta(ip, i1), ViterbiPathBeamB.this.getDelta(ip, i2));
                    }
                });
                return Transducer.this.getState(rankedStates[rank]);
            }
            throw new RuntimeException("Attempt to called getMaxState() when lattice not stored.");
        }

        protected ViterbiNode getViterbiNode(ViterbiNode[][] nodes, int ip, int stateIndex) {
            if (nodes[ip][stateIndex] == null) {
                nodes[ip][stateIndex] = new ViterbiNode(ip, Transducer.this.getState(stateIndex));
            }
            return nodes[ip][stateIndex];
        }

        protected ViterbiPathBeamB(Sequence inputSequence, Sequence outputSequence, int Bwidth) {
            this(inputSequence, outputSequence, false, Bwidth);
        }

        protected ViterbiPathBeamB(Sequence inputSequence, Sequence outputSequence, boolean saveLattice, int Bwidth) {
            if (!$assertionsDisabled && inputSequence == null) {
                throw new AssertionError();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting ViterbiPath");
                logger.fine("Input: ");
                int ip = 0;
                while (ip < inputSequence.size()) {
                    logger.fine(" " + inputSequence.get(ip));
                    ++ip;
                }
                logger.fine("\nOutput: ");
                if (outputSequence == null) {
                    logger.fine("null");
                } else {
                    int op = 0;
                    while (op < outputSequence.size()) {
                        logger.fine(" " + outputSequence.get(op));
                        ++op;
                    }
                }
                logger.fine("\n");
            }
            this.input = inputSequence;
            this.providedOutput = outputSequence;
            this.latticeLength = this.input.size() + 1;
            int numStates = Transducer.this.numStates();
            ViterbiNode[][] bnodes = new ViterbiNode[this.latticeLength][numStates];
            if (saveLattice) {
                this.lattice = bnodes;
            }
            logger.fine("Starting Backward Viterbi Computation");
            boolean anyFinalState = false;
            int i = 0;
            while (i < numStates) {
                double finalCost = Transducer.this.getState((int)i).finalCost;
                if (finalCost < Double.POSITIVE_INFINITY) {
                    ViterbiNode n = this.getViterbiNode(bnodes, this.latticeLength - 1, i);
                    n.delta = finalCost;
                    anyFinalState = true;
                    State s = Transducer.this.getState(i);
                    n.output = s.getName();
                }
                ++i;
            }
            if (!anyFinalState) {
                logger.warning("Viterbi: No final states!");
            }
            NBestSlist[] slistsB = new NBestSlist[this.latticeLength];
            int ip = this.latticeLength - 2;
            while (ip >= 0) {
                slistsB[ip + 1] = new NBestSlist(Bwidth);
                int i2 = 0;
                while (i2 < numStates) {
                    if (bnodes[ip + 1][i2] != null && bnodes[ip + 1][i2].delta != Double.POSITIVE_INFINITY) {
                        NBViterbiNode cnode = new NBViterbiNode(bnodes[ip + 1][i2].delta, i2);
                        slistsB[ip + 1].push(cnode);
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < numStates) {
                    State s = Transducer.this.getState(i2);
                    ViterbiNode currentNode = this.getViterbiNode(bnodes, ip, s.getIndex());
                    if (bnodes[ip][i2] != null) {
                        TransitionIterator iter = s.transitionIterator(this.input, ip, this.providedOutput, ip);
                        currentNode.output = s.getName();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(" Starting Backward Viterbi transition iteration from state " + s.getName() + " on input " + this.input.get(ip));
                        }
                        while (iter.hasNext()) {
                            int j;
                            boolean inbeam;
                            State destination = iter.nextState();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Backward Viterbi[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                            }
                            if (!(inbeam = slistsB[ip + 1].haspos(j = destination.getIndex()))) continue;
                            ViterbiNode destinationNode = bnodes[ip + 1][j];
                            double transitionCost = iter.getCost();
                            if (!$assertionsDisabled && Double.isNaN(transitionCost)) {
                                throw new AssertionError();
                            }
                            this.cost = destinationNode.delta + transitionCost;
                            if (ip == 0) {
                                this.cost += s.getInitialCost();
                            }
                            if (!(this.cost < currentNode.delta)) continue;
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Backward Viterbi[inputPos=" + ip + "][source][dest=" + s.getName() + "] cost reduced to " + this.cost + " by source=" + destination.getName());
                            }
                            currentNode.delta = this.cost;
                            currentNode.minCostPredecessor = bnodes[ip + 1][j];
                        }
                    }
                    ++i2;
                }
                --ip;
            }
            slistsB[0] = new NBestSlist(Bwidth);
            int i3 = 0;
            while (i3 < numStates) {
                if (bnodes[0][i3] != null && bnodes[0][i3].delta != Double.POSITIVE_INFINITY) {
                    NBViterbiNode cnode = new NBViterbiNode(bnodes[0][i3].delta, i3);
                    slistsB[0].push(cnode);
                }
                ++i3;
            }
            int ip2 = 0;
            this.cost = Double.POSITIVE_INFINITY;
            ViterbiNode minCostNode = null;
            int i4 = 0;
            while (i4 < numStates) {
                if (bnodes[ip2][i4] != null && bnodes[ip2][i4].delta < this.cost) {
                    minCostNode = bnodes[ip2][i4];
                    this.cost = minCostNode.delta;
                }
                ++i4;
            }
            if (minCostNode == null) {
                logger.warning("Viterbi: Sequence has infinite cost.  Output will be empty...");
                this.output = new ArraySequence(new ArrayList());
                return;
            }
            this.nodePath = new ViterbiNode[this.latticeLength];
            Object[] outputArray = new Object[this.input.size()];
            ip2 = 0;
            while (ip2 <= this.latticeLength - 1) {
                this.nodePath[ip2] = minCostNode;
                if (ip2 > 0) {
                    outputArray[ip2 - 1] = minCostNode.output;
                }
                minCostNode = minCostNode.minCostPredecessor;
                ++ip2;
            }
            this.output = new ArraySequence(outputArray, false);
        }

        public void incrementTransducerCounts() {
            this.nodePath[0].state.incrementInitialCount(1.0);
            this.nodePath[this.nodePath.length - 1].state.incrementFinalCount(1.0);
            int ip = 0;
            while (ip < this.nodePath.length - 1) {
                TransitionIterator iter = this.nodePath[ip].state.transitionIterator(this.input, ip, this.providedOutput, ip);
                int numIncrements = 0;
                while (iter.hasNext()) {
                    if (!iter.nextState().equals(this.nodePath[ip + 1].state) || !iter.getOutput().equals(this.nodePath[ip].output)) continue;
                    iter.incrementCount(1.0);
                    ++numIncrements;
                }
                if (numIncrements > 1) {
                    throw new IllegalStateException("More than one satisfying transition found.");
                }
                if (numIncrements == 0) {
                    throw new IllegalStateException("No satisfying transition found.");
                }
                ++ip;
            }
        }

        public SequencePairAlignment trimStateInfo() {
            return new SequencePairAlignment(this.input, this.output, this.cost);
        }

        public double tokenAccuracy(Sequence referenceOutput) {
            int accuracy = 0;
            if (!$assertionsDisabled && referenceOutput.size() != this.output.size()) {
                throw new AssertionError();
            }
            int i = 0;
            while (i < this.output.size()) {
                if (referenceOutput.get(i).toString().equals(this.output.get(i).toString())) {
                    ++accuracy;
                }
                ++i;
            }
            logger.info("Number correct: " + accuracy + " out of " + this.output.size());
            return (double)accuracy / (double)this.output.size();
        }

        public double tokenAccuracy(Sequence referenceOutput, PrintWriter out) {
            int accuracy = 0;
            if (!$assertionsDisabled && referenceOutput.size() != this.output.size()) {
                throw new AssertionError();
            }
            int i = 0;
            while (i < this.output.size()) {
                String testString = this.output.get(i).toString();
                if (out != null) {
                    out.println(testString);
                }
                if (referenceOutput.get(i).toString().equals(testString)) {
                    ++accuracy;
                }
                ++i;
            }
            logger.info("Number correct: " + accuracy + " out of " + this.output.size());
            return (double)accuracy / (double)this.output.size();
        }

        public Transducer getTransducer() {
            return Transducer.this;
        }

        private class ViterbiNode {
            int inputPosition;
            State state;
            Object output;
            double delta = Double.POSITIVE_INFINITY;
            ViterbiNode minCostPredecessor = null;

            ViterbiNode(int inputPosition, State state) {
                this.inputPosition = inputPosition;
                this.state = state;
            }
        }

        private class NBViterbiNode {
            double cost;
            int pos;

            NBViterbiNode(double cost, int pos) {
                this.cost = cost;
                this.pos = pos;
            }
        }

        private class NBestSlist {
            ArrayList list = new ArrayList();
            int MaxElements;

            NBestSlist(int MaxElements) {
                this.MaxElements = MaxElements;
            }

            int size() {
                return this.list.size();
            }

            boolean empty() {
                return this.list.isEmpty();
            }

            Object pop() {
                return this.list.remove(0);
            }

            int getPosByIndex(int ii) {
                NBViterbiNode tn = (NBViterbiNode)this.list.get(ii);
                return tn.pos;
            }

            NBViterbiNode getNBVNodeByIndex(int ii) {
                NBViterbiNode tn = (NBViterbiNode)this.list.get(ii);
                return tn;
            }

            boolean haspos(int ipos) {
                int i = 0;
                while (i < this.list.size()) {
                    NBViterbiNode tn = (NBViterbiNode)this.list.get(i);
                    int lp = tn.pos;
                    if (lp == ipos) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            boolean combine(NBViterbiNode vn) {
                int i = 0;
                while (i < this.list.size()) {
                    NBViterbiNode tn = (NBViterbiNode)this.list.get(i);
                    int lp = tn.pos;
                    if (tn.pos == vn.pos) {
                        tn.cost += vn.cost;
                        return true;
                    }
                    ++i;
                }
                this.list.add(vn);
                return false;
            }

            ArrayList push(NBViterbiNode vn) {
                double tc = vn.cost;
                boolean atEnd = true;
                int i = 0;
                while (i < this.list.size()) {
                    NBViterbiNode tn = (NBViterbiNode)this.list.get(i);
                    double lc = tn.cost;
                    if (tc < lc) {
                        this.list.add(i, vn);
                        atEnd = false;
                        break;
                    }
                    ++i;
                }
                if (atEnd) {
                    this.list.add(vn);
                }
                if (this.list.size() > this.MaxElements) {
                    this.list.remove(this.MaxElements);
                }
                return this.list;
            }
        }
    }

    public class ViterbiPathBeamFB
    extends SequencePairAlignment {
        Sequence providedOutput;
        ViterbiNode[] nodePath;
        int latticeLength;
        ViterbiNode[][] lattice;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !ViterbiPathBeamFB.class.desiredAssertionStatus();
        }

        public double getDelta(int ip, int stateIndex) {
            if (this.lattice != null) {
                return this.getViterbiNode((ViterbiNode[][])this.lattice, (int)ip, (int)stateIndex).delta;
            }
            throw new RuntimeException("Attempt to called getDelta() when lattice not stored.");
        }

        public State getBestState(int ip) {
            return this.getStateAtRank(ip, 0);
        }

        public State getStateAtRank(final int ip, int rank) {
            if (this.lattice != null) {
                Integer[] rankedStates = new Integer[Transducer.this.numStates()];
                int k = 0;
                while (k < Transducer.this.numStates()) {
                    rankedStates[k] = new Integer(k);
                    ++k;
                }
                Arrays.sort(rankedStates, new Comparator(){

                    public int compare(Object o, Object o1) {
                        int i1 = (Integer)o;
                        int i2 = (Integer)o1;
                        return Double.compare(ViterbiPathBeamFB.this.getDelta(ip, i1), ViterbiPathBeamFB.this.getDelta(ip, i2));
                    }
                });
                return Transducer.this.getState(rankedStates[rank]);
            }
            throw new RuntimeException("Attempt to called getMaxState() when lattice not stored.");
        }

        protected ViterbiNode getViterbiNode(ViterbiNode[][] nodes, int ip, int stateIndex) {
            if (nodes[ip][stateIndex] == null) {
                nodes[ip][stateIndex] = new ViterbiNode(ip, Transducer.this.getState(stateIndex));
            }
            return nodes[ip][stateIndex];
        }

        protected ViterbiPathBeamFB(Sequence inputSequence, Sequence outputSequence, int Bwidth) {
            this(inputSequence, outputSequence, false, Bwidth);
        }

        protected ViterbiPathBeamFB(Sequence inputSequence, Sequence outputSequence, boolean saveLattice, int Bwidth) {
            NBViterbiNode cnode;
            if (!$assertionsDisabled && inputSequence == null) {
                throw new AssertionError();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting ViterbiPath");
                logger.fine("Input: ");
                int ip = 0;
                while (ip < inputSequence.size()) {
                    logger.fine(" " + inputSequence.get(ip));
                    ++ip;
                }
                logger.fine("\nOutput: ");
                if (outputSequence == null) {
                    logger.fine("null");
                } else {
                    int op = 0;
                    while (op < outputSequence.size()) {
                        logger.fine(" " + outputSequence.get(op));
                        ++op;
                    }
                }
                logger.fine("\n");
            }
            this.input = inputSequence;
            this.providedOutput = outputSequence;
            this.latticeLength = this.input.size() + 1;
            int numStates = Transducer.this.numStates();
            ViterbiNode[][] nodes = new ViterbiNode[this.latticeLength][numStates];
            ViterbiNode[][] bnodes = new ViterbiNode[this.latticeLength][numStates];
            ViterbiNode[][] mfnodes = new ViterbiNode[this.latticeLength][numStates];
            if (saveLattice) {
                this.lattice = nodes;
            }
            logger.fine("Starting Viterbi");
            boolean anyInitialState = false;
            int i = 0;
            while (i < numStates) {
                double initialCost = Transducer.this.getState((int)i).initialCost;
                if (initialCost < Double.POSITIVE_INFINITY) {
                    ViterbiNode n = this.getViterbiNode(nodes, 0, i);
                    n.delta = initialCost;
                    anyInitialState = true;
                }
                ++i;
            }
            if (!anyInitialState) {
                logger.warning("Viterbi: No initial states!");
            }
            logger.fine("Starting Backward Viterbi Computation");
            boolean anyFinalState = false;
            int i2 = 0;
            while (i2 < numStates) {
                double finalCost = Transducer.this.getState((int)i2).finalCost;
                if (finalCost < Double.POSITIVE_INFINITY) {
                    ViterbiNode n = this.getViterbiNode(bnodes, this.latticeLength - 1, i2);
                    n.delta = finalCost;
                    anyFinalState = true;
                    State s = Transducer.this.getState(i2);
                    n.output = s.getName();
                }
                ++i2;
            }
            if (!anyFinalState) {
                logger.warning("Viterbi: No initial states!");
            }
            NBestSlist[] slists = new NBestSlist[this.latticeLength];
            NBestSlist[] slistsB = new NBestSlist[this.latticeLength];
            NBestSlist[] slistsV = new NBestSlist[this.latticeLength];
            int ip = 0;
            while (ip < this.latticeLength - 1) {
                slists[ip] = new NBestSlist(Bwidth);
                int i3 = 0;
                while (i3 < numStates) {
                    if (nodes[ip][i3] != null && nodes[ip][i3].delta != Double.POSITIVE_INFINITY) {
                        cnode = new NBViterbiNode(nodes[ip][i3].delta, i3);
                        slists[ip].push(cnode);
                    }
                    ++i3;
                }
                int jj = 0;
                while (jj < slists[ip].size()) {
                    int i4 = slists[ip].getPosByIndex(jj);
                    State s = Transducer.this.getState(i4);
                    TransitionIterator iter = s.transitionIterator(this.input, ip, this.providedOutput, ip);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine(" Starting Viterbi transition iteration from state " + s.getName() + " on input " + this.input.get(ip));
                    }
                    while (iter.hasNext()) {
                        State destination = iter.nextState();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Viterbi[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                        }
                        ViterbiNode destinationNode = this.getViterbiNode(nodes, ip + 1, destination.getIndex());
                        destinationNode.output = iter.getOutput();
                        this.cost = nodes[ip][i4].delta + iter.getCost();
                        if (ip == this.latticeLength - 2) {
                            this.cost += destination.getFinalCost();
                        }
                        if (!(this.cost < destinationNode.delta)) continue;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Viterbi[inputPos=" + ip + "][source][dest=" + destination.getName() + "] cost reduced to " + this.cost + " by source=" + s.getName());
                        }
                        destinationNode.delta = this.cost;
                        destinationNode.minCostPredecessor = nodes[ip][i4];
                    }
                    ++jj;
                }
                ++ip;
            }
            int lend = this.latticeLength - 1;
            slists[lend] = new NBestSlist(Bwidth);
            int i5 = 0;
            while (i5 < numStates) {
                if (nodes[lend][i5] != null && nodes[lend][i5].delta != Double.POSITIVE_INFINITY) {
                    cnode = new NBViterbiNode(nodes[lend][i5].delta, i5);
                    slists[lend].push(cnode);
                }
                ++i5;
            }
            int ip2 = this.latticeLength - 1;
            this.cost = Double.POSITIVE_INFINITY;
            ViterbiNode minCostNode = null;
            int i6 = 0;
            while (i6 < numStates) {
                if (nodes[ip2][i6] != null && nodes[ip2][i6].delta < this.cost) {
                    minCostNode = nodes[ip2][i6];
                    this.cost = minCostNode.delta;
                }
                ++i6;
            }
            double VitFBCost = this.cost;
            if (minCostNode == null) {
                logger.warning("Viterbi: Sequence has infinite cost.  Output will be empty...");
                this.output = new ArraySequence(new ArrayList());
                return;
            }
            this.nodePath = new ViterbiNode[this.latticeLength];
            Object[] outputArray = new Object[this.input.size()];
            ip2 = this.latticeLength - 1;
            while (ip2 >= 0) {
                this.nodePath[ip2] = minCostNode;
                if (ip2 > 0) {
                    outputArray[ip2 - 1] = minCostNode.output;
                }
                minCostNode = minCostNode.minCostPredecessor;
                --ip2;
            }
            ip2 = this.latticeLength - 2;
            while (ip2 >= 0) {
                slistsB[ip2 + 1] = new NBestSlist(1);
                slistsV[ip2 + 1] = new NBestSlist(numStates);
                int i7 = 0;
                while (i7 < numStates) {
                    if (bnodes[ip2 + 1][i7] != null && bnodes[ip2 + 1][i7].delta != Double.POSITIVE_INFINITY && nodes[ip2 + 1][i7] != null && nodes[ip2 + 1][i7].delta != Double.POSITIVE_INFINITY) {
                        ViterbiNode n = this.getViterbiNode(mfnodes, ip2 + 1, i7);
                        n.delta = 0.0;
                        mfnodes[ip2 + 1][i7].delta = bnodes[ip2 + 1][i7].delta + nodes[ip2 + 1][i7].delta;
                        NBViterbiNode cnode2 = new NBViterbiNode(mfnodes[ip2 + 1][i7].delta, i7);
                        NBViterbiNode ccnode = new NBViterbiNode(bnodes[ip2 + 1][i7].delta, i7);
                        int VPState = this.nodePath[ip2 + 1].state.getIndex();
                        if (ccnode.pos != VPState) {
                            slistsB[ip2 + 1].push(ccnode);
                        }
                        if (cnode2.pos == VPState || mfnodes[ip2 + 1][i7].delta <= VitFBCost) {
                            slistsV[ip2 + 1].push(cnode2);
                        }
                    }
                    ++i7;
                }
                i7 = 0;
                while (i7 < numStates) {
                    State s = Transducer.this.getState(i7);
                    ViterbiNode currentNode = this.getViterbiNode(bnodes, ip2, s.getIndex());
                    if (bnodes[ip2][i7] != null) {
                        TransitionIterator iter = s.transitionIterator(this.input, ip2, this.providedOutput, ip2);
                        currentNode.output = s.getName();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(" Starting Backward Viterbi transition iteration from state " + s.getName() + " on input " + this.input.get(ip2));
                        }
                        while (iter.hasNext()) {
                            boolean inbeamORBvit;
                            State destination = iter.nextState();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Backward Viterbi[inputPos=" + ip2 + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                            }
                            int j = destination.getIndex();
                            boolean inBbeam = slistsB[ip2 + 1].haspos(j);
                            boolean inVlist = slistsV[ip2 + 1].haspos(j);
                            boolean bl = inbeamORBvit = inBbeam || inVlist;
                            if (!inbeamORBvit) continue;
                            ViterbiNode destinationNode = bnodes[ip2 + 1][j];
                            double transitionCost = iter.getCost();
                            if (!$assertionsDisabled && Double.isNaN(transitionCost)) {
                                throw new AssertionError();
                            }
                            this.cost = destinationNode.delta + transitionCost;
                            if (ip2 == 0) {
                                this.cost += s.getInitialCost();
                            }
                            if (!(this.cost < currentNode.delta)) continue;
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Backward Viterbi[inputPos=" + ip2 + "][source][dest=" + s.getName() + "] cost reduced to " + this.cost + " by source=" + destination.getName());
                            }
                            currentNode.delta = this.cost;
                            currentNode.minCostPredecessor = bnodes[ip2 + 1][j];
                        }
                    }
                    ++i7;
                }
                --ip2;
            }
            slistsB[0] = new NBestSlist(Bwidth);
            int i8 = 0;
            while (i8 < numStates) {
                if (bnodes[0][i8] != null && bnodes[0][i8].delta != Double.POSITIVE_INFINITY) {
                    NBViterbiNode cnode3 = new NBViterbiNode(bnodes[0][i8].delta, i8);
                    slistsB[0].push(cnode3);
                }
                ++i8;
            }
            Object[] outputArray2 = new Object[this.input.size()];
            ip2 = 0;
            this.cost = Double.POSITIVE_INFINITY;
            minCostNode = null;
            int i9 = 0;
            while (i9 < numStates) {
                if (bnodes[ip2][i9] != null && bnodes[ip2][i9].delta < this.cost) {
                    minCostNode = bnodes[ip2][i9];
                    this.cost = minCostNode.delta;
                }
                ++i9;
            }
            if (minCostNode == null) {
                logger.warning("Viterbi: Sequence has infinite cost.  Output will be empty...");
                this.output = new ArraySequence(new ArrayList());
                return;
            }
            this.nodePath = new ViterbiNode[this.latticeLength];
            ip2 = 0;
            while (ip2 <= this.latticeLength - 1) {
                this.nodePath[ip2] = minCostNode;
                if (ip2 > 0) {
                    outputArray2[ip2 - 1] = minCostNode.output;
                }
                minCostNode = minCostNode.minCostPredecessor;
                ++ip2;
            }
            this.output = new ArraySequence(outputArray2, false);
        }

        public void incrementTransducerCounts() {
            this.nodePath[0].state.incrementInitialCount(1.0);
            this.nodePath[this.nodePath.length - 1].state.incrementFinalCount(1.0);
            int ip = 0;
            while (ip < this.nodePath.length - 1) {
                TransitionIterator iter = this.nodePath[ip].state.transitionIterator(this.input, ip, this.providedOutput, ip);
                int numIncrements = 0;
                while (iter.hasNext()) {
                    if (!iter.nextState().equals(this.nodePath[ip + 1].state) || !iter.getOutput().equals(this.nodePath[ip].output)) continue;
                    iter.incrementCount(1.0);
                    ++numIncrements;
                }
                if (numIncrements > 1) {
                    throw new IllegalStateException("More than one satisfying transition found.");
                }
                if (numIncrements == 0) {
                    throw new IllegalStateException("No satisfying transition found.");
                }
                ++ip;
            }
        }

        public SequencePairAlignment trimStateInfo() {
            return new SequencePairAlignment(this.input, this.output, this.cost);
        }

        public double tokenAccuracy(Sequence referenceOutput) {
            int accuracy = 0;
            if (!$assertionsDisabled && referenceOutput.size() != this.output.size()) {
                throw new AssertionError();
            }
            int i = 0;
            while (i < this.output.size()) {
                if (referenceOutput.get(i).toString().equals(this.output.get(i).toString())) {
                    ++accuracy;
                }
                ++i;
            }
            logger.info("Number correct: " + accuracy + " out of " + this.output.size());
            return (double)accuracy / (double)this.output.size();
        }

        public double tokenAccuracy(Sequence referenceOutput, PrintWriter out) {
            int accuracy = 0;
            if (!$assertionsDisabled && referenceOutput.size() != this.output.size()) {
                throw new AssertionError();
            }
            int i = 0;
            while (i < this.output.size()) {
                String testString = this.output.get(i).toString();
                if (out != null) {
                    out.println(testString);
                }
                if (referenceOutput.get(i).toString().equals(testString)) {
                    ++accuracy;
                }
                ++i;
            }
            logger.info("Number correct: " + accuracy + " out of " + this.output.size());
            return (double)accuracy / (double)this.output.size();
        }

        public Transducer getTransducer() {
            return Transducer.this;
        }

        private class ViterbiNode {
            int inputPosition;
            State state;
            Object output;
            double delta = Double.POSITIVE_INFINITY;
            ViterbiNode minCostPredecessor = null;

            ViterbiNode(int inputPosition, State state) {
                this.inputPosition = inputPosition;
                this.state = state;
            }
        }

        private class NBViterbiNode {
            double cost;
            int pos;

            NBViterbiNode(double cost, int pos) {
                this.cost = cost;
                this.pos = pos;
            }
        }

        private class NBestSlist {
            ArrayList list = new ArrayList();
            int MaxElements;

            NBestSlist(int MaxElements) {
                this.MaxElements = MaxElements;
            }

            int size() {
                return this.list.size();
            }

            boolean empty() {
                return this.list.isEmpty();
            }

            Object pop() {
                return this.list.remove(0);
            }

            int getPosByIndex(int ii) {
                NBViterbiNode tn = (NBViterbiNode)this.list.get(ii);
                return tn.pos;
            }

            double getCostByIndex(int ii) {
                NBViterbiNode tn = (NBViterbiNode)this.list.get(ii);
                return tn.cost;
            }

            NBViterbiNode getNBVNodeByIndex(int ii) {
                NBViterbiNode tn = (NBViterbiNode)this.list.get(ii);
                return tn;
            }

            boolean haspos(int ipos) {
                int i = 0;
                while (i < this.list.size()) {
                    NBViterbiNode tn = (NBViterbiNode)this.list.get(i);
                    int lp = tn.pos;
                    if (lp == ipos) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            boolean combine(NBViterbiNode vn) {
                int i = 0;
                while (i < this.list.size()) {
                    NBViterbiNode tn = (NBViterbiNode)this.list.get(i);
                    int lp = tn.pos;
                    if (tn.pos == vn.pos) {
                        tn.cost += vn.cost;
                        return true;
                    }
                    ++i;
                }
                this.list.add(vn);
                return false;
            }

            ArrayList push(NBViterbiNode vn) {
                double tc = vn.cost;
                boolean atEnd = true;
                int i = 0;
                while (i < this.list.size()) {
                    NBViterbiNode tn = (NBViterbiNode)this.list.get(i);
                    double lc = tn.cost;
                    if (tc < lc) {
                        this.list.add(i, vn);
                        atEnd = false;
                        break;
                    }
                    ++i;
                }
                if (atEnd) {
                    this.list.add(vn);
                }
                if (this.list.size() > this.MaxElements) {
                    this.list.remove(this.MaxElements);
                }
                return this.list;
            }
        }
    }

    public class ViterbiPath_NBest
    extends SequencePairAlignment {
        Sequence providedOutput;
        ViterbiNode_NBest[] nodePath;
        int latticeLength;
        int numStates;
        ViterbiNode_NBest[][] nodes;
        ViterbiNode_NBest[] finalNodePredecessor;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !ViterbiPath_NBest.class.desiredAssertionStatus();
        }

        protected ViterbiNode_NBest getViterbiNode(ViterbiNode_NBest[][] nodes, int ip, int stateIndex) {
            if (nodes[ip][stateIndex] == null) {
                nodes[ip][stateIndex] = new ViterbiNode_NBest(ip, Transducer.this.getState(stateIndex));
            }
            if (nodes[ip][stateIndex] == null) {
                throw new IllegalArgumentException("WARNING: nodes[" + ip + "][" + stateIndex + "] is not successfully generated.");
            }
            return nodes[ip][stateIndex];
        }

        protected ViterbiPath_NBest(Sequence inputSequence, Sequence outputSequence, int N) {
            this.input = inputSequence;
            this.providedOutput = outputSequence;
            this.latticeLength = this.input.size() + 1;
            this.numStates = Transducer.this.numStates();
            this.nodes = new ViterbiNode_NBest[this.latticeLength][this.numStates];
            this.finalNodePredecessor = new ViterbiNode_NBest[this.numStates];
            this.NBestForwardViterbi(this.nodes, this.finalNodePredecessor, N);
            this.outputNBest = this.NBestBackwardASearch(N);
            this.combineNBest();
        }

        protected void NBestForwardViterbi(ViterbiNode_NBest[][] nodes, ViterbiNode_NBest[] finalNodePredecessor, int N) {
            int ip;
            if (!$assertionsDisabled && this.input == null) {
                throw new AssertionError();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting ViterbiPath");
                logger.fine("Input: ");
                ip = 0;
                while (ip < this.input.size()) {
                    logger.fine(" " + this.input.get(ip));
                    ++ip;
                }
                logger.fine("\nOutput: ");
                if (this.providedOutput == null) {
                    logger.fine("null");
                } else {
                    int op = 0;
                    while (op < this.providedOutput.size()) {
                        logger.fine(" " + this.providedOutput.get(op));
                        ++op;
                    }
                }
                logger.fine("\n");
            }
            logger.fine("Starting Viterbi");
            int i = 0;
            while (i < this.numStates) {
                double initialCost = Transducer.this.getState((int)i).initialCost;
                if (initialCost < Double.POSITIVE_INFINITY) {
                    ViterbiNode_NBest n = this.getViterbiNode(nodes, 0, i);
                    n.delta = initialCost;
                }
                ++i;
            }
            ip = 0;
            while (ip < this.latticeLength - 1) {
                int i2 = 0;
                while (i2 < this.numStates) {
                    if (nodes[ip][i2] != null && nodes[ip][i2].delta != Double.POSITIVE_INFINITY) {
                        State s = Transducer.this.getState(i2);
                        TransitionIterator iter = s.transitionIterator(this.input, ip, this.providedOutput, ip);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine(" Starting Viterbi transition iteration from state " + s.getName() + " on input " + this.input.get(ip));
                        }
                        while (iter.hasNext()) {
                            State destination = iter.nextState();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("Viterbi[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                            }
                            ViterbiNode_NBest destinationNode = this.getViterbiNode(nodes, ip + 1, destination.getIndex());
                            destinationNode.output = iter.getOutput();
                            this.cost = nodes[ip][i2].delta + iter.getCost();
                            destinationNode.iterCost[i2] = iter.getCost();
                            if (ip == this.latticeLength - 2) {
                                this.cost += destination.getFinalCost();
                            }
                            if (this.cost < destinationNode.delta) {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.fine("Viterbi[inputPos=" + ip + "][source][dest=" + destination.getName() + "] cost reduced to " + this.cost + " by source=" + s.getName());
                                }
                                destinationNode.delta = this.cost;
                            }
                            destinationNode.phi[i2] = this.cost;
                        }
                    }
                    ++i2;
                }
                ++ip;
            }
            ip = this.latticeLength - 1;
            while (ip > 0) {
                int i3 = 0;
                while (i3 < this.numStates) {
                    if (nodes[ip][i3] != null && nodes[ip][i3].delta != Double.POSITIVE_INFINITY) {
                        nodes[ip][i3].sortPredecessor();
                    }
                    ++i3;
                }
                --ip;
            }
            int[] predecessorIndex = new int[this.numStates];
            predecessorIndex[0] = 0;
            int i4 = 1;
            while (i4 < this.numStates) {
                boolean atEnd = true;
                int j = 0;
                while (j < i4) {
                    if (nodes[this.latticeLength - 1][i4].delta < nodes[this.latticeLength - 1][predecessorIndex[j]].delta) {
                        int k = i4 - 1;
                        while (k >= j) {
                            predecessorIndex[k + 1] = predecessorIndex[k];
                            --k;
                        }
                        predecessorIndex[j] = i4;
                        atEnd = false;
                        break;
                    }
                    ++j;
                }
                if (atEnd) {
                    predecessorIndex[i4] = i4;
                }
                ++i4;
            }
            i4 = 0;
            while (i4 < this.numStates) {
                if (nodes[this.latticeLength - 1][predecessorIndex[i4]] == null) {
                    throw new IllegalArgumentException("null node");
                }
                finalNodePredecessor[i4] = nodes[this.latticeLength - 1][predecessorIndex[i4]];
                ++i4;
            }
            int ip2 = this.latticeLength - 1;
            this.cost = Double.POSITIVE_INFINITY;
            ViterbiNode_NBest minCostNode = null;
            int i5 = 0;
            while (i5 < this.numStates) {
                if (nodes[ip2][i5] != null && nodes[ip2][i5].delta < this.cost) {
                    minCostNode = nodes[ip2][i5];
                    this.cost = minCostNode.delta;
                }
                ++i5;
            }
            this.nodePath = new ViterbiNode_NBest[this.latticeLength];
            Object[] outputArray = new Object[this.input.size()];
            ip2 = this.latticeLength - 1;
            while (ip2 >= 0) {
                this.nodePath[ip2] = minCostNode;
                if (ip2 > 0) {
                    outputArray[ip2 - 1] = minCostNode.output;
                }
                minCostNode = minCostNode.minCostPredecessor[0];
                --ip2;
            }
            this.output = new ArraySequence(outputArray, false);
        }

        protected Sequence[] NBestBackwardASearch(int N) {
            NBestStack stack = new NBestStack();
            ASearchNode_NBest startNode = new ASearchNode_NBest(this.latticeLength, null);
            startNode.predecessorNodes = this.finalNodePredecessor;
            int i = 0;
            while (i < this.numStates) {
                if (this.finalNodePredecessor[i] == null) {
                    throw new IllegalArgumentException(String.valueOf(i) + ": null node");
                }
                startNode.totalCost[i] = this.finalNodePredecessor[i].delta + 0.0;
                ++i;
            }
            startNode.backwardCost = 0.0;
            startNode.nextBestStateIndex = 0;
            startNode.succeedNode = null;
            startNode.output = null;
            stack.push(startNode);
            int nFound = 0;
            ArrayList<ArraySequence> hypothesisList = new ArrayList<ArraySequence>();
            ArrayList<Double> costList = new ArrayList<Double>();
            while (!stack.empty()) {
                ASearchNode_NBest node_current = (ASearchNode_NBest)stack.pop();
                int nextStateIndex = node_current.nextBestStateIndex++;
                if (node_current.nextBestStateIndex < this.numStates) {
                    stack.push(node_current);
                }
                State s = node_current.predecessorNodes[nextStateIndex].state;
                ASearchNode_NBest node_next = new ASearchNode_NBest(node_current.inputPosition - 1, s);
                node_next.output = this.nodes[node_next.inputPosition][s.getIndex()].output;
                if (node_next.inputPosition == 1) {
                    Object[] outputArray = new Object[this.input.size()];
                    outputArray[0] = node_next.output;
                    ASearchNode_NBest v = node_current;
                    int i2 = 1;
                    while (v.succeedNode != null) {
                        if (!$assertionsDisabled && i2 >= this.input.size()) {
                            throw new AssertionError();
                        }
                        outputArray[i2++] = v.output;
                        v = v.succeedNode;
                    }
                    ArraySequence hypo_current = new ArraySequence(outputArray, false);
                    hypothesisList.add(hypo_current);
                    costList.add(new Double(node_current.totalCost[nextStateIndex]));
                    if (++nFound < N) continue;
                    break;
                }
                node_next.predecessorNodes = this.nodes[node_next.inputPosition][s.getIndex()].minCostPredecessor;
                if (node_next.inputPosition < this.latticeLength - 1) {
                    int current_state_index = node_current.state.getIndex();
                    int next_state_index = node_next.state.getIndex();
                    node_next.backwardCost = node_current.backwardCost + this.nodes[node_current.inputPosition][current_state_index].iterCost[next_state_index];
                } else {
                    node_next.backwardCost = node_next.state.getFinalCost();
                }
                ViterbiNode_NBest tempNode = this.nodes[node_next.inputPosition][s.getIndex()];
                int k = 0;
                while (k < this.numStates) {
                    node_next.totalCost[k] = tempNode.rankedPhi(k);
                    if (node_next.inputPosition < this.latticeLength - 1) {
                        int n = k;
                        node_next.totalCost[n] = node_next.totalCost[n] + node_next.backwardCost;
                    }
                    ++k;
                }
                node_next.nextBestStateIndex = 0;
                node_next.succeedNode = node_current;
                stack.push(node_next);
            }
            Sequence[] sequenceList = new Sequence[hypothesisList.size()];
            this.costNBest = new double[hypothesisList.size()];
            int i3 = 0;
            while (i3 < hypothesisList.size()) {
                sequenceList[i3] = (Sequence)hypothesisList.get(i3);
                this.costNBest[i3] = (Double)costList.get(i3);
                ++i3;
            }
            return sequenceList;
        }

        protected void combineNBest() {
            Alphabet targets = Transducer.this.inputPipe.getTargetAlphabet();
            if (!$assertionsDisabled && targets == null) {
                throw new AssertionError();
            }
            if (this.numStates == 0) {
                this.numStates = Transducer.this.numStates();
            }
            double[][] node_weight = new double[this.input.size()][this.numStates];
            double totalWeight = 0.0;
            int i = 0;
            while (i < this.outputNBest.length) {
                double weight = Math.exp(-(this.costNBest[i] - this.costNBest[0]));
                int j = 0;
                while (j < this.input.size()) {
                    Object obj = this.outputNBest[i].get(j);
                    int index = targets.lookupIndex(obj);
                    double[] dArray = node_weight[j];
                    int n = index;
                    dArray[n] = dArray[n] + weight;
                    ++j;
                }
                ++i;
            }
            Object[] outputArray = new Object[this.input.size()];
            int j = 0;
            while (j < this.input.size()) {
                int index = 0;
                int k = 1;
                while (k < this.numStates) {
                    if (node_weight[j][k] > node_weight[j][index]) {
                        index = k;
                    }
                    ++k;
                }
                outputArray[j] = targets.lookupObject(index);
                ++j;
            }
            this.output = new ArraySequence(outputArray, false);
        }

        private class NBestStack {
            ArrayList list = new ArrayList();

            NBestStack() {
            }

            int size() {
                return this.list.size();
            }

            boolean empty() {
                return this.list.isEmpty();
            }

            Object pop() {
                return this.list.remove(0);
            }

            ArrayList push(ASearchNode_NBest o) {
                double f = o.totalCost[o.nextBestStateIndex];
                boolean atEnd = true;
                int i = 0;
                while (i < this.list.size()) {
                    ASearchNode_NBest tempNode = (ASearchNode_NBest)this.list.get(i);
                    double f1 = tempNode.totalCost[tempNode.nextBestStateIndex];
                    if (f < f1) {
                        this.list.add(i, o);
                        atEnd = false;
                        break;
                    }
                    ++i;
                }
                if (atEnd) {
                    this.list.add(o);
                }
                return this.list;
            }
        }

        private class ViterbiNode_NBest {
            int inputPosition;
            State state;
            Object output;
            double delta = Double.POSITIVE_INFINITY;
            double[] phi;
            double[] rankedPhi;
            ViterbiNode_NBest[] minCostPredecessor;
            double[] iterCost;
            static final /* synthetic */ boolean $assertionsDisabled;

            static {
                $assertionsDisabled = !ViterbiNode_NBest.class.desiredAssertionStatus();
            }

            ViterbiNode_NBest(int inputPosition, State state) {
                this.inputPosition = inputPosition;
                this.state = state;
                this.phi = new double[ViterbiPath_NBest.this.numStates];
                this.rankedPhi = new double[ViterbiPath_NBest.this.numStates];
                this.minCostPredecessor = new ViterbiNode_NBest[ViterbiPath_NBest.this.numStates];
                this.iterCost = new double[ViterbiPath_NBest.this.numStates];
                int i = 0;
                while (i < ViterbiPath_NBest.this.numStates) {
                    this.phi[i] = Double.POSITIVE_INFINITY;
                    this.minCostPredecessor[i] = null;
                    this.iterCost[i] = Double.POSITIVE_INFINITY;
                    ++i;
                }
            }

            double rankedPhi(int k) {
                return this.rankedPhi[k];
            }

            void sortPredecessor() {
                if (this.inputPosition == 0) {
                    return;
                }
                int[] predecessorIndex = new int[ViterbiPath_NBest.this.numStates];
                predecessorIndex[0] = 0;
                int i = 1;
                while (i < ViterbiPath_NBest.this.numStates) {
                    boolean atEnd = true;
                    int j = 0;
                    while (j < i) {
                        if (this.phi[i] < this.phi[predecessorIndex[j]]) {
                            int k = i - 1;
                            while (k >= j) {
                                predecessorIndex[k + 1] = predecessorIndex[k];
                                --k;
                            }
                            predecessorIndex[j] = i;
                            atEnd = false;
                            break;
                        }
                        ++j;
                    }
                    if (atEnd) {
                        predecessorIndex[i] = i;
                    }
                    ++i;
                }
                if (!$assertionsDisabled && this.inputPosition < 1) {
                    throw new AssertionError();
                }
                i = 0;
                while (i < ViterbiPath_NBest.this.numStates) {
                    this.rankedPhi[i] = this.phi[predecessorIndex[i]];
                    this.minCostPredecessor[i] = ViterbiPath_NBest.this.getViterbiNode(ViterbiPath_NBest.this.nodes, this.inputPosition - 1, predecessorIndex[i]);
                    ++i;
                }
            }
        }

        private class ASearchNode_NBest {
            int inputPosition;
            State state;
            Object output;
            ViterbiNode_NBest[] predecessorNodes;
            double[] totalCost;
            double backwardCost;
            int nextBestStateIndex;
            ASearchNode_NBest succeedNode;

            ASearchNode_NBest(int inputPosition, State state) {
                this.inputPosition = inputPosition;
                this.state = state;
                this.totalCost = new double[ViterbiPath_NBest.this.numStates];
                this.succeedNode = null;
            }
        }
    }
}

