/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.util;

import java.util.HashMap;
import java.util.Map;
import tratz.jwni.IndexEntry;
import tratz.jwni.POS;
import tratz.jwni.WordNet;
import tratz.parse.types.Token;

public class NLParserUtils {
    public static final String UNUSUAL_DOUBLE_QUOTES;
    public static final String UNUSUAL_SINGLE_QUOTES;
    private static Map<String, POS> stringToPos;

    public static String getLemma(Token t, WordNet wn) {
        POS pos = stringToPos.get(t.getPos());
        String lemma = t.getText();
        if (pos != null) {
            IndexEntry ie = wn.lookupIndexEntry(pos, lemma);
            lemma = ie != null ? ie.getLemma() : lemma.toLowerCase();
        } else if (!t.getPos().startsWith("NN")) {
            lemma = lemma.toLowerCase();
        }
        return lemma;
    }

    static {
        int[] doubleQuoteInts = new int[]{132, 171, 187, 147, 148, 8220, 8221, 8222, 8223, 8243, 8244, 8246, 8247};
        int[] singleQuoteInts = new int[]{145, 146, 8216, 8217, 8218, 8219, 8242, 8245};
        StringBuilder buf = new StringBuilder();
        for (int i : doubleQuoteInts) {
            buf.append((char)i).append("|");
        }
        buf.setLength(buf.length() - 1);
        UNUSUAL_DOUBLE_QUOTES = buf.toString();
        buf = new StringBuilder();
        for (int i : singleQuoteInts) {
            buf.append((char)i).append("|");
        }
        buf.setLength(buf.length() - 1);
        UNUSUAL_SINGLE_QUOTES = buf.toString();
        stringToPos = new HashMap<String, POS>();
        for (String s : new String[]{"VB", "VBP", "VBZ", "VBD", "VBN", "VBG"}) {
            stringToPos.put(s, POS.VERB);
        }
        for (String s : new String[]{"NN", "NNS"}) {
            stringToPos.put(s, POS.NOUN);
        }
        for (String s : new String[]{"JJ", "JJR", "JJS"}) {
            stringToPos.put(s, POS.ADJECTIVE);
        }
        for (String s : new String[]{"RB", "RBR", "RBS"}) {
            stringToPos.put(s, POS.ADVERB);
        }
    }
}

