/*
 * Decompiled with CFR 0.152.
 */
package tratz.jwikt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tratz.jwikt.WPOS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WEntry {
    public Set<String> mJunk = new HashSet<String>();
    private final String mTerm;
    private final WPOS mPos;
    private boolean mIsCountable;
    private boolean mIsComparable;
    private final List<Definition> mDefinitions = new ArrayList<Definition>();

    public WEntry(String term, WPOS pos) {
        this.mTerm = term;
        this.mPos = pos;
    }

    public WPOS getPos() {
        return this.mPos;
    }

    public String getTerm() {
        return this.mTerm;
    }

    void setComparable(boolean comparable) {
        this.mIsComparable = comparable;
    }

    void setCountable(boolean countable) {
        this.mIsCountable = countable;
    }

    public boolean isCountable() {
        return this.mPos == WPOS.NOUN && this.mIsCountable;
    }

    public boolean isComparable() {
        return this.mPos == WPOS.ADJECTIVE && this.mIsComparable;
    }

    void addDefinition(Definition def) {
        this.mDefinitions.add(def);
    }

    public List<Definition> getDefinitions() {
        return this.mDefinitions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Definition {
        private String mGloss;
        private List<String> mExamples = new ArrayList<String>();

        public Definition(String gloss) {
            this.mGloss = gloss;
        }

        public String getGloss() {
            return this.mGloss;
        }

        public List<String> getExamples() {
            return this.mExamples;
        }
    }
}

